/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

public class CComboSingleSelectionObservableValueTest
extends AbstractSWTTestCase {
    @Test
    public void testSetValue() throws Exception {
        CCombo combo = new CCombo((Composite)this.getShell(), 0);
        ISWTObservableValue observableValue = SWTObservables.observeSingleSelectionIndex((Control)combo);
        combo.add("Item1");
        combo.add("Item2");
        Assert.assertEquals((long)-1L, (long)combo.getSelectionIndex());
        Assert.assertEquals((long)-1L, (long)((Integer)observableValue.getValue()).intValue());
        Integer value = 1;
        observableValue.setValue((Object)value);
        Assert.assertEquals((String)"combo selection index", (long)value.intValue(), (long)combo.getSelectionIndex());
        Assert.assertEquals((String)"observable value", (Object)value, (Object)observableValue.getValue());
        Assert.assertEquals((Object)"Item2", (Object)combo.getText());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private CCombo combo;
        private Shell shell;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.combo = new CCombo((Composite)this.shell, 0);
            this.combo.add("0");
            this.combo.add("1");
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.singleSelectionIndex().observe(realm, (Object)this.combo);
        }

        public void change(IObservable observable) {
            IObservableValue value = (IObservableValue)observable;
            value.setValue(this.createValue(value));
        }

        public Object getValueType(IObservableValue observable) {
            return Integer.TYPE;
        }

        public Object createValue(IObservableValue observable) {
            return this._createValue(observable);
        }

        private int _createValue(IObservableValue observable) {
            int value = Math.max(0, this.combo.getSelectionIndex());
            return Math.abs(value - 1);
        }
    }
}

