/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CLabelObservableValueTest {
    private Delegate delegate;
    private IObservableValue observable;
    private CLabel label;

    @Before
    public void setUp() throws Exception {
        this.delegate = new Delegate();
        this.delegate.setUp();
        this.label = this.delegate.label;
        this.observable = this.delegate.createObservableValue(DisplayRealm.getRealm((Display)Display.getDefault()));
    }

    @After
    public void tearDown() throws Exception {
        this.delegate.tearDown();
        this.observable.dispose();
    }

    @Test
    public void testSetValue() throws Exception {
        Assert.assertEquals(null, (Object)this.label.getText());
        Assert.assertEquals(null, (Object)this.observable.getValue());
        String value = "value";
        this.observable.setValue((Object)value);
        Assert.assertEquals((String)"label text", (Object)value, (Object)this.label.getText());
        Assert.assertEquals((String)"observable value", (Object)value, (Object)this.observable.getValue());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        CLabel label;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.label = new CLabel((Composite)this.shell, 0);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.text().observe(realm, (Object)this.label);
        }

        public void change(IObservable observable) {
            IObservableValue value = (IObservableValue)observable;
            value.setValue((Object)(value.getValue() + "a"));
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public Object createValue(IObservableValue observable) {
            return observable.getValue() + "a";
        }
    }
}

