/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.tests.internal.databinding.swt.Screenshots;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ControlObservableValueTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
            this.shell = null;
        }
    }

    @Test
    public void testSetValueEnabled() throws Exception {
        ISWTObservableValue observableValue = SWTObservables.observeEnabled((Control)this.shell);
        Boolean value = Boolean.FALSE;
        observableValue.setValue((Object)value);
        Assert.assertFalse((boolean)this.shell.isEnabled());
    }

    @Test
    public void testGetValueEnabled() throws Exception {
        ISWTObservableValue value = SWTObservables.observeEnabled((Control)this.shell);
        this.shell.setEnabled(false);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)value.getValue());
    }

    @Test
    public void testGetValueTypeEnabled() throws Exception {
        ISWTObservableValue value = SWTObservables.observeEnabled((Control)this.shell);
        Assert.assertEquals(Boolean.TYPE, (Object)value.getValueType());
    }

    @Test
    public void testSetValueVisible() throws Exception {
        ISWTObservableValue value = SWTObservables.observeVisible((Control)this.shell);
        value.setValue((Object)Boolean.FALSE);
        Assert.assertFalse((boolean)this.shell.isVisible());
    }

    @Test
    public void testGetValueVisible() throws Exception {
        ISWTObservableValue value = SWTObservables.observeVisible((Control)this.shell);
        this.shell.setVisible(false);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)value.getValue());
    }

    @Test
    public void testGetValueTypeVisible() throws Exception {
        ISWTObservableValue value = SWTObservables.observeVisible((Control)this.shell);
        Assert.assertEquals(Boolean.TYPE, (Object)value.getValueType());
    }

    @Test
    public void testSetValueForeground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeForeground((Control)this.shell);
        Color color = this.shell.getDisplay().getSystemColor(2);
        value.setValue((Object)color);
        Assert.assertEquals((Object)color, (Object)this.shell.getForeground());
    }

    @Test
    public void testGetValueForeground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeForeground((Control)this.shell);
        Color color = this.shell.getDisplay().getSystemColor(2);
        this.shell.setForeground(color);
        Assert.assertEquals((Object)color, (Object)value.getValue());
    }

    @Test
    public void testGetValueTypeForgroundColor() throws Exception {
        ISWTObservableValue value = SWTObservables.observeForeground((Control)this.shell);
        Assert.assertEquals(Color.class, (Object)value.getValueType());
    }

    @Test
    public void testGetValueBackground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeBackground((Control)this.shell);
        Color color = this.shell.getDisplay().getSystemColor(2);
        this.shell.setBackground(color);
        Assert.assertEquals((Object)color, (Object)value.getValue());
    }

    @Test
    public void testSetValueBackground() throws Exception {
        ISWTObservableValue value = SWTObservables.observeBackground((Control)this.shell);
        Color color = this.shell.getDisplay().getSystemColor(2);
        value.setValue((Object)color);
        Assert.assertEquals((Object)color, (Object)this.shell.getBackground());
    }

    @Test
    public void testGetValueTypeBackgroundColor() throws Exception {
        ISWTObservableValue value = SWTObservables.observeBackground((Control)this.shell);
        Assert.assertEquals(Color.class, (Object)value.getValueType());
    }

    @Test
    public void testGetValueTypeTooltip() throws Exception {
        ISWTObservableValue value = SWTObservables.observeTooltipText((Control)this.shell);
        Assert.assertEquals(String.class, (Object)value.getValueType());
    }

    @Test
    public void testSetValueFont() throws Exception {
        ISWTObservableValue value = SWTObservables.observeFont((Control)this.shell);
        Font font = JFaceResources.getDialogFont();
        value.setValue((Object)font);
        Assert.assertEquals((Object)font, (Object)this.shell.getFont());
    }

    @Test
    public void testGetValueFont() throws Exception {
        ISWTObservableValue value = SWTObservables.observeFont((Control)this.shell);
        Font font = JFaceResources.getDialogFont();
        this.shell.setFont(font);
        Assert.assertEquals((Object)font, (Object)value.getValue());
    }

    @Test
    public void testGetValueTypeFont() throws Exception {
        ISWTObservableValue value = SWTObservables.observeFont((Control)this.shell);
        Assert.assertEquals(Font.class, (Object)value.getValueType());
    }

    @Test
    public void testSetValueTooltipText() throws Exception {
        ISWTObservableValue value = SWTObservables.observeTooltipText((Control)this.shell);
        String text = "text";
        value.setValue((Object)text);
        Assert.assertEquals((Object)text, (Object)this.shell.getToolTipText());
    }

    @Test
    public void testGetValueTooltipText() throws Exception {
        ISWTObservableValue value = SWTObservables.observeTooltipText((Control)this.shell);
        String text = "text";
        this.shell.setToolTipText(text);
        Assert.assertEquals((Object)text, (Object)value.getValue());
    }

    @Test
    public void testGetValueTypeTooltipText() throws Exception {
        ISWTObservableValue value = SWTObservables.observeTooltipText((Control)this.shell);
        Assert.assertEquals(String.class, (Object)value.getValueType());
    }

    @Test
    public void testObserveFocus() {
        System.out.println("ControlObservableValueTest.testObserveFocus() start active shell: " + this.shell.getDisplay().getActiveShell());
        this.shell.setLayout((Layout)new FillLayout());
        Text c1 = new Text((Composite)this.shell, 0);
        c1.setText("1");
        Text c2 = new Text((Composite)this.shell, 0);
        c2.setText("2");
        this.shell.pack();
        this.shell.setVisible(true);
        this.processDisplayQueue();
        System.out.println("active shell (2): " + this.shell.getDisplay().getActiveShell());
        this.shell.forceActive();
        System.out.println("active shell (3): " + this.shell.getDisplay().getActiveShell());
        Assert.assertTrue((boolean)c1.setFocus());
        Control focus = this.shell.getDisplay().getFocusControl();
        System.out.println("focus control (1): " + focus + ", c2? " + (focus == c2));
        System.out.println("active shell (4): " + this.shell.getDisplay().getActiveShell());
        ISWTObservableValue value = WidgetProperties.focused().observe((Widget)c2);
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)value);
        Assert.assertTrue((boolean)c2.setFocus());
        this.processDisplayQueue();
        focus = this.shell.getDisplay().getFocusControl();
        System.out.println("focus control (2): " + focus + ", c2? " + (focus == c2));
        System.out.println("active shell (5): " + this.shell.getDisplay().getActiveShell());
        System.out.println("Value (should be true): " + value.getValue());
        Screenshots.takeScreenshot(this.getClass(), this.getClass().getSimpleName(), System.out);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)value.getValue());
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)tracker.event.diff.getOldValue());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)tracker.event.diff.getNewValue());
    }

    private void processDisplayQueue() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }
}

