/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.junit.Before;
import org.junit.Test;

public class GroupObservableValueTest
extends ObservableDelegateTest {
    private Delegate delegate;
    private IObservableValue observable;
    private Group group;

    public GroupObservableValueTest() {
        this(null);
    }

    public GroupObservableValueTest(String testName) {
        super(testName, (IObservableContractDelegate)new Delegate());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.delegate = (Delegate)this.getObservableContractDelegate();
        this.observable = (IObservableValue)this.getObservable();
        this.group = this.delegate.group;
    }

    protected IObservable doCreateObservable() {
        return this.getObservableContractDelegate().createObservable(DisplayRealm.getRealm((Display)Display.getDefault()));
    }

    @Test
    public void testSetValue() throws Exception {
        GroupObservableValueTest.assertEquals((String)"", (String)this.group.getText());
        GroupObservableValueTest.assertEquals((Object)"", (Object)this.observable.getValue());
        String value = "value";
        this.observable.setValue((Object)value);
        GroupObservableValueTest.assertEquals((String)"label text", (String)value, (String)this.group.getText());
        GroupObservableValueTest.assertEquals((String)"observable value", (Object)value, (Object)this.observable.getValue());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Group group;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.group = new Group((Composite)this.shell, 32);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.text().observe(realm, (Object)this.group);
        }

        public void change(IObservable observable) {
            IObservableValue value = (IObservableValue)observable;
            value.setValue((Object)(value.getValue() + "a"));
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public Object createValue(IObservableValue observable) {
            return observable.getValue() + "a";
        }
    }
}

