/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.internal.databinding.swt.SWTObservableValueDecorator;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SWTDelayedObservableValueDecoratorTest
extends AbstractDefaultRealmTestCase {
    private Display display;
    private Shell shell;
    private Object oldValue;
    private Object newValue;
    private ISWTObservableValue target;
    private ISWTObservableValue delayed;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        this.target = new SWTObservableValueDecorator((IObservableValue)new WritableValue(DisplayRealm.getRealm((Display)this.display)), (Widget)this.shell);
        this.oldValue = new Object();
        this.newValue = new Object();
        this.target.setValue(this.oldValue);
        this.delayed = SWTObservables.observeDelayedValue((int)1, (ISWTObservableValue)this.target);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.delayed.dispose();
        this.target.dispose();
        this.target = null;
        this.shell.dispose();
        this.shell = null;
        this.display = null;
        super.tearDown();
    }

    @Test
    public void testFocusOut_FiresPendingValueChange() {
        this.assertFiresPendingValueChange(() -> this.shell.notifyListeners(16, new Event()));
    }

    private void assertFiresPendingValueChange(Runnable runnable) {
        ValueChangeEventTracker tracker = ValueChangeEventTracker.observe((IObservableValue)this.delayed);
        this.target.setValue(this.newValue);
        Assert.assertTrue((boolean)this.delayed.isStale());
        Assert.assertEquals((long)0L, (long)tracker.count);
        runnable.run();
        Assert.assertFalse((boolean)this.delayed.isStale());
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)tracker.event.diff.getOldValue());
        Assert.assertEquals((Object)this.newValue, (Object)tracker.event.diff.getNewValue());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        Shell shell;

        Delegate() {
        }

        public void setUp() {
            super.setUp();
            this.shell = new Shell();
        }

        public void tearDown() {
            this.shell.dispose();
            this.shell = null;
            super.tearDown();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return SWTObservables.observeDelayedValue((int)0, (ISWTObservableValue)new SWTObservableValueDecorator((IObservableValue)new WritableValue(realm, null, Object.class), (Widget)this.shell));
        }

        public Object getValueType(IObservableValue observable) {
            return Object.class;
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object createValue(IObservableValue observable) {
            return new Object();
        }
    }
}

