/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import java.io.File;
import java.io.PrintStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class Screenshots {
    public static String takeScreenshot(Class<?> testClass, String name, PrintStream out) {
        File resultsHtmlDir = Screenshots.getJunitReportOutput();
        if (resultsHtmlDir == null) {
            File eclipseDir = new File("").getAbsoluteFile();
            resultsHtmlDir = new File(eclipseDir, "../../results/html/").getAbsoluteFile();
        }
        Display display = Display.getCurrent();
        Event mouseMove = new Event();
        mouseMove.x = 10;
        mouseMove.y = 10;
        display.post(mouseMove);
        Screenshots.runEventQueue();
        mouseMove.x = 20;
        mouseMove.y = 20;
        display.post(mouseMove);
        Screenshots.runEventQueue();
        Control focusControl = display.getFocusControl();
        out.println("FocusControl: ");
        if (focusControl == null) {
            System.out.println("  null!");
        } else {
            StringBuilder indent = new StringBuilder("  ");
            do {
                out.println(String.valueOf(indent.toString()) + focusControl);
                focusControl = focusControl.getParent();
                indent.append("  ");
            } while (focusControl != null);
        }
        Shell[] shells = display.getShells();
        if (shells.length > 0) {
            out.println("Shells: ");
            int i = 0;
            while (i < shells.length) {
                Shell shell = shells[i];
                out.print(display.getActiveShell() == shell ? "  active, " : "  inactive, ");
                out.print(String.valueOf(shell.isVisible() ? "visible: " : "invisible: ") + shell);
                out.println(" @ " + shell.getBounds().toString());
                ++i;
            }
        }
        GC gc = new GC((Drawable)display);
        Rectangle displayBounds = display.getBounds();
        out.println("Display @ " + displayBounds);
        Image image = new Image((Device)display, displayBounds);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        resultsHtmlDir.mkdirs();
        String filename = new File(resultsHtmlDir.getAbsolutePath(), String.valueOf(testClass.getName()) + "." + name + ".png").getAbsolutePath();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(filename, 5);
        out.println("Screenshot saved to: " + filename);
        image.dispose();
        return filename;
    }

    private static File getJunitReportOutput() {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length - 1) {
            if ("-junitReportOutput".equals(args[i])) {
                return new File(args[i + 1]).getAbsoluteFile();
            }
            ++i;
        }
        return null;
    }

    private static void runEventQueue() {
        Display display = Display.getCurrent();
        int i = 0;
        while (i < 10) {
            while (display.readAndDispatch()) {
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
    }
}

