/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShellObservableValueTest
extends AbstractDefaultRealmTestCase {
    String oldValue;
    String newValue;
    Shell shell;
    IObservableValue observable;
    ValueChangeEventTracker tracker;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.observable = SWTObservables.observeText((Control)this.shell);
        this.oldValue = "old";
        this.newValue = "new";
        this.shell.setText(this.oldValue);
        this.tracker = ValueChangeEventTracker.observe((IObservableValue)this.observable);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.observable.dispose();
        this.observable = null;
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    @Test
    public void testGetValueType() {
        Assert.assertEquals(String.class, (Object)this.observable.getValueType());
    }

    @Test
    public void testSetValue_FiresValueChangeEvent() {
        this.observable.setValue((Object)this.newValue);
        Assert.assertEquals((long)1L, (long)this.tracker.count);
        Assert.assertEquals((Object)this.oldValue, (Object)this.tracker.event.diff.getOldValue());
        Assert.assertEquals((Object)this.newValue, (Object)this.tracker.event.diff.getNewValue());
    }

    @Test
    public void testSetValue_NullConvertedToEmptyString() {
        this.observable.setValue(null);
        Assert.assertEquals((Object)"", (Object)this.observable.getValue());
        Assert.assertEquals((Object)"", (Object)this.shell.getText());
    }

    @Test
    public void testShellSetText_GetValueReturnsSame() {
        Assert.assertEquals((Object)this.oldValue, (Object)this.observable.getValue());
        this.shell.setText(this.newValue);
        Assert.assertEquals((Object)this.newValue, (Object)this.observable.getValue());
    }

    @Test
    public void testShellSetText_NoValueChangeEvent() {
        this.shell.setText(this.newValue);
        Assert.assertEquals((long)0L, (long)this.tracker.count);
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        Shell shell;
        int counter;

        Delegate() {
        }

        public void setUp() {
            super.setUp();
            this.shell = new Shell();
        }

        public void tearDown() {
            this.shell.dispose();
            this.shell = null;
            super.tearDown();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.text().observe(realm, (Object)this.shell);
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object createValue(IObservableValue observable) {
            return Integer.toString(this.counter++);
        }
    }
}

