/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.junit.Before;
import org.junit.Test;

public class SpinnerObservableValueMinTest
extends ObservableDelegateTest {
    private Delegate delegate;
    private Spinner spinner;
    private IObservableValue observable;

    public SpinnerObservableValueMinTest() {
        this(null);
    }

    public SpinnerObservableValueMinTest(String testName) {
        super(testName, (IObservableContractDelegate)new Delegate());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.delegate = (Delegate)this.getObservableContractDelegate();
        this.observable = (IObservableValue)this.getObservable();
        this.spinner = this.delegate.spinner;
    }

    protected IObservable doCreateObservable() {
        return this.getObservableContractDelegate().createObservable(DisplayRealm.getRealm((Display)Display.getDefault()));
    }

    @Test
    public void testGetValue() throws Exception {
        int min = 100;
        this.spinner.setMinimum(min);
        SpinnerObservableValueMinTest.assertEquals((Object)min, (Object)this.observable.getValue());
    }

    @Test
    public void testSetValue() throws Exception {
        int min = 100;
        this.observable.setValue((Object)min);
        SpinnerObservableValueMinTest.assertEquals((int)min, (int)this.spinner.getMinimum());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Spinner spinner;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.spinner = new Spinner((Composite)this.shell, 0);
            this.spinner.setMaximum(1000);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.minimum().observe(realm, (Object)this.spinner);
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object getValueType(IObservableValue observable) {
            return Integer.TYPE;
        }

        public Object createValue(IObservableValue observable) {
            return this.createIntegerValue(observable);
        }

        private Integer createIntegerValue(IObservableValue observable) {
            return (Integer)observable.getValue() + 1;
        }
    }
}

