/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableCollectionContentProviderTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    private TableViewer viewer;
    ObservableListContentProvider contentProvider;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.viewer = new TableViewer((Composite)this.shell);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
        this.shell = null;
        this.viewer = null;
        super.tearDown();
    }

    @Test
    public void testGetKnownElements_DisposedWithoutModificationOnContentProviderDispose() {
        WritableList input = new WritableList(Collections.singletonList("element"), null);
        this.contentProvider = new ObservableListContentProvider();
        this.contentProvider.inputChanged((Viewer)this.viewer, null, (Object)input);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        this.contentProvider.getElements((Object)input);
        Assert.assertEquals((long)1L, (long)knownElements.size());
        DisposeEventTracker disposeTracker = DisposeEventTracker.observe((IObservable)knownElements);
        ChangeEventTracker changeTracker = ChangeEventTracker.observe((IObservable)knownElements);
        this.contentProvider.dispose();
        Assert.assertEquals((long)0L, (long)changeTracker.count);
        Assert.assertEquals((long)1L, (long)disposeTracker.count);
        Assert.assertTrue((boolean)knownElements.isDisposed());
    }

    @Test
    public void testKnownElementsAreFilledOnSettingAFilledCollectionAsInput() {
        WritableList input = new WritableList(Collections.singletonList("element"), null);
        this.contentProvider = new ObservableListContentProvider();
        this.contentProvider.inputChanged((Viewer)this.viewer, null, (Object)input);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        Assert.assertEquals((long)1L, (long)knownElements.size());
        Assert.assertTrue((boolean)knownElements.containsAll((Collection)input));
    }
}

