/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableCollectionTreeContentProviderTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    private TreeViewer viewer;
    ObservableListTreeContentProvider contentProvider;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.viewer = new TreeViewer((Composite)this.shell);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
        this.shell = null;
        this.viewer = null;
        super.tearDown();
    }

    @Test
    public void testGetKnownElements_ExcludesInput() {
        Object input = new Object();
        Object[] rootElements = new Object[]{"one", "two", "three"};
        WritableList rootElementList = new WritableList(Arrays.asList(rootElements), null);
        this.contentProvider = new ObservableListTreeContentProvider(arg_0 -> ObservableCollectionTreeContentProviderTest.lambda$0(input, (IObservableList)rootElementList, arg_0), null);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setInput(input);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        Assert.assertFalse((boolean)knownElements.contains(input));
        Assert.assertEquals(new HashSet<Object>(Arrays.asList(rootElements)), (Object)knownElements);
    }

    @Test
    public void testGetKnownElements_DisposedWithoutModificationOnContentProviderDispose() {
        Object input = new Object();
        WritableList rootElementList = new WritableList(Collections.singletonList("element"), null);
        this.contentProvider = new ObservableListTreeContentProvider(arg_0 -> ObservableCollectionTreeContentProviderTest.lambda$1(input, (IObservableList)rootElementList, arg_0), null);
        this.contentProvider.inputChanged((Viewer)this.viewer, null, input);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        this.contentProvider.getElements(input);
        Assert.assertEquals((long)1L, (long)knownElements.size());
        DisposeEventTracker disposeTracker = DisposeEventTracker.observe((IObservable)knownElements);
        ChangeEventTracker changeTracker = ChangeEventTracker.observe((IObservable)knownElements);
        this.contentProvider.dispose();
        Assert.assertEquals((long)0L, (long)changeTracker.count);
        Assert.assertEquals((long)1L, (long)disposeTracker.count);
        Assert.assertTrue((boolean)knownElements.isDisposed());
    }

    private static /* synthetic */ IObservable lambda$0(Object object, IObservableList iObservableList, Object target) {
        if (target == object) {
            return iObservableList;
        }
        return null;
    }

    private static /* synthetic */ IObservable lambda$1(Object object, IObservableList iObservableList, Object target) {
        if (target == object) {
            return iObservableList;
        }
        return null;
    }
}

