/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SelectionProviderMultiSelectionObservableListTest {
    private IPostSelectionProvider selectionProvider;
    private TableViewer viewer;
    private static String[] model = new String[]{"element0", "element1", "element2", "element3"};

    @Before
    public void setUp() throws Exception {
        Shell shell = new Shell();
        this.viewer = new TableViewer((Composite)shell, 2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)model);
        this.selectionProvider = this.viewer;
    }

    @After
    public void tearDown() throws Exception {
        Shell shell = this.viewer.getTable().getShell();
        if (!shell.isDisposed()) {
            shell.dispose();
        }
    }

    @Test
    public void testConstructorIllegalArgumentException() {
        try {
            ViewersObservables.observeMultiSelection(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testAddRemove_NormalSelection() {
        this.doTestAddRemove(false);
    }

    @Test
    public void testAddRemove_PostSelection() {
        this.doTestAddRemove(true);
    }

    private void doTestAddRemove(boolean postSelection) {
        IObservableList observable = postSelection ? ViewersObservables.observeMultiPostSelection((IPostSelectionProvider)this.selectionProvider) : ViewersObservables.observeMultiSelection((ISelectionProvider)this.selectionProvider);
        ListChangeEventTracker listener = ListChangeEventTracker.observe((IObservableList)observable);
        Assert.assertEquals((long)0L, (long)observable.size());
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)model[0]));
        Assert.assertEquals((long)1L, (long)listener.count);
        this.assertDiff(listener.event.diff, Collections.EMPTY_LIST, Collections.singletonList(model[0]));
        Assert.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        Assert.assertEquals((long)1L, (long)observable.size());
        Assert.assertEquals((Object)model[0], (Object)observable.get(0));
        this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)model[1]));
        Assert.assertEquals((long)2L, (long)listener.count);
        Assert.assertEquals((long)2L, (long)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Collections.singletonList(model[0]), Collections.singletonList(model[1]));
        Assert.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        Assert.assertEquals((long)1L, (long)observable.size());
        Assert.assertEquals((Object)model[1], (Object)observable.get(0));
        this.selectionProvider.setSelection((ISelection)new StructuredSelection(new Object[]{model[2], model[3]}));
        Assert.assertEquals((long)3L, (long)listener.count);
        Assert.assertEquals((long)3L, (long)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Collections.singletonList(model[1]), Arrays.asList(model[2], model[3]));
        Assert.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        Assert.assertEquals((long)2L, (long)observable.size());
        Assert.assertEquals((Object)model[2], (Object)observable.get(0));
        Assert.assertEquals((Object)model[3], (Object)observable.get(1));
        this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        Assert.assertEquals((long)4L, (long)listener.count);
        Assert.assertEquals((long)2L, (long)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Arrays.asList(model[2], model[3]), Collections.EMPTY_LIST);
        Assert.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        Assert.assertEquals((long)0L, (long)observable.size());
        observable.add((Object)model[1]);
        Assert.assertEquals((long)5L, (long)listener.count);
        Assert.assertEquals((long)1L, (long)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Collections.EMPTY_LIST, Collections.singletonList(model[1]));
        Assert.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        Assert.assertEquals((long)1L, (long)this.viewer.getStructuredSelection().size());
        observable.add(0, (Object)model[2]);
        Assert.assertEquals((long)6L, (long)listener.count);
        Assert.assertEquals((long)1L, (long)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Collections.singletonList(model[1]), Arrays.asList(model[1], model[2]));
        Assert.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        Assert.assertEquals((long)2L, (long)this.viewer.getStructuredSelection().size());
        observable.clear();
        Assert.assertEquals((long)7L, (long)listener.count);
        Assert.assertEquals((long)2L, (long)listener.event.diff.getDifferences().length);
        this.assertDiff(listener.event.diff, Arrays.asList(model[1], model[2]), Collections.EMPTY_LIST);
        Assert.assertEquals((Object)observable, (Object)listener.event.getObservableList());
        Assert.assertEquals((long)0L, (long)this.viewer.getStructuredSelection().size());
    }

    private void assertDiff(ListDiff diff, List oldList, List newList) {
        oldList = new ArrayList(oldList);
        diff.applyTo(oldList);
        Assert.assertEquals((String)"applying diff to list did not produce expected result", (Object)newList, oldList);
    }
}

