/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementMap;
import org.eclipse.jface.viewers.IElementComparer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewerElementMapTest {
    IdentityElementComparer comparer;
    ViewerElementMap map;
    Object key;
    Object value;

    @Before
    public void setUp() throws Exception {
        this.comparer = new IdentityElementComparer();
        this.map = new ViewerElementMap((IElementComparer)this.comparer);
        this.key = new Object();
        this.value = new Object();
    }

    @Test
    public void testConstructor_NullComparer() {
        try {
            new ViewerElementMap(null);
            Assert.fail((String)"Constructor should throw exception when null comparer passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    @Test
    public void testConstructorWithCollection_NullCollection() {
        try {
            new ViewerElementMap(null, (IElementComparer)new IdentityElementComparer());
            Assert.fail((String)"Constructor should throw exception when null collection passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    @Test
    public void testConstructorWithCollection_ContainsAllEntries() {
        HashMap<Object, Object> toCopy = new HashMap<Object, Object>();
        toCopy.put(new Object(), new Object());
        this.map = new ViewerElementMap(toCopy, (IElementComparer)new IdentityElementComparer());
        Assert.assertEquals(toCopy, (Object)this.map);
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.map.isEmpty());
        this.map.put(this.key, this.value);
        Assert.assertFalse((boolean)this.map.isEmpty());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.map.size());
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)this.map.size());
    }

    @Test
    public void testClear() {
        this.map.put(this.key, this.value);
        Assert.assertFalse((boolean)this.map.isEmpty());
        this.map.clear();
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void testGet() {
        Assert.assertNull((Object)this.map.get(this.key));
        this.map.put(this.key, this.value);
        Assert.assertEquals((Object)this.value, (Object)this.map.get(this.key));
    }

    @Test
    public void testContainsKey() {
        String key1 = new String("key");
        String key2 = new String("key");
        Assert.assertFalse((boolean)this.map.containsKey((Object)key1));
        this.map.put((Object)key1, this.value);
        Assert.assertTrue((boolean)this.map.containsKey((Object)key1));
        Assert.assertFalse((boolean)this.map.containsKey((Object)key2));
    }

    @Test
    public void testContainsValue() {
        Assert.assertFalse((boolean)this.map.containsValue(this.value));
        this.map.put(this.key, this.value);
        Assert.assertTrue((boolean)this.map.containsValue(this.value));
    }

    @Test
    public void testPutAll() {
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(this.key, this.value);
        Assert.assertTrue((boolean)this.map.isEmpty());
        this.map.putAll(other);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.containsKey(this.key));
        Assert.assertEquals((Object)this.value, (Object)this.map.get(this.key));
    }

    @Test
    public void testRemove() {
        this.map.put(this.key, this.value);
        Assert.assertTrue((boolean)this.map.containsKey(this.key));
        this.map.remove(this.key);
        Assert.assertFalse((boolean)this.map.containsKey(this.key));
    }

    @Test
    public void testValues() {
        Collection values = this.map.values();
        Assert.assertTrue((boolean)values.isEmpty());
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)this.value, values.iterator().next());
        this.map.remove(this.key);
        Assert.assertTrue((boolean)this.map.values().isEmpty());
    }

    @Test
    public void testKeySet() {
        Set keySet = this.map.keySet();
        Assert.assertTrue((boolean)keySet.isEmpty());
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)keySet.size());
        Assert.assertTrue((boolean)keySet.contains(this.key));
        this.map.remove(this.key);
        Assert.assertTrue((boolean)keySet.isEmpty());
    }

    @Test
    public void testKeySet_Add() {
        try {
            this.map.keySet().add(this.key);
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    @Test
    public void testKeySet_AddAll() {
        try {
            this.map.keySet().addAll(Collections.singleton(this.key));
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    @Test
    public void testKeySet_Clear() {
        this.map.put(this.key, this.value);
        Set keySet = this.map.keySet();
        Assert.assertTrue((boolean)keySet.contains(this.key));
        keySet.clear();
        Assert.assertTrue((boolean)keySet.isEmpty());
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void testKeySet_Contains() {
        Set keySet = this.map.keySet();
        Assert.assertFalse((boolean)keySet.contains(this.key));
        this.map.put(this.key, this.value);
        Assert.assertTrue((boolean)keySet.contains(this.key));
    }

    @Test
    public void testKeySet_ContainsAll() {
        Set keySet = this.map.keySet();
        Assert.assertFalse((boolean)keySet.containsAll(Collections.singleton(this.key)));
        this.map.put(this.key, this.value);
        Assert.assertTrue((boolean)keySet.containsAll(Collections.singleton(this.key)));
    }

    @Test
    public void testKeySet_IsEmpty() {
        Set keySet = this.map.keySet();
        Assert.assertTrue((boolean)keySet.isEmpty());
        this.map.put(this.key, this.value);
        Assert.assertFalse((boolean)keySet.isEmpty());
    }

    @Test
    public void testKeySet_Iterator() {
        this.map.put(this.key, this.value);
        Iterator iterator = this.map.keySet().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)this.key, iterator.next());
        Assert.assertEquals((long)1L, (long)this.map.size());
        iterator.remove();
        Assert.assertTrue((boolean)this.map.isEmpty());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testKeySet_Remove() {
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)this.map.size());
        this.map.keySet().remove(this.key);
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void testKeySet_RemoveAll() {
        this.map.put(this.key, this.value);
        Set keySet = this.map.keySet();
        Assert.assertFalse((boolean)keySet.removeAll(Collections.EMPTY_SET));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)keySet.removeAll(Collections.singleton(this.key)));
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void testKeySet_RetainAll() {
        this.map.put(this.key, this.value);
        Set keySet = this.map.keySet();
        Assert.assertFalse((boolean)keySet.retainAll(Collections.singleton(this.key)));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)keySet.retainAll(Collections.EMPTY_SET));
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void testKeySet_Size() {
        Set keySet = this.map.keySet();
        Assert.assertEquals((long)0L, (long)keySet.size());
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)keySet.size());
        this.map.clear();
        Assert.assertEquals((long)0L, (long)keySet.size());
    }

    @Test
    public void testKeySet_ToArray() {
        Set keySet = this.map.keySet();
        this.map.put(this.key, this.value);
        Object[] array = keySet.toArray();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertSame((Object)this.key, (Object)array[0]);
    }

    @Test
    public void testKeySet_ToArrayWithObjectArray() {
        this.key = new String("key");
        this.map.put(this.key, this.value);
        String[] array = this.map.keySet().toArray(new String[0]);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertSame((Object)this.key, (Object)array[0]);
    }

    @Test
    public void testKeySet_Equals() {
        Set keySet = this.map.keySet();
        Assert.assertFalse((boolean)keySet.equals(null));
        Assert.assertTrue((boolean)keySet.equals(keySet));
        Assert.assertTrue((boolean)keySet.equals(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        Assert.assertTrue((boolean)keySet.equals(Collections.singleton(this.key)));
    }

    @Test
    public void testKeySet_HashCode() {
        Set keySet = this.map.keySet();
        Assert.assertEquals((long)0L, (long)keySet.hashCode());
        this.map.put(this.key, this.value);
        int hash = this.comparer.hashCode(this.key);
        Assert.assertEquals((long)hash, (long)keySet.hashCode());
    }

    @Test
    public void testEntrySet() {
        Set entrySet = this.map.entrySet();
        Assert.assertTrue((boolean)entrySet.isEmpty());
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)entrySet.size());
        Map.Entry entry = (Map.Entry)entrySet.iterator().next();
        Assert.assertEquals((Object)this.key, entry.getKey());
        Assert.assertEquals((Object)this.value, entry.getValue());
        this.map.remove(this.key);
        Assert.assertTrue((boolean)entrySet.isEmpty());
    }

    @Test
    public void testEntrySet_Add() {
        try {
            this.map.entrySet().add(this.key);
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    @Test
    public void testEntrySet_AddAll() {
        try {
            this.map.entrySet().addAll(Collections.EMPTY_SET);
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    @Test
    public void testEntrySet_Clear() {
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)this.map.size());
        this.map.entrySet().clear();
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void testEntrySet_Contains() {
        this.map.put(this.key, this.value);
        Set entrySet = this.map.entrySet();
        Assert.assertTrue((boolean)entrySet.contains(new MapEntryStub(this.key, this.value)));
        this.map.remove(this.key);
        Assert.assertFalse((boolean)entrySet.contains(new MapEntryStub(this.key, this.value)));
    }

    @Test
    public void testEntrySet_ContainsAll() {
        Set entrySet = this.map.entrySet();
        Assert.assertFalse((boolean)entrySet.containsAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
        Assert.assertTrue((boolean)entrySet.containsAll(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        Assert.assertTrue((boolean)entrySet.containsAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
    }

    @Test
    public void testEntrySet_IsEmpty() {
        Set entrySet = this.map.entrySet();
        Assert.assertTrue((boolean)entrySet.isEmpty());
        this.map.put(this.key, this.value);
        Assert.assertFalse((boolean)entrySet.isEmpty());
    }

    @Test
    public void testEntrySet_Iterator() {
        this.map.put(this.key, this.value);
        Iterator iterator = this.map.entrySet().iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Map.Entry entry = (Map.Entry)iterator.next();
        Assert.assertTrue((boolean)entry.equals(new MapEntryStub(this.key, this.value)));
        Assert.assertEquals((long)1L, (long)this.map.size());
        iterator.remove();
        Assert.assertTrue((boolean)this.map.isEmpty());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testEntrySet_Remove() {
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.entrySet().remove(new MapEntryStub(this.key, this.value)));
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void testEntrySet_RemoveAll() {
        Set entrySet = this.map.entrySet();
        Assert.assertFalse((boolean)entrySet.removeAll(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)entrySet.removeAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void testEntrySet_RetainAll() {
        Set entrySet = this.map.entrySet();
        Assert.assertFalse((boolean)entrySet.retainAll(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertFalse((boolean)entrySet.retainAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)entrySet.retainAll(Collections.EMPTY_SET));
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void testEntrySet_Size() {
        Set entrySet = this.map.entrySet();
        Assert.assertEquals((long)0L, (long)entrySet.size());
        this.map.put(this.key, this.value);
        Assert.assertEquals((long)1L, (long)entrySet.size());
    }

    @Test
    public void testEntrySet_ToArray() {
        Set entrySet = this.map.entrySet();
        Assert.assertEquals((long)0L, (long)entrySet.toArray().length);
        this.map.put(this.key, this.value);
        Object[] array = entrySet.toArray();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)array[0].equals(new MapEntryStub(this.key, this.value)));
    }

    @Test
    public void testEntrySet_ToArrayWithObjectArray() {
        Set entrySet = this.map.entrySet();
        Assert.assertEquals((long)0L, (long)entrySet.toArray(new Object[0]).length);
        this.map.put(this.key, this.value);
        Map.Entry[] array = entrySet.toArray(new Map.Entry[0]);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)array[0].equals(new MapEntryStub(this.key, this.value)));
    }

    @Test
    public void testEntrySet_Equals() {
        Set entrySet = this.map.entrySet();
        Assert.assertFalse((boolean)entrySet.equals(null));
        Assert.assertTrue((boolean)entrySet.equals(entrySet));
        Assert.assertTrue((boolean)entrySet.equals(Collections.EMPTY_SET));
        Assert.assertFalse((boolean)entrySet.equals(Collections.singleton(new MapEntryStub(this.key, this.value))));
        this.map.put(this.key, this.value);
        Assert.assertFalse((boolean)entrySet.equals(Collections.EMPTY_SET));
        Assert.assertTrue((boolean)entrySet.equals(Collections.singleton(new MapEntryStub(this.key, this.value))));
    }

    @Test
    public void testEntrySet_HashCode() {
        Set entrySet = this.map.entrySet();
        Assert.assertEquals((long)0L, (long)entrySet.hashCode());
        this.map.put(this.key, this.value);
        int hash = this.comparer.hashCode(this.key) ^ this.value.hashCode();
        Assert.assertEquals((long)hash, (long)entrySet.hashCode());
    }

    @Test
    public void testEntrySet_Entry_SetValue() {
        this.map.put(this.key, this.value);
        Map.Entry entry = (Map.Entry)this.map.entrySet().iterator().next();
        Object newValue = new Object();
        Object oldValue = entry.setValue(newValue);
        Assert.assertEquals((Object)this.value, (Object)oldValue);
        Assert.assertEquals((Object)newValue, entry.getValue());
        Assert.assertEquals((Object)newValue, (Object)this.map.get(this.key));
    }

    @Test
    public void testEntrySet_Entry_Equals() {
        this.map.put(this.key, this.value);
        Map.Entry entry = (Map.Entry)this.map.entrySet().iterator().next();
        Assert.assertFalse((boolean)entry.equals(null));
        Assert.assertTrue((boolean)entry.equals(entry));
        Assert.assertTrue((boolean)entry.equals(new MapEntryStub(this.key, this.value)));
    }

    @Test
    public void testEntrySet_Entry_HashCode() {
        this.map.put(this.key, this.value);
        int hash = this.comparer.hashCode(this.key) ^ this.value.hashCode();
        Assert.assertEquals((long)hash, (long)this.map.entrySet().iterator().next().hashCode());
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.map.equals(null));
        Assert.assertTrue((boolean)this.map.equals((Object)this.map));
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(this.key, this.value);
        Assert.assertTrue((boolean)this.map.equals((Object)Collections.EMPTY_MAP));
        Assert.assertFalse((boolean)this.map.equals(other));
        this.map.put(this.key, this.value);
        Assert.assertFalse((boolean)this.map.equals((Object)Collections.EMPTY_MAP));
        Assert.assertTrue((boolean)this.map.equals(other));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)0L, (long)this.map.hashCode());
        this.map.put(this.key, this.value);
        int hash = this.comparer.hashCode(this.key) ^ this.value.hashCode();
        Assert.assertEquals((long)hash, (long)this.map.hashCode());
    }

    @Test
    public void testWithComparer() {
        Assert.assertFalse((boolean)(ViewerElementMap.withComparer(null) instanceof ViewerElementMap));
        Assert.assertTrue((boolean)(ViewerElementMap.withComparer((IElementComparer)this.comparer) instanceof ViewerElementMap));
    }

    static class IdentityElementComparer
    implements IElementComparer {
        IdentityElementComparer() {
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }

        public int hashCode(Object element) {
            return System.identityHashCode(element);
        }
    }

    static class MapEntryStub
    implements Map.Entry {
        private final Object key;
        private final Object value;

        public MapEntryStub(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

