/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import org.eclipse.jface.internal.databinding.viewers.ViewerElementWrapper;
import org.eclipse.jface.viewers.IElementComparer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewerElementWrapperTest {
    private ViewerElementWrapper wrapper;
    private Object element;
    private IElementComparer comparer;

    @Before
    public void setUp() throws Exception {
        this.element = new ElementStub(0);
        this.comparer = new IdentityElementComparer();
        this.wrapper = new ViewerElementWrapper(this.element, this.comparer);
    }

    @Test
    public void testConstructor_NullComparer() {
        try {
            new ViewerElementWrapper(this.element, null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {}
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.wrapper.equals(null));
        Assert.assertTrue((boolean)this.wrapper.equals((Object)this.wrapper));
        Assert.assertTrue((boolean)this.wrapper.equals((Object)new ViewerElementWrapper(this.element, this.comparer)));
    }

    @Test
    public void testHashCode() {
        int hash = 0;
        this.element = new ElementStub(hash);
        this.wrapper = new ViewerElementWrapper(this.element, this.comparer);
        Assert.assertEquals((long)System.identityHashCode(this.element), (long)this.wrapper.hashCode());
        Assert.assertEquals((long)hash, (long)this.element.hashCode());
    }

    static class ElementStub {
        private final int hash;

        public ElementStub(int hash) {
            this.hash = hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ElementStub that = (ElementStub)obj;
            return this.hash == that.hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class IdentityElementComparer
    implements IElementComparer {
        IdentityElementComparer() {
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }

        public int hashCode(Object element) {
            return System.identityHashCode(element);
        }
    }
}

