/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewerInputObservableValueTest
extends AbstractDefaultRealmTestCase {
    private TableViewer viewer;
    private static String[] model = new String[]{"0", "1"};

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Shell shell = new Shell();
        this.viewer = new TableViewer((Composite)shell, 0);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        Shell shell = this.viewer.getTable().getShell();
        if (!shell.isDisposed()) {
            shell.dispose();
        }
        super.tearDown();
    }

    @Test
    public void testConstructor_IllegalArgumentException() {
        try {
            ViewersObservables.observeInput(null);
            Assert.fail((String)"Expected IllegalArgumentException for null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testSetInputOnViewer_FiresChangeEventOnGetValue() {
        IObservableValue observable = ViewersObservables.observeInput((Viewer)this.viewer);
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe((IObservableValue)observable);
        Assert.assertNull((Object)this.viewer.getInput());
        Assert.assertEquals((long)0L, (long)listener.count);
        this.viewer.setInput((Object)model);
        Assert.assertEquals((Object)model, (Object)this.viewer.getInput());
        Assert.assertEquals((long)0L, (long)listener.count);
        Assert.assertEquals((Object)model, (Object)observable.getValue());
        Assert.assertEquals((long)1L, (long)listener.count);
        this.viewer.setInput(null);
        Assert.assertEquals(null, (Object)this.viewer.getInput());
        Assert.assertEquals(null, (Object)observable.getValue());
        Assert.assertEquals((long)2L, (long)listener.count);
    }

    @Test
    public void testGetSetValue_FiresChangeEvents() {
        IObservableValue observable = ViewersObservables.observeInput((Viewer)this.viewer);
        ValueChangeEventTracker listener = new ValueChangeEventTracker();
        observable.addValueChangeListener((IValueChangeListener)listener);
        Assert.assertNull((Object)observable.getValue());
        Assert.assertEquals((long)0L, (long)listener.count);
        observable.setValue((Object)model);
        Assert.assertEquals((Object)model, (Object)observable.getValue());
        Assert.assertEquals((long)1L, (long)listener.count);
        this.assertValueChangeEventEquals(observable, null, model, listener.event);
        observable.setValue(null);
        Assert.assertNull((Object)observable.getValue());
        Assert.assertEquals((long)2L, (long)listener.count);
        this.assertValueChangeEventEquals(observable, model, null, listener.event);
    }

    @Test
    public void testGetValueType_AlwaysNull() throws Exception {
        IObservableValue observable = ViewersObservables.observeInput((Viewer)this.viewer);
        Assert.assertEquals(null, (Object)observable.getValueType());
    }

    @Test
    public void testDispose() throws Exception {
        IObservableValue observable = ViewersObservables.observeInput((Viewer)this.viewer);
        observable.dispose();
        try {
            observable.setValue((Object)model);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void assertValueChangeEventEquals(IObservableValue expectedObservable, Object expectedOldValue, Object expectedNewValue, ValueChangeEvent event) {
        Assert.assertSame((Object)expectedObservable, (Object)event.getObservableValue());
        Assert.assertEquals((Object)expectedOldValue, (Object)event.diff.getOldValue());
        Assert.assertEquals((Object)expectedNewValue, (Object)event.diff.getNewValue());
    }

    public static void addConformanceTest(TestSuite suite) {
        suite.addTest(MutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
    }

    static class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (String[])inputElement;
        }
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        TableViewer viewer;

        Delegate() {
        }

        public void setUp() {
            super.setUp();
            Shell shell = new Shell();
            this.viewer = new TableViewer((Composite)shell, 0);
            this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        }

        public void tearDown() {
            Shell shell = this.viewer.getTable().getShell();
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            super.tearDown();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return ViewerProperties.input().observe(realm, (Object)this.viewer);
        }

        public void change(IObservable observable) {
            IObservableValue value = (IObservableValue)observable;
            value.setValue(this.createValue(value));
        }

        public Object createValue(IObservableValue observable) {
            return new String[]{"one", "two"};
        }

        public Object getValueType(IObservableValue observable) {
            return null;
        }
    }
}

