/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.internal.text.html.HTML2TextReader;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.junit.Assert;
import org.junit.Test;

public class HTML2TextReaderTest {
    private static final boolean DEBUG = false;
    private static final String LD = System.getProperty("line.separator", "\n");

    @Deprecated
    private void verify(String input, String expectedOutput, int styleRangeCount) throws IOException {
        String result;
        StringReader reader = new StringReader(input);
        TextPresentation textPresentation = new TextPresentation();
        Throwable throwable = null;
        Object var8_8 = null;
        try (HTML2TextReader htmlReader = new HTML2TextReader((Reader)reader, textPresentation);){
            result = htmlReader.getString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((Object)expectedOutput, (Object)result);
        Iterator styleRangeIterator = textPresentation.getAllStyleRangeIterator();
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        while (styleRangeIterator.hasNext()) {
            ranges.add((StyleRange)styleRangeIterator.next());
        }
        Assert.assertEquals((String)"Incorrect number of style ranges", (long)styleRangeCount, (long)ranges.size());
        Collections.sort(ranges, (r1, r2) -> r1.start - r2.start);
        int i = 0;
        while (i < ranges.size() - 1) {
            StyleRange range1 = (StyleRange)ranges.get(i);
            StyleRange range2 = (StyleRange)ranges.get(i + 1);
            if (range1.start + range1.length > range2.start) {
                Assert.assertTrue((String)"StyleRanges overlap", (boolean)false);
            }
            ++i;
        }
    }

    private void verify(String input, String expectedOutput, StyleRange[] styleRanges) throws IOException {
        String result;
        StringReader reader = new StringReader(input);
        TextPresentation textPresentation = new TextPresentation();
        Throwable throwable = null;
        Object var8_8 = null;
        try (HTML2TextReader htmlReader = new HTML2TextReader((Reader)reader, textPresentation);){
            result = htmlReader.getString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((Object)expectedOutput, (Object)result);
        Iterator styleRangeIterator = textPresentation.getAllStyleRangeIterator();
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        while (styleRangeIterator.hasNext()) {
            ranges.add((StyleRange)styleRangeIterator.next());
        }
        Collections.sort(ranges, (r1, r2) -> r1.start - r2.start);
        Assert.assertEquals(Arrays.asList(styleRanges), ranges);
        int i = 0;
        while (i < ranges.size() - 1) {
            StyleRange range1 = (StyleRange)ranges.get(i);
            StyleRange range2 = (StyleRange)ranges.get(i + 1);
            if (range1.start + range1.length > range2.start) {
                Assert.assertTrue((String)"StyleRanges overlap", (boolean)false);
            }
            ++i;
        }
    }

    @Test
    public void test0() throws IOException {
        String string = "<code>3<5<code>";
        String expected = "3<5";
        this.verify(string, expected, 0);
    }

    @Test
    public void test1() throws IOException {
        String string = "<dl><dt>@author</dt><dd>Foo Bar</dd></dl>";
        String expected = String.valueOf(LD) + "@author" + LD + "\tFoo Bar" + LD;
        this.verify(string, expected, 1);
    }

    @Test
    public void test2() throws IOException {
        String string = "<code>3>5<code>";
        String expected = "3>5";
        this.verify(string, expected, 0);
    }

    @Test
    public void test3() throws IOException {
        String string = "<a href= \"<p>this is only a string - not a tag<p>\">text</a>";
        String expected = "text";
        this.verify(string, expected, 0);
    }

    @Test
    public void test4() throws IOException {
        String string = "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1><h5>void p.Bb.fes()</h5><p><dl><dt>Parameters:</dt><dd><b>i</b> fred or <code>null</code></dd></dl></font></body></html>";
        String expected = "void p.Bb.fes()" + LD + LD + LD + "Parameters:" + LD + "\ti fred or null" + LD;
        this.verify(string, expected, 3);
    }

    @Test
    public void test5() throws IOException {
        String string = "<code>1<2<3<4</code>";
        String expected = "1<2<3<4";
        this.verify(string, expected, 0);
    }

    @Test
    public void test6() throws IOException {
        String string = "<p>Something.<p>Something more.";
        String expected = String.valueOf(LD) + "Something." + LD + "Something more.";
        this.verify(string, expected, 0);
    }

    @Test
    public void testEntity1() throws IOException {
        String string = "&amp;";
        String expected = "&";
        this.verify(string, expected, 0);
    }

    @Test
    public void testEntity2() throws IOException {
        String string = "&unknown;";
        String expected = "&unknown;";
        this.verify(string, expected, 0);
    }

    @Test
    public void testBug367378() throws IOException {
        this.verify("<head>", "", 0);
        this.verify("<head>some styles</html>", "", 0);
        char[] cb = new char[20];
        StringReader reader = new StringReader("<head>");
        Throwable throwable = null;
        Object var4_5 = null;
        try (HTML2TextReader r = new HTML2TextReader((Reader)reader, null);){
            r.read(cb);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)Arrays.equals(new char[20], cb));
    }

    @Test
    public void testComments() throws Exception {
        String string = "<!-- begin-user-doc -->no comment<!-- end-user-doc -->";
        String expected = "no comment";
        this.verify(string, expected, 0);
    }

    @Test
    public void testStyles1() throws IOException {
        String string = "<b>Hello World</b>";
        String expected = "Hello World";
        this.verify(string, expected, 1);
    }

    @Test
    public void testStyles2() throws IOException {
        String string = "<del>Hello World</del>";
        String expected = "Hello World";
        this.verify(string, expected, 1);
    }

    @Test
    public void testStyles3() throws IOException {
        String string = "<b><del>Hello World</del></b>";
        String expected = "Hello World";
        this.verify(string, expected, 1);
    }

    @Test
    public void testStyles4() throws IOException {
        String string = "<del><b>Hello World</b></del>";
        String expected = "Hello World";
        this.verify(string, expected, 1);
    }

    @Test
    public void testStyles5() throws IOException {
        String string = "<b>This <del> is a </del> test</b>";
        String expected = "This is a test";
        this.verify(string, expected, 3);
    }

    @Test
    public void testStyles6() throws IOException {
        String string = "<del>This <b> is a </b> test</del>";
        String expected = "This is a test";
        this.verify(string, expected, 3);
    }

    @Test
    public void testStyles7() throws IOException {
        String string = "<b>This<del>is a</del>test</b>";
        String expected = "Thisis atest";
        this.verify(string, expected, 3);
    }

    @Test
    public void testStyles8() throws IOException {
        String string = "<del>This<b>is a</b>test</del>";
        String expected = "Thisis atest";
        this.verify(string, expected, 3);
    }

    @Test
    public void testStyles9() throws IOException {
        String string = "<b>This <del>is <b>yet</b> another</del> test</b>";
        String expected = "This is yet another test";
        this.verify(string, expected, 3);
    }

    @Test
    public void testStyles10() throws IOException {
        String string = "<del>This <b>is <del>yet</del> another </b>test</del>";
        String expected = "This is yet another test";
        this.verify(string, expected, 3);
    }

    @Test
    public void testStylesWithPre() throws IOException {
        String string = "I am <b>bold</b>." + LD + "<p>" + LD + "<pre>One" + LD + LD + "<b>T</b>hree.</pre>" + LD + "<p>" + LD + "<b>Author:</b> me.";
        String expected = "I am bold. " + LD + "One" + LD + LD + "Three. " + LD + "Author: me.";
        StyleRange[] ranges = new StyleRange[]{new StyleRange(5, 4, null, null, 1), new StyleRange(14 + 3 * LD.length(), 1, null, null, 1), new StyleRange(21 + 4 * LD.length(), 7, null, null, 1)};
        this.verify(string, expected, ranges);
    }

    @Test
    public void testCombineBoldItalicStriker() throws IOException {
        String string = "<strong>strong</strong>,<em>italic</em>,<s>strike</s>,<strong><em>strongItalic</em></strong>,<s><strong>strongStrike</strong></s>,<em><s>italicStrike</s></em>,<em><strong><s>strongItalicStrike</s></strong></em>,none";
        String expected = "strong,italic,strike,strongItalic,strongStrike,italicStrike,strongItalicStrike,none";
        StyleRange[] ranges = new StyleRange[]{new StyleRange(0, 6, null, null, 1), new StyleRange(7, 6, null, null, 2), this.strike(new StyleRange(14, 6, null, null)), new StyleRange(21, 12, null, null, 3), this.strike(new StyleRange(34, 12, null, null, 1)), this.strike(new StyleRange(47, 12, null, null, 2)), this.strike(new StyleRange(60, 18, null, null, 3))};
        this.verify(string, expected, ranges);
    }

    private StyleRange strike(StyleRange styleRange) {
        styleRange.strikeout = true;
        return styleRange;
    }
}

