/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.tests.TestTextEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public class TestTextViewer
implements ISourceViewer,
IDocumentListener {
    protected IDocument fDocument;
    protected List<ITextInputListener> fInputListeners = new ArrayList<ITextInputListener>();
    protected List<ITextListener> fTextListeners = new ArrayList<ITextListener>();
    protected TextPresentation fTextPresentation;
    protected Point fSelection = new Point(-1, -1);
    protected String fDeletion;

    public void setDocument(IDocument document, int p1, int p2) {
        this.setDocument(document);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocument(IDocument document) {
        IDocument oldDoc = this.fDocument;
        this.fireTextInputChanged(oldDoc, document, true);
        if (oldDoc != null) {
            oldDoc.removeDocumentListener((IDocumentListener)this);
        }
        this.fDocument = document;
        if (this.fDocument != null) {
            this.fireTextChanged(new TestTextEvent(this.fDocument.get()));
            this.fDocument.addDocumentListener((IDocumentListener)this);
        }
        this.fireTextInputChanged(oldDoc, document, false);
    }

    public void removeTextInputListener(ITextInputListener listener) {
        this.fInputListeners.remove(listener);
    }

    public void addTextInputListener(ITextInputListener listener) {
        if (!this.fInputListeners.contains(listener)) {
            this.fInputListeners.add(listener);
        }
    }

    protected void fireTextInputChanged(IDocument oldDoc, IDocument newDoc, boolean about) {
        for (ITextInputListener l : new ArrayList<ITextInputListener>(this.fInputListeners)) {
            if (about) {
                l.inputDocumentAboutToBeChanged(oldDoc, newDoc);
                continue;
            }
            l.inputDocumentChanged(oldDoc, newDoc);
        }
    }

    public void changeTextPresentation(TextPresentation presentation, boolean p1) {
        this.fTextPresentation = presentation;
    }

    public void invalidateTextPresentation() {
    }

    public TextPresentation getTextPresentation() {
        return this.fTextPresentation;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        try {
            this.fDeletion = this.fDocument.get(event.getOffset(), event.getLength());
        }
        catch (BadLocationException badLocationException) {}
    }

    public void documentChanged(DocumentEvent event) {
        this.fireTextChanged(new TestTextEvent(event, this.fDeletion));
    }

    public IFindReplaceTarget getFindReplaceTarget() {
        return null;
    }

    public ITextOperationTarget getTextOperationTarget() {
        return null;
    }

    public void setTextColor(Color p0, int p1, int p2, boolean p3) {
    }

    public void setTextColor(Color p0) {
    }

    public boolean overlapsWithVisibleRegion(int p0, int p1) {
        return false;
    }

    public IRegion getVisibleRegion() {
        return null;
    }

    public void resetVisibleRegion() {
    }

    public void setVisibleRegion(int p0, int p1) {
    }

    public void setIndentPrefixes(String[] p0, String p1) {
    }

    public void setDefaultPrefixes(String[] p0, String p1) {
    }

    public void setAutoIndentStrategy(IAutoIndentStrategy p0, String p1) {
    }

    public void setTextDoubleClickStrategy(ITextDoubleClickStrategy p0, String p1) {
    }

    public void setUndoManager(IUndoManager p0) {
    }

    public StyledText getTextWidget() {
        return null;
    }

    public void setTextHover(ITextHover p0, String p1) {
    }

    public void activatePlugins() {
    }

    public void resetPlugins() {
    }

    public int getTopInset() {
        return 0;
    }

    public int getBottomIndexEndOffset() {
        return 0;
    }

    public int getBottomIndex() {
        return 0;
    }

    public int getTopIndexStartOffset() {
        return 0;
    }

    public int getTopIndex() {
        return 0;
    }

    public void setTopIndex(int p0) {
    }

    public void revealRange(int p0, int p1) {
    }

    public Point getSelectedRange() {
        return this.fSelection;
    }

    public void setSelectedRange(int offset, int length) {
        this.fSelection.x = offset;
        this.fSelection.y = length;
    }

    public boolean isEditable() {
        return true;
    }

    public void setEditable(boolean p0) {
    }

    public void setEventConsumer(IEventConsumer p0) {
    }

    public void removeTextListener(ITextListener listener) {
        this.fTextListeners.remove(listener);
    }

    protected void fireTextChanged(TextEvent event) {
        for (ITextListener l : new ArrayList<ITextListener>(this.fTextListeners)) {
            l.textChanged(event);
        }
    }

    public void addTextListener(ITextListener listener) {
        if (!this.fTextListeners.contains(listener)) {
            this.fTextListeners.add(listener);
        }
    }

    public void removeViewportListener(IViewportListener p0) {
    }

    public void addViewportListener(IViewportListener p0) {
    }

    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    public void showAnnotations(boolean p0) {
    }

    public void removeRangeIndication() {
    }

    public IRegion getRangeIndication() {
        return null;
    }

    public void setRangeIndication(int p0, int p1, boolean p2) {
    }

    public void setRangeIndicator(Annotation p0) {
    }

    public IAnnotationModel getAnnotationModel() {
        return null;
    }

    public void setDocument(IDocument p0, IAnnotationModel p1, int p2, int p3) {
    }

    public void setDocument(IDocument p0, IAnnotationModel p1) {
    }

    public void setAnnotationHover(IAnnotationHover p0) {
    }

    public void configure(SourceViewerConfiguration p0) {
    }
}

