/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.history;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.tests.history.MockRefactoring;

public class MockRefactoringDescriptor
extends RefactoringDescriptor {
    public static final String ID = "org.eclipse.ltk.core.mock";
    private final Map<String, String> fArguments = new HashMap<String, String>();

    public MockRefactoringDescriptor(String project, String description, String comment, int flags) {
        super(ID, project, description, comment, flags);
    }

    public MockRefactoringDescriptor(String project, String description, String comment, Map<String, String> arguments, int flags) {
        this(project, description, comment, flags);
        this.fArguments.putAll(arguments);
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        return new MockRefactoring();
    }

    public Map<String, String> getArguments() {
        return this.fArguments;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(((Object)((Object)this)).getClass().getName());
        if (this.getID().equals("org.eclipse.ltk.core.refactoring.unknown")) {
            buffer.append("[unknown refactoring]");
        } else {
            buffer.append("[timeStamp=");
            buffer.append(this.getTimeStamp());
            buffer.append(",id=");
            buffer.append(this.getID());
            buffer.append(",description=");
            buffer.append(this.getDescription());
            buffer.append(",project=");
            buffer.append(this.getProject());
            buffer.append(",comment=");
            buffer.append(this.getComment());
            buffer.append(",arguments=");
            buffer.append(new TreeMap<String, String>(this.getArguments()));
            buffer.append(",flags=");
            buffer.append(this.getFlags());
            buffer.append("]");
        }
        return buffer.toString();
    }
}

