/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.history;

import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringExecutionListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringExecutionEvent;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistoryEvent;
import org.eclipse.ltk.core.refactoring.tests.history.MockRefactoring;
import org.eclipse.ltk.core.refactoring.tests.history.MockRefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.tests.util.SimpleTestProject;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringDescriptorProxyAdapter;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.osgi.service.prefs.BackingStoreException;

public class RefactoringHistoryServiceTests
extends TestCase {
    private static final int BREAKING_NUMBER = 20;
    private static final int COMMON_NUMBER = 20;
    private static final int CUSTOM_FLAG = 1024;
    private static final int CUSTOM_NUMBER = 5;
    private static final int NONE_NUMBER = 10;
    private static final int STAMP_FACTOR = 10000000;
    private static final int STRUCTURAL_NUMBER = 10;
    private static final int TOTAL_PROJECT_NUMBER = 45;
    private static final int TOTALZ_HISTORY_NUMBER = 65;
    private SimpleTestProject fProject;

    private void assertDescendingSortOrder(RefactoringDescriptorProxy[] proxies) {
        int index = 0;
        while (index < proxies.length - 1) {
            RefactoringHistoryServiceTests.assertTrue((String)"", (proxies[index].getTimeStamp() > proxies[index + 1].getTimeStamp() ? 1 : 0) != 0);
            ++index;
        }
    }

    private RefactoringDescriptor executeRefactoring(String project, int index, int flags) throws CoreException {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        try {
            service.setOverrideTimeStamp((long)((index + 1) * 10000000));
            MockRefactoring refactoring = new MockRefactoring(project, "A mock description number " + index, "A mock comment number " + index, Collections.emptyMap(), flags);
            MockRefactoringDescriptor descriptor = refactoring.createRefactoringDescriptor();
            PerformRefactoringOperation operation = new PerformRefactoringOperation((Refactoring)refactoring, 6);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, null);
            MockRefactoringDescriptor mockRefactoringDescriptor = descriptor;
            return mockRefactoringDescriptor;
        }
        finally {
            service.setOverrideTimeStamp(-1L);
        }
    }

    private void setSharedRefactoringHistory(boolean shared) throws BackingStoreException, CoreException {
        IEclipsePreferences preferences = new ProjectScope(this.fProject.getProject()).getNode("org.eclipse.ltk.core.refactoring");
        preferences.put("org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", Boolean.toString(shared));
        preferences.flush();
        RefactoringHistoryService.setSharedRefactoringHistory((IProject)this.fProject.getProject(), (boolean)shared, null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        service.connect();
        this.fProject = new SimpleTestProject();
        this.setSharedRefactoringHistory(true);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)this.fProject.getProject()));
        IFolder folder = this.fProject.getProject().getFolder(".refactorings");
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history folder should not exist.", (!folder.exists() ? 1 : 0) != 0);
        this.setUpTestProjectRefactorings();
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history folder should exist", (boolean)folder.exists());
    }

    private void setUpTestProjectRefactorings() throws CoreException {
        String name = this.fProject.getProject().getName();
        int index = 0;
        while (index < 10) {
            this.executeRefactoring(name, index, 0);
            ++index;
        }
        index = 0;
        while (index < 20) {
            this.executeRefactoring(name, index + 10, 1);
            ++index;
        }
        index = 0;
        while (index < 10) {
            this.executeRefactoring(name, index + 10 + 20, 2);
            ++index;
        }
        index = 0;
        while (index < 5) {
            this.executeRefactoring(name, index + 10 + 20 + 10, 1024);
            ++index;
        }
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryServiceTests.assertEquals((int)45, (int)history.getDescriptors().length);
    }

    private void setUpWorkspaceRefactorings() throws CoreException {
        int index = 0;
        while (index < 20) {
            this.executeRefactoring(null, index + 45, 1);
            ++index;
        }
    }

    protected void tearDown() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        service.deleteRefactoringHistory(this.fProject.getProject(), null);
        RefactoringHistory history = service.getWorkspaceHistory(null);
        service.deleteRefactoringDescriptors(history.getDescriptors(), null);
        history = service.getWorkspaceHistory(null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must be empty", (boolean)history.isEmpty());
        service.disconnect();
        this.fProject.delete();
        super.tearDown();
    }

    public void testDeleteProjectHistory0() throws Exception {
        this.setUpWorkspaceRefactorings();
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        service.deleteRefactoringHistory(project, null);
        RefactoringHistory projectHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history has wrong size:", (projectHistory.getDescriptors().length == 20 ? 1 : 0) != 0);
        RefactoringHistory workspaceHistory = service.getWorkspaceHistory(null);
        RefactoringDescriptorProxy[] descriptors = workspaceHistory.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size:", (int)20, (int)descriptors.length);
        int index = 0;
        while (index < descriptors.length) {
            RefactoringHistoryServiceTests.assertTrue((String)("Workspace refactoring should have no project attribute set:\n\n" + descriptors[index].toString()), (descriptors[index].getProject() == null ? 1 : 0) != 0);
            ++index;
        }
    }

    public void testDeleteProjectHistory1() throws Exception {
        this.setUpWorkspaceRefactorings();
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory workspaceHistory = service.getWorkspaceHistory(null);
        RefactoringDescriptorProxy[] descriptors = workspaceHistory.getDescriptors();
        HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>();
        int index = 0;
        while (index < descriptors.length) {
            if (descriptors[index].getProject() == null) {
                set.add(descriptors[index]);
            }
            ++index;
        }
        service.deleteRefactoringDescriptors(set.toArray(new RefactoringDescriptorProxy[set.size()]), null);
        workspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory projectHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)projectHistory, (Object)workspaceHistory);
        service.deleteRefactoringHistory(project, null);
        projectHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should be empty", (boolean)projectHistory.isEmpty());
        workspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should be empty", (boolean)workspaceHistory.isEmpty());
    }

    public void testDeleteRefactoringDescriptors0() throws Exception {
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory projectHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should not be empty", (!projectHistory.isEmpty() ? 1 : 0) != 0);
        service.deleteRefactoringDescriptors(projectHistory.getDescriptors(), null);
        projectHistory = service.getProjectHistory(project, null);
        projectHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should be empty", (boolean)projectHistory.isEmpty());
        RefactoringHistory workspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should be empty", (boolean)workspaceHistory.isEmpty());
    }

    public void testDeleteRefactoringDescriptors1() throws Exception {
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory workspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory projectHistory = service.getProjectHistory(project, 0L, Long.MAX_VALUE, 1, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should not be empty", (!projectHistory.isEmpty() ? 1 : 0) != 0);
        service.deleteRefactoringDescriptors(projectHistory.getDescriptors(), null);
        RefactoringHistory afterHistory = service.getWorkspaceHistory(null);
        RefactoringHistoryServiceTests.assertEquals((String)"", (int)(afterHistory.getDescriptors().length + 20), (int)workspaceHistory.getDescriptors().length);
    }

    public void testPopDescriptor0() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor descriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 1024);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousProjectHistory.getDescriptors().length + 1), (int)nextProjectHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousWorkspaceHistory.getDescriptors().length + 1), (int)nextWorkspaceHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
            RefactoringCore.getUndoManager().performUndo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(2);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(2);
            RefactoringCore.getUndoManager().performRedo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(3);
            nextWorkspaceHistory = service.getWorkspaceHistory(null);
            nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousProjectHistory.getDescriptors().length + 1), (int)nextProjectHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousWorkspaceHistory.getDescriptors().length + 1), (int)nextWorkspaceHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    public void testPopDescriptor1() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor firstDescriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 1024);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringDescriptor secondDescriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000001, 1);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousProjectHistory.getDescriptors().length + 2), (int)nextProjectHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousWorkspaceHistory.getDescriptors().length + 2), (int)nextWorkspaceHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(firstDescriptor), new RefactoringDescriptorProxyAdapter(secondDescriptor)})), (Object)previousProjectHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(firstDescriptor), new RefactoringDescriptorProxyAdapter(secondDescriptor)})), (Object)previousWorkspaceHistory);
            RefactoringCore.getUndoManager().performUndo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(2);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(2);
            RefactoringCore.getUndoManager().performUndo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(2);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(2);
            RefactoringCore.getUndoManager().performRedo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(3);
            RefactoringCore.getUndoManager().performRedo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(3);
            nextWorkspaceHistory = service.getWorkspaceHistory(null);
            nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousProjectHistory.getDescriptors().length + 2), (int)nextProjectHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousWorkspaceHistory.getDescriptors().length + 2), (int)nextWorkspaceHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(firstDescriptor), new RefactoringDescriptorProxyAdapter(secondDescriptor)})), (Object)previousProjectHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(firstDescriptor), new RefactoringDescriptorProxyAdapter(secondDescriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    public void testPushDescriptor0() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor descriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 1024);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousProjectHistory.getDescriptors().length + 1), (int)nextProjectHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousWorkspaceHistory.getDescriptors().length + 1), (int)nextWorkspaceHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    public void testPushDescriptor1() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor descriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 5);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousProjectHistory.getDescriptors().length + 1), (int)nextProjectHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousWorkspaceHistory.getDescriptors().length + 1), (int)nextWorkspaceHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    public void testPushDescriptor2() throws Exception {
        this.setUpWorkspaceRefactorings();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 0, null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor descriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 5);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            RefactoringHistoryServiceTests.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousProjectHistory.getDescriptors().length + 1), (int)nextProjectHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Length of refactoring history should be one more:", (int)(previousWorkspaceHistory.getDescriptors().length + 1), (int)nextWorkspaceHistory.getDescriptors().length);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    public void testReadProjectHistory0() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)45, (int)proxies.length);
    }

    public void testReadProjectHistory1() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 0, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)45, (int)proxies.length);
    }

    public void testReadProjectHistory2() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 1, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)20, (int)proxies.length);
    }

    public void testReadProjectHistory3() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 2, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)10, (int)proxies.length);
    }

    public void testReadProjectHistory4() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 4, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should  be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)0, (int)proxies.length);
    }

    public void testReadProjectHistory5() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 1024, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)5, (int)proxies.length);
    }

    public void testReadProjectHistory6() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, 10000000L, 1024, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should  be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)0, (int)proxies.length);
    }

    public void testReadRefactoringHistory0() throws Exception {
        this.setUpWorkspaceRefactorings();
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)65, (int)proxies.length);
    }

    public void testReadRefactoringHistory1() throws Exception {
        this.setUpWorkspaceRefactorings();
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(0L, Long.MAX_VALUE, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)65, (int)proxies.length);
    }

    public void testReadWorkspaceHistory0() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(0L, 10000000L, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should  be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)1, (int)proxies.length);
    }

    public void testReadWorkspaceHistory1() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(0L, Long.MAX_VALUE, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should  be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)45, (int)proxies.length);
    }

    public void testReadWorkspaceHistory2() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(10000000L, 50000000L, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should  be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)5, (int)proxies.length);
    }

    public void testReadWorkspaceHistory3() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(30000000L, 50000000L, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should  be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)3, (int)proxies.length);
    }

    public void testSharing0() throws Exception {
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        IFolder folder = this.fProject.getProject().getFolder(".refactorings");
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history folder should exist.", (boolean)folder.exists());
        this.setSharedRefactoringHistory(false);
        RefactoringHistory nextHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)previousHistory, (Object)nextHistory);
        RefactoringHistoryServiceTests.assertFalse((String)"Refactoring history should not be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        RefactoringHistoryServiceTests.assertFalse((String)"Refactoring history folder should not exist.", (boolean)folder.exists());
    }

    public void testSharing1() throws Exception {
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        IFolder folder = this.fProject.getProject().getFolder(".refactorings");
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history folder should exist.", (boolean)folder.exists());
        this.setSharedRefactoringHistory(false);
        RefactoringHistory nextHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)previousHistory, (Object)nextHistory);
        RefactoringHistoryServiceTests.assertFalse((String)"Refactoring history should not be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        RefactoringHistoryServiceTests.assertFalse((String)"Refactoring history folder should not exist.", (boolean)folder.exists());
        this.setSharedRefactoringHistory(true);
        RefactoringHistory lastHistory = service.getProjectHistory(project, null);
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)previousHistory, (Object)lastHistory);
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history should be the same:", (Object)nextHistory, (Object)lastHistory);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history should be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history folder should exist.", (boolean)folder.exists());
    }

    public void testSortOrder0() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)45, (int)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    public void testSortOrder1() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 10000000L, 50000000L, 0, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)5, (int)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    public void testSortOrder2() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 30000000L, 50000000L, 0, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)3, (int)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    public void testSortOrder3() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 110000000L, 140000000L, 1, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)4, (int)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    public void testSortOrder4() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 110000000L, 280000000L, 0, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)18, (int)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    public void testSortOrder5() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 1024, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)5, (int)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    public void testSortOrder6() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(0L, Long.MAX_VALUE, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)45, (int)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    public void testSortOrder7() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(30000000L, 50000000L, null);
        RefactoringHistoryServiceTests.assertTrue((String)"Refactoring history must not be empty", (!history.isEmpty() ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        RefactoringHistoryServiceTests.assertEquals((String)"Refactoring history has wrong size", (int)3, (int)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    private static final class RefactoringExecutionListener
    implements IRefactoringExecutionListener {
        private RefactoringExecutionEvent fLastEvent = null;

        private RefactoringExecutionListener() {
        }

        public void assertEventDescriptor(RefactoringDescriptorProxyAdapter expected) throws Exception {
            RefactoringHistoryServiceTests.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            RefactoringDescriptor expectedDescriptor = expected.requestDescriptor(null);
            RefactoringHistoryServiceTests.assertNotNull((String)"Could not resolve expected refactoring descriptor", (Object)expectedDescriptor);
            expectedDescriptor.setTimeStamp(this.fLastEvent.getDescriptor().getTimeStamp());
            RefactoringHistoryServiceTests.assertEquals((String)"Wrong refactoring descriptor proxy in refactoring history event:", (Object)expected, (Object)this.fLastEvent.getDescriptor());
            RefactoringDescriptor actualDescriptor = this.fLastEvent.getDescriptor().requestDescriptor(null);
            RefactoringHistoryServiceTests.assertNotNull((String)"Could not resolve actual refactoring descriptor", (Object)actualDescriptor);
            RefactoringHistoryServiceTests.assertEquals((String)"Resolved refactoring descriptors are not equal:", (Object)expectedDescriptor, (Object)actualDescriptor);
        }

        public void assertEventSource(IRefactoringHistoryService expected) throws Exception {
            RefactoringHistoryServiceTests.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            RefactoringHistoryServiceTests.assertTrue((String)"Wrong refactoring history service in refactoring history event:", (expected == this.fLastEvent.getHistoryService() ? 1 : 0) != 0);
        }

        public void assertEventType(int expected) throws Exception {
            RefactoringHistoryServiceTests.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            RefactoringHistoryServiceTests.assertEquals((String)"Wrong refactoring history event type:", (int)expected, (int)this.fLastEvent.getEventType());
        }

        public void connect() {
            this.fLastEvent = null;
            RefactoringHistoryService.getInstance().addExecutionListener((IRefactoringExecutionListener)this);
        }

        public void disconnect() {
            RefactoringHistoryService.getInstance().removeExecutionListener((IRefactoringExecutionListener)this);
            this.fLastEvent = null;
        }

        public void executionNotification(RefactoringExecutionEvent event) {
            int previous = this.fLastEvent != null ? this.fLastEvent.getEventType() : -1;
            switch (event.getEventType()) {
                case 1: {
                    RefactoringHistoryServiceTests.assertTrue((String)"Previous event should be ABOUT_TO_PERFORM", (previous == 4 ? 1 : 0) != 0);
                    break;
                }
                case 3: {
                    RefactoringHistoryServiceTests.assertTrue((String)"Previous event should be ABOUT_TO_REDO", (previous == 6 ? 1 : 0) != 0);
                    break;
                }
                case 2: {
                    RefactoringHistoryServiceTests.assertTrue((String)"Previous event should be ABOUT_TO_UNDO", (previous == 5 ? 1 : 0) != 0);
                }
            }
            this.fLastEvent = event;
        }
    }

    private static final class RefactoringHistoryListener
    implements IRefactoringHistoryListener {
        private RefactoringHistoryEvent fLastEvent = null;

        private RefactoringHistoryListener() {
        }

        public void assertEventDescriptor(RefactoringDescriptorProxyAdapter expected) throws Exception {
            RefactoringHistoryServiceTests.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            RefactoringDescriptor expectedDescriptor = expected.requestDescriptor(null);
            RefactoringHistoryServiceTests.assertNotNull((String)"Could not resolve expected refactoring descriptor", (Object)expectedDescriptor);
            expectedDescriptor.setTimeStamp(this.fLastEvent.getDescriptor().getTimeStamp());
            RefactoringHistoryServiceTests.assertEquals((String)"Wrong refactoring descriptor proxy in refactoring history event:", (Object)expected, (Object)this.fLastEvent.getDescriptor());
            RefactoringDescriptor actualDescriptor = this.fLastEvent.getDescriptor().requestDescriptor(null);
            RefactoringHistoryServiceTests.assertNotNull((String)"Could not resolve actual refactoring descriptor", (Object)actualDescriptor);
            RefactoringHistoryServiceTests.assertEquals((String)"Resolved refactoring descriptors are not equal:", (Object)expectedDescriptor, (Object)actualDescriptor);
        }

        public void assertEventSource(IRefactoringHistoryService expected) throws Exception {
            RefactoringHistoryServiceTests.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            RefactoringHistoryServiceTests.assertTrue((String)"Wrong refactoring history service in refactoring history event:", (expected == this.fLastEvent.getHistoryService() ? 1 : 0) != 0);
        }

        public void assertEventType(int expected) throws Exception {
            RefactoringHistoryServiceTests.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            RefactoringHistoryServiceTests.assertEquals((String)"Wrong refactoring history event type:", (int)expected, (int)this.fLastEvent.getEventType());
        }

        public void connect() {
            this.fLastEvent = null;
            RefactoringHistoryService.getInstance().addHistoryListener((IRefactoringHistoryListener)this);
        }

        public void disconnect() {
            RefactoringHistoryService.getInstance().removeHistoryListener((IRefactoringHistoryListener)this);
            this.fLastEvent = null;
        }

        public void historyNotification(RefactoringHistoryEvent event) {
            this.fLastEvent = event;
        }
    }
}

