/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.resource;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContext;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourcesDescriptor;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.eclipse.ltk.core.refactoring.resource.MoveResourcesDescriptor;
import org.eclipse.ltk.core.refactoring.tests.resource.ResourceRefactoringUndoTests;
import org.eclipse.ltk.core.refactoring.tests.util.SimpleTestProject;

public class ResourceRefactoringTests
extends TestCase {
    private SimpleTestProject fProject;

    public static Test suite() {
        TestSuite suite = new TestSuite(ResourceRefactoringTests.class.getName());
        suite.addTestSuite(ResourceRefactoringTests.class);
        suite.addTestSuite(ResourceRefactoringUndoTests.class);
        return suite;
    }

    protected void setUp() throws Exception {
        this.fProject = new SimpleTestProject();
    }

    protected void tearDown() throws Exception {
        this.fProject.delete();
    }

    public void testMoveChange1() throws Exception {
        String content = "hello";
        IFolder testFolder = this.fProject.createFolder("test");
        IFile file = this.fProject.createFile((IContainer)testFolder, "myFile.txt", content);
        IFolder destination = this.fProject.createFolder("dest");
        Change undoChange = this.perform((Change)new MoveResourceChange((IResource)file, (IContainer)destination));
        IResource movedResource = this.assertMove((IResource)file, (IContainer)destination, content);
        this.perform(undoChange);
        this.assertMove(movedResource, file.getParent(), content);
    }

    public void testMoveChange2() throws Exception {
        String content = "hello";
        IFolder testFolder = this.fProject.createFolder("test");
        this.fProject.createFile((IContainer)testFolder, "myFile.txt", content);
        IFolder destination = this.fProject.createFolder("dest");
        Change undoChange = this.perform((Change)new MoveResourceChange((IResource)testFolder, (IContainer)destination));
        IFolder movedResource = (IFolder)this.assertMove((IResource)testFolder, (IContainer)destination, null);
        ResourceRefactoringTests.assertTrue((boolean)movedResource.getFile("myFile.txt").exists());
        this.perform(undoChange);
        this.assertMove((IResource)movedResource, testFolder.getParent(), null);
        ResourceRefactoringTests.assertTrue((boolean)testFolder.getFile("myFile.txt").exists());
    }

    public void testMoveChange3() throws Exception {
        String content1 = "hello";
        String content2 = "world";
        IFolder testFolder = this.fProject.createFolder("test");
        IFile file1 = this.fProject.createFile((IContainer)testFolder, "myFile.txt", content1);
        IFolder destination = this.fProject.createFolder("dest");
        IFile file2 = this.fProject.createFile((IContainer)destination, "myFile.txt", content2);
        Change undoChange = this.perform((Change)new MoveResourceChange((IResource)file1, (IContainer)destination));
        IResource movedResource = this.assertMove((IResource)file1, (IContainer)destination, content1);
        this.perform(undoChange);
        this.assertMove(movedResource, file1.getParent(), content1);
        ResourceRefactoringTests.assertTrue((boolean)content2.equals(this.fProject.getContent(file2)));
    }

    public void testMoveRefactoring1() throws Exception {
        String content = "hello";
        IFolder testFolder = this.fProject.createFolder("test");
        IFile file = this.fProject.createFile((IContainer)testFolder, "myFile.txt", content);
        IFolder destination = this.fProject.createFolder("dest");
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.move.resources");
        MoveResourcesDescriptor descriptor = (MoveResourcesDescriptor)contribution.createDescriptor();
        descriptor.setResourcesToMove(new IResource[]{file});
        descriptor.setDestination((IContainer)destination);
        Change undoChange = this.perform((RefactoringDescriptor)descriptor);
        IResource movedResource = this.assertMove((IResource)file, (IContainer)destination, content);
        this.perform(undoChange);
        this.assertMove(movedResource, file.getParent(), content);
    }

    public void testMoveRefactoring2() throws Exception {
        String content = "hello";
        IFolder testFolder = this.fProject.createFolder("test");
        this.fProject.createFile((IContainer)testFolder, "myFile.txt", content);
        IFolder destination = this.fProject.createFolder("dest");
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.move.resources");
        MoveResourcesDescriptor descriptor = (MoveResourcesDescriptor)contribution.createDescriptor();
        descriptor.setResourcesToMove(new IResource[]{testFolder});
        descriptor.setDestination((IContainer)destination);
        Change undoChange = this.perform((RefactoringDescriptor)descriptor);
        IFolder movedResource = (IFolder)this.assertMove((IResource)testFolder, (IContainer)destination, null);
        ResourceRefactoringTests.assertTrue((boolean)movedResource.getFile("myFile.txt").exists());
        this.perform(undoChange);
        this.assertMove((IResource)movedResource, testFolder.getParent(), null);
        ResourceRefactoringTests.assertTrue((boolean)testFolder.getFile("myFile.txt").exists());
    }

    public void testMoveRefactoring3() throws Exception {
        String content1 = "hello";
        String content2 = "world";
        IFolder testFolder = this.fProject.createFolder("test");
        IFile file1 = this.fProject.createFile((IContainer)testFolder, "myFile.txt", content1);
        IFolder destination = this.fProject.createFolder("dest");
        IFile file2 = this.fProject.createFile((IContainer)destination, "myFile.txt", content2);
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.move.resources");
        MoveResourcesDescriptor descriptor = (MoveResourcesDescriptor)contribution.createDescriptor();
        descriptor.setResourcesToMove(new IResource[]{file1});
        descriptor.setDestination((IContainer)destination);
        Change undoChange = this.perform((RefactoringDescriptor)descriptor);
        IResource movedResource = this.assertMove((IResource)file1, (IContainer)destination, content1);
        this.perform(undoChange);
        this.assertMove(movedResource, file1.getParent(), content1);
        ResourceRefactoringTests.assertTrue((boolean)content2.equals(this.fProject.getContent(file2)));
    }

    public void testDeleteRefactoring1_bug343584() throws Exception {
        IFolder testFolder = this.fProject.createFolder("test");
        this.fProject.createFile((IContainer)testFolder, "myFile.txt", "hello");
        IProject testProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject("TestProject2");
        try {
            testProject2.create(null);
            testProject2.open(null);
            RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
            DeleteResourcesDescriptor descriptor = (DeleteResourcesDescriptor)contribution.createDescriptor();
            descriptor.setDeleteContents(true);
            descriptor.setResources(new IResource[]{this.fProject.getProject(), testProject2});
            this.perform((RefactoringDescriptor)descriptor);
            ResourceRefactoringTests.assertFalse((boolean)this.fProject.getProject().exists());
            ResourceRefactoringTests.assertFalse((boolean)testProject2.exists());
        }
        finally {
            testProject2.delete(true, true, null);
        }
    }

    public void testDeleteRefactoring2_bug343584() throws Exception {
        IPath location = this.fProject.getProject().getLocation();
        IFolder testFolder = this.fProject.createFolder("test");
        this.fProject.createFile((IContainer)testFolder, "myFile.txt", "hello");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String p2Name = "p2";
        IProjectDescription p2Description = workspace.newProjectDescription(p2Name);
        p2Description.setLocation(location.append(p2Name));
        IProject p2 = workspace.getRoot().getProject(p2Name);
        p2.create(p2Description, null);
        p2.open(null);
        IPath p2Location = p2.getLocation();
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
        DeleteResourcesDescriptor descriptor = (DeleteResourcesDescriptor)contribution.createDescriptor();
        descriptor.setDeleteContents(true);
        descriptor.setResources(new IResource[]{this.fProject.getProject(), p2});
        this.perform((RefactoringDescriptor)descriptor);
        ResourceRefactoringTests.assertFalse((boolean)this.fProject.getProject().exists());
        ResourceRefactoringTests.assertFalse((boolean)p2.exists());
        ResourceRefactoringTests.assertFalse((boolean)location.toFile().exists());
        ResourceRefactoringTests.assertFalse((boolean)p2Location.toFile().exists());
    }

    public void testDeleteRefactoring3_bug343584() throws Exception {
        IPath location = this.fProject.getProject().getLocation();
        IFolder testFolder = this.fProject.createFolder("test");
        IFile file = this.fProject.createFile((IContainer)testFolder, "myFile.txt", "hello");
        IPath fileLocation = file.getLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String p2Name = "p2";
        IProjectDescription p2Description = workspace.newProjectDescription(p2Name);
        p2Description.setLocation(location.append(p2Name));
        IProject p2 = workspace.getRoot().getProject(p2Name);
        p2.create(p2Description, null);
        p2.open(null);
        IPath p2Location = p2.getLocation();
        try {
            RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.delete.resources");
            DeleteResourcesDescriptor descriptor = (DeleteResourcesDescriptor)contribution.createDescriptor();
            descriptor.setDeleteContents(false);
            descriptor.setResources(new IResource[]{this.fProject.getProject(), p2});
            this.perform((RefactoringDescriptor)descriptor);
            ResourceRefactoringTests.assertFalse((boolean)this.fProject.getProject().exists());
            ResourceRefactoringTests.assertFalse((boolean)p2.exists());
            ResourceRefactoringTests.assertTrue((boolean)location.toFile().exists());
            ResourceRefactoringTests.assertTrue((boolean)fileLocation.toFile().exists());
            ResourceRefactoringTests.assertTrue((boolean)p2Location.toFile().exists());
        }
        finally {
            EFS.getLocalFileSystem().getStore(location).delete(0, null);
            EFS.getLocalFileSystem().getStore(p2Location).delete(0, null);
        }
    }

    private Change perform(Change change) throws CoreException {
        PerformChangeOperation op = new PerformChangeOperation(change);
        op.run(null);
        ResourceRefactoringTests.assertTrue((boolean)op.changeExecuted());
        return op.getUndoChange();
    }

    private Change perform(RefactoringDescriptor descriptor) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        RefactoringContext context = descriptor.createRefactoringContext(status);
        try {
            Refactoring refactoring = context != null ? context.getRefactoring() : null;
            ResourceRefactoringTests.assertTrue((boolean)status.isOK());
            PerformRefactoringOperation op = new PerformRefactoringOperation(refactoring, 6);
            op.run(null);
            RefactoringStatus validationStatus = op.getValidationStatus();
            ResourceRefactoringTests.assertTrue((!validationStatus.hasFatalError() && !validationStatus.hasError() ? 1 : 0) != 0);
            Change change = op.getUndoChange();
            return change;
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
    }

    private IResource assertMove(IResource source, IContainer destination, String content) throws CoreException, IOException {
        IResource res = destination.findMember(source.getName());
        ResourceRefactoringTests.assertTrue((res != null ? 1 : 0) != 0);
        ResourceRefactoringTests.assertTrue((res.getType() == source.getType() ? 1 : 0) != 0);
        if (res instanceof IFile) {
            ResourceRefactoringTests.assertTrue((boolean)content.equals(this.fProject.getContent((IFile)res)));
        }
        return res;
    }
}

