/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.examples;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.resource.DeleteResourcesWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;

public class DeleteResourcesRefactoringAction
extends Action
implements IActionDelegate {
    private IResource[] fResources;

    public void run(IAction action) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.fResources != null && DeleteResourcesRefactoringAction.isDeleteAvailable(this.fResources)) {
            try {
                DeleteResourcesWizard refactoringWizard = new DeleteResourcesWizard(this.fResources);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)refactoringWizard);
                op.run(shell, "Delete resources");
            }
            catch (InterruptedException interruptedException) {}
        } else {
            MessageDialog.openInformation((Shell)shell, (String)"Delete Resources", (String)"Invalid selection. Can not mix projects with files and folders. Files and folders must not be nested or nesting.");
        }
    }

    private static boolean isDeleteAvailable(IResource[] resource) {
        int i = 0;
        while (i < resource.length) {
            if (!resource[i].exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fResources = null;
        if (selection instanceof IStructuredSelection) {
            this.fResources = DeleteResourcesRefactoringAction.evaluateResources((IStructuredSelection)selection);
        }
        this.setEnabled(this.fResources != null);
    }

    private static IResource[] evaluateResources(IStructuredSelection sel) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        Object[] objects = sel.toArray();
        int i = 0;
        while (i < objects.length) {
            Object curr = objects[i];
            if (curr instanceof IFile || curr instanceof IFolder) {
                if (!DeleteResourcesRefactoringAction.addFileOrFolder(res, (IResource)curr)) {
                    return null;
                }
            } else if (curr instanceof IProject) {
                if (!DeleteResourcesRefactoringAction.addProject(res, (IProject)curr)) {
                    return null;
                }
            } else {
                return null;
            }
            ++i;
        }
        return res.toArray(new IResource[res.size()]);
    }

    private static boolean addProject(ArrayList<IResource> res, IProject project) {
        if (!res.isEmpty()) {
            if (!(res.get(0) instanceof IProject)) {
                return false;
            }
            if (res.contains(project)) {
                return false;
            }
        }
        res.add((IResource)project);
        return true;
    }

    private static boolean addFileOrFolder(ArrayList<IResource> res, IResource resource) {
        if (!res.isEmpty()) {
            if (res.get(0) instanceof IProject) {
                return false;
            }
            IPath path = resource.getFullPath();
            int i = 0;
            while (i < res.size()) {
                IResource curr = res.get(i);
                IPath currPath = curr.getFullPath();
                if (path.isPrefixOf(currPath) || currPath.isPrefixOf(path) || currPath.equals((Object)path)) {
                    return false;
                }
                ++i;
            }
        }
        res.add(resource);
        return true;
    }
}

