/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.examples;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.resource.MoveResourcesWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;

public class MoveResourcesRefactoringAction
extends Action
implements IActionDelegate {
    private IResource[] fResources;

    public void run(IAction action) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.fResources != null && MoveResourcesRefactoringAction.isMoveAvailable(this.fResources)) {
            try {
                MoveResourcesWizard refactoringWizard = new MoveResourcesWizard(this.fResources);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)refactoringWizard);
                op.run(shell, "Move resources");
            }
            catch (InterruptedException interruptedException) {}
        } else {
            MessageDialog.openInformation((Shell)shell, (String)"Move Resources", (String)"Invalid selection. Can only move resources with the same parent.");
        }
    }

    private static boolean isMoveAvailable(IResource[] resource) {
        int i = 0;
        while (i < resource.length) {
            if (!resource[i].exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fResources = null;
        if (selection instanceof IStructuredSelection) {
            this.fResources = MoveResourcesRefactoringAction.evaluateResources((IStructuredSelection)selection);
        }
        this.setEnabled(this.fResources != null);
    }

    private static IResource[] evaluateResources(IStructuredSelection sel) {
        Object[] objects = sel.toArray();
        ArrayList<IResource> res = new ArrayList<IResource>();
        IContainer parent = null;
        int i = 0;
        while (i < objects.length) {
            Object curr = objects[i];
            if (curr instanceof IFile || curr instanceof IFolder) {
                IResource resource = (IResource)curr;
                if (parent == null) {
                    parent = resource.getParent();
                } else if (!parent.equals((Object)resource.getParent())) {
                    return null;
                }
                res.add(resource);
            }
            ++i;
        }
        return res.toArray(new IResource[res.size()]);
    }
}

