/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.examples;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.resource.RenameResourceWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;

public class RenameResourceRefactoringAction
extends Action
implements IActionDelegate {
    private IResource fResource;

    public void run(IAction action) {
        if (this.fResource != null && RenameResourceRefactoringAction.isRenameAvailable(this.fResource)) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            try {
                RenameResourceWizard refactoringWizard = new RenameResourceWizard(this.fResource);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)refactoringWizard);
                op.run(shell, "Rename resource");
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static boolean isRenameAvailable(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        return resource.isAccessible();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        this.fResource = null;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            this.fResource = (IResource)object;
        }
    }
}

