/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.equinox.log.test.TestListener;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;

public class ExtendedLogReaderServiceTest
extends TestCase {
    private ExtendedLogService log;
    private ServiceReference logReference;
    private ExtendedLogReaderService reader;
    private ServiceReference readerReference;
    private ServiceReference<LoggerAdmin> loggerAdminReference;
    private LoggerAdmin loggerAdmin;
    LoggerContext rootLoggerContext;
    Map<String, LogLevel> rootLogLevels;
    boolean called;

    public ExtendedLogReaderServiceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.logReference = OSGiTestsActivator.getContext().getServiceReference(ExtendedLogService.class.getName());
        this.readerReference = OSGiTestsActivator.getContext().getServiceReference(ExtendedLogReaderService.class.getName());
        this.loggerAdminReference = OSGiTestsActivator.getContext().getServiceReference(LoggerAdmin.class);
        this.log = (ExtendedLogService)OSGiTestsActivator.getContext().getService(this.logReference);
        this.reader = (ExtendedLogReaderService)OSGiTestsActivator.getContext().getService(this.readerReference);
        this.loggerAdmin = (LoggerAdmin)OSGiTestsActivator.getContext().getService(this.loggerAdminReference);
        this.rootLoggerContext = this.loggerAdmin.getLoggerContext(null);
        this.rootLogLevels = this.rootLoggerContext.getLogLevels();
        HashMap<String, LogLevel> copyLogLevels = new HashMap<String, LogLevel>(this.rootLogLevels);
        copyLogLevels.put("ROOT", LogLevel.TRACE);
        this.rootLoggerContext.setLogLevels(copyLogLevels);
    }

    protected void tearDown() throws Exception {
        this.rootLoggerContext.setLogLevels(this.rootLogLevels);
        OSGiTestsActivator.getContext().ungetService(this.loggerAdminReference);
        OSGiTestsActivator.getContext().ungetService(this.logReference);
        OSGiTestsActivator.getContext().ungetService(this.readerReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testaddFilteredListener() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener, new LogFilter(){

            public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
                return true;
            }
        });
        TestListener testListener = listener;
        synchronized (testListener) {
            this.log.log(3, "info");
            listener.waitForLogEntry();
        }
        ExtendedLogReaderServiceTest.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    public void testaddNullFilterr() throws Exception {
        TestListener listener = new TestListener();
        try {
            this.reader.addLogListener((LogListener)listener, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        ExtendedLogReaderServiceTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testaddFilteredListenerTwice() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener, new LogFilter(){

            public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
                return false;
            }
        });
        if (this.log.isLoggable(3)) {
            ExtendedLogReaderServiceTest.fail();
        }
        this.reader.addLogListener((LogListener)listener, new LogFilter(){

            public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
                return true;
            }
        });
        TestListener testListener = listener;
        synchronized (testListener) {
            this.log.log(3, "info");
            listener.waitForLogEntry();
        }
        ExtendedLogReaderServiceTest.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    public void testaddNullListener() throws Exception {
        try {
            this.reader.addLogListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        ExtendedLogReaderServiceTest.fail();
    }

    public void testBadFilter() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener, new LogFilter(){

            public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
                throw new RuntimeException("Expected error for testBadFilter.");
            }
        });
        if (this.log.isLoggable(3)) {
            ExtendedLogReaderServiceTest.fail();
        }
    }

    public void testSynchronousLogListener() throws Exception {
        final Thread loggerThread = Thread.currentThread();
        this.called = false;
        SynchronousLogListener listener = new SynchronousLogListener(){

            public void logged(LogEntry entry) {
                ExtendedLogReaderServiceTest.assertTrue((Thread.currentThread() == loggerThread ? 1 : 0) != 0);
                ExtendedLogReaderServiceTest.this.called = true;
            }
        };
        this.reader.addLogListener((LogListener)listener);
        this.log.log(3, "info");
        ExtendedLogReaderServiceTest.assertTrue((boolean)this.called);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExtendedLogEntry() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        long timeBeforeLog = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        long threadId = this.getCurrentThreadId();
        TestListener testListener = listener;
        synchronized (testListener) {
            this.log.getLogger("test").log(this.logReference, 3, "info", new Throwable("test"));
            listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = listener.getEntryX();
        long sequenceNumberBefore = entry.getSequenceNumber();
        TestListener testListener2 = listener;
        synchronized (testListener2) {
            this.log.getLogger("test").log(this.logReference, 3, "info", new Throwable("test"));
            listener.waitForLogEntry();
        }
        entry = listener.getEntryX();
        ExtendedLogReaderServiceTest.assertTrue((entry.getBundle() == OSGiTestsActivator.getContext().getBundle() ? 1 : 0) != 0);
        ExtendedLogReaderServiceTest.assertTrue((boolean)entry.getMessage().equals("info"));
        ExtendedLogReaderServiceTest.assertTrue((boolean)entry.getException().getMessage().equals("test"));
        ExtendedLogReaderServiceTest.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
        ExtendedLogReaderServiceTest.assertTrue((entry.getTime() >= timeBeforeLog ? 1 : 0) != 0);
        ExtendedLogReaderServiceTest.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        ExtendedLogReaderServiceTest.assertTrue((boolean)entry.getLoggerName().equals("test"));
        ExtendedLogReaderServiceTest.assertTrue((boolean)entry.getThreadName().equals(threadName));
        if (threadId >= 0L) {
            ExtendedLogReaderServiceTest.assertTrue((entry.getThreadId() == threadId ? 1 : 0) != 0);
        }
        ExtendedLogReaderServiceTest.assertTrue((entry.getContext() == this.logReference ? 1 : 0) != 0);
        ExtendedLogReaderServiceTest.assertTrue((entry.getSequenceNumber() > sequenceNumberBefore ? 1 : 0) != 0);
    }

    private long getCurrentThreadId() {
        Thread current = Thread.currentThread();
        try {
            Method getId = Thread.class.getMethod("getId", new Class[0]);
            Long id = (Long)getId.invoke((Object)current, new Object[0]);
            return id;
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }
}

