/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.test.TestListener;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;

public class LogServiceTest
extends TestCase {
    private LogService log;
    private ServiceReference logReference;
    private LogReaderService reader;
    private ServiceReference readerReference;
    private TestListener listener;
    private ServiceReference<LoggerAdmin> loggerAdminReference;
    private LoggerAdmin loggerAdmin;
    LoggerContext rootLoggerContext;
    Map<String, LogLevel> rootLogLevels;

    public LogServiceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.logReference = OSGiTestsActivator.getContext().getServiceReference(LogService.class.getName());
        this.readerReference = OSGiTestsActivator.getContext().getServiceReference(LogReaderService.class.getName());
        this.loggerAdminReference = OSGiTestsActivator.getContext().getServiceReference(LoggerAdmin.class);
        this.log = (LogService)OSGiTestsActivator.getContext().getService(this.logReference);
        this.reader = (LogReaderService)OSGiTestsActivator.getContext().getService(this.readerReference);
        this.loggerAdmin = (LoggerAdmin)OSGiTestsActivator.getContext().getService(this.loggerAdminReference);
        this.listener = new TestListener();
        this.reader.addLogListener((LogListener)this.listener);
        this.rootLoggerContext = this.loggerAdmin.getLoggerContext(null);
        this.rootLogLevels = this.rootLoggerContext.getLogLevels();
        HashMap<String, LogLevel> copyLogLevels = new HashMap<String, LogLevel>(this.rootLogLevels);
        copyLogLevels.put("ROOT", LogLevel.TRACE);
        this.rootLoggerContext.setLogLevels(copyLogLevels);
    }

    protected void tearDown() throws Exception {
        this.rootLoggerContext.setLogLevels(this.rootLogLevels);
        this.reader.removeLogListener((LogListener)this.listener);
        OSGiTestsActivator.getContext().ungetService(this.loggerAdminReference);
        OSGiTestsActivator.getContext().ungetService(this.logReference);
        OSGiTestsActivator.getContext().ungetService(this.readerReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogDebug() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(4, "debug");
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((this.listener.getEntryX().getLevel() == 4 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogError() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(1, "error");
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((this.listener.getEntryX().getLevel() == 1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogInfo() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(3, "info");
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((this.listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogWarning() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(2, "warning");
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((this.listener.getEntryX().getLevel() == 2 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogZeroLevel() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(0, "zero");
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((this.listener.getEntryX().getLevel() == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogNegativeLevel() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(-1, "negative");
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((this.listener.getEntryX().getLevel() == -1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogMessage() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(3, "message");
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((boolean)this.listener.getEntryX().getMessage().equals("message"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogNullMessage() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(3, null);
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((this.listener.getEntryX().getMessage() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogThrowable() throws Exception {
        Throwable t = new Throwable("throwable");
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(3, null, t);
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((boolean)this.listener.getEntryX().getException().getMessage().equals(t.getMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogNullThrowable() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(3, null, null);
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((this.listener.getEntryX().getException() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogServiceReference() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(this.logReference, 3, null);
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((boolean)this.listener.getEntryX().getServiceReference().equals(this.logReference));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullLogServiceReference() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(null, 3, null);
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((this.listener.getEntryX().getServiceReference() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogServiceReferenceWithNullThrowable() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(this.logReference, 3, null, null);
            this.listener.waitForLogEntry();
        }
        LogServiceTest.assertTrue((boolean)this.listener.getEntryX().getServiceReference().equals(this.logReference));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogNull1() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(0, null);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        LogServiceTest.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogNull2() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(0, null, null);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        LogServiceTest.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogNull3() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(null, 0, null);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        LogServiceTest.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogNull4() throws Exception {
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(null, 0, null, null);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        LogServiceTest.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogFull1() throws Exception {
        String message = "test";
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(3, message);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        LogServiceTest.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        LogServiceTest.assertTrue((boolean)entry.getMessage().equals(message));
        LogServiceTest.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogFull2() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(3, message, t);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        LogServiceTest.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        LogServiceTest.assertTrue((boolean)entry.getMessage().equals(message));
        LogServiceTest.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        LogServiceTest.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogFull3() throws Exception {
        String message = "test";
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(this.logReference, 3, message);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        LogServiceTest.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        LogServiceTest.assertTrue((boolean)entry.getMessage().equals(message));
        LogServiceTest.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        LogServiceTest.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogFull4() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        TestListener testListener = this.listener;
        synchronized (testListener) {
            this.log.log(this.logReference, 3, message, t);
            this.listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = this.listener.getEntryX();
        LogServiceTest.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        LogServiceTest.assertTrue((boolean)entry.getMessage().equals(message));
        LogServiceTest.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        LogServiceTest.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    public void testServiceEventLog() throws InterruptedException {
        BundleContext context = OSGiTestsActivator.getContext();
        ServiceRegistration reg = context.registerService(Object.class, new Object(), null);
        ServiceReference ref = reg.getReference();
        this.listener.waitForLogEntry();
        this.listener.waitForLogEntry();
        ExtendedLogEntry entry = this.listener.getEntryX();
        LogServiceTest.assertEquals((String)"Wrong logger name.", (String)"Events.Service", (String)entry.getLoggerName());
        LogServiceTest.assertEquals((String)"Wrong event log level.", (Object)LogLevel.INFO, (Object)entry.getLogLevel());
        LogServiceTest.assertEquals((String)"Wrong bundle.", (Object)context.getBundle(), (Object)entry.getBundle());
        LogServiceTest.assertNull((String)"Wrong exception.", (Object)entry.getException());
        LogServiceTest.assertEquals((String)"Wrong service reference.", (Object)ref, (Object)entry.getServiceReference());
        LogServiceTest.assertEquals((String)"Wrong message.", (String)"ServiceEvent REGISTERED", (String)entry.getMessage());
        reg.setProperties(new Hashtable<String, String>(Collections.singletonMap("key1", "value1")));
        this.listener.waitForLogEntry();
        entry = this.listener.getEntryX();
        LogServiceTest.assertEquals((String)"Wrong logger name.", (String)"Events.Service", (String)entry.getLoggerName());
        LogServiceTest.assertEquals((String)"Wrong event log level.", (Object)LogLevel.DEBUG, (Object)entry.getLogLevel());
        LogServiceTest.assertEquals((String)"Wrong bundle.", (Object)context.getBundle(), (Object)entry.getBundle());
        LogServiceTest.assertNull((String)"Wrong exception.", (Object)entry.getException());
        LogServiceTest.assertEquals((String)"Wrong service reference.", (Object)ref, (Object)entry.getServiceReference());
        LogServiceTest.assertEquals((String)"Wrong message.", (String)"ServiceEvent MODIFIED", (String)entry.getMessage());
        reg.unregister();
        this.listener.waitForLogEntry();
        entry = this.listener.getEntryX();
        LogServiceTest.assertEquals((String)"Wrong logger name.", (String)"Events.Service", (String)entry.getLoggerName());
        LogServiceTest.assertEquals((String)"Wrong event log level.", (Object)LogLevel.INFO, (Object)entry.getLogLevel());
        LogServiceTest.assertEquals((String)"Wrong bundle.", (Object)context.getBundle(), (Object)entry.getBundle());
        LogServiceTest.assertNull((String)"Wrong exception.", (Object)entry.getException());
        LogServiceTest.assertEquals((String)"Wrong service reference.", (Object)ref, (Object)entry.getServiceReference());
        LogServiceTest.assertEquals((String)"Wrong message.", (String)"ServiceEvent UNREGISTERING", (String)entry.getMessage());
    }
}

