/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.eclipse.osgi.tests.bundles.EventListenerTestResults;
import org.eclipse.osgi.tests.bundles.SyncEventListenerTestResults;
import org.eclipse.osgi.tests.bundles.TestResults;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class AbstractBundleTests
extends CoreTest {
    public static int BUNDLE_LISTENER = 1;
    public static int SYNC_BUNDLE_LISTENER = 2;
    public static int SIMPLE_RESULTS = 4;
    public static final String BUNDLES_ROOT = "bundle_tests";
    public static TestResults simpleResults;
    public static EventListenerTestResults listenerResults;
    public static SyncEventListenerTestResults syncListenerResults;
    public static EventListenerTestResults frameworkListenerResults;
    public static BundleInstaller installer;

    protected void setUp() throws Exception {
        installer = new BundleInstaller(BUNDLES_ROOT, OSGiTestsActivator.getContext());
        installer.refreshPackages(null);
        listenerResults = new EventListenerTestResults();
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)listenerResults);
        syncListenerResults = new SyncEventListenerTestResults();
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)syncListenerResults);
        simpleResults = new TestResults();
        frameworkListenerResults = new EventListenerTestResults();
        OSGiTestsActivator.getContext().addFrameworkListener((FrameworkListener)frameworkListenerResults);
    }

    protected void tearDown() throws Exception {
        installer.shutdown();
        installer = null;
        OSGiTestsActivator.getContext().removeBundleListener((BundleListener)listenerResults);
        OSGiTestsActivator.getContext().removeBundleListener((BundleListener)syncListenerResults);
        OSGiTestsActivator.getContext().removeFrameworkListener((FrameworkListener)frameworkListenerResults);
        listenerResults = null;
        syncListenerResults = null;
        simpleResults = null;
        frameworkListenerResults = null;
    }

    public BundleContext getContext() {
        return OSGiTestsActivator.getContext();
    }

    public static void compareResults(Object[] expectedEvents, Object[] actualEvents) {
        String expectedActual = " -- EXPECTED:" + AbstractBundleTests.toStringEventArray(expectedEvents) + " ACTUAL:" + AbstractBundleTests.toStringEventArray(actualEvents);
        AbstractBundleTests.assertEquals((String)("compareResults length" + expectedActual), (int)expectedEvents.length, (int)actualEvents.length);
        int i = 0;
        while (i < expectedEvents.length) {
            String assertMsg = "compareResults: " + i + expectedActual;
            AbstractBundleTests.assertEquals(assertMsg, expectedEvents[i], actualEvents[i]);
            ++i;
        }
    }

    public static String toStringEventArray(Object[] events) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        Object[] objectArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            Object event = objectArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(AbstractBundleTests.toString(event));
            ++n2;
        }
        sb.append(']');
        return sb.toString();
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if ((expected == null || actual == null) && expected != actual) {
            AbstractBundleTests.failNotEquals((String)message, (Object)AbstractBundleTests.toString(expected), (Object)AbstractBundleTests.toString(actual));
        }
        if (AbstractBundleTests.isEqual(expected, actual)) {
            return;
        }
        AbstractBundleTests.failNotEquals((String)message, (Object)AbstractBundleTests.toString(expected), (Object)AbstractBundleTests.toString(actual));
    }

    public static void assertEquals(String message, int[] expected, int[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        if ((expected == null || actual == null) && expected != actual) {
            AbstractBundleTests.failNotEquals((String)message, (Object)AbstractBundleTests.toString(expected), (Object)AbstractBundleTests.toString(actual));
        }
        if (expected.length != actual.length) {
            AbstractBundleTests.failNotEquals((String)message, (Object)AbstractBundleTests.toString(expected), (Object)AbstractBundleTests.toString(actual));
        }
        int i = 0;
        while (i < expected.length) {
            if (expected[i] != actual[i]) {
                AbstractBundleTests.failNotEquals((String)message, (Object)AbstractBundleTests.toString(expected), (Object)AbstractBundleTests.toString(actual));
            }
            ++i;
        }
    }

    private static boolean isEqual(Object expected, Object actual) {
        if (!expected.getClass().isAssignableFrom(actual.getClass())) {
            return false;
        }
        if (expected instanceof BundleEvent) {
            return AbstractBundleTests.isEqual((BundleEvent)expected, (BundleEvent)actual);
        }
        if (expected instanceof FrameworkEvent) {
            return AbstractBundleTests.isEqual((FrameworkEvent)expected, (FrameworkEvent)actual);
        }
        return expected.equals(actual);
    }

    private static boolean isEqual(BundleEvent expected, BundleEvent actual) {
        return expected.getSource() == actual.getSource() && expected.getType() == actual.getType();
    }

    private static boolean isEqual(FrameworkEvent expected, FrameworkEvent actual) {
        return expected.getSource() == actual.getSource() && expected.getType() == actual.getType();
    }

    private static String toString(int[] array) {
        if (array == null) {
            return "null";
        }
        String result = "[";
        int i = 0;
        while (i < array.length) {
            if (i != 0) {
                result = String.valueOf(result) + ',';
            }
            result = String.valueOf(result) + array[i];
            ++i;
        }
        result = String.valueOf(result) + "]";
        return result;
    }

    private static Object toString(Object object) {
        if (object instanceof BundleEvent) {
            return AbstractBundleTests.toString((BundleEvent)object);
        }
        if (object instanceof FrameworkEvent) {
            return AbstractBundleTests.toString((FrameworkEvent)object);
        }
        return object.toString();
    }

    private static Object toString(FrameworkEvent event) {
        StringBuffer result = new StringBuffer("FrameworkEvent [");
        switch (event.getType()) {
            case 2: {
                result.append("ERROR");
                break;
            }
            case 32: {
                result.append("INFO");
                break;
            }
            case 4: {
                result.append("PACKAGES_REFRESHED");
                break;
            }
            case 1: {
                result.append("STARTED");
                break;
            }
            case 8: {
                result.append("STARTLEVEL_CHANGED");
                break;
            }
            case 16: {
                result.append("WARNING");
                break;
            }
        }
        result.append("] ").append(event.getSource());
        return result.toString();
    }

    private static Object toString(BundleEvent event) {
        StringBuffer result = new StringBuffer("BundleEvent [");
        switch (event.getType()) {
            case 1: {
                result.append("INSTALLED");
                break;
            }
            case 512: {
                result.append("LAZY_ACTIVATION");
                break;
            }
            case 32: {
                result.append("RESOLVED");
                break;
            }
            case 2: {
                result.append("STARTED");
                break;
            }
            case 128: {
                result.append("STARTING");
                break;
            }
            case 4: {
                result.append("STOPPED");
                break;
            }
            case 256: {
                result.append("STOPPING");
                break;
            }
            case 16: {
                result.append("UNINSTALLED");
                break;
            }
            case 64: {
                result.append("UNRESOLVED");
                break;
            }
            case 8: {
                result.append("UPDATED");
                break;
            }
        }
        result.append("] ").append(event.getSource());
        return result.toString();
    }
}

