/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class BundleInstaller {
    private BundleContext context;
    private String rootLocation;
    private HashMap bundles = new HashMap();
    private ServiceTracker packageAdmin;
    private ServiceTracker startlevel;
    private ServiceTracker converter;
    private ServiceTracker platformAdmin;

    public BundleInstaller(String bundlesRoot, BundleContext context) throws InvalidSyntaxException {
        this.context = context;
        this.rootLocation = bundlesRoot;
        this.converter = new ServiceTracker(context, context.createFilter("(&(objectClass=" + URLConverter.class.getName() + ")(protocol=bundleentry))"), null);
        this.converter.open();
        this.startlevel = new ServiceTracker(context, StartLevel.class.getName(), null);
        this.startlevel.open();
        this.packageAdmin = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.packageAdmin.open();
        this.platformAdmin = new ServiceTracker(context, PlatformAdmin.class.getName(), null);
        this.platformAdmin.open();
    }

    public synchronized Bundle installBundle(String name) throws BundleException {
        return this.installBundle(name, true);
    }

    public synchronized Bundle installBundle(String name, boolean track) throws BundleException {
        if (this.bundles == null && track) {
            return null;
        }
        String location = this.getBundleLocation(name);
        Bundle bundle = this.context.installBundle(location);
        if (track) {
            this.bundles.put(name, bundle);
        }
        return bundle;
    }

    public String getBundleLocation(final String name) throws BundleException {
        if (System.getSecurityManager() == null) {
            return this.getBundleLocation0(name);
        }
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return BundleInstaller.this.getBundleLocation0(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (BundleException)((Object)e.getException());
        }
    }

    String getBundleLocation0(String name) throws BundleException {
        String bundleFileName = String.valueOf(this.rootLocation) + "/" + name;
        URL bundleURL = this.context.getBundle().getEntry(String.valueOf(bundleFileName) + ".jar");
        if (bundleURL == null) {
            bundleURL = this.context.getBundle().getEntry(bundleFileName);
        }
        if (bundleURL == null) {
            throw new BundleException("Could not find bundle to install at: " + name);
        }
        try {
            bundleURL = ((URLConverter)this.converter.getService()).resolve(bundleURL);
        }
        catch (IOException e) {
            throw new BundleException("Converter error", (Throwable)e);
        }
        String location = bundleURL.toExternalForm();
        if ("file".equals(bundleURL.getProtocol())) {
            location = "reference:" + location;
        }
        return location;
    }

    public synchronized Bundle updateBundle(String fromName, String toName) throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle fromBundle = (Bundle)this.bundles.get(fromName);
        if (fromBundle == null) {
            throw new BundleException("The bundle to update does not exist!! " + fromName);
        }
        String bundleFileName = String.valueOf(this.rootLocation) + "/" + toName;
        URL bundleURL = this.context.getBundle().getEntry(String.valueOf(bundleFileName) + ".jar");
        if (bundleURL == null) {
            bundleURL = this.context.getBundle().getEntry(bundleFileName);
        }
        try {
            bundleURL = ((URLConverter)this.converter.getService()).resolve(bundleURL);
        }
        catch (IOException e) {
            throw new BundleException("Converter error", (Throwable)e);
        }
        String location = bundleURL.toExternalForm();
        if ("file".equals(bundleURL.getProtocol())) {
            location = "reference:" + location;
        }
        try {
            fromBundle.update(new URL(location).openStream());
        }
        catch (Exception e) {
            throw new BundleException("Errors when updating bundle " + fromBundle, (Throwable)e);
        }
        this.bundles.remove(fromName);
        this.bundles.put(toName, fromBundle);
        return fromBundle;
    }

    public synchronized Bundle uninstallBundle(String name) throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle bundle = (Bundle)this.bundles.remove(name);
        if (bundle == null) {
            return null;
        }
        bundle.uninstall();
        return bundle;
    }

    public synchronized Bundle[] uninstallAllBundles() {
        if (this.bundles == null) {
            return null;
        }
        ArrayList<Bundle> result = new ArrayList<Bundle>(this.bundles.size());
        for (Bundle bundle : this.bundles.values()) {
            try {
                bundle.uninstall();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
            result.add(bundle);
        }
        this.bundles.clear();
        return result.toArray(new Bundle[result.size()]);
    }

    public synchronized Bundle[] shutdown() {
        if (this.bundles == null) {
            return null;
        }
        Bundle[] result = this.uninstallAllBundles();
        this.refreshPackages(result);
        this.packageAdmin.close();
        this.startlevel.close();
        this.converter.close();
        this.platformAdmin.close();
        this.bundles = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Bundle[] refreshPackages(Bundle[] refresh) {
        if (this.bundles == null) {
            return null;
        }
        PackageAdmin pa = (PackageAdmin)this.packageAdmin.getService();
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        this.context.addFrameworkListener(listener);
        final HashSet refreshed = new HashSet();
        SynchronousBundleListener refreshBundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                refreshed.add(event.getBundle());
            }
        };
        this.context.addBundleListener((BundleListener)refreshBundleListener);
        try {
            pa.refreshPackages(refresh);
            boolean[] blArray = flag;
            synchronized (flag) {
                while (true) {
                    if (flag[0]) {
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                        return refreshed.toArray(new Bundle[refreshed.size()]);
                    }
                    try {
                        flag.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        finally {
            this.context.removeFrameworkListener(listener);
            this.context.removeBundleListener((BundleListener)refreshBundleListener);
        }
    }

    public synchronized boolean resolveBundles(Bundle[] resolve) {
        if (this.bundles == null) {
            return false;
        }
        PackageAdmin pa = (PackageAdmin)this.packageAdmin.getService();
        return pa.resolveBundles(resolve);
    }

    public synchronized Bundle getBundle(String name) {
        if (this.bundles == null) {
            return null;
        }
        return (Bundle)this.bundles.get(name);
    }

    public StartLevel getStartLevel() {
        return (StartLevel)this.startlevel.getService();
    }

    public PackageAdmin getPackageAdmin() {
        return (PackageAdmin)this.packageAdmin.getService();
    }

    public PlatformAdmin getPlatformAdmin() {
        return (PlatformAdmin)this.platformAdmin.getService();
    }
}

