/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.net.URL;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class BundleResourceTests
extends CoreTest {
    private BundleInstaller installer;

    protected void setUp() throws Exception {
        try {
            this.installer = new BundleInstaller("test_files/resourcetests/bundles", OSGiTestsActivator.getContext());
        }
        catch (InvalidSyntaxException e) {
            BundleResourceTests.fail((String)"Failed to create bundle installer", (Throwable)e);
        }
    }

    protected void tearDown() throws Exception {
        this.installer.shutdown();
    }

    public static Test suite() {
        return new TestSuite(BundleResourceTests.class);
    }

    public void testBug320546_01() throws Exception {
        Bundle bundle = this.installer.installBundle("test");
        URL result = bundle.getEntry("../../../../security");
        BundleResourceTests.assertNull((String)"Found resource!", (Object)result);
        result = bundle.getEntry("../file.txt");
        BundleResourceTests.assertNull((String)"Found resource!", (Object)result);
        result = bundle.getEntry("../../");
        BundleResourceTests.assertNull((String)"Found resource!", (Object)result);
        result = bundle.getEntry("folder/../../file.txt");
        BundleResourceTests.assertNull((String)"Found resource!", (Object)result);
        result = bundle.getEntry("folder/../plugin.xml");
        BundleResourceTests.assertNotNull((String)"Did not find resource!", (Object)result);
        result = bundle.getEntry("/plugin.xml");
        BundleResourceTests.assertNotNull((String)"Did not find resource!", (Object)result);
    }

    public void testBug320546_02() throws Exception {
        Bundle bundle = this.installer.installBundle("test");
        Enumeration paths = bundle.getEntryPaths("../");
        BundleResourceTests.assertNull((String)"found resource!", (Object)paths);
        paths = bundle.getEntryPaths("folder");
        BundleResourceTests.assertNotNull((String)"Did not find resource!", (Object)paths);
        paths = bundle.getEntryPaths("folder/../../");
        BundleResourceTests.assertNull((String)"found resource!", (Object)paths);
        paths = bundle.getEntryPaths("folder/..");
        BundleResourceTests.assertNotNull((String)"Did not find resource!", (Object)paths);
    }

    public void testBug395274() throws Exception {
        ServiceReference infoRef = OSGiTestsActivator.getContext().getServiceReference(EnvironmentInfo.class);
        EnvironmentInfo info = (EnvironmentInfo)OSGiTestsActivator.getContext().getService(infoRef);
        String original = info.setProperty("osgi.strictBundleEntryPath", "true");
        try {
            Bundle bundle = this.installer.installBundle("test");
            URL path = bundle.getEntry("META-INF./MANIFEST.MF");
            BundleResourceTests.assertNull((String)"found resource!", (Object)path);
            path = bundle.getEntry("META-INF/MANIFEST.MF");
            BundleResourceTests.assertNotNull((String)"Did not find resource!", (Object)path);
            path = bundle.getEntry("folder/file1.TXT");
            BundleResourceTests.assertNull((String)"found resource!", (Object)path);
            path = bundle.getEntry("folder/file1.txt");
            BundleResourceTests.assertNotNull((String)"Did not find resource!", (Object)path);
            this.checkEntries(bundle, "/./file1.txt", 1);
            this.checkEntries(bundle, "//file1.txt", 1);
            this.checkEntries(bundle, "/", 1);
            this.checkEntries(bundle, "/.", 1);
        }
        finally {
            info.setProperty("osgi.strictBundleEntryPath", original);
            OSGiTestsActivator.getContext().ungetService(infoRef);
        }
    }

    public void testBug328795() throws BundleException {
        Bundle bundle = this.installer.installBundle("test");
        this.checkEntries(bundle, "notFound\\", 0);
        this.checkEntries(bundle, "notFound\\\\", 0);
        this.checkEntries(bundle, "notFound(", 0);
        this.checkEntries(bundle, "notFound\\(", 0);
        this.checkEntries(bundle, "notFound)", 0);
        this.checkEntries(bundle, "notFound\\)", 0);
        this.checkEntries(bundle, "notFound*", 0);
        this.checkEntries(bundle, "notFound\\*", 0);
        this.checkEntries(bundle, "paren(.txt", 1);
        this.checkEntries(bundle, "paren\\(.txt", 1);
        this.checkEntries(bundle, "paren\\\\(.txt", 0);
        this.checkEntries(bundle, "paren).txt", 1);
        this.checkEntries(bundle, "paren\\).txt", 1);
        this.checkEntries(bundle, "paren\\\\).txt", 0);
        this.checkEntries(bundle, "paren(", 1);
        this.checkEntries(bundle, "paren\\(", 1);
        this.checkEntries(bundle, "paren\\\\(", 0);
        this.checkEntries(bundle, "paren)", 1);
        this.checkEntries(bundle, "paren\\)", 1);
        this.checkEntries(bundle, "paren\\\\)", 0);
        this.checkEntries(bundle, "paren*", 4);
        this.checkEntries(bundle, "paren*.txt", 2);
        this.checkEntries(bundle, "paren\\*", 0);
        this.checkEntries(bundle, "paren\\\\*", 0);
        this.checkEntries(bundle, "p*r*n*", 4);
        this.checkEntries(bundle, "p*r*n*.txt", 2);
        this.checkEntries(bundle, "*)*", 2);
        this.checkEntries(bundle, "*(*", 2);
        this.checkEntries(bundle, "*\\)*", 2);
        this.checkEntries(bundle, "*\\(*", 2);
    }

    public void testBug338081() throws BundleException {
        Bundle bundle = this.installer.installBundle("test");
        Enumeration entries = bundle.findEntries("", "file1.txt", false);
        BundleResourceTests.assertNotNull((String)"An entry should have been found", (Object)entries);
        BundleResourceTests.assertTrue((String)"An entry should have been found", (boolean)entries.hasMoreElements());
        BundleResourceTests.assertTrue((String)"Wrong entry found", (((URL)entries.nextElement()).toString().indexOf("file1.txt") > -1 ? 1 : 0) != 0);
        BundleResourceTests.assertFalse((String)"Only one entry should have been found", (boolean)entries.hasMoreElements());
    }

    private void checkEntries(Bundle bundle, String filePattern, int expectedNumber) {
        Enumeration entries = bundle.findEntries("folder", filePattern, false);
        if (expectedNumber == 0) {
            BundleResourceTests.assertNull((String)"Expected nothing here.", (Object)entries);
            return;
        }
        int i = 0;
        while (entries.hasMoreElements()) {
            entries.nextElement();
            ++i;
        }
        BundleResourceTests.assertEquals((String)"Unexpected number of entries", (int)expectedNumber, (int)i);
    }
}

