/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.File;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class ImportJavaSEPackagesTests
extends AbstractBundleTests {
    private static final String JAVA_LANG = "java.lang";
    private static final String JAVA_UTIL = "java.util";
    private static String originalSpecVersion;

    public static Test suite() {
        return new TestSuite(ImportJavaSEPackagesTests.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        originalSpecVersion = System.getProperty("java.specification.version");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        System.setProperty("java.specification.version", originalSpecVersion);
    }

    public void testExportPackageCannotContainJavaPackages() throws Exception {
        block11: {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Bundle-ManifestVersion", "2");
            headers.put("Bundle-SymbolicName", this.getName());
            headers.put("Export-Package", JAVA_LANG);
            config.mkdirs();
            File bundle = SystemBundleTests.createBundle(config, this.getName(), headers, new Map[0]);
            Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
            try {
                try {
                    equinox.start();
                    BundleContext systemContext = equinox.getBundleContext();
                    Bundle testBundle = systemContext.installBundle(bundle.toURI().toString());
                    testBundle.start();
                    ImportJavaSEPackagesTests.fail((String)"Failed to test Export-Package header");
                }
                catch (BundleException e) {
                    ImportJavaSEPackagesTests.assertEquals((String)"It should throw a bundle exception of type manifest error", (int)3, (int)e.getType());
                    ImportJavaSEPackagesTests.assertTrue((String)"It should throw a Bundle Exception stating Invalid manifest header Export-Package", (boolean)e.getMessage().contains("Cannot specify java.* packages in Export headers"));
                    try {
                        equinox.stop();
                        equinox.waitForStop(10000L);
                    }
                    catch (Exception exception) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    equinox.stop();
                    equinox.waitForStop(10000L);
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                equinox.stop();
                equinox.waitForStop(10000L);
            }
            catch (Exception exception) {}
        }
    }

    public void testImportPackageCanContainJavaPackages() throws Exception {
        block11: {
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Bundle-ManifestVersion", "2");
            headers.put("Bundle-SymbolicName", this.getName());
            headers.put("Import-Package", JAVA_LANG);
            config.mkdirs();
            File bundle = SystemBundleTests.createBundle(config, this.getName(), headers, new Map[0]);
            Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
            try {
                try {
                    equinox.start();
                    BundleContext systemContext = equinox.getBundleContext();
                    Bundle testBundle = systemContext.installBundle(bundle.toURI().toString());
                    testBundle.start();
                    Dictionary testHeaders = testBundle.getHeaders();
                    ImportJavaSEPackagesTests.assertTrue((String)"Import-Package does not contain the java.* package", (boolean)((String)testHeaders.get("Import-Package")).contains(JAVA_LANG));
                    List pkgWires = ((BundleWiring)testBundle.adapt(BundleWiring.class)).getRequiredWires("osgi.wiring.package");
                    ImportJavaSEPackagesTests.assertEquals((String)"Wrong number of package requiremens: ", (int)1, (int)pkgWires.size());
                    ImportJavaSEPackagesTests.assertEquals("Wrong package found: " + pkgWires.get(0), JAVA_LANG, ((BundleWire)pkgWires.get(0)).getCapability().getAttributes().get("osgi.wiring.package"));
                }
                catch (BundleException bundleException) {
                    ImportJavaSEPackagesTests.fail((String)"Failed to test Import-Package header");
                    try {
                        equinox.stop();
                        equinox.waitForStop(10000L);
                    }
                    catch (Exception exception) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    equinox.stop();
                    equinox.waitForStop(10000L);
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                equinox.stop();
                equinox.waitForStop(10000L);
            }
            catch (Exception exception) {}
        }
    }

    public void testSystemPackages() throws Exception {
        HashMap<Integer, Integer> packagesPerVersion = new HashMap<Integer, Integer>();
        packagesPerVersion.put(7, 56);
        packagesPerVersion.put(8, 63);
        packagesPerVersion.put(9, 66);
        for (Map.Entry entry : packagesPerVersion.entrySet()) {
            this.doSystemPackages((Integer)entry.getKey(), (Integer)entry.getValue());
        }
    }

    public void doSystemPackages(int rv, int expectedPackages) throws Exception {
        block14: {
            if (rv < 9) {
                System.setProperty("java.specification.version", "1." + rv);
            } else {
                System.setProperty("java.specification.version", Integer.toString(rv));
            }
            File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Bundle-ManifestVersion", "2");
            headers.put("Bundle-SymbolicName", this.getName());
            config.mkdirs();
            File bundle = SystemBundleTests.createBundle(config, this.getName(), headers, new Map[0]);
            Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
            try {
                try {
                    equinox.start();
                    BundleContext systemContext = equinox.getBundleContext();
                    Dictionary testHeaders = equinox.getHeaders();
                    ImportJavaSEPackagesTests.assertTrue((String)"Export-Package does not contain the java.* package", (boolean)((String)testHeaders.get("Export-Package")).contains(JAVA_LANG));
                    ImportJavaSEPackagesTests.assertTrue((String)"Export-Package does not contain the java.* package", (boolean)((String)testHeaders.get("Export-Package")).contains(JAVA_UTIL));
                    List capabilities = ((BundleWiring)equinox.adapt(BundleWiring.class)).getCapabilities("osgi.wiring.package");
                    int count = 0;
                    for (BundleCapability cap : capabilities) {
                        if (!cap.getAttributes().get("osgi.wiring.package").toString().startsWith("java.")) continue;
                        ++count;
                    }
                    ImportJavaSEPackagesTests.assertEquals((String)("Wrong number of java.* packages for version " + rv), (int)expectedPackages, (int)count);
                    Bundle testBundle = systemContext.installBundle(bundle.toURI().toString());
                    testBundle.start();
                    String systemPackages = testBundle.getBundleContext().getProperty("org.osgi.framework.system.packages");
                    ImportJavaSEPackagesTests.assertTrue((String)"System packages should include java.* packages", (boolean)systemPackages.contains(JAVA_LANG));
                    ImportJavaSEPackagesTests.assertTrue((String)"System packages should include java.* packages", (boolean)systemPackages.contains(JAVA_UTIL));
                }
                catch (BundleException bundleException) {
                    ImportJavaSEPackagesTests.fail((String)"Failed to test System packages");
                    try {
                        equinox.stop();
                        equinox.waitForStop(10000L);
                    }
                    catch (Exception exception) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    equinox.stop();
                    equinox.waitForStop(10000L);
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                equinox.stop();
                equinox.waitForStop(10000L);
            }
            catch (Exception exception) {}
        }
    }
}

