/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class LoggingTests
extends AbstractBundleTests {
    static final String EQUINOX_LOGGER = "org.eclipse.equinox.logger";

    public static Test suite() {
        return new TestSuite(LoggingTests.class);
    }

    private LogServiceReference getLogService(BundleContext bc) {
        ServiceReference logRef = bc.getServiceReference(ExtendedLogService.class.getName());
        LoggingTests.assertNotNull((String)"log service ref is null", (Object)logRef);
        ServiceReference readerRef = bc.getServiceReference(ExtendedLogReaderService.class.getName());
        LoggingTests.assertNotNull((String)"log reader ref is null", (Object)readerRef);
        ServiceReference fwkLogRef = bc.getServiceReference(FrameworkLog.class.getName());
        LoggingTests.assertNotNull((String)"framework log ref is null", (Object)fwkLogRef);
        ExtendedLogService logService = (ExtendedLogService)bc.getService(logRef);
        LoggingTests.assertNotNull((String)"log service is null", (Object)logService);
        ExtendedLogReaderService readerService = (ExtendedLogReaderService)bc.getService(readerRef);
        LoggingTests.assertNotNull((String)"reader service is null", (Object)readerService);
        FrameworkLog fwkLog = (FrameworkLog)bc.getService(fwkLogRef);
        LoggingTests.assertNotNull((String)"framework log is null", (Object)fwkLog);
        return new LogServiceReference(logRef, logService, readerRef, readerService, fwkLogRef, fwkLog);
    }

    public void testLogService() throws BundleException {
        Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        BundleContext bc = testBundle.getBundleContext();
        LogServiceReference logRef = this.getLogService(bc);
        Status a = new Status(4, testBundle.getSymbolicName(), this.getName());
        ArrayList<Status> context = new ArrayList<Status>();
        context.add(a);
        TestILogListener iLogListener1 = new TestILogListener(new ArrayList(context));
        TestILogListener iLogListener2 = new TestILogListener(new ArrayList(context));
        TestLogListener logListener = new TestLogListener(new ArrayList(context));
        ILog testLog = Platform.getLog((Bundle)testBundle);
        testLog.addLogListener((ILogListener)iLogListener1);
        Platform.addLogListener((ILogListener)iLogListener2);
        logRef.readerService.addLogListener((LogListener)logListener, (LogFilter)logListener);
        try {
            ExtendedLogService logService = logRef.logService;
            Logger logger = logService.getLogger(testBundle, EQUINOX_LOGGER);
            logger.log((Object)a, 1, a.getMessage());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            logger.log((Object)new FrameworkLogEntry((Object)a, testBundle.getSymbolicName(), a.getSeverity(), a.getCode(), a.getMessage(), 0, null, null), 1, a.getMessage());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            logListener.entries.clear();
            logger.log(1, a.getMessage());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertFalse((String)"Missing context", (boolean)logListener.waitforContext());
            LoggingTests.assertEquals((String)"Wrong number of entries", (int)1, (int)logListener.entries.size());
        }
        finally {
            testLog.removeLogListener((ILogListener)iLogListener1);
            Platform.removeLogListener((ILogListener)iLogListener2);
            logRef.readerService.removeLogListener((LogListener)logListener);
            logRef.unget(bc);
        }
    }

    public void testPluginILog() throws BundleException {
        Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        BundleContext bc = testBundle.getBundleContext();
        LogServiceReference logRef = this.getLogService(bc);
        Status a = new Status(4, testBundle.getSymbolicName(), this.getName());
        ArrayList<Status> context = new ArrayList<Status>();
        context.add(a);
        TestILogListener iLogListener1 = new TestILogListener(new ArrayList(context));
        TestILogListener iLogListener2 = new TestILogListener(new ArrayList(context));
        TestLogListener logListener = new TestLogListener(new ArrayList(context));
        ILog testLog = Platform.getLog((Bundle)testBundle);
        testLog.addLogListener((ILogListener)iLogListener1);
        Platform.addLogListener((ILogListener)iLogListener2);
        logRef.readerService.addLogListener((LogListener)logListener, (LogFilter)logListener);
        try {
            testLog.log((IStatus)a);
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            testLog.log((IStatus)a);
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
        }
        finally {
            testLog.removeLogListener((ILogListener)iLogListener1);
            Platform.removeLogListener((ILogListener)iLogListener2);
            logRef.readerService.removeLogListener((LogListener)logListener);
            logRef.unget(bc);
        }
    }

    public void testRuntimeLog() throws BundleException {
        Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        BundleContext bc = testBundle.getBundleContext();
        LogServiceReference logRef = this.getLogService(bc);
        Status a = new Status(4, testBundle.getSymbolicName(), this.getName());
        ArrayList<Status> context = new ArrayList<Status>();
        context.add(a);
        TestILogListener iLogListener1 = new TestILogListener(new ArrayList(context));
        TestILogListener iLogListener2 = new TestILogListener(new ArrayList(context));
        TestLogListener logListener = new TestLogListener(new ArrayList(context));
        ILog testLog = Platform.getLog((Bundle)testBundle);
        testLog.addLogListener((ILogListener)iLogListener1);
        Platform.addLogListener((ILogListener)iLogListener2);
        logRef.readerService.addLogListener((LogListener)logListener, (LogFilter)logListener);
        try {
            RuntimeLog.log((IStatus)a);
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            RuntimeLog.log((IStatus)a);
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
        }
        finally {
            testLog.removeLogListener((ILogListener)iLogListener1);
            Platform.removeLogListener((ILogListener)iLogListener2);
            logRef.readerService.removeLogListener((LogListener)logListener);
            logRef.unget(bc);
        }
    }

    public void testFrameworkLog() throws BundleException {
        Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        BundleContext bc = testBundle.getBundleContext();
        LogServiceReference logRef = this.getLogService(bc);
        Status a = new Status(4, testBundle.getSymbolicName(), this.getName());
        ArrayList<Status> context = new ArrayList<Status>();
        context.add(a);
        TestILogListener iLogListener1 = new TestILogListener(new ArrayList(context));
        TestILogListener iLogListener2 = new TestILogListener(new ArrayList(context));
        TestLogListener logListener = new TestLogListener(new ArrayList(context));
        ILog testLog = Platform.getLog((Bundle)testBundle);
        testLog.addLogListener((ILogListener)iLogListener1);
        Platform.addLogListener((ILogListener)iLogListener2);
        logRef.readerService.addLogListener((LogListener)logListener, (LogFilter)logListener);
        try {
            FrameworkLogEntry fwkLogEntry = new FrameworkLogEntry((Object)a, testBundle.getSymbolicName(), a.getSeverity(), a.getCode(), a.getMessage(), 0, null, null);
            logRef.fwkLog.log(fwkLogEntry);
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            logRef.fwkLog.log(fwkLogEntry);
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)logListener.waitforContext());
            iLogListener1.addContext(new ArrayList(context));
            iLogListener2.addContext(new ArrayList(context));
            logListener.addContext(new ArrayList(context));
            logListener.entries.clear();
            logRef.fwkLog.log(new FrameworkLogEntry(testBundle.getSymbolicName(), a.getSeverity(), a.getCode(), a.getMessage(), 0, null, null));
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener1.waitforContext());
            LoggingTests.assertTrue((String)"Missing context", (boolean)iLogListener2.waitforContext());
            LoggingTests.assertFalse((String)"Missing context", (boolean)logListener.waitforContext());
            LoggingTests.assertEquals((String)"Wrong number of entries", (int)1, (int)logListener.entries.size());
        }
        finally {
            testLog.removeLogListener((ILogListener)iLogListener1);
            Platform.removeLogListener((ILogListener)iLogListener2);
            logRef.readerService.removeLogListener((LogListener)logListener);
            logRef.unget(bc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventAdminAdapter1() {
        ServiceReference eventRef = this.getContext().getServiceReference(EventAdmin.class.getName());
        LoggingTests.assertNotNull((String)"No eventAdmin.", (Object)eventRef);
        LogServiceReference logRef = this.getLogService(this.getContext());
        final ArrayList events = new ArrayList();
        EventHandler testHandler = new EventHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event) {
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", "org/osgi/service/log/LogEntry/*");
        ServiceRegistration handlerReg = this.getContext().registerService(EventHandler.class.getName(), (Object)testHandler, props);
        try {
            logRef.logService.log(1, this.getName());
            Event testEvent = null;
            ArrayList arrayList = events;
            synchronized (arrayList) {
                if (events.size() == 0) {
                    try {
                        events.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (events.size() > 0) {
                    testEvent = (Event)events.get(0);
                }
            }
            LoggingTests.assertNotNull((String)"No event fired", (Object)testEvent);
            LoggingTests.assertEquals("Wrong message", this.getName(), testEvent.getProperty("message"));
        }
        finally {
            handlerReg.unregister();
            logRef.unget(this.getContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventAdminAdapter2() {
        ServiceReference eventRef = this.getContext().getServiceReference(EventAdmin.class.getName());
        LoggingTests.assertNotNull((String)"No eventAdmin.", (Object)eventRef);
        LogServiceReference logRef = this.getLogService(this.getContext());
        final ArrayList events = new ArrayList();
        EventHandler testHandler = new EventHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event) {
                List list = events;
                synchronized (list) {
                    events.add(event);
                    events.notifyAll();
                }
                throw new NullPointerException();
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", "org/osgi/service/log/LogEntry/*");
        ServiceRegistration handlerReg = this.getContext().registerService(EventHandler.class.getName(), (Object)testHandler, props);
        try {
            logRef.logService.log(1, this.getName());
            int size = 0;
            ArrayList arrayList = events;
            synchronized (arrayList) {
                int i = 0;
                while (i < 3 && events.size() < 3) {
                    try {
                        events.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    ++i;
                }
                size = events.size();
            }
            LoggingTests.assertEquals((String)"Should only get one event from bad handler", (int)2, (int)size);
        }
        finally {
            handlerReg.unregister();
            logRef.unget(this.getContext());
        }
    }

    public void testBug347183() throws BundleException {
        final Bundle testBundle = installer.installBundle("test.logging.a");
        testBundle.start();
        LogServiceReference logRef = this.getLogService(this.getContext());
        ILogListener recurseLog = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                Platform.getLog((Bundle)testBundle).log(status);
            }
        };
        Platform.addLogListener((ILogListener)recurseLog);
        try {
            logRef.fwkLog.log(new FrameworkLogEntry(this.getContext().getBundle().getSymbolicName(), 4, 0, "Test message", 0, null, null));
            Platform.getLog((Bundle)testBundle);
            logRef.fwkLog.log(new FrameworkLogEntry(this.getContext().getBundle().getSymbolicName(), 4, 0, "Test message", 0, null, null));
        }
        finally {
            Platform.removeLogListener((ILogListener)recurseLog);
        }
    }

    class ILogEntry {
        final IStatus status;
        final String plugin;

        ILogEntry(IStatus status, String plugin) {
            this.status = status;
            this.plugin = plugin;
        }
    }

    class LogServiceReference {
        private final ServiceReference logRef;
        final ExtendedLogService logService;
        private final ServiceReference readerRef;
        final ExtendedLogReaderService readerService;
        private final ServiceReference fwkLogRef;
        final FrameworkLog fwkLog;

        public LogServiceReference(ServiceReference logRef, ExtendedLogService logService, ServiceReference readerRef, ExtendedLogReaderService readerService, ServiceReference fwkLogRef, FrameworkLog fwkLog) {
            this.logRef = logRef;
            this.logService = logService;
            this.readerRef = readerRef;
            this.readerService = readerService;
            this.fwkLogRef = fwkLogRef;
            this.fwkLog = fwkLog;
        }

        public void unget(BundleContext bc) {
            bc.ungetService(this.logRef);
            bc.ungetService(this.readerRef);
            bc.ungetService(this.fwkLogRef);
        }
    }

    class TestILogListener
    extends TestListener
    implements ILogListener {
        List entries;

        TestILogListener(List context) {
            super(context);
            this.entries = new ArrayList();
        }

        public void logging(IStatus status, String plugin) {
            this.entries.add(new ILogEntry(status, plugin));
            this.checkContext(status);
        }

        List getEntries() {
            return this.entries;
        }
    }

    class TestListener {
        final List context;
        boolean found = false;

        TestListener(List context) {
            this.context = context;
        }

        synchronized boolean waitforContext() {
            if (this.context.size() > 0) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.context.size() == 0;
        }

        synchronized void checkContext(IStatus check) {
            if (check == null) {
                return;
            }
            if (this.context.size() > 0) {
                IStatus expected = (IStatus)this.context.get(0);
                try {
                    LoggingTests.assertEquals((int)expected.getSeverity(), (int)check.getSeverity());
                    LoggingTests.assertEquals((int)expected.getCode(), (int)check.getCode());
                    LoggingTests.assertEquals((String)expected.getMessage(), (String)check.getMessage());
                    LoggingTests.assertEquals((String)expected.getPlugin(), (String)check.getPlugin());
                }
                catch (AssertionFailedError assertionFailedError) {
                    return;
                }
                this.context.remove(0);
                if (this.context.size() == 0) {
                    this.notifyAll();
                }
            }
        }

        synchronized void addContext(List moreContext) {
            this.context.addAll(moreContext);
        }
    }

    class TestLogListener
    extends TestListener
    implements LogListener,
    LogFilter {
        List entries;

        TestLogListener(List context) {
            super(context);
            this.entries = new ArrayList();
        }

        public void logged(LogEntry entry) {
            this.entries.add(entry);
            Object check = ((ExtendedLogEntry)entry).getContext();
            if (check instanceof FrameworkLogEntry) {
                check = ((FrameworkLogEntry)check).getContext();
            }
            if (check instanceof IStatus) {
                this.checkContext((IStatus)check);
            }
        }

        List getEntries() {
            return this.entries;
        }

        public boolean isLoggable(Bundle bundle, String loggerName, int logLevel) {
            return LoggingTests.EQUINOX_LOGGER.equals(loggerName);
        }
    }
}

