/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.storage.StorageUtil;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

public class MultiReleaseJarTests
extends AbstractBundleTests {
    private static final String RNF = "RNF";
    private static final String CNFE = "CNFE";
    private File mrJarBundle;
    private String originalSpecVersion;

    public static Test suite() {
        return new TestSuite(MultiReleaseJarTests.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.mrJarBundle = MultiReleaseJarTests.createMRJarBundle();
        this.originalSpecVersion = System.getProperty("java.specification.version");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        System.setProperty("java.specification.version", this.originalSpecVersion);
    }

    private static File createMRJarBundle() throws BundleException, IOException {
        BundleContext bc = OSGiTestsActivator.getContext();
        File mrJarBundle = bc.getDataFile("mrJarBundleTest.jar");
        if (mrJarBundle.exists()) {
            return mrJarBundle;
        }
        File classpathMrJar = bc.getDataFile("classpathMrJar.jar");
        Bundle base = installer.installBundle("mrBundleInputBase");
        LinkedHashMap<String, String> bundleHeaders = new LinkedHashMap<String, String>();
        bundleHeaders.put("Bundle-ManifestVersion", "2");
        bundleHeaders.put("Bundle-SymbolicName", "mrBundle");
        bundleHeaders.put("Bundle-Version", "1.0.0");
        bundleHeaders.put("Import-Package", "pkgbase");
        bundleHeaders.put("Require-Capability", "capbase");
        bundleHeaders.put("Export-Package", "pkgbase, pkg8, pkg9, pkg10, pkg11");
        bundleHeaders.put("Provide-Capability", "capbase, cap8, cap9, cap10, cap11");
        bundleHeaders.put("Bundle-ClassPath", "., " + classpathMrJar.getName() + ", classPathDir");
        LinkedHashMap<String, byte[]> bundleEntries = new LinkedHashMap<String, byte[]>();
        bundleEntries.put("multi/", null);
        bundleEntries.put("multi/release/", null);
        bundleEntries.put("multi/release/test/", null);
        bundleEntries.put("multi/release/test/TestClassBase.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClassBase.class", base));
        bundleEntries.put("multi/release/test/TestClass8.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClass8.class", base));
        bundleEntries.put("multi/release/test/TestClass9.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClass9.class", base));
        bundleEntries.put("multi/release/test/TestClass10.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClass10.class", base));
        bundleEntries.put("multi/release/test/TestClass11.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClass11.class", base));
        bundleEntries.put("multi/release/test/TestService.class", MultiReleaseJarTests.getBytes("multi/release/test/TestService.class", base));
        bundleEntries.put("multi/release/test/TestService9.class", MultiReleaseJarTests.getBytes("multi/release/test/TestService9.class", base));
        bundleEntries.put("multi/release/test/TestServiceBase.class", MultiReleaseJarTests.getBytes("multi/release/test/TestServiceBase.class", base));
        bundleEntries.put("multi/release/test/testResourceBase.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResourceBase.txt", base));
        bundleEntries.put("multi/release/test/testResource8.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResource8.txt", base));
        bundleEntries.put("multi/release/test/testResource9.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResource9.txt", base));
        bundleEntries.put("multi/release/test/testResource10.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResource10.txt", base));
        bundleEntries.put("multi/release/test/testResource11.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResource11.txt", base));
        bundleEntries.put("META-INF/services/", null);
        bundleEntries.put("META-INF/services/multi.release.test.TestService", "multi.release.test.TestServiceBase".getBytes("UTF-8"));
        bundleEntries.put("META-INF/versions/", null);
        bundleEntries.put("META-INF/versions/8/", null);
        bundleEntries.put("META-INF/versions/8/multi/", null);
        bundleEntries.put("META-INF/versions/8/multi/release/", null);
        bundleEntries.put("META-INF/versions/8/multi/release/test/", null);
        bundleEntries.put("META-INF/versions/8/multi/release/test/TestClass8.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClass8.class", base, new byte[]{48, 56}));
        bundleEntries.put("META-INF/versions/8/multi/release/test/TestClassAdd8.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClassAdd8.class", base));
        bundleEntries.put("META-INF/versions/8/multi/release/test/testResource8.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResource8.txt", base, new byte[]{48, 56}));
        bundleEntries.put("META-INF/versions/8/multi/release/test/testResourceAdd8.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResourceAdd8.txt", base));
        bundleEntries.put("META-INF/versions/9/", null);
        bundleEntries.put("META-INF/versions/9/META-INF/", null);
        bundleEntries.put("META-INF/versions/9/META-INF/addedFor9.txt", "added for 9".getBytes("UTF-8"));
        bundleEntries.put("META-INF/versions/9/META-INF/addedDirFor9/", null);
        bundleEntries.put("META-INF/versions/9/META-INF/addedDirFor9/addedFor9.txt", "added for 9".getBytes("UTF-8"));
        bundleEntries.put("META-INF/versions/9/META-INF/services/", null);
        bundleEntries.put("META-INF/versions/9/META-INF/services/multi.release.test.TestService", "multi.release.test.TestService9".getBytes("UTF-8"));
        bundleEntries.put("META-INF/versions/9/multi/", null);
        bundleEntries.put("META-INF/versions/9/multi/release/", null);
        bundleEntries.put("META-INF/versions/9/multi/release/test/", null);
        bundleEntries.put("META-INF/versions/9/multi/release/test/TestClass9.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClass9.class", base, new byte[]{48, 57}));
        bundleEntries.put("META-INF/versions/9/multi/release/test/TestClassAdd9.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClassAdd9.class", base));
        bundleEntries.put("META-INF/versions/9/multi/release/test/testResource9.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResource9.txt", base, new byte[]{48, 57}));
        bundleEntries.put("META-INF/versions/9/multi/release/test/testResourceAdd9.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResourceAdd9.txt", base));
        bundleEntries.put("META-INF/versions/10/", null);
        bundleEntries.put("META-INF/versions/10/multi/", null);
        bundleEntries.put("META-INF/versions/10/multi/release/", null);
        bundleEntries.put("META-INF/versions/10/multi/release/test/", null);
        bundleEntries.put("META-INF/versions/10/multi/release/test/TestClass10.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClass10.class", base, new byte[]{49, 48}));
        bundleEntries.put("META-INF/versions/10/multi/release/test/TestClassAdd10.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClassAdd10.class", base));
        bundleEntries.put("META-INF/versions/10/multi/release/test/testResource10.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResource10.txt", base, new byte[]{49, 48}));
        bundleEntries.put("META-INF/versions/10/multi/release/test/testResourceAdd10.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResourceAdd10.txt", base));
        bundleEntries.put("META-INF/versions/11/", null);
        bundleEntries.put("META-INF/versions/11/multi/", null);
        bundleEntries.put("META-INF/versions/11/multi/release/", null);
        bundleEntries.put("META-INF/versions/11/multi/release/test/", null);
        bundleEntries.put("META-INF/versions/11/multi/release/test/TestClass11.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClass11.class", base, new byte[]{49, 49}));
        bundleEntries.put("META-INF/versions/11/multi/release/test/TestClassAdd11.class", MultiReleaseJarTests.getBytes("multi/release/test/TestClassAdd11.class", base));
        bundleEntries.put("META-INF/versions/11/multi/release/test/testResource11.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResource11.txt", base, new byte[]{49, 49}));
        bundleEntries.put("META-INF/versions/11/multi/release/test/testResourceAdd11.txt", MultiReleaseJarTests.getBytes("multi/release/test/testResourceAdd11.txt", base));
        bundleEntries.put("META-INF/versions/8/OSGI-INF/", null);
        bundleEntries.put("META-INF/versions/8/OSGI-INF/MANIFEST.MF", MultiReleaseJarTests.getBytes("manifests/manifest8.mf", base));
        bundleEntries.put("META-INF/versions/9/OSGI-INF/", null);
        bundleEntries.put("META-INF/versions/9/OSGI-INF/MANIFEST.MF", MultiReleaseJarTests.getBytes("manifests/manifest9.mf", base));
        bundleEntries.put("META-INF/versions/10/OSGI-INF/", null);
        bundleEntries.put("META-INF/versions/10/OSGI-INF/MANIFEST.MF", MultiReleaseJarTests.getBytes("manifests/manifest10.mf", base));
        bundleEntries.put("META-INF/versions/11/OSGI-INF/", null);
        bundleEntries.put("META-INF/versions/11/OSGI-INF/MANIFEST.MF", MultiReleaseJarTests.getBytes("manifests/manifest11.mf", base));
        LinkedHashMap<String, byte[]> classPathJarEntries = new LinkedHashMap<String, byte[]>();
        classPathJarEntries.put("multi/", null);
        classPathJarEntries.put("multi/release/", null);
        classPathJarEntries.put("multi/release/test/", null);
        classPathJarEntries.put("multi/release/test/sub/", null);
        classPathJarEntries.put("multi/release/test/sub/TestClassBase.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClassBase.class", base));
        classPathJarEntries.put("multi/release/test/sub/TestClass8.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClass8.class", base));
        classPathJarEntries.put("multi/release/test/sub/TestClass9.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClass9.class", base));
        classPathJarEntries.put("multi/release/test/sub/TestClass10.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClass10.class", base));
        classPathJarEntries.put("multi/release/test/sub/TestClass11.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClass11.class", base));
        classPathJarEntries.put("multi/release/test/sub/testResourceBase.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResourceBase.txt", base));
        classPathJarEntries.put("multi/release/test/sub/testResource8.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResource8.txt", base));
        classPathJarEntries.put("multi/release/test/sub/testResource9.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResource9.txt", base));
        classPathJarEntries.put("multi/release/test/sub/testResource10.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResource10.txt", base));
        classPathJarEntries.put("multi/release/test/sub/testResource11.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResource11.txt", base));
        classPathJarEntries.put("META-INF/versions/", null);
        classPathJarEntries.put("META-INF/versions/8/", null);
        classPathJarEntries.put("META-INF/versions/8/multi/", null);
        classPathJarEntries.put("META-INF/versions/8/multi/release/", null);
        classPathJarEntries.put("META-INF/versions/8/multi/release/test/", null);
        classPathJarEntries.put("META-INF/versions/8/multi/release/test/sub/", null);
        classPathJarEntries.put("META-INF/versions/8/multi/release/test/sub/TestClass8.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClass8.class", base, new byte[]{48, 56}));
        classPathJarEntries.put("META-INF/versions/8/multi/release/test/sub/TestClassAdd8.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClassAdd8.class", base));
        classPathJarEntries.put("META-INF/versions/8/multi/release/test/sub/testResource8.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResource8.txt", base, new byte[]{48, 56}));
        classPathJarEntries.put("META-INF/versions/8/multi/release/test/sub/testResourceAdd8.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResourceAdd8.txt", base));
        classPathJarEntries.put("META-INF/versions/9/", null);
        classPathJarEntries.put("META-INF/versions/9/multi/", null);
        classPathJarEntries.put("META-INF/versions/9/multi/release/", null);
        classPathJarEntries.put("META-INF/versions/9/multi/release/test/", null);
        classPathJarEntries.put("META-INF/versions/9/multi/release/test/sub/", null);
        classPathJarEntries.put("META-INF/versions/9/multi/release/test/sub/TestClass9.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClass9.class", base, new byte[]{48, 57}));
        classPathJarEntries.put("META-INF/versions/9/multi/release/test/sub/TestClassAdd9.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClassAdd9.class", base));
        classPathJarEntries.put("META-INF/versions/9/multi/release/test/sub/testResource9.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResource9.txt", base, new byte[]{48, 57}));
        classPathJarEntries.put("META-INF/versions/9/multi/release/test/sub/testResourceAdd9.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResourceAdd9.txt", base));
        classPathJarEntries.put("META-INF/versions/10/", null);
        classPathJarEntries.put("META-INF/versions/10/multi/", null);
        classPathJarEntries.put("META-INF/versions/10/multi/release/", null);
        classPathJarEntries.put("META-INF/versions/10/multi/release/test/", null);
        classPathJarEntries.put("META-INF/versions/10/multi/release/test/sub/", null);
        classPathJarEntries.put("META-INF/versions/10/multi/release/test/sub/TestClass10.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClass10.class", base, new byte[]{49, 48}));
        classPathJarEntries.put("META-INF/versions/10/multi/release/test/sub/TestClassAdd10.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClassAdd10.class", base));
        classPathJarEntries.put("META-INF/versions/10/multi/release/test/sub/testResource10.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResource10.txt", base, new byte[]{49, 48}));
        classPathJarEntries.put("META-INF/versions/10/multi/release/test/sub/testResourceAdd10.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResourceAdd10.txt", base));
        classPathJarEntries.put("META-INF/versions/11/", null);
        classPathJarEntries.put("META-INF/versions/11/multi/", null);
        classPathJarEntries.put("META-INF/versions/11/multi/release/", null);
        classPathJarEntries.put("META-INF/versions/11/multi/release/test/", null);
        classPathJarEntries.put("META-INF/versions/11/multi/release/test/sub/", null);
        classPathJarEntries.put("META-INF/versions/11/multi/release/test/sub/TestClass11.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClass11.class", base, new byte[]{49, 49}));
        classPathJarEntries.put("META-INF/versions/11/multi/release/test/sub/TestClassAdd11.class", MultiReleaseJarTests.getBytes("multi/release/test/sub/TestClassAdd11.class", base));
        classPathJarEntries.put("META-INF/versions/11/multi/release/test/sub/testResource11.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResource11.txt", base, new byte[]{49, 49}));
        classPathJarEntries.put("META-INF/versions/11/multi/release/test/sub/testResourceAdd11.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub/testResourceAdd11.txt", base));
        MultiReleaseJarTests.createMRJar(classpathMrJar, Collections.emptyMap(), classPathJarEntries);
        bundleEntries.put(classpathMrJar.getName(), StorageUtil.getBytes((InputStream)new FileInputStream(classpathMrJar), (int)-1, (int)4000));
        bundleEntries.put("classPathDir/", null);
        bundleEntries.put("classPathDir/multi/", null);
        bundleEntries.put("classPathDir/multi/release/", null);
        bundleEntries.put("classPathDir/multi/release/test/", null);
        bundleEntries.put("classPathDir/multi/release/test/sub2/", null);
        bundleEntries.put("classPathDir/multi/release/test/sub2/TestClassBase.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClassBase.class", base));
        bundleEntries.put("classPathDir/multi/release/test/sub2/TestClass8.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClass8.class", base));
        bundleEntries.put("classPathDir/multi/release/test/sub2/TestClass9.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClass9.class", base));
        bundleEntries.put("classPathDir/multi/release/test/sub2/TestClass10.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClass10.class", base));
        bundleEntries.put("classPathDir/multi/release/test/sub2/TestClass11.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClass11.class", base));
        bundleEntries.put("classPathDir/multi/release/test/sub2/testResourceBase.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResourceBase.txt", base));
        bundleEntries.put("classPathDir/multi/release/test/sub2/testResource8.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResource8.txt", base));
        bundleEntries.put("classPathDir/multi/release/test/sub2/testResource9.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResource9.txt", base));
        bundleEntries.put("classPathDir/multi/release/test/sub2/testResource10.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResource10.txt", base));
        bundleEntries.put("classPathDir/multi/release/test/sub2/testResource11.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResource11.txt", base));
        String classPathDirManifest = "Manifest-Version: 1\nMulti-Release: true\n\n";
        bundleEntries.put("classPathDir/META-INF/", null);
        bundleEntries.put("classPathDir/META-INF/MANIFEST.MF", classPathDirManifest.getBytes(Charset.forName("UTF-8")));
        bundleEntries.put("classPathDir/META-INF/versions/", null);
        bundleEntries.put("classPathDir/META-INF/versions/8/", null);
        bundleEntries.put("classPathDir/META-INF/versions/8/multi/", null);
        bundleEntries.put("classPathDir/META-INF/versions/8/multi/release/", null);
        bundleEntries.put("classPathDir/META-INF/versions/8/multi/release/test/", null);
        bundleEntries.put("classPathDir/META-INF/versions/8/multi/release/test/sub2/", null);
        bundleEntries.put("classPathDir/META-INF/versions/8/multi/release/test/sub2/TestClass8.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClass8.class", base, new byte[]{48, 56}));
        bundleEntries.put("classPathDir/META-INF/versions/8/multi/release/test/sub2/TestClassAdd8.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClassAdd8.class", base));
        bundleEntries.put("classPathDir/META-INF/versions/8/multi/release/test/sub2/testResource8.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResource8.txt", base, new byte[]{48, 56}));
        bundleEntries.put("classPathDir/META-INF/versions/8/multi/release/test/sub2/testResourceAdd8.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResourceAdd8.txt", base));
        bundleEntries.put("classPathDir/META-INF/versions/9/", null);
        bundleEntries.put("classPathDir/META-INF/versions/9/multi/", null);
        bundleEntries.put("classPathDir/META-INF/versions/9/multi/release/", null);
        bundleEntries.put("classPathDir/META-INF/versions/9/multi/release/test/", null);
        bundleEntries.put("classPathDir/META-INF/versions/9/multi/release/test/sub2/", null);
        bundleEntries.put("classPathDir/META-INF/versions/9/multi/release/test/sub2/TestClass9.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClass9.class", base, new byte[]{48, 57}));
        bundleEntries.put("classPathDir/META-INF/versions/9/multi/release/test/sub2/TestClassAdd9.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClassAdd9.class", base));
        bundleEntries.put("classPathDir/META-INF/versions/9/multi/release/test/sub2/testResource9.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResource9.txt", base, new byte[]{48, 57}));
        bundleEntries.put("classPathDir/META-INF/versions/9/multi/release/test/sub2/testResourceAdd9.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResourceAdd9.txt", base));
        bundleEntries.put("classPathDir/META-INF/versions/10/", null);
        bundleEntries.put("classPathDir/META-INF/versions/10/multi/", null);
        bundleEntries.put("classPathDir/META-INF/versions/10/multi/release/", null);
        bundleEntries.put("classPathDir/META-INF/versions/10/multi/release/test/", null);
        bundleEntries.put("classPathDir/META-INF/versions/10/multi/release/test/sub2/", null);
        bundleEntries.put("classPathDir/META-INF/versions/10/multi/release/test/sub2/TestClass10.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClass10.class", base, new byte[]{49, 48}));
        bundleEntries.put("classPathDir/META-INF/versions/10/multi/release/test/sub2/TestClassAdd10.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClassAdd10.class", base));
        bundleEntries.put("classPathDir/META-INF/versions/10/multi/release/test/sub2/testResource10.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResource10.txt", base, new byte[]{49, 48}));
        bundleEntries.put("classPathDir/META-INF/versions/10/multi/release/test/sub2/testResourceAdd10.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResourceAdd10.txt", base));
        bundleEntries.put("classPathDir/META-INF/versions/11/", null);
        bundleEntries.put("classPathDir/META-INF/versions/11/multi/", null);
        bundleEntries.put("classPathDir/META-INF/versions/11/multi/release/", null);
        bundleEntries.put("classPathDir/META-INF/versions/11/multi/release/test/", null);
        bundleEntries.put("classPathDir/META-INF/versions/11/multi/release/test/sub2/", null);
        bundleEntries.put("classPathDir/META-INF/versions/11/multi/release/test/sub2/TestClass11.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClass11.class", base, new byte[]{49, 49}));
        bundleEntries.put("classPathDir/META-INF/versions/11/multi/release/test/sub2/TestClassAdd11.class", MultiReleaseJarTests.getBytes("multi/release/test/sub2/TestClassAdd11.class", base));
        bundleEntries.put("classPathDir/META-INF/versions/11/multi/release/test/sub2/testResource11.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResource11.txt", base, new byte[]{49, 49}));
        bundleEntries.put("classPathDir/META-INF/versions/11/multi/release/test/sub2/testResourceAdd11.txt", MultiReleaseJarTests.getBytes("multi/release/test/sub2/testResourceAdd11.txt", base));
        MultiReleaseJarTests.createMRJar(mrJarBundle, bundleHeaders, bundleEntries);
        return mrJarBundle;
    }

    static void createMRJar(File file, Map<String, String> headers, Map<String, byte[]> entries) throws IOException {
        Manifest m = new Manifest();
        Attributes attributes = m.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Multi-Release", "true");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            attributes.putValue(entry.getKey(), entry.getValue());
        }
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(file), m);
        if (entries != null) {
            for (Map.Entry<String, byte[]> entry : entries.entrySet()) {
                jos.putNextEntry(new JarEntry(entry.getKey()));
                if (entry.getValue() != null) {
                    jos.write(entry.getValue());
                }
                jos.closeEntry();
            }
        }
        jos.flush();
        jos.close();
    }

    private static byte[] getBytes(String path, Bundle b) throws IOException {
        return MultiReleaseJarTests.getBytes(path, b, null);
    }

    private static byte[] getBytes(String path, Bundle b, byte[] replace) throws IOException {
        URL entry = b.getEntry(path);
        if (entry == null) {
            throw new FileNotFoundException("No entry found for: " + path);
        }
        byte[] result = StorageUtil.getBytes((InputStream)entry.openStream(), (int)-1, (int)4000);
        if (replace != null) {
            int i = 0;
            while (i < result.length - 1) {
                if (result[i] == 88 && result[i + 1] == 88) {
                    result[i] = replace[0];
                    result[i + 1] = replace[1];
                }
                ++i;
            }
        }
        return result;
    }

    public void testMultiRelease8ClassLoad() throws Exception {
        this.doTestMultiReleaseClassLoad(8);
    }

    public void testMultiRelease9ClassLoad() throws Exception {
        this.doTestMultiReleaseClassLoad(9);
    }

    public void testMultiRelease10ClassLoad() throws Exception {
        this.doTestMultiReleaseClassLoad(10);
    }

    public void testMultiRelease11ClassLoad() throws Exception {
        this.doTestMultiReleaseClassLoad(11);
    }

    private void doTestMultiReleaseClassLoad(int rv) throws Exception {
        if (rv < 9) {
            System.setProperty("java.specification.version", "1." + rv);
        } else {
            System.setProperty("java.specification.version", Integer.toString(rv));
        }
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle(this.mrJarBundle.toURI().toString());
            mrBundle.start();
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)"BASEXX", (String)this.loadClass("multi.release.test.TestClassBase", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)"BASEXX", (String)this.loadClass("multi.release.test.TestClass8", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)CNFE, (String)this.loadClass("multi.release.test.TestClassAdd8", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 9 ? "BASE09" : "BASEXX"), (String)this.loadClass("multi.release.test.TestClass9", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 9 ? "ADD09" : CNFE), (String)this.loadClass("multi.release.test.TestClassAdd9", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 10 ? "BASE10" : "BASEXX"), (String)this.loadClass("multi.release.test.TestClass10", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 10 ? "ADD10" : CNFE), (String)this.loadClass("multi.release.test.TestClassAdd10", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 11 ? "BASE11" : "BASEXX"), (String)this.loadClass("multi.release.test.TestClass11", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 11 ? "ADD11" : CNFE), (String)this.loadClass("multi.release.test.TestClassAdd11", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)"BASEXX", (String)this.loadClass("multi.release.test.sub.TestClassBase", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)"BASEXX", (String)this.loadClass("multi.release.test.sub.TestClass8", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)CNFE, (String)this.loadClass("multi.release.test.TestClassAdd8", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 9 ? "BASE09" : "BASEXX"), (String)this.loadClass("multi.release.test.sub.TestClass9", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 9 ? "ADD09" : CNFE), (String)this.loadClass("multi.release.test.sub.TestClassAdd9", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 10 ? "BASE10" : "BASEXX"), (String)this.loadClass("multi.release.test.sub.TestClass10", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 10 ? "ADD10" : CNFE), (String)this.loadClass("multi.release.test.sub.TestClassAdd10", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 11 ? "BASE11" : "BASEXX"), (String)this.loadClass("multi.release.test.sub.TestClass11", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 11 ? "ADD11" : CNFE), (String)this.loadClass("multi.release.test.sub.TestClassAdd11", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)"BASEXX", (String)this.loadClass("multi.release.test.sub2.TestClassBase", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)"BASEXX", (String)this.loadClass("multi.release.test.sub2.TestClass8", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)CNFE, (String)this.loadClass("multi.release.test.TestClassAdd8", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 9 ? "BASE09" : "BASEXX"), (String)this.loadClass("multi.release.test.sub2.TestClass9", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 9 ? "ADD09" : CNFE), (String)this.loadClass("multi.release.test.sub2.TestClassAdd9", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 10 ? "BASE10" : "BASEXX"), (String)this.loadClass("multi.release.test.sub2.TestClass10", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 10 ? "ADD10" : CNFE), (String)this.loadClass("multi.release.test.sub2.TestClassAdd10", mrBundle, true));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 11 ? "BASE11" : "BASEXX"), (String)this.loadClass("multi.release.test.sub2.TestClass11", mrBundle, false));
            MultiReleaseJarTests.assertEquals((String)"Wrong class.", (String)(rv >= 11 ? "ADD11" : CNFE), (String)this.loadClass("multi.release.test.sub2.TestClassAdd11", mrBundle, true));
        }
        catch (Throwable throwable) {
            try {
                equinox.stop();
                equinox.waitForStop(10000L);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            equinox.stop();
            equinox.waitForStop(10000L);
        }
        catch (Exception exception) {}
    }

    private String loadClass(String name, Bundle mrBundle, boolean cnfeExpected) throws Exception {
        try {
            return mrBundle.loadClass(name).getConstructor(new Class[0]).newInstance(new Object[0]).toString();
        }
        catch (ClassNotFoundException e) {
            if (cnfeExpected) {
                return CNFE;
            }
            throw e;
        }
    }

    public void testMultiRelease8GetResource() throws Exception {
        this.doTestMultiReleaseGetResource(8);
    }

    public void testMultiRelease9GetResource() throws Exception {
        this.doTestMultiReleaseGetResource(9);
    }

    public void testMultiRelease10GetResource() throws Exception {
        this.doTestMultiReleaseGetResource(10);
    }

    public void testMultiRelease11GetResource() throws Exception {
        this.doTestMultiReleaseGetResource(11);
    }

    private void doTestMultiReleaseGetResource(int rv) throws Exception {
        if (rv < 9) {
            System.setProperty("java.specification.version", "1." + rv);
        } else {
            System.setProperty("java.specification.version", Integer.toString(rv));
        }
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle(this.mrJarBundle.toURI().toString());
            mrBundle.start();
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResource("multi/release/test/testResourceBase.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResource("multi/release/test/testResource8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)RNF, (String)this.readResource("multi/release/test/testResourceAdd8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "RESOURCE 09" : "RESOURCE XX"), (String)this.readResource("multi/release/test/testResource9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "ADD 09" : RNF), (String)this.readResource("multi/release/test/testResourceAdd9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "RESOURCE 10" : "RESOURCE XX"), (String)this.readResource("multi/release/test/testResource10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "ADD 10" : RNF), (String)this.readResource("multi/release/test/testResourceAdd10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "RESOURCE 11" : "RESOURCE XX"), (String)this.readResource("multi/release/test/testResource11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "ADD 11" : RNF), (String)this.readResource("multi/release/test/testResourceAdd11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResource("multi/release/test/sub/testResourceBase.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResource("multi/release/test/sub/testResource8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)RNF, (String)this.readResource("multi/release/test/testResourceAdd8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "RESOURCE 09" : "RESOURCE XX"), (String)this.readResource("multi/release/test/sub/testResource9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "ADD 09" : RNF), (String)this.readResource("multi/release/test/sub/testResourceAdd9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "RESOURCE 10" : "RESOURCE XX"), (String)this.readResource("multi/release/test/sub/testResource10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "ADD 10" : RNF), (String)this.readResource("multi/release/test/sub/testResourceAdd10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "RESOURCE 11" : "RESOURCE XX"), (String)this.readResource("multi/release/test/sub/testResource11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "ADD 11" : RNF), (String)this.readResource("multi/release/test/sub/testResourceAdd11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResource("multi/release/test/sub2/testResourceBase.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResource("multi/release/test/sub2/testResource8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)RNF, (String)this.readResource("multi/release/test/testResourceAdd8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "RESOURCE 09" : "RESOURCE XX"), (String)this.readResource("multi/release/test/sub2/testResource9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "ADD 09" : RNF), (String)this.readResource("multi/release/test/sub2/testResourceAdd9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "RESOURCE 10" : "RESOURCE XX"), (String)this.readResource("multi/release/test/sub2/testResource10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "ADD 10" : RNF), (String)this.readResource("multi/release/test/sub2/testResourceAdd10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "RESOURCE 11" : "RESOURCE XX"), (String)this.readResource("multi/release/test/sub2/testResource11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "ADD 11" : RNF), (String)this.readResource("multi/release/test/sub2/testResourceAdd11.txt", mrBundle));
        }
        catch (Throwable throwable) {
            try {
                equinox.stop();
                equinox.waitForStop(10000L);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            equinox.stop();
            equinox.waitForStop(10000L);
        }
        catch (Exception exception) {}
    }

    private String readResource(String name, Bundle mrBundle) throws Exception {
        BundleWiring wiring = (BundleWiring)mrBundle.adapt(BundleWiring.class);
        URL url = wiring.getClassLoader().getResource(name);
        String result = this.readURL(url);
        int lastSlash = name.lastIndexOf(47);
        Collection resourcePaths = wiring.listResources(name.substring(0, lastSlash + 1), name.substring(lastSlash + 1), 0);
        if (result == RNF) {
            if (!resourcePaths.isEmpty()) {
                MultiReleaseJarTests.fail((String)("listResources found path for '" + name + "'"));
            }
        } else {
            MultiReleaseJarTests.assertEquals((String)("Found too many resource paths for '" + name + "'"), (int)1, (int)resourcePaths.size());
            MultiReleaseJarTests.assertEquals((String)"Wrong path listed.", (String)name, (String)((String)resourcePaths.iterator().next()));
            this.assertURLCopy(result, url, mrBundle);
        }
        return result;
    }

    private void assertURLCopy(String expected, URL url, Bundle mrBundle) throws Exception {
        Class testClassBase = mrBundle.loadClass("multi.release.test.TestClassBase");
        URL copy = (URL)testClassBase.getDeclaredMethod("createURL", String.class).invoke(null, url.toExternalForm());
        String copyResult = this.readURL(copy);
        MultiReleaseJarTests.assertEquals((String)expected, (String)copyResult);
    }

    private String readURL(URL url) throws IOException {
        if (url == null) {
            return RNF;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));){
            String string = br.readLine();
            return string;
        }
    }

    public void testMultiRelease8GetResources() throws Exception {
        this.doTestMultiReleaseGetResources(8);
    }

    public void testMultiRelease9GetResources() throws Exception {
        this.doTestMultiReleaseGetResources(9);
    }

    public void testMultiRelease10GetResources() throws Exception {
        this.doTestMultiReleaseGetResources(10);
    }

    public void testMultiRelease11GetResources() throws Exception {
        this.doTestMultiReleaseGetResources(11);
    }

    private void doTestMultiReleaseGetResources(int rv) throws Exception {
        if (rv < 9) {
            System.setProperty("java.specification.version", "1." + rv);
        } else {
            System.setProperty("java.specification.version", Integer.toString(rv));
        }
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle(this.mrJarBundle.toURI().toString());
            mrBundle.start();
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResources("multi/release/test/testResourceBase.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResources("multi/release/test/testResource8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)RNF, (String)this.readResources("multi/release/test/testResourceAdd8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "RESOURCE 09" : "RESOURCE XX"), (String)this.readResources("multi/release/test/testResource9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "ADD 09" : RNF), (String)this.readResources("multi/release/test/testResourceAdd9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "RESOURCE 10" : "RESOURCE XX"), (String)this.readResources("multi/release/test/testResource10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "ADD 10" : RNF), (String)this.readResources("multi/release/test/testResourceAdd10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "RESOURCE 11" : "RESOURCE XX"), (String)this.readResources("multi/release/test/testResource11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "ADD 11" : RNF), (String)this.readResources("multi/release/test/testResourceAdd11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResources("multi/release/test/sub/testResourceBase.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResources("multi/release/test/sub/testResource8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)RNF, (String)this.readResources("multi/release/test/testResourceAdd8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "RESOURCE 09" : "RESOURCE XX"), (String)this.readResources("multi/release/test/sub/testResource9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "ADD 09" : RNF), (String)this.readResources("multi/release/test/sub/testResourceAdd9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "RESOURCE 10" : "RESOURCE XX"), (String)this.readResources("multi/release/test/sub/testResource10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "ADD 10" : RNF), (String)this.readResources("multi/release/test/sub/testResourceAdd10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "RESOURCE 11" : "RESOURCE XX"), (String)this.readResources("multi/release/test/sub/testResource11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "ADD 11" : RNF), (String)this.readResources("multi/release/test/sub/testResourceAdd11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResources("multi/release/test/sub2/testResourceBase.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)"RESOURCE XX", (String)this.readResources("multi/release/test/sub2/testResource8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)RNF, (String)this.readResources("multi/release/test/testResourceAdd8.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "RESOURCE 09" : "RESOURCE XX"), (String)this.readResources("multi/release/test/sub2/testResource9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 9 ? "ADD 09" : RNF), (String)this.readResources("multi/release/test/sub2/testResourceAdd9.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "RESOURCE 10" : "RESOURCE XX"), (String)this.readResources("multi/release/test/sub2/testResource10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 10 ? "ADD 10" : RNF), (String)this.readResources("multi/release/test/sub2/testResourceAdd10.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "RESOURCE 11" : "RESOURCE XX"), (String)this.readResources("multi/release/test/sub2/testResource11.txt", mrBundle));
            MultiReleaseJarTests.assertEquals((String)"Wrong resource.", (String)(rv >= 11 ? "ADD 11" : RNF), (String)this.readResources("multi/release/test/sub2/testResourceAdd11.txt", mrBundle));
        }
        catch (Throwable throwable) {
            try {
                equinox.stop();
                equinox.waitForStop(10000L);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            equinox.stop();
            equinox.waitForStop(10000L);
        }
        catch (Exception exception) {}
    }

    private String readResources(String name, Bundle mrBundle) throws IOException {
        BundleWiring wiring = (BundleWiring)mrBundle.adapt(BundleWiring.class);
        ArrayList<URL> urls = Collections.list(wiring.getClassLoader().getResources(name));
        if (urls.isEmpty()) {
            return RNF;
        }
        MultiReleaseJarTests.assertEquals((String)"Wrong number of resources.", (int)1, (int)urls.size());
        return this.readURL((URL)urls.get(0));
    }

    public void testMultiRelease8ListResources() throws Exception {
        this.doTestMultiReleaseListResources(8);
    }

    public void testMultiRelease9ListResources() throws Exception {
        this.doTestMultiReleaseListResources(9);
    }

    public void testMultiRelease10ListResources() throws Exception {
        this.doTestMultiReleaseListResources(10);
    }

    public void testMultiRelease11ListResources() throws Exception {
        this.doTestMultiReleaseListResources(11);
    }

    private void doTestMultiReleaseListResources(int rv) throws Exception {
        if (rv < 9) {
            System.setProperty("java.specification.version", "1." + rv);
        } else {
            System.setProperty("java.specification.version", Integer.toString(rv));
        }
        ArrayList<String> expected = new ArrayList<String>();
        ArrayList<String> expectedRecurse = new ArrayList<String>();
        expected.add("multi/release/test/testResourceBase.txt");
        expected.add("multi/release/test/testResource8.txt");
        expected.add("multi/release/test/testResource9.txt");
        expected.add("multi/release/test/testResource10.txt");
        expected.add("multi/release/test/testResource11.txt");
        if (rv >= 9) {
            expected.add("multi/release/test/testResourceAdd9.txt");
        }
        if (rv >= 10) {
            expected.add("multi/release/test/testResourceAdd10.txt");
        }
        if (rv >= 11) {
            expected.add("multi/release/test/testResourceAdd11.txt");
        }
        expectedRecurse.addAll(expected);
        expectedRecurse.add("multi/release/test/sub/testResourceBase.txt");
        expectedRecurse.add("multi/release/test/sub/testResource8.txt");
        expectedRecurse.add("multi/release/test/sub/testResource9.txt");
        expectedRecurse.add("multi/release/test/sub/testResource10.txt");
        expectedRecurse.add("multi/release/test/sub/testResource11.txt");
        expectedRecurse.add("multi/release/test/sub2/testResourceBase.txt");
        expectedRecurse.add("multi/release/test/sub2/testResource8.txt");
        expectedRecurse.add("multi/release/test/sub2/testResource9.txt");
        expectedRecurse.add("multi/release/test/sub2/testResource10.txt");
        expectedRecurse.add("multi/release/test/sub2/testResource11.txt");
        if (rv >= 9) {
            expectedRecurse.add("multi/release/test/sub/testResourceAdd9.txt");
            expectedRecurse.add("multi/release/test/sub2/testResourceAdd9.txt");
        }
        if (rv >= 10) {
            expectedRecurse.add("multi/release/test/sub/testResourceAdd10.txt");
            expectedRecurse.add("multi/release/test/sub2/testResourceAdd10.txt");
        }
        if (rv >= 11) {
            expectedRecurse.add("multi/release/test/sub/testResourceAdd11.txt");
            expectedRecurse.add("multi/release/test/sub2/testResourceAdd11.txt");
        }
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle(this.mrJarBundle.toURI().toString());
            mrBundle.start();
            this.listResources("multi/release/test", expected, mrBundle, 0);
            this.listResources("multi/release/test", expectedRecurse, mrBundle, 1);
        }
        catch (Throwable throwable) {
            try {
                equinox.stop();
                equinox.waitForStop(10000L);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            equinox.stop();
            equinox.waitForStop(10000L);
        }
        catch (Exception exception) {}
    }

    private void listResources(String path, Collection<String> expected, Bundle mrBundle, int options) {
        BundleWiring wiring = (BundleWiring)mrBundle.adapt(BundleWiring.class);
        Collection found = wiring.listResources(path, "*.txt", options);
        this.assertEquals("Wrong resource listing.", expected.toArray(), found.toArray(), false);
    }

    public void testMultiReleaseBundleManifest8() throws Exception {
        this.doTestMultiReleaseBundleManifest(8);
    }

    public void testMultiReleaseBundleManifest9() throws Exception {
        this.doTestMultiReleaseBundleManifest(9);
    }

    public void testMultiReleaseBundleManifest10() throws Exception {
        this.doTestMultiReleaseBundleManifest(10);
    }

    public void testMultiReleaseBundleManifest11() throws Exception {
        this.doTestMultiReleaseBundleManifest(11);
    }

    private void doTestMultiReleaseBundleManifest(int rv) throws Exception {
        String expectedPkg;
        String expectedCap;
        if (rv < 9) {
            System.setProperty("java.specification.version", "1." + rv);
        } else {
            System.setProperty("java.specification.version", Integer.toString(rv));
        }
        if (rv < 9) {
            expectedCap = "capbase";
            expectedPkg = "pkgbase";
        } else {
            expectedCap = "cap" + rv;
            expectedPkg = "pkg" + rv;
        }
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Equinox equinox = new Equinox(Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath()));
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle(this.mrJarBundle.toURI().toString());
            mrBundle.start();
            List capWires = ((BundleWiring)mrBundle.adapt(BundleWiring.class)).getRequiredWires(expectedCap);
            MultiReleaseJarTests.assertEquals((String)"Wrong number of capability wires.", (int)1, (int)capWires.size());
            List pkgReqs = ((BundleRevision)mrBundle.adapt(BundleRevision.class)).getDeclaredRequirements("osgi.wiring.package");
            MultiReleaseJarTests.assertEquals((String)"Wrong number of package requiremens.", (int)1, (int)pkgReqs.size());
            String filter = (String)((BundleRequirement)pkgReqs.get(0)).getDirectives().get("filter");
            MultiReleaseJarTests.assertTrue((String)("Wrong package filter: " + filter), (boolean)filter.contains(expectedPkg));
        }
        catch (Throwable throwable) {
            try {
                equinox.stop();
                equinox.waitForStop(10000L);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            equinox.stop();
            equinox.waitForStop(10000L);
        }
        catch (Exception exception) {}
    }

    public void testMultiReleaseBundleManifestChangeRuntime() throws Exception {
        String location;
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Map<String, String> configMap = Collections.singletonMap("org.osgi.framework.storage", String.valueOf(config.getAbsolutePath()) + " with space");
        Equinox equinox = new Equinox(configMap);
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle(this.mrJarBundle.toURI().toString());
            location = mrBundle.getLocation();
            mrBundle.start();
        }
        finally {
            equinox.stop();
            equinox.waitForStop(1000L);
        }
        int rv = 8;
        while (rv <= 11) {
            this.doTestMultiReleaseBundleManifestChangeRuntime(rv, configMap, location);
            ++rv;
        }
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle toUninstall = systemContext.getBundle(location);
            toUninstall.uninstall();
            Bundle mrBundle = systemContext.installBundle("reference:" + this.mrJarBundle.toURI().toString());
            location = mrBundle.getLocation();
            mrBundle.start();
        }
        finally {
            equinox.stop();
            equinox.waitForStop(1000L);
        }
        rv = 8;
        while (rv <= 11) {
            this.doTestMultiReleaseBundleManifestChangeRuntime(rv, configMap, location);
            ++rv;
        }
    }

    private void doTestMultiReleaseBundleManifestChangeRuntime(int rv, Map<String, String> configMap, String location) throws BundleException {
        String expectedPkg;
        String expectedCap;
        if (rv < 9) {
            System.setProperty("java.specification.version", "1." + rv);
        } else {
            System.setProperty("java.specification.version", Integer.toString(rv));
        }
        if (rv < 9) {
            expectedCap = "capbase";
            expectedPkg = "pkgbase";
        } else {
            expectedCap = "cap" + rv;
            expectedPkg = "pkg" + rv;
        }
        Equinox equinox = new Equinox(configMap);
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.getBundle(location);
            MultiReleaseJarTests.assertNotNull((String)("No mrBundle found: " + rv), (Object)mrBundle);
            MultiReleaseJarTests.assertEquals((String)("Wrong state of mrBundle: " + rv), (int)32, (int)mrBundle.getState());
            List capWires = ((BundleWiring)mrBundle.adapt(BundleWiring.class)).getRequiredWires(expectedCap);
            MultiReleaseJarTests.assertEquals((String)("Wrong number of capability wires: " + rv), (int)1, (int)capWires.size());
            List pkgReqs = ((BundleRevision)mrBundle.adapt(BundleRevision.class)).getDeclaredRequirements("osgi.wiring.package");
            MultiReleaseJarTests.assertEquals((String)("Wrong number of package requiremens: " + rv), (int)1, (int)pkgReqs.size());
            String filter = (String)((BundleRequirement)pkgReqs.get(0)).getDirectives().get("filter");
            MultiReleaseJarTests.assertTrue((String)("Wrong package filter: " + rv + " " + filter), (boolean)filter.contains(expectedPkg));
        }
        catch (Throwable throwable) {
            try {
                equinox.stop();
                equinox.waitForStop(10000L);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            equinox.stop();
            equinox.waitForStop(10000L);
        }
        catch (Exception exception) {}
    }

    public void testMultiReleaseBundleDeletedRestart() throws Exception {
        File copyMrJarBundle = OSGiTestsActivator.getContext().getDataFile("copy-" + this.mrJarBundle.getName());
        StorageUtil.readFile((InputStream)new FileInputStream(this.mrJarBundle), (File)copyMrJarBundle);
        System.setProperty("java.specification.version", "9");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Map<String, String> configMap = Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configMap);
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle("reference:" + copyMrJarBundle.toURI().toString());
            mrBundle.start();
        }
        finally {
            equinox.stop();
            equinox.waitForStop(1000L);
        }
        copyMrJarBundle.delete();
        System.setProperty("java.specification.version", "10");
        equinox = new Equinox(configMap);
        try {
            equinox.start();
        }
        finally {
            equinox.stop();
            equinox.waitForStop(1000L);
        }
    }

    public void testMultiReleasePreventMetaInfServiceVersions() throws Exception {
        System.setProperty("java.specification.version", "9");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Map<String, String> configMap = Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configMap);
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle("reference:" + this.mrJarBundle.toURI().toString());
            mrBundle.start();
            Class testServiceClass = mrBundle.loadClass("multi.release.test.TestService");
            ServiceLoader loader = ServiceLoader.load(testServiceClass, ((BundleWiring)mrBundle.adapt(BundleWiring.class)).getClassLoader());
            Object testService = loader.iterator().next();
            MultiReleaseJarTests.assertEquals((String)"Wrong service found.", (String)"SERVICE_BASE", (String)testService.toString());
        }
        finally {
            equinox.stop();
            equinox.waitForStop(1000L);
        }
    }

    public void testMultiReleasePreventMetaInfResourceURLs() throws Exception {
        System.setProperty("java.specification.version", "9");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Map<String, String> configMap = Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configMap);
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle("reference:" + this.mrJarBundle.toURI().toString());
            mrBundle.start();
            URL existingResource = mrBundle.getResource("multi/release/test/testResourceAdd9.txt");
            MultiReleaseJarTests.assertNotNull((String)"Did not find Java 9 added resource.", (Object)existingResource);
            URL metaInfResource = new URL(existingResource, "/META-INF/addedFor9.txt");
            try {
                metaInfResource.openStream().close();
                MultiReleaseJarTests.fail((String)"Expected error opening versioned META-INF resource.");
            }
            catch (IOException iOException) {}
        }
        finally {
            equinox.stop();
            equinox.waitForStop(1000L);
        }
    }

    public void testMultiReleasePreventMetaInfVersionListing() throws Exception {
        System.setProperty("java.specification.version", "9");
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        Map<String, String> configMap = Collections.singletonMap("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configMap);
        try {
            equinox.start();
            BundleContext systemContext = equinox.getBundleContext();
            Bundle mrBundle = systemContext.installBundle("reference:" + this.mrJarBundle.toURI().toString());
            mrBundle.start();
            Collection list = ((BundleWiring)mrBundle.adapt(BundleWiring.class)).listResources("/META-INF/", "*.txt", 0);
            MultiReleaseJarTests.assertTrue((String)("Found versioned META-INF resources: " + list), (boolean)list.isEmpty());
        }
        finally {
            equinox.stop();
            equinox.waitForStop(1000L);
        }
    }
}

