/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class PackageAdminBundleTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(PackageAdminBundleTests.class);
    }

    public void testBundleEvents01() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        Bundle[] resolveBundles = new Bundle[]{chainTestC, chainTestA, chainTestB, chainTest, chainTestD};
        Bundle[] dependencyOrder = new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD};
        TestListener testListener = new TestListener();
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testListener);
        try {
            installer.resolveBundles(resolveBundles);
            BundleEvent[] events = testListener.getEvents();
            PackageAdminBundleTests.assertEquals((String)"Event count", (int)10, (int)events.length);
            int j = 0;
            int i = dependencyOrder.length - 1;
            while (i >= 0) {
                PackageAdminBundleTests.assertTrue((String)("Resolved Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                PackageAdminBundleTests.assertEquals((String)"Expecting Resolved event", (int)32, (int)events[j].getType());
                --i;
                ++j;
            }
            j = 5;
            i = dependencyOrder.length - 1;
            while (i >= 0) {
                PackageAdminBundleTests.assertTrue((String)("Lazy Starting Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                PackageAdminBundleTests.assertEquals((String)"Expecting Lazy Starting event", (int)512, (int)events[j].getType());
                --i;
                ++j;
            }
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testListener);
        }
    }

    public void testBundleEvents02() throws Exception {
        Bundle chainTest = installer.installBundle("chain.test");
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        Bundle[] resolveBundles = new Bundle[]{chainTestC, chainTestA, chainTestB, chainTest, chainTestD};
        Bundle[] dependencyOrder = new Bundle[]{chainTest, chainTestA, chainTestB, chainTestC, chainTestD};
        TestListener testListener = new TestListener();
        OSGiTestsActivator.getContext().addBundleListener((BundleListener)testListener);
        try {
            installer.resolveBundles(resolveBundles);
            BundleEvent[] events = testListener.getEvents();
            installer.refreshPackages(resolveBundles);
            events = testListener.getEvents();
            PackageAdminBundleTests.assertEquals((String)"Event count", (int)25, (int)events.length);
            int j = 0;
            int i = 0;
            while (i < dependencyOrder.length) {
                PackageAdminBundleTests.assertTrue((String)("Stopping Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                PackageAdminBundleTests.assertEquals((String)"Expecting Stopping event", (int)256, (int)events[j].getType());
                PackageAdminBundleTests.assertTrue((String)("Stopped Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j + 1].getBundle() ? 1 : 0) != 0);
                PackageAdminBundleTests.assertEquals((String)"Expecting Stopping event", (int)4, (int)events[j + 1].getType());
                ++i;
                j += 2;
            }
            j = 10;
            i = 0;
            while (i < dependencyOrder.length) {
                PackageAdminBundleTests.assertTrue((String)("Unresolved Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                PackageAdminBundleTests.assertEquals((String)"Expecting Unresolved event", (int)64, (int)events[j].getType());
                ++i;
                ++j;
            }
            j = 15;
            i = dependencyOrder.length - 1;
            while (i >= 0) {
                PackageAdminBundleTests.assertTrue((String)("Resolved Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                PackageAdminBundleTests.assertEquals((String)"Expecting Resolved event", (int)32, (int)events[j].getType());
                --i;
                ++j;
            }
            j = 20;
            i = dependencyOrder.length - 1;
            while (i >= 0) {
                PackageAdminBundleTests.assertTrue((String)("Lazy Starting Event Bundle: " + dependencyOrder[i].getSymbolicName()), (dependencyOrder[i] == events[j].getBundle() ? 1 : 0) != 0);
                PackageAdminBundleTests.assertEquals((String)"Expecting Lazy Starting event", (int)512, (int)events[j].getType());
                --i;
                ++j;
            }
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testListener);
        }
    }

    public void testBug259903() throws Exception {
        Bundle bug259903a = installer.installBundle("test.bug259903.a");
        Bundle bug259903b = installer.installBundle("test.bug259903.b");
        Bundle bug259903c = installer.installBundle("test.bug259903.c");
        try {
            installer.resolveBundles(new Bundle[]{bug259903a, bug259903b, bug259903c});
            bug259903c.start();
            bug259903a.uninstall();
            installer.installBundle("test.bug259903.a.update");
            installer.refreshPackages(new Bundle[]{bug259903a});
            Object[] expectedEvents = new Object[]{new BundleEvent(4, bug259903c)};
            Object[] actualEvents = simpleResults.getResults(expectedEvents.length);
            PackageAdminBundleTests.compareResults(expectedEvents, actualEvents);
        }
        catch (Exception e) {
            PackageAdminBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBug287636() throws Exception {
        Bundle bug287636a = installer.installBundle("test.bug287636.a1");
        Bundle bug287636b = installer.installBundle("test.bug287636.b");
        try {
            bug287636a.start();
            bug287636b.start();
            PackageAdminBundleTests.assertTrue((String)"Bundles are not resolved", (boolean)installer.resolveBundles(new Bundle[]{bug287636a, bug287636b}));
            ExportedPackage ep = installer.getPackageAdmin().getExportedPackage("test.bug287636.a");
            PackageAdminBundleTests.assertNotNull((String)"Could not find exported package", (Object)ep);
            PackageAdminBundleTests.assertEquals("Wrong version", new Version(1, 0, 0), ep.getVersion());
            String updateLocation = installer.getBundleLocation("test.bug287636.a2");
            bug287636a.update(new URL(updateLocation).openStream());
            bug287636b.update();
            updateLocation = installer.getBundleLocation("test.bug287636.a1");
            bug287636a.update(new URL(updateLocation).openStream());
            bug287636b.update();
            updateLocation = installer.getBundleLocation("test.bug287636.a2");
            bug287636a.update(new URL(updateLocation).openStream());
            bug287636b.update();
            installer.refreshPackages(null);
            ep = installer.getPackageAdmin().getExportedPackage("test.bug287636.a");
            PackageAdminBundleTests.assertNotNull((String)"Could not find exported package", (Object)ep);
            PackageAdminBundleTests.assertEquals("Wrong version", new Version(1, 1, 0), ep.getVersion());
            ExportedPackage[] eps = installer.getPackageAdmin().getExportedPackages("test.bug287636.a");
            PackageAdminBundleTests.assertNotNull((String)"Could not find exported package", (Object)eps);
            PackageAdminBundleTests.assertEquals((String)"Wrong number of exports", (int)1, (int)eps.length);
            PackageAdminBundleTests.assertEquals("Wrong version", new Version(1, 1, 0), eps[0].getVersion());
            eps = installer.getPackageAdmin().getExportedPackages(bug287636a);
            PackageAdminBundleTests.assertNotNull((String)"Could not find exported package", (Object)eps);
            PackageAdminBundleTests.assertEquals((String)"Wrong number of exports", (int)1, (int)eps.length);
            PackageAdminBundleTests.assertEquals("Wrong version", new Version(1, 1, 0), eps[0].getVersion());
        }
        catch (Exception e) {
            PackageAdminBundleTests.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBug289719() throws Exception {
        Bundle bug259903a = installer.installBundle("test.bug259903.a");
        Bundle bug259903b = installer.installBundle("test.bug259903.b");
        Bundle bug259903c = installer.installBundle("test.bug259903.c");
        Bug289719Listener testListener = new Bug289719Listener();
        try {
            try {
                installer.resolveBundles(new Bundle[]{bug259903a, bug259903b, bug259903c});
                bug259903a.start();
                bug259903b.start();
                bug259903c.start();
                installer.getStartLevel().setBundleStartLevel(bug259903c, 2);
                installer.getStartLevel().setBundleStartLevel(bug259903b, 3);
                installer.getStartLevel().setBundleStartLevel(bug259903a, 4);
                OSGiTestsActivator.getContext().addBundleListener((BundleListener)testListener);
                BundleEvent[] expectedEvents = new BundleEvent[]{new BundleEvent(256, bug259903a), new BundleEvent(4, bug259903a), new BundleEvent(256, bug259903b), new BundleEvent(4, bug259903b), new BundleEvent(256, bug259903c), new BundleEvent(4, bug259903c), new BundleEvent(64, bug259903a), new BundleEvent(64, bug259903b), new BundleEvent(64, bug259903c), new BundleEvent(32, bug259903c), new BundleEvent(32, bug259903b), new BundleEvent(32, bug259903a), new BundleEvent(128, bug259903c), new BundleEvent(2, bug259903c), new BundleEvent(128, bug259903b), new BundleEvent(2, bug259903b), new BundleEvent(128, bug259903a), new BundleEvent(2, bug259903a)};
                testListener.setExpectedEvents(expectedEvents);
                Thread.sleep(500L);
                installer.refreshPackages(new Bundle[]{bug259903a});
                Throwable[] results = testListener.getFailures();
                if (results.length > 0) {
                    PackageAdminBundleTests.fail((String)this.getMessage(results));
                }
                expectedEvents = new BundleEvent[]{new BundleEvent(256, bug259903c), new BundleEvent(4, bug259903c), new BundleEvent(256, bug259903b), new BundleEvent(4, bug259903b), new BundleEvent(256, bug259903a), new BundleEvent(4, bug259903a), new BundleEvent(64, bug259903c), new BundleEvent(64, bug259903b), new BundleEvent(64, bug259903a), new BundleEvent(32, bug259903a), new BundleEvent(32, bug259903b), new BundleEvent(32, bug259903c), new BundleEvent(128, bug259903a), new BundleEvent(2, bug259903a), new BundleEvent(128, bug259903b), new BundleEvent(2, bug259903b), new BundleEvent(128, bug259903c), new BundleEvent(2, bug259903c)};
                testListener.setExpectedEvents(expectedEvents);
                installer.getStartLevel().setBundleStartLevel(bug259903c, 4);
                installer.getStartLevel().setBundleStartLevel(bug259903b, 4);
                installer.getStartLevel().setBundleStartLevel(bug259903a, 4);
                Thread.sleep(500L);
                installer.refreshPackages(new Bundle[]{bug259903a});
                results = testListener.getFailures();
                if (results.length > 0) {
                    PackageAdminBundleTests.fail((String)this.getMessage(results));
                }
            }
            catch (Exception e) {
                PackageAdminBundleTests.fail((String)"Unexpected exception", (Throwable)e);
                OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testListener);
            }
        }
        finally {
            OSGiTestsActivator.getContext().removeBundleListener((BundleListener)testListener);
        }
    }

    public void testBug415447() {
        PackageAdmin pa = installer.getPackageAdmin();
        Bundle[] systemBundles = pa.getBundles("system.bundle", null);
        PackageAdminBundleTests.assertNotNull((String)"No system bundles found.", (Object)systemBundles);
        PackageAdminBundleTests.assertEquals((String)"Srong number of system bundles.", (int)1, (int)systemBundles.length);
        PackageAdminBundleTests.assertEquals("Wrong system bundle found.", OSGiTestsActivator.getContext().getBundle("System Bundle"), systemBundles[0]);
    }

    public void testUninstallWhileResolving() throws BundleException {
        ServiceRegistration resolverHookReg = this.getContext().registerService(ResolverHookFactory.class, (Object)new ResolverHookFactory(){

            public ResolverHook begin(Collection<BundleRevision> triggers) {
                return new ResolverHook(){

                    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                    }

                    public void filterResolvable(Collection<BundleRevision> candidates) {
                        candidates.clear();
                    }

                    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                    }

                    public void end() {
                    }
                };
            }
        }, null);
        try {
            Bundle b1 = installer.installBundle("test.uninstall.start1");
            Bundle b2 = installer.installBundle("test.uninstall.start2");
            try {
                b1.start();
            }
            catch (BundleException bundleException) {}
            try {
                b2.start();
            }
            catch (BundleException bundleException) {}
            resolverHookReg.unregister();
            resolverHookReg = null;
            ((FrameworkWiring)this.getContext().getBundle("System Bundle").adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(b1, b2));
        }
        finally {
            if (resolverHookReg != null) {
                resolverHookReg.unregister();
            }
        }
    }

    private String getMessage(Throwable[] results) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int i = 0;
        while (i < results.length) {
            results[i].printStackTrace(pw);
            ++i;
        }
        return sw.toString();
    }

    public class Bug289719Listener
    implements SynchronousBundleListener {
        ArrayList expectedEvents = new ArrayList();
        ArrayList failures = new ArrayList();
        int i = 0;

        public synchronized void setExpectedEvents(BundleEvent[] events) {
            this.i = 0;
            this.failures.clear();
            this.expectedEvents.clear();
            this.expectedEvents.addAll(Arrays.asList(events));
        }

        public synchronized void bundleChanged(BundleEvent event) {
            BundleEvent expected = this.expectedEvents.size() == 0 ? null : (BundleEvent)this.expectedEvents.remove(0);
            try {
                try {
                    PackageAdminBundleTests.assertEquals("Compare results: " + this.i, expected, event);
                }
                catch (Throwable t) {
                    this.failures.add(t);
                    ++this.i;
                }
            }
            finally {
                ++this.i;
            }
        }

        public synchronized Throwable[] getFailures() {
            Throwable[] results = this.failures.toArray(new Throwable[this.failures.size()]);
            this.setExpectedEvents(new BundleEvent[0]);
            return results;
        }
    }

    public class TestListener
    implements SynchronousBundleListener {
        ArrayList events = new ArrayList();

        public synchronized void bundleChanged(BundleEvent event) {
            this.events.add(event);
        }

        public synchronized BundleEvent[] getEvents() {
            try {
                BundleEvent[] bundleEventArray = this.events.toArray(new BundleEvent[0]);
                return bundleEventArray;
            }
            finally {
                this.events.clear();
            }
        }
    }
}

