/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.configuration;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.harness.FileSystemComparator;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.osgi.tests.OSGiTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class MovableConfigurationAreaTest
extends OSGiTest {
    static void doMove(IPath sourcePath, IPath destinationPath) {
        MovableConfigurationAreaTest.assertTrue((String)("Failed moving " + sourcePath + " to " + destinationPath), (boolean)sourcePath.toFile().renameTo(destinationPath.toFile()));
    }

    static void doTakeSnapshot(IPath destinationPath) {
        File configurationDir = destinationPath.toFile();
        FileSystemComparator comparator = new FileSystemComparator();
        Object snapshot = comparator.takeSnapshot(configurationDir, true);
        try {
            comparator.saveSnapshot(snapshot, configurationDir);
        }
        catch (IOException iOException) {
            MovableConfigurationAreaTest.fail((String)"1.0");
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MovableConfigurationAreaTest.class.getName());
        ConfigurationSessionTestSuite initialization = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", MovableConfigurationAreaTest.class.getName());
        String[] ids = ConfigurationSessionTestSuite.MINIMAL_BUNDLE_SET;
        int i = 0;
        while (i < ids.length) {
            initialization.addBundle(ids[i]);
            ++i;
        }
        initialization.addBundle("org.eclipse.osgi.tests");
        initialization.setReadOnly(true);
        initialization.setCleanup(false);
        initialization.addTest((Test)new MovableConfigurationAreaTest("testInitialization"));
        suite.addTest((Test)initialization);
        final IPath sourcePath = initialization.getConfigurationPath();
        final IPath destinationPath = FileSystemHelper.getRandomLocation((IPath)FileSystemHelper.getTempDir());
        suite.addTest((Test)new TestCase("testMove"){

            public void runBare() throws Throwable {
                MovableConfigurationAreaTest.doMove(sourcePath, destinationPath);
            }
        });
        suite.addTest((Test)new TestCase("testTakeSnapshot"){

            public void runBare() throws Throwable {
                MovableConfigurationAreaTest.doTakeSnapshot(destinationPath);
            }
        });
        ConfigurationSessionTestSuite afterMoving = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", MovableConfigurationAreaTest.class.getName());
        afterMoving.setConfigurationPath(destinationPath);
        int i2 = 0;
        while (i2 < ids.length) {
            afterMoving.addBundle(ids[i2]);
            ++i2;
        }
        afterMoving.setReadOnly(true);
        afterMoving.setPrime(false);
        afterMoving.addTest((Test)new MovableConfigurationAreaTest("testAfterMoving"));
        afterMoving.addTest((Test)new MovableConfigurationAreaTest("testVerifySnapshot"));
        suite.addTest((Test)afterMoving);
        return suite;
    }

    public MovableConfigurationAreaTest(String name) {
        super(name);
    }

    public void testAfterMoving() throws MalformedURLException, IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((BundleContext)this.getContext(), (String)"test_files/configuration/bundle02");
                MovableConfigurationAreaTest.fail((String)"1.0");
            }
            catch (BundleException bundleException) {
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void testInitialization() throws MalformedURLException, IOException {
        try {
            Bundle installed = BundleTestingHelper.installBundle((String)"1.0", (BundleContext)this.getContext(), (String)"test_files/configuration/bundle01");
            if (!BundleTestingHelper.resolveBundles((BundleContext)this.getContext(), (Bundle[])new Bundle[]{installed})) {
                MovableConfigurationAreaTest.fail((String)"1.1");
            }
        }
        catch (BundleException be) {
            MovableConfigurationAreaTest.fail((String)"1.2", (Throwable)be);
        }
    }

    public void testVerifySnapshot() throws IOException {
        FileSystemComparator comparator = new FileSystemComparator();
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        Object oldSnaphot = comparator.loadSnapshot(configurationDir);
        Object newSnapshot = comparator.takeSnapshot(configurationDir, true);
        comparator.compareSnapshots("1.0", oldSnaphot, newSnapshot);
    }
}

