/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.tests.container.AbstractTest;
import org.eclipse.osgi.tests.container.dummys.DummyCollisionHook;
import org.eclipse.osgi.tests.container.dummys.DummyContainerAdaptor;
import org.eclipse.osgi.tests.container.dummys.DummyDebugOptions;
import org.eclipse.osgi.tests.container.dummys.DummyModuleDatabase;
import org.eclipse.osgi.tests.container.dummys.DummyResolverHook;
import org.eclipse.osgi.tests.container.dummys.DummyResolverHookFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class TestModuleContainer
extends AbstractTest {
    private static DummyModuleDatabase resolvedModuleDatabase;
    private static final String OSGI_OS = "osgi.os";
    private static final String OSGI_WS = "osgi.ws";
    private static final String OSGI_ARCH = "osgi.arch";
    List<String> HTTPCOMPS_AND_EATHER = Arrays.asList("org.apache.commons.codec_1.9.0.v20170208-1614.MF", "org.apache.commons.logging_1.1.1.v201101211721.MF", "org.apache.httpcomponents.httpclient_4.3.6.v201511171540.MF", "org.apache.httpcomponents.httpclient_4.5.2.v20170208-1614.MF", "org.apache.httpcomponents.httpclient_4.5.2.v20170210-0925.MF", "org.apache.httpcomponents.httpcore_4.3.3.v201411290715.MF", "org.apache.httpcomponents.httpcore_4.4.4.v20161115-1643.MF", "org.apache.httpcomponents.httpcore_4.4.6.v20170210-0925.MF", "org.eclipse.aether.api_1.0.1.v20141111.MF", "org.eclipse.aether.spi_1.0.1.v20141111.MF", "org.eclipse.aether.transport.http_1.0.1.v20141111.MF", "org.eclipse.aether.util_1.0.1.v20141111.MF");

    private void setupModuleDatabase() throws BundleException {
        if (resolvedModuleDatabase == null) {
            resolvedModuleDatabase = this.getDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DummyModuleDatabase getDatabase() throws BundleException {
        Bundle[] bundles;
        BundleContext context = ((BundleReference)this.getClass().getClassLoader()).getBundle().getBundleContext();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        final ModuleContainer container = adaptor.getContainer();
        Bundle systemBundle = context.getBundle(0L);
        String extraPackages = context.getProperty("org.osgi.framework.system.packages");
        String extraCapabilities = context.getProperty("org.osgi.framework.system.capabilities");
        extraCapabilities = extraCapabilities == null ? "" : String.valueOf(extraCapabilities) + ", ";
        String osName = context.getProperty(OSGI_OS);
        String wsName = context.getProperty(OSGI_WS);
        String archName = context.getProperty(OSGI_ARCH);
        extraCapabilities = String.valueOf(extraCapabilities) + "eclipse.platform; osgi.os=" + osName + "; " + OSGI_WS + "=" + wsName + "; " + OSGI_ARCH + "=" + archName;
        ModuleRevisionBuilder systembuilder = OSGiManifestBuilderFactory.createBuilder(TestModuleContainer.asMap(systemBundle.getHeaders("")), (String)"system.bundle", (String)extraPackages, (String)extraCapabilities);
        container.install(null, systemBundle.getLocation(), systembuilder, null);
        final ArrayList installErrors = new ArrayList(0);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            final Bundle bundle = bundleArray[n2];
            if (bundle.getBundleId() != 0L) {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ModuleRevisionBuilder builder = OSGiManifestBuilderFactory.createBuilder(TestModuleContainer.asMap(bundle.getHeaders("")));
                            container.install(null, bundle.getLocation(), builder, null);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            List list = installErrors;
                            synchronized (list) {
                                installErrors.add(t);
                            }
                        }
                    }
                });
            }
            ++n2;
        }
        executor.shutdown();
        try {
            executor.awaitTermination(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ArrayList e = installErrors;
        synchronized (e) {
            if (!installErrors.isEmpty()) {
                Assert.assertNull((String)"Unexpected install errors.", installErrors);
            }
        }
        container.resolve(new ArrayList(), false);
        List modules = container.getModules();
        for (Module module : modules) {
            if (module.getCurrentRevision().getWiring() != null) continue;
            System.out.println("Could not resolve module: " + module.getCurrentRevision());
        }
        return adaptor.getDatabase();
    }

    static <K, V> Map<K, V> asMap(Dictionary<K, V> dictionary) {
        HashMap<K, V> map = new HashMap<K, V>();
        Enumeration<K> eKeys = dictionary.keys();
        while (eKeys.hasMoreElements()) {
            K key = eKeys.nextElement();
            V value = dictionary.get(key);
            map.put(key, value);
        }
        return map;
    }

    @Test
    public void testModuleContainerCreate() {
        this.createDummyAdaptor();
    }

    public void testResolveInstallBundles() throws BundleException, IOException {
        this.setupModuleDatabase();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        resolvedModuleDatabase.store(new DataOutputStream(bytes), false);
        bytes.close();
        adaptor.getDatabase().load(new DataInputStream(new ByteArrayInputStream(bytes.toByteArray())));
        adaptor.getContainer().resolve(new ArrayList(), false);
    }

    public void testResolveInstallBundles01() throws BundleException, IOException {
        this.setupModuleDatabase();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        resolvedModuleDatabase.store(new DataOutputStream(bytes), false);
        bytes.close();
        adaptor.getDatabase().load(new DataInputStream(new ByteArrayInputStream(bytes.toByteArray())));
        int i = 0;
        while (i < 50) {
            adaptor.getContainer().refresh((Collection)adaptor.getContainer().getModules());
            ++i;
        }
    }

    public void testResolveAlreadyResolvedBundles() throws BundleException, IOException {
        this.setupModuleDatabase();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        resolvedModuleDatabase.store(new DataOutputStream(bytes), true);
        bytes.close();
        adaptor.getDatabase().load(new DataInputStream(new ByteArrayInputStream(bytes.toByteArray())));
        adaptor.getContainer().resolve(new ArrayList(), false);
    }

    public void testRefreshSystemBundle() throws BundleException, IOException {
        this.setupModuleDatabase();
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        resolvedModuleDatabase.store(new DataOutputStream(bytes), true);
        bytes.close();
        adaptor.getDatabase().load(new DataInputStream(new ByteArrayInputStream(bytes.toByteArray())));
        adaptor.getContainer().refresh(Arrays.asList(adaptor.getContainer().getModule(0L)));
    }

    public void testLoadPerformance() throws BundleException, IOException {
        this.setupModuleDatabase();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        resolvedModuleDatabase.store(new DataOutputStream(bytes), true);
        bytes.close();
        System.out.println("SIZE: " + bytes.size());
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 1000) {
            DummyContainerAdaptor adaptor = this.createDummyAdaptor();
            adaptor.getDatabase().load(new DataInputStream(new ByteArrayInputStream(bytes.toByteArray())));
            ++i;
        }
        System.out.println("END: " + (System.currentTimeMillis() - start));
    }

    @Test
    public void testSimpleResolve() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        ModuleRevision systemRevision = systemBundle.getCurrentRevision();
        container.resolve(Arrays.asList(systemBundle), true);
        ModuleWiring systemWiring = systemRevision.getWiring();
        Assert.assertNotNull((String)"system wiring is null", (Object)systemWiring);
        Module b1 = this.installDummyModule("b1_v1.MF", "b1", container);
        ModuleRevision b1Revision = b1.getCurrentRevision();
        container.resolve(Arrays.asList(b1), true);
        ModuleWiring b1Wiring = b1Revision.getWiring();
        Assert.assertNotNull((String)"b1 wiring is null", (Object)b1Wiring);
    }

    @Test
    public void testSimpleUnResolveable() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module c7 = this.installDummyModule("c7_v1.MF", "c7", container);
        this.installDummyModule("c6_v1.MF", "c6", container);
        ResolutionReport report = container.resolve(Arrays.asList(c7), true);
        Assert.assertNotNull((String)"Expected a resolution exception", (Object)report.getResolutionException());
        this.installDummyModule("c4_v1.MF", "c4", container);
        report = container.resolve(Arrays.asList(c7), true);
        Assert.assertNull((String)"Unexpected resoltuion exception", (Object)report.getResolutionException());
    }

    @Test
    public void testMultiHost() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        this.installDummyModule("system.bundle.MF", "System Bundle", container);
        Module h1v1 = this.installDummyModule("h1_v1.MF", "h1_v1", container);
        Module h1v2 = this.installDummyModule("h1_v2.MF", "h1_v2", container);
        Module f1v1 = this.installDummyModule("f1_v1.MF", "f1_v1", container);
        Module b3 = this.installDummyModule("b3_v1.MF", "b3_v1", container);
        ResolutionReport report = container.resolve(Arrays.asList(h1v1, h1v2, f1v1, b3), true);
        Assert.assertNull((String)"Expected no resolution exception.", (Object)report.getResolutionException());
    }

    @Test
    public void testMissingHost() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        this.installDummyModule("system.bundle.MF", "System Bundle", container);
        Module f1v1 = this.installDummyModule("f1_v1.MF", "f1_v1", container);
        Module b3 = this.installDummyModule("b3_v1.MF", "b3_v1", container);
        ResolutionReport report = container.resolve(Arrays.asList(f1v1, b3), true);
        Assert.assertNotNull((String)"Expected a resolution exception.", (Object)report.getResolutionException());
        Module h1v1 = this.installDummyModule("h1_v1.MF", "h1_v1", container);
        report = container.resolve(Arrays.asList(b3), true);
        Assert.assertNull((String)"Expected no resolution exception.", (Object)report.getResolutionException());
        ModuleWiring wiring = b3.getCurrentRevision().getWiring();
        List packageWires = wiring.getRequiredModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)"Expected 1 import.", (long)1L, (long)packageWires.size());
        ModuleWire pkgWire = (ModuleWire)packageWires.get(0);
        Assert.assertEquals((String)"Wrong host exporter.", (Object)pkgWire.getProviderWiring().getRevision(), (Object)h1v1.getCurrentRevision());
    }

    @Test
    public void testFragments01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemModule = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module h2 = this.installDummyModule("h2_v1.MF", "h2_v1", container);
        Module f2 = this.installDummyModule("f2_v1.MF", "f2_v1", container);
        container.resolve(Arrays.asList(systemModule, c1, h2, f2), true);
        ModuleWiring wiring = h2.getCurrentRevision().getWiring();
        List requiredWires = wiring.getRequiredModuleWires(null);
        Assert.assertEquals((String)"Wrong number of required wires.", (long)3L, (long)requiredWires.size());
        for (ModuleWire wire : requiredWires) {
            ModuleCapability capability = wire.getCapability();
            Assert.assertEquals((String)"Wrong namespace.", (Object)"osgi.wiring.package", (Object)capability.getNamespace());
            Assert.assertEquals((String)"Wrong requirer.", (Object)h2.getCurrentRevision(), (Object)wire.getRequirer());
            String pkgName = (String)capability.getAttributes().get("osgi.wiring.package");
            Assert.assertNotNull((String)"No package name.", (Object)pkgName);
            ModuleRevision expectedReqRevision = pkgName.equals("org.osgi.framework") ? h2.getCurrentRevision() : f2.getCurrentRevision();
            Assert.assertEquals((String)"Wrong requirement revision.", (Object)expectedReqRevision, (Object)wire.getRequirement().getRevision());
        }
    }

    @Test
    public void testFragments02() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemModule = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module h2 = this.installDummyModule("h2_v1.MF", "h2_v1", container);
        container.resolve(Arrays.asList(systemModule, c1, h2), true);
        ModuleWiring h2wiring = h2.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"Wiring is null.", (Object)h2wiring);
        Module f2 = this.installDummyModule("f2_v1.MF", "f2_v1", container);
        Assert.assertEquals((String)"Wrong state.", (Object)Module.State.INSTALLED, (Object)f2.getState());
        container.resolve(Arrays.asList(f2), false);
        Assert.assertNull((String)"Expected to not be able to resolve f2.", (Object)f2.getCurrentRevision().getWiring());
    }

    @Test
    public void testExecutionEnvironment() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        String extraCapabilities = "osgi.ee; osgi.ee=JavaSE; version:List<Version>=\"1.3, 1.4, 1.5, 1.6, 1.7\"";
        this.installDummyModule("system.bundle.MF", "System Bundle", null, null, extraCapabilities, container);
        container.resolve(null, false);
        Module ee1 = this.installDummyModule("ee1_v1.MF", "ee1", container);
        Module ee2 = this.installDummyModule("ee2_v1.MF", "ee2", container);
        Module ee3 = this.installDummyModule("ee3_v1.MF", "ee3", container);
        container.resolve(Arrays.asList(ee1, ee2), true);
        container.resolve(Arrays.asList(ee3), false);
        ModuleWiring ee1Wiring = ee1.getCurrentRevision().getWiring();
        ModuleWiring ee2Wiring = ee2.getCurrentRevision().getWiring();
        ModuleWiring ee3Wiring = ee3.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"ee1 is not resolved", (Object)ee1Wiring);
        Assert.assertNotNull((String)"ee2 is not resolved", (Object)ee2Wiring);
        Assert.assertNull((String)"ee3 is resolved", (Object)ee3Wiring);
        List ee1Requirements = ee1Wiring.getModuleRequirements("osgi.ee");
        Assert.assertEquals((String)"Wrong number of requirements", (long)1L, (long)ee1Requirements.size());
        List ee1Wires = ee1Wiring.getRequiredModuleWires("osgi.ee");
        Assert.assertEquals((String)"Wrong number of wires", (long)1L, (long)ee1Wires.size());
        List ee2Requirements = ee2Wiring.getModuleRequirements("osgi.ee");
        Assert.assertEquals((String)"Wrong number of requirements", (long)1L, (long)ee2Requirements.size());
        List ee2Wires = ee2Wiring.getRequiredModuleWires("osgi.ee");
        Assert.assertEquals((String)"Wrong number of wires", (long)1L, (long)ee2Wires.size());
    }

    @Test
    public void testPlatformFilter01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        String extraCapabilities = "eclipse.platform; osgi.os=foo; osgi.arch=bar";
        this.installDummyModule("system.bundle.MF", "System Bundle", null, null, extraCapabilities, container);
        container.resolve(null, false);
        Module platformFilter1 = this.installDummyModule("platformFilter1_v1.MF", "ee1", container);
        container.resolve(Arrays.asList(platformFilter1), true);
        ModuleWiring platformFilter1Wiring = platformFilter1.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"platformFilter1 is not resolved", (Object)platformFilter1Wiring);
    }

    @Test
    public void testPlatformFilter02() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        String extraCapabilities = "eclipse.platform; osgi.os=baz; osgi.arch=boz";
        this.installDummyModule("system.bundle.MF", "System Bundle", null, null, extraCapabilities, container);
        container.resolve(null, false);
        Module platformFilter1 = this.installDummyModule("platformFilter1_v1.MF", "ee1", container);
        container.resolve(Arrays.asList(platformFilter1), false);
        ModuleWiring platformFilter1Wiring = platformFilter1.getCurrentRevision().getWiring();
        Assert.assertNull((String)"platformFilter1 is resolved", (Object)platformFilter1Wiring);
    }

    @Test
    public void testInstallCollision01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        this.installDummyModule("system.bundle.MF", "System Bundle", container);
        this.installDummyModule("b1_v1.MF", "b1_a", container);
        try {
            this.installDummyModule("b1_v1.MF", "b1_b", container);
            Assert.fail((String)"Expected to fail installation because of a collision.");
        }
        catch (BundleException e) {
            Assert.assertEquals((String)"Wrong exception type.", (long)9L, (long)e.getType());
        }
    }

    @Test
    public void testInstallCollision02() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = new DummyContainerAdaptor(new DummyCollisionHook(true), Collections.emptyMap());
        ModuleContainer container = adaptor.getContainer();
        this.installDummyModule("system.bundle.MF", "System Bundle", container);
        this.installDummyModule("b1_v1.MF", "b1_a", container);
        this.installDummyModule("b1_v1.MF", "b1_b", container);
    }

    @Test
    public void testUpdateCollision01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module b1_v1 = this.installDummyModule("b1_v1.MF", "b1_v1", container);
        this.installDummyModule("b1_v2.MF", "b1_v2", container);
        try {
            container.update(b1_v1, OSGiManifestBuilderFactory.createBuilder(this.getManifest("b1_v2.MF")), null);
            Assert.fail((String)"Expected to fail update because of a collision.");
        }
        catch (BundleException e) {
            Assert.assertEquals((String)"Wrong exception type.", (long)9L, (long)e.getType());
        }
    }

    @Test
    public void testUpdateCollision02() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module b1_v1 = this.installDummyModule("b1_v1.MF", "b1_v1", container);
        try {
            container.update(b1_v1, OSGiManifestBuilderFactory.createBuilder(this.getManifest("b1_v1.MF")), null);
        }
        catch (BundleException e) {
            Assert.assertNull((String)"Expected to succeed update to same revision.", (Object)((Object)e));
        }
    }

    @Test
    public void testUpdateCollision03() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = new DummyContainerAdaptor(new DummyCollisionHook(true), Collections.emptyMap());
        ModuleContainer container = adaptor.getContainer();
        Module b1_v1 = this.installDummyModule("b1_v1.MF", "b1_v1", container);
        this.installDummyModule("b1_v2.MF", "b1_v2", container);
        try {
            container.update(b1_v1, OSGiManifestBuilderFactory.createBuilder(this.getManifest("b1_v2.MF")), null);
        }
        catch (BundleException e) {
            Assert.assertNull((String)"Expected to succeed update to same revision.", (Object)((Object)e));
        }
    }

    @Test
    public void testSingleton01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module s1 = this.installDummyModule("singleton1_v1.MF", "s1_v1", container);
        Module s2 = this.installDummyModule("singleton1_v2.MF", "s1_v2", container);
        Module s3 = this.installDummyModule("singleton1_v3.MF", "s1_v3", container);
        container.resolve(null, false);
        Assert.assertFalse((String)"Singleton v1 is resolved.", (boolean)Module.RESOLVED_SET.contains(s1.getState()));
        Assert.assertFalse((String)"Singleton v2 is resolved.", (boolean)Module.RESOLVED_SET.contains(s2.getState()));
        Assert.assertTrue((String)"Singleton v3 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s3.getState()));
    }

    @Test
    public void testSingleton02() throws BundleException, IOException {
        ResolverHookFactory resolverHookFactory = new ResolverHookFactory(){

            public ResolverHook begin(Collection<BundleRevision> triggers) {
                return new ResolverHook(){

                    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                        collisionCandidates.clear();
                    }

                    public void filterResolvable(Collection<BundleRevision> candidates) {
                    }

                    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                    }

                    public void end() {
                    }
                };
            }
        };
        DummyContainerAdaptor adaptor = new DummyContainerAdaptor(new DummyCollisionHook(false), Collections.emptyMap(), resolverHookFactory);
        ModuleContainer container = adaptor.getContainer();
        Module s1 = this.installDummyModule("singleton1_v1.MF", "s1_v1", container);
        Module s2 = this.installDummyModule("singleton1_v2.MF", "s1_v2", container);
        Module s3 = this.installDummyModule("singleton1_v3.MF", "s1_v3", container);
        container.resolve(null, false);
        Assert.assertTrue((String)"Singleton v1 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s1.getState()));
        Assert.assertTrue((String)"Singleton v2 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s2.getState()));
        Assert.assertTrue((String)"Singleton v3 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s3.getState()));
    }

    @Test
    public void testSingleton03() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module s1 = this.installDummyModule("singleton1_v1.MF", "s1_v1", container);
        container.resolve(null, false);
        Assert.assertTrue((String)"Singleton v1 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s1.getState()));
        Module s2 = this.installDummyModule("singleton1_v2.MF", "s1_v2", container);
        Module s3 = this.installDummyModule("singleton1_v3.MF", "s1_v3", container);
        container.resolve(Arrays.asList(s2, s3), false);
        Assert.assertTrue((String)"Singleton v1 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s1.getState()));
        Assert.assertFalse((String)"Singleton v2 is resolved.", (boolean)Module.RESOLVED_SET.contains(s2.getState()));
        Assert.assertFalse((String)"Singleton v3 is resolved.", (boolean)Module.RESOLVED_SET.contains(s3.getState()));
    }

    @Test
    public void testSingleton04() throws BundleException, IOException {
        final ArrayList<ModuleRevision> disabled = new ArrayList<ModuleRevision>();
        ResolverHookFactory resolverHookFactory = new ResolverHookFactory(){

            public ResolverHook begin(Collection<BundleRevision> triggers) {
                return new ResolverHook(){

                    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                    }

                    public void filterResolvable(Collection<BundleRevision> candidates) {
                        candidates.removeAll(disabled);
                    }

                    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                    }

                    public void end() {
                    }
                };
            }
        };
        DummyContainerAdaptor adaptor = new DummyContainerAdaptor(new DummyCollisionHook(false), Collections.emptyMap(), resolverHookFactory);
        ModuleContainer container = adaptor.getContainer();
        Module s1_v1 = this.installDummyModule("singleton1_v1.MF", "s1_v1", container);
        Module s1_v2 = this.installDummyModule("singleton1_v2.MF", "s1_v2", container);
        Module s1_v3 = this.installDummyModule("singleton1_v3.MF", "s1_v3", container);
        Module s2_v1 = this.installDummyModule("singleton2_v1.MF", "s1_v1", container);
        Module s2_v2 = this.installDummyModule("singleton2_v2.MF", "s1_v2", container);
        Module s2_v3 = this.installDummyModule("singleton2_v3.MF", "s1_v3", container);
        container.resolve(null, false);
        Assert.assertFalse((String)"Singleton v1 is resolved.", (boolean)Module.RESOLVED_SET.contains(s1_v1.getState()));
        Assert.assertFalse((String)"Singleton v2 is resolved.", (boolean)Module.RESOLVED_SET.contains(s1_v2.getState()));
        Assert.assertTrue((String)"Singleton v3 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s1_v3.getState()));
        Assert.assertFalse((String)"client v1 is resolved.", (boolean)Module.RESOLVED_SET.contains(s2_v1.getState()));
        Assert.assertFalse((String)"client v2 is resolved.", (boolean)Module.RESOLVED_SET.contains(s2_v2.getState()));
        Assert.assertTrue((String)"client v3 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s2_v3.getState()));
        disabled.add(s1_v3.getCurrentRevision());
        container.refresh(Arrays.asList(s1_v3));
        Assert.assertFalse((String)"Singleton v1 is resolved.", (boolean)Module.RESOLVED_SET.contains(s1_v1.getState()));
        Assert.assertTrue((String)"Singleton v2 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s1_v2.getState()));
        Assert.assertFalse((String)"Singleton v3 is resolved.", (boolean)Module.RESOLVED_SET.contains(s1_v3.getState()));
        Assert.assertFalse((String)"client v1 is resolved.", (boolean)Module.RESOLVED_SET.contains(s2_v1.getState()));
        Assert.assertTrue((String)"client v2 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s2_v2.getState()));
        Assert.assertFalse((String)"client v3 is resolved.", (boolean)Module.RESOLVED_SET.contains(s2_v3.getState()));
        disabled.add(s1_v2.getCurrentRevision());
        container.refresh(Arrays.asList(s1_v2));
        Assert.assertTrue((String)"Singleton v1 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s1_v1.getState()));
        Assert.assertFalse((String)"Singleton v2 is resolved.", (boolean)Module.RESOLVED_SET.contains(s1_v2.getState()));
        Assert.assertFalse((String)"Singleton v3 is resolved.", (boolean)Module.RESOLVED_SET.contains(s1_v3.getState()));
        Assert.assertTrue((String)"client v1 is not resolved.", (boolean)Module.RESOLVED_SET.contains(s2_v1.getState()));
        Assert.assertFalse((String)"client v2 is resolved.", (boolean)Module.RESOLVED_SET.contains(s2_v2.getState()));
        Assert.assertFalse((String)"client v3 is resolved.", (boolean)Module.RESOLVED_SET.contains(s2_v3.getState()));
    }

    @Test
    public void testEventsInstall() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module c2 = this.installDummyModule("c2_v1.MF", "c2_v1", container);
        Module c3 = this.installDummyModule("c3_v1.MF", "c3_v1", container);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module c5 = this.installDummyModule("c5_v1.MF", "c5_v1", container);
        Module c6 = this.installDummyModule("c6_v1.MF", "c6_v1", container);
        Module c7 = this.installDummyModule("c7_v1.MF", "c7_v1", container);
        List<DummyModuleDatabase.DummyModuleEvent> actual = adaptor.getDatabase().getModuleEvents();
        List<DummyModuleDatabase.DummyModuleEvent> expected = Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.INSTALLED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.INSTALLED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.INSTALLED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.INSTALLED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.INSTALLED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.INSTALLED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.INSTALLED, Module.State.INSTALLED));
        Assert.assertEquals((String)"Wrong install events.", expected, actual);
    }

    @Test
    public void testEventsResolved() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module c2 = this.installDummyModule("c2_v1.MF", "c2_v1", container);
        Module c3 = this.installDummyModule("c3_v1.MF", "c3_v1", container);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module c5 = this.installDummyModule("c5_v1.MF", "c5_v1", container);
        Module c6 = this.installDummyModule("c6_v1.MF", "c6_v1", container);
        Module c7 = this.installDummyModule("c7_v1.MF", "c7_v1", container);
        database.getModuleEvents();
        container.resolve(Arrays.asList(c1, c2, c3, c4, c5, c6, c7), true);
        List<DummyModuleDatabase.DummyModuleEvent> actual = database.getModuleEvents();
        ArrayList<DummyModuleDatabase.DummyModuleEvent> expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED)));
        this.assertEvents(expected, actual, false);
    }

    @Test
    public void testEventsRefresh() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module c2 = this.installDummyModule("c2_v1.MF", "c2_v1", container);
        Module c3 = this.installDummyModule("c3_v1.MF", "c3_v1", container);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module c5 = this.installDummyModule("c5_v1.MF", "c5_v1", container);
        Module c6 = this.installDummyModule("c6_v1.MF", "c6_v1", container);
        Module c7 = this.installDummyModule("c7_v1.MF", "c7_v1", container);
        container.resolve(Arrays.asList(c1, c2, c3, c4, c5, c6, c7), true);
        database.getModuleEvents();
        container.refresh(Arrays.asList(systemBundle));
        List<DummyModuleDatabase.DummyModuleEvent> actual = database.getModuleEvents();
        ArrayList<DummyModuleDatabase.DummyModuleEvent> expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED)));
        this.assertEvents(expected, actual, false);
    }

    @Test
    public void testEventsStart() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        systemBundle.start(new Module.StartOptions[0]);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module c2 = this.installDummyModule("c2_v1.MF", "c2_v1", container);
        Module c3 = this.installDummyModule("c3_v1.MF", "c3_v1", container);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module c5 = this.installDummyModule("c5_v1.MF", "c5_v1", container);
        Module c6 = this.installDummyModule("c6_v1.MF", "c6_v1", container);
        Module c7 = this.installDummyModule("c7_v1.MF", "c7_v1", container);
        database.getModuleEvents();
        c7.start(new Module.StartOptions[0]);
        List<DummyModuleDatabase.DummyModuleEvent> actual = database.getModuleEvents();
        ArrayList<DummyModuleDatabase.DummyModuleEvent> expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE)));
        this.assertEvents(expected, actual, false);
    }

    @Test
    public void testEventsStartRefresh() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        systemBundle.start(new Module.StartOptions[0]);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module c5 = this.installDummyModule("c5_v1.MF", "c5_v1", container);
        Module c6 = this.installDummyModule("c6_v1.MF", "c6_v1", container);
        Module c7 = this.installDummyModule("c7_v1.MF", "c7_v1", container);
        c7.start(new Module.StartOptions[0]);
        database.getModuleEvents();
        container.refresh(Arrays.asList(c4));
        List<DummyModuleDatabase.DummyModuleEvent> actual = database.getModuleEvents();
        ArrayList<DummyModuleDatabase.DummyModuleEvent> expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE)));
        this.assertEvents(expected, actual, false);
    }

    @Test
    public void testRemovalPending() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module c6 = this.installDummyModule("c6_v1.MF", "c6_v1", container);
        Module c7 = this.installDummyModule("c7_v1.MF", "c7_v1", container);
        container.resolve(Arrays.asList(c7), true);
        database.getModuleEvents();
        ModuleRevision c4Revision0 = c4.getCurrentRevision();
        container.update(c4, OSGiManifestBuilderFactory.createBuilder(this.getManifest("c4_v1.MF")), null);
        container.resolve(Arrays.asList(c4), true);
        Collection removalPending = container.getRemovalPending();
        Assert.assertEquals((String)"Wrong number of removal pending", (long)1L, (long)removalPending.size());
        Assert.assertTrue((String)("Wrong module removalPending: " + removalPending), (boolean)removalPending.contains(c4Revision0));
        ModuleRevision c6Revision0 = c6.getCurrentRevision();
        container.update(c6, OSGiManifestBuilderFactory.createBuilder(this.getManifest("c6_v1.MF")), null);
        container.resolve(Arrays.asList(c6), true);
        removalPending = container.getRemovalPending();
        Assert.assertEquals((String)"Wrong number of removal pending", (long)2L, (long)removalPending.size());
        Assert.assertTrue((String)("Wrong module removalPending: " + removalPending), (boolean)removalPending.containsAll(Arrays.asList(c4Revision0, c6Revision0)));
        container.update(c4, OSGiManifestBuilderFactory.createBuilder(this.getManifest("c4_v1.MF")), null);
        container.update(c6, OSGiManifestBuilderFactory.createBuilder(this.getManifest("c6_v1.MF")), null);
        container.resolve(Arrays.asList(c4, c6), true);
        removalPending = container.getRemovalPending();
        Assert.assertEquals((String)"Wrong number of removal pending", (long)2L, (long)removalPending.size());
        Assert.assertTrue((String)("Wrong module removalPending: " + removalPending), (boolean)removalPending.containsAll(Arrays.asList(c4Revision0, c6Revision0)));
        container.refresh(null);
        removalPending = container.getRemovalPending();
        Assert.assertEquals((String)"Wrong number of removal pending", (long)0L, (long)removalPending.size());
        List<DummyModuleDatabase.DummyModuleEvent> actual = database.getModuleEvents();
        ArrayList<DummyModuleDatabase.DummyModuleEvent> expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UPDATED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.UPDATED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UPDATED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.UPDATED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED)));
        this.assertEvents(expected, actual, false);
        c4Revision0 = c4.getCurrentRevision();
        container.uninstall(c4);
        removalPending = container.getRemovalPending();
        Assert.assertEquals((String)"Wrong number of removal pending", (long)1L, (long)removalPending.size());
        Assert.assertTrue((String)("Wrong module removalPending: " + removalPending), (boolean)removalPending.containsAll(Arrays.asList(c4Revision0)));
        container.refresh(null);
        actual = database.getModuleEvents();
        expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UNINSTALLED, Module.State.UNINSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED)));
        this.assertEvents(expected, actual, false);
        c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        container.resolve(Arrays.asList(c6), true);
        database.getModuleEvents();
        removalPending = container.getRemovalPending();
        Assert.assertEquals((String)"Wrong number of removal pending", (long)0L, (long)removalPending.size());
        c4Revision0 = c4.getCurrentRevision();
        container.uninstall(c4);
        removalPending = container.getRemovalPending();
        Assert.assertEquals((String)"Wrong number of removal pending", (long)1L, (long)removalPending.size());
        Assert.assertTrue((String)("Wrong module removalPending: " + removalPending), (boolean)removalPending.containsAll(Arrays.asList(c4Revision0)));
        container.refresh(Collections.singletonList(c6));
        actual = database.getModuleEvents();
        expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.UNINSTALLED, Module.State.UNINSTALLED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED)));
        this.assertEvents(expected, actual, false);
        removalPending = container.getRemovalPending();
        Assert.assertEquals((String)"Wrong number of removal pending", (long)0L, (long)removalPending.size());
    }

    @Test
    public void testSubstitutableExports01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module sub1 = this.installDummyModule("sub1_v1.MF", "sub1", container);
        Module sub2 = this.installDummyModule("sub2_v1.MF", "sub2", container);
        ModuleRevision sub1Revision0 = sub1.getCurrentRevision();
        container.resolve(Arrays.asList(sub2), true);
        container.update(sub1, OSGiManifestBuilderFactory.createBuilder(this.getManifest("sub1_v2.MF")), null);
        container.resolve(Arrays.asList(sub1), true);
        ModuleWiring sub1Wiring = sub1.getCurrentRevision().getWiring();
        List exportedPackages = sub1Wiring.getCapabilities("osgi.wiring.package");
        Assert.assertEquals((String)("Wrong number of exported packages: " + exportedPackages), (long)0L, (long)exportedPackages.size());
        List requiredWires = sub1Wiring.getRequiredWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imported packages: ", (long)2L, (long)requiredWires.size());
        Assert.assertEquals((String)("Wrong provider for package: " + ((BundleWire)requiredWires.get(1)).getProvider()), (Object)sub1Revision0, (Object)((BundleWire)requiredWires.get(1)).getProvider());
        container.refresh(Arrays.asList(sub1));
        sub1Wiring = sub1.getCurrentRevision().getWiring();
        exportedPackages = sub1Wiring.getCapabilities("osgi.wiring.package");
        Assert.assertEquals((String)("Wrong number of exported packages: " + exportedPackages), (long)1L, (long)exportedPackages.size());
        requiredWires = sub1Wiring.getRequiredWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imported packages: ", (long)1L, (long)requiredWires.size());
    }

    @Test
    public void testSubstitutableExports02() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module a = this.installDummyModule("sub.a.MF", "a", container);
        Module b = this.installDummyModule("sub.b.MF", "b", container);
        Module c = this.installDummyModule("sub.c.MF", "c", container);
        container.resolve(Arrays.asList(a, b, c), true);
        ModuleWiring wiringA = a.getCurrentRevision().getWiring();
        ModuleWiring wiringB = b.getCurrentRevision().getWiring();
        ModuleWiring wiringC = c.getCurrentRevision().getWiring();
        List providedWiresA = wiringA.getProvidedModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of provided wires.", (long)2L, (long)providedWiresA.size());
        ArrayList<ModuleRevision> requirers = new ArrayList<ModuleRevision>();
        for (ModuleWire wire : providedWiresA) {
            requirers.add(wire.getRequirer());
        }
        Assert.assertTrue((String)"b does not require.", (boolean)requirers.contains(b.getCurrentRevision()));
        Assert.assertTrue((String)"c does not require.", (boolean)requirers.contains(c.getCurrentRevision()));
        List requiredWiresB = wiringB.getRequiredModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of required wires.", (long)1L, (long)requiredWiresB.size());
        Assert.assertEquals((String)"Unexpected package name.", (Object)"javax.servlet", ((ModuleWire)requiredWiresB.iterator().next()).getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider.", (Object)a.getCurrentRevision(), (Object)((ModuleWire)requiredWiresB.iterator().next()).getProvider());
        List requiredWiresC = wiringC.getRequiredModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of required wires.", (long)1L, (long)requiredWiresC.size());
        Assert.assertEquals((String)"Wrong number of required wires.", (long)1L, (long)requiredWiresC.size());
        Assert.assertEquals((String)"Unexpected package name.", (Object)"javax.servlet", ((ModuleWire)requiredWiresC.iterator().next()).getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider.", (Object)a.getCurrentRevision(), (Object)((ModuleWire)requiredWiresC.iterator().next()).getProvider());
        Module d = this.installDummyModule("sub.d.MF", "d", container);
        container.resolve(Arrays.asList(d), true);
        ModuleWiring wiringD = d.getCurrentRevision().getWiring();
        List requiredWiresD = wiringD.getRequiredModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of required wires.", (long)2L, (long)requiredWiresD.size());
        Assert.assertEquals((String)"Unexpected package name.", (Object)"org.ops4j.pax.web.service", ((ModuleWire)requiredWiresD.get(0)).getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider.", (Object)c.getCurrentRevision(), (Object)((ModuleWire)requiredWiresD.get(0)).getProvider());
        Assert.assertEquals((String)"Unexpected package name.", (Object)"javax.servlet", ((ModuleWire)requiredWiresD.get(1)).getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider.", (Object)a.getCurrentRevision(), (Object)((ModuleWire)requiredWiresD.get(1)).getProvider());
    }

    @Test
    public void testSubstitutableExports03() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module g = this.installDummyModule("sub.g.MF", "g", container);
        Module f = this.installDummyModule("sub.f.MF", "f", container);
        Module e = this.installDummyModule("sub.e.MF", "e", container);
        container.resolve(Arrays.asList(g, f, e), true);
        ModuleWiring wiringE = e.getCurrentRevision().getWiring();
        ModuleWiring wiringF = f.getCurrentRevision().getWiring();
        List providedWiresE = wiringE.getProvidedModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of provided wires.", (long)3L, (long)providedWiresE.size());
        HashSet<ModuleRevision> requirers = new HashSet<ModuleRevision>();
        for (ModuleWire wire : providedWiresE) {
            requirers.add(wire.getRequirer());
        }
        Assert.assertTrue((String)"f does not require.", (boolean)requirers.remove(f.getCurrentRevision()));
        Assert.assertTrue((String)"g does not require.", (boolean)requirers.remove(g.getCurrentRevision()));
        Assert.assertTrue((String)("No requirers should be left: " + requirers), (boolean)requirers.isEmpty());
        List providedWiresF = wiringF.getProvidedModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)("Wrong number of provided wires: " + providedWiresF), (long)0L, (long)providedWiresF.size());
    }

    @Test
    public void testSubstitutableExports04() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        this.installDummyModule("sub.h.MF", "h", container);
        Module i = this.installDummyModule("sub.i.MF", "i", container);
        this.installDummyModule("sub.j.MF", "j", container);
        Module k = this.installDummyModule("sub.k.MF", "k", container);
        container.resolve(Arrays.asList(k), true);
        ModuleWiring wiringI = i.getCurrentRevision().getWiring();
        ModuleWiring wiringK = k.getCurrentRevision().getWiring();
        List requiredWiresK = wiringK.getRequiredModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)("Wrong number of required wires: " + requiredWiresK), (long)2L, (long)requiredWiresK.size());
        for (ModuleWire moduleWire : requiredWiresK) {
            Assert.assertEquals((String)("Wrong provider: " + moduleWire.getProviderWiring()), (Object)wiringI, (Object)moduleWire.getProviderWiring());
        }
    }

    @Test
    public void testLazy01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        systemBundle.start(new Module.StartOptions[0]);
        Module lazy1 = this.installDummyModule("lazy1_v1.MF", "lazy1", container);
        database.getModuleEvents();
        lazy1.start(new Module.StartOptions[]{Module.StartOptions.USE_ACTIVATION_POLICY});
        List<DummyModuleDatabase.DummyModuleEvent> actual = database.getModuleEvents();
        ArrayList<DummyModuleDatabase.DummyModuleEvent> expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION, Module.State.LAZY_STARTING)));
        this.assertEvents(expected, actual, true);
        lazy1.start(new Module.StartOptions[]{Module.StartOptions.LAZY_TRIGGER});
        actual = database.getModuleEvents();
        expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE)));
        this.assertEvents(expected, actual, true);
        container.refresh(Arrays.asList(lazy1));
        actual = database.getModuleEvents();
        expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION, Module.State.LAZY_STARTING)));
        this.assertEvents(expected, actual, true);
        container.update(lazy1, OSGiManifestBuilderFactory.createBuilder(this.getManifest("lazy1_v1.MF")), null);
        actual = database.getModuleEvents();
        expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.UPDATED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION, Module.State.LAZY_STARTING)));
        this.assertEvents(expected, actual, true);
        container.refresh(Arrays.asList(lazy1));
        actual = database.getModuleEvents();
        expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, Module.State.INSTALLED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.RESOLVED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION, Module.State.LAZY_STARTING)));
        this.assertEvents(expected, actual, true);
    }

    @Test
    public void testSettings01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        systemBundle.start(new Module.StartOptions[0]);
        container.getFrameworkStartLevel().setInitialBundleStartLevel(2);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module lazy1 = this.installDummyModule("lazy1_v1.MF", "lazy1", container);
        container.resolve(Arrays.asList(c4, lazy1), true);
        Assert.assertEquals((String)"Wrong startlevel.", (long)2L, (long)c4.getStartLevel());
        Assert.assertEquals((String)"Wrong startlevel.", (long)2L, (long)lazy1.getStartLevel());
        c4.setStartLevel(3);
        lazy1.setStartLevel(3);
        Assert.assertEquals((String)"Wrong startlevel.", (long)3L, (long)c4.getStartLevel());
        Assert.assertEquals((String)"Wrong startlevel.", (long)3L, (long)lazy1.getStartLevel());
        database.getModuleEvents();
        c4.start(new Module.StartOptions[0]);
        lazy1.start(new Module.StartOptions[]{Module.StartOptions.USE_ACTIVATION_POLICY});
        List<DummyModuleDatabase.DummyModuleEvent> actual = database.getModuleEvents();
        Assert.assertEquals((String)"Did not expect any events.", (long)0L, (long)actual.size());
        database.getContainerEvents();
        container.getFrameworkStartLevel().setStartLevel(3, new FrameworkListener[0]);
        List<DummyModuleDatabase.DummyContainerEvent> actualContainerEvents = database.getContainerEvents(1);
        ArrayList<DummyModuleDatabase.DummyContainerEvent> expectedContainerEvents = new ArrayList<DummyModuleDatabase.DummyContainerEvent>(Arrays.asList(new DummyModuleDatabase.DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent.START_LEVEL, systemBundle, null, new FrameworkListener[0])));
        Assert.assertEquals((String)"Wrong container events.", expectedContainerEvents, actualContainerEvents);
        actual = database.getModuleEvents(3);
        ArrayList<DummyModuleDatabase.DummyModuleEvent> expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION, Module.State.LAZY_STARTING), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE)));
        this.assertEvents(expected, actual, true);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        database.store(data, true);
        systemBundle.stop(new Module.StopOptions[0]);
        adaptor = this.createDummyAdaptor();
        container = adaptor.getContainer();
        database = adaptor.getDatabase();
        database.load(new DataInputStream(new ByteArrayInputStream(bytes.toByteArray())));
        systemBundle = container.getModule(0L);
        Assert.assertNotNull((String)"System bundle is null.", (Object)systemBundle);
        Assert.assertTrue((String)"System bundle should always use activation policy.", (boolean)systemBundle.isActivationPolicyUsed());
        Assert.assertTrue((String)"System bundle should always have its auto-start flag set.", (boolean)systemBundle.isPersistentlyStarted());
        c4 = container.getModule(c4.getId().longValue());
        Assert.assertNotNull((String)"c4 is null", (Object)c4);
        lazy1 = container.getModule(lazy1.getId().longValue());
        Assert.assertNotNull((String)"lazy1 is null", (Object)lazy1);
        Assert.assertFalse((String)"c4 has activation policy set.", (boolean)c4.isActivationPolicyUsed());
        Assert.assertTrue((String)"c4 is not auto started.", (boolean)c4.isPersistentlyStarted());
        Assert.assertEquals((String)"c4 has wrong start-level", (long)3L, (long)c4.getStartLevel());
        Assert.assertTrue((String)"lazy1 is using activation policy.", (boolean)lazy1.isActivationPolicyUsed());
        Assert.assertTrue((String)"lazy1 is not auto started.", (boolean)lazy1.isPersistentlyStarted());
        Assert.assertEquals((String)"lazy1 has wrong start-level", (long)3L, (long)lazy1.getStartLevel());
        systemBundle.start(new Module.StartOptions[0]);
        actualContainerEvents = database.getContainerEvents();
        expectedContainerEvents = new ArrayList<DummyModuleDatabase.DummyContainerEvent>(Arrays.asList(new DummyModuleDatabase.DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent.START_LEVEL, systemBundle, null, new FrameworkListener[0]), new DummyModuleDatabase.DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent.STARTED, systemBundle, null, new FrameworkListener[0])));
        actual = database.getModuleEvents(2);
        expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE)));
        this.assertEvents(expected, actual, true);
        container.getFrameworkStartLevel().setStartLevel(3, new FrameworkListener[0]);
        actualContainerEvents = database.getContainerEvents(1);
        expectedContainerEvents = new ArrayList<DummyModuleDatabase.DummyContainerEvent>(Arrays.asList(new DummyModuleDatabase.DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent.START_LEVEL, systemBundle, null, new FrameworkListener[0])));
        Assert.assertEquals((String)"Wrong container events.", expectedContainerEvents, actualContainerEvents);
        actual = database.getModuleEvents(3);
        expected = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(lazy1, ModuleContainerAdaptor.ModuleEvent.LAZY_ACTIVATION, Module.State.LAZY_STARTING), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE)));
        this.assertEvents(expected, actual, true);
    }

    @Test
    public void testTimestampSeeding() throws BundleException, IOException, InterruptedException {
        Assert.assertNotEquals((String)"The timestamps are the same!", (long)this.createTestContainerAndGetTimestamp(), (long)this.createTestContainerAndGetTimestamp());
    }

    private long createTestContainerAndGetTimestamp() throws BundleException, IOException, InterruptedException {
        Thread.sleep(100L);
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        systemBundle.start(new Module.StartOptions[0]);
        container.getFrameworkStartLevel().setInitialBundleStartLevel(2);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module lazy1 = this.installDummyModule("lazy1_v1.MF", "lazy1", container);
        container.resolve(Arrays.asList(c4, lazy1), true);
        Assert.assertEquals((String)"Wrong startlevel.", (long)2L, (long)c4.getStartLevel());
        Assert.assertEquals((String)"Wrong startlevel.", (long)2L, (long)lazy1.getStartLevel());
        return database.getTimestamp();
    }

    @Test
    public void testEventsStartLevelBeginningAt100() throws BundleException, IOException {
        this.doTestEventsStartLevel(100);
    }

    @Test
    public void testEventsStartLevelBeginningAt1() throws BundleException, IOException {
        this.doTestEventsStartLevel(1);
    }

    private void doTestEventsStartLevel(int beginningStartLevel) throws BundleException, IOException {
        ArrayList<DummyModuleDatabase.DummyContainerEvent> expectedContainerEvents;
        List<DummyModuleDatabase.DummyContainerEvent> actualContainerEvents;
        ArrayList<DummyModuleDatabase.DummyModuleEvent> expectedModuleEvents;
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.startlevel.beginning", String.valueOf(beginningStartLevel));
        DummyContainerAdaptor adaptor = new DummyContainerAdaptor(new DummyCollisionHook(false), configuration);
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module c2 = this.installDummyModule("c2_v1.MF", "c2_v1", container);
        Module c3 = this.installDummyModule("c3_v1.MF", "c3_v1", container);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module c5 = this.installDummyModule("c5_v1.MF", "c5_v1", container);
        Module c6 = this.installDummyModule("c6_v1.MF", "c6_v1", container);
        Module c7 = this.installDummyModule("c7_v1.MF", "c7_v1", container);
        container.resolve(Arrays.asList(c1, c2, c3, c4, c5, c6, c7), true);
        database.getModuleEvents();
        c1.setStartLevel(70);
        c2.setStartLevel(60);
        c3.setStartLevel(50);
        c4.setStartLevel(40);
        c5.setStartLevel(30);
        c6.setStartLevel(20);
        c7.setStartLevel(10);
        c1.start(new Module.StartOptions[0]);
        c2.start(new Module.StartOptions[0]);
        c3.start(new Module.StartOptions[0]);
        c4.start(new Module.StartOptions[0]);
        c5.start(new Module.StartOptions[0]);
        c6.start(new Module.StartOptions[0]);
        c7.start(new Module.StartOptions[0]);
        List<DummyModuleDatabase.DummyModuleEvent> actualModuleEvents = database.getModuleEvents();
        Assert.assertEquals((String)"Expecting no events.", (long)0L, (long)actualModuleEvents.size());
        systemBundle.start(new Module.StartOptions[0]);
        if (beginningStartLevel == 1) {
            actualModuleEvents = database.getModuleEvents(2);
            expectedModuleEvents = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE)));
            this.assertEvents(expectedModuleEvents, actualModuleEvents, true);
            actualContainerEvents = database.getContainerEvents();
            expectedContainerEvents = new ArrayList<DummyModuleDatabase.DummyContainerEvent>(Arrays.asList(new DummyModuleDatabase.DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent.STARTED, systemBundle, null, new FrameworkListener[0])));
            Assert.assertEquals((String)"Wrong container events.", expectedContainerEvents, actualContainerEvents);
            container.getFrameworkStartLevel().setStartLevel(100, new FrameworkListener[0]);
            actualModuleEvents = database.getModuleEvents(14);
            expectedModuleEvents = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE)));
            actualContainerEvents = database.getContainerEvents(1);
            expectedContainerEvents = new ArrayList<DummyModuleDatabase.DummyContainerEvent>(Arrays.asList(new DummyModuleDatabase.DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent.START_LEVEL, systemBundle, null, new FrameworkListener[0])));
            Assert.assertEquals((String)"Wrong container events.", expectedContainerEvents, actualContainerEvents);
        } else {
            actualModuleEvents = database.getModuleEvents(16);
            expectedModuleEvents = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.STARTING, Module.State.STARTING), new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE), new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STARTED, Module.State.ACTIVE)));
            this.assertEvents(expectedModuleEvents, actualModuleEvents, true);
            actualContainerEvents = database.getContainerEvents();
            expectedContainerEvents = new ArrayList<DummyModuleDatabase.DummyContainerEvent>(Arrays.asList(new DummyModuleDatabase.DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent.STARTED, systemBundle, null, new FrameworkListener[0])));
            Assert.assertEquals((String)"Wrong container events.", expectedContainerEvents, actualContainerEvents);
        }
        if (beginningStartLevel == 1) {
            container.getFrameworkStartLevel().setStartLevel(1, new FrameworkListener[0]);
            actualModuleEvents = database.getModuleEvents(14);
            expectedModuleEvents = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED)));
            this.assertEvents(expectedModuleEvents, actualModuleEvents, true);
            actualContainerEvents = database.getContainerEvents(1);
            expectedContainerEvents = new ArrayList<DummyModuleDatabase.DummyContainerEvent>(Arrays.asList(new DummyModuleDatabase.DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent.START_LEVEL, systemBundle, null, new FrameworkListener[0])));
            Assert.assertEquals((String)"Wrong container events.", expectedContainerEvents, actualContainerEvents);
        }
        systemBundle.stop(new Module.StopOptions[0]);
        if (beginningStartLevel == 1) {
            actualModuleEvents = database.getModuleEvents(2);
            expectedModuleEvents = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED)));
            this.assertEvents(expectedModuleEvents, actualModuleEvents, true);
        } else {
            actualModuleEvents = database.getModuleEvents(16);
            expectedModuleEvents = new ArrayList<DummyModuleDatabase.DummyModuleEvent>(Arrays.asList(new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c1, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c2, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c3, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c4, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c5, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c6, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STOPPING, Module.State.STOPPING), new DummyModuleDatabase.DummyModuleEvent(c7, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED), new DummyModuleDatabase.DummyModuleEvent(systemBundle, ModuleContainerAdaptor.ModuleEvent.STOPPED, Module.State.RESOLVED)));
            this.assertEvents(expectedModuleEvents, actualModuleEvents, true);
        }
        List<DummyModuleDatabase.DummyContainerEvent> actualContainerEvents2 = database.getContainerEvents();
        ArrayList<DummyModuleDatabase.DummyContainerEvent> expectedContainerEvents2 = new ArrayList<DummyModuleDatabase.DummyContainerEvent>(Arrays.asList(new DummyModuleDatabase.DummyContainerEvent(ModuleContainerAdaptor.ContainerEvent.STOPPED, systemBundle, null, new FrameworkListener[0])));
        Assert.assertEquals((String)"Wrong container events.", expectedContainerEvents2, actualContainerEvents2);
    }

    @Test
    public void testDynamicImport01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", null, null, "osgi.ee; osgi.ee=JavaSE; version:Version=\"1.5.0\"", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module dynamic1 = this.installDummyModule("dynamic1_v1.MF", "dynamic1_v1", container);
        container.resolve(Arrays.asList(c1, dynamic1), true);
        ModuleWire dynamicWire = container.resolveDynamic("org.osgi.framework", dynamic1.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"org.osgi.framework", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)systemBundle.getCurrentRevision(), (Object)dynamicWire.getProvider());
        dynamicWire = container.resolveDynamic("org.osgi.framework.wiring", dynamic1.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"org.osgi.framework.wiring", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)systemBundle.getCurrentRevision(), (Object)dynamicWire.getProvider());
        dynamicWire = container.resolveDynamic("c1.b", dynamic1.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"c1.b", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)c1.getCurrentRevision(), (Object)dynamicWire.getProvider());
    }

    @Test
    public void testDynamicImport02() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", null, null, "osgi.ee; osgi.ee=JavaSE; version:Version=\"1.5.0\"", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module dynamic1 = this.installDummyModule("dynamic1_v1.MF", "dynamic1_v1", container);
        Module dynamic1Frag = this.installDummyModule("dynamic1.frag_v1.MF", "dynamic1.frag_v1", container);
        container.resolve(Arrays.asList(c1, c4, dynamic1, dynamic1Frag), true);
        ModuleWire dynamicWire = container.resolveDynamic("c1.b", dynamic1.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"c1.b", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)c1.getCurrentRevision(), (Object)dynamicWire.getProvider());
        dynamicWire = container.resolveDynamic("c4.a", dynamic1.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"c4.a", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)c4.getCurrentRevision(), (Object)dynamicWire.getProvider());
        dynamicWire = container.resolveDynamic("c4.b", dynamic1.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"c4.b", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)c4.getCurrentRevision(), (Object)dynamicWire.getProvider());
    }

    @Test
    public void testDynamicImport03() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module dynamic3 = this.installDummyModule("dynamic2_v1.MF", "dynamic2_v1", container);
        container.resolve(Arrays.asList(systemBundle, dynamic3), true);
        ModuleWire dynamicWire = container.resolveDynamic("c1.a", dynamic3.getCurrentRevision());
        Assert.assertNull((String)"Dynamic wire found.", (Object)dynamicWire);
        Module c1v1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        database.getModuleEvents();
        dynamicWire = container.resolveDynamic("c1.a", dynamic3.getCurrentRevision());
        Assert.assertNotNull((String)"Dynamic wire not found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"c1.a", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)c1v1.getCurrentRevision(), (Object)dynamicWire.getProvider());
        ModuleWiring c1v1Wiring = c1v1.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"c1 wiring is null.", (Object)c1v1Wiring);
        Module c1v2 = this.installDummyModule("c1_v2.MF", "c1_v2", container);
        container.resolve(Arrays.asList(c1v2), true);
        database.getModuleEvents();
        dynamicWire = container.resolveDynamic("c1.b", dynamic3.getCurrentRevision());
        Assert.assertNotNull((String)"Dynamic wire not found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"c1.b", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider.", (Object)c1v1.getCurrentRevision(), (Object)dynamicWire.getProvider());
    }

    @Test
    public void testDynamicImport04() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module dynamic3 = this.installDummyModule("dynamic2_v1.MF", "dynamic2_v1", container);
        container.resolve(Arrays.asList(systemBundle, dynamic3), true);
        ModuleWire dynamicWire = container.resolveDynamic("h1.a", dynamic3.getCurrentRevision());
        Assert.assertNull((String)"Dynamic wire found.", (Object)dynamicWire);
        Module h1 = this.installDummyModule("h1_v1.MF", "h1_v1", container);
        Module f1 = this.installDummyModule("f1_v1.MF", "f1_v1", container);
        database.getModuleEvents();
        dynamicWire = container.resolveDynamic("h1.a", dynamic3.getCurrentRevision());
        Assert.assertNotNull((String)"Dynamic wire not found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"h1.a", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)h1.getCurrentRevision(), (Object)dynamicWire.getProvider());
        dynamicWire = container.resolveDynamic("f1.a", dynamic3.getCurrentRevision());
        Assert.assertNotNull((String)"Dynamic wire not found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"f1.a", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)h1.getCurrentRevision(), (Object)dynamicWire.getProvider());
        ModuleWiring h1Wiring = h1.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"h1 wiring is null.", (Object)h1Wiring);
        ModuleWiring f1Wiring = f1.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"f1 wiring is null.", (Object)f1Wiring);
    }

    @Test
    public void testDynamicImport05() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", null, null, "osgi.ee; osgi.ee=JavaSE; version:Version=\"1.5.0\"", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module c4 = this.installDummyModule("c4_v1.MF", "c4_v1", container);
        Module dynamic3 = this.installDummyModule("dynamic3_v1.MF", "dynamic3_v1", container);
        Module dynamic3Frag = this.installDummyModule("dynamic3.frag_v1.MF", "dynamic3.frag_v1", container);
        container.resolve(Arrays.asList(c1, c4, dynamic3, dynamic3Frag), true);
        ModuleWire dynamicWire = container.resolveDynamic("c4.a", dynamic3.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"c4.a", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)c4.getCurrentRevision(), (Object)dynamicWire.getProvider());
        dynamicWire = container.resolveDynamic("c4.b", dynamic3.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"c4.b", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)c4.getCurrentRevision(), (Object)dynamicWire.getProvider());
    }

    @Test
    public void testDynamicImport06() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module dynamic3 = this.installDummyModule("dynamic2_v1.MF", "dynamic2_v1", container);
        container.resolve(Arrays.asList(systemBundle, dynamic3), true);
        Module f1 = this.installDummyModule("f1_v1.MF", "f1_v1", container);
        ModuleWire dynamicWire = container.resolveDynamic("h1.a", dynamic3.getCurrentRevision());
        Assert.assertNull((String)"Dynamic wire found.", (Object)dynamicWire);
        dynamicWire = container.resolveDynamic("f1.a", dynamic3.getCurrentRevision());
        Assert.assertNull((String)"Dynamic wire found.", (Object)dynamicWire);
        Module h1 = this.installDummyModule("h1_v1.MF", "h1_v1", container);
        dynamicWire = container.resolveDynamic("h1.a", dynamic3.getCurrentRevision());
        Assert.assertNotNull((String)"Dynamic wire not found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"h1.a", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong host revision found.", (Object)h1.getCurrentRevision(), (Object)dynamicWire.getProvider());
        dynamicWire = container.resolveDynamic("f1.a", dynamic3.getCurrentRevision());
        Assert.assertNotNull((String)"Dynamic wire not found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"f1.a", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong host revision found.", (Object)h1.getCurrentRevision(), (Object)dynamicWire.getProvider());
        ModuleWiring h1Wiring = h1.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"h1 wiring is null.", (Object)h1Wiring);
        ModuleWiring f1Wiring = f1.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"f1 wiring is null.", (Object)f1Wiring);
    }

    @Test
    public void testDynamicImport07() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module dynamic3 = this.installDummyModule("dynamic2_v1.MF", "dynamic2_v1", container);
        Assert.assertNull((String)"Expected no resolution exception.", (Object)container.resolve(Arrays.asList(systemBundle, dynamic3), true).getResolutionException());
        this.installDummyModule("c6_v1.MF", "c6_v1", container);
        ModuleWire dynamicWire = container.resolveDynamic("c6", dynamic3.getCurrentRevision());
        Assert.assertNull((String)"Dynamic wire found.", (Object)dynamicWire);
    }

    @Test
    public void testDynamicImport08() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        DummyModuleDatabase database = adaptor.getDatabase();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module dynamic2 = this.installDummyModule("dynamic2_v1.MF", "dynamic2_v1", container);
        container.resolve(Arrays.asList(systemBundle, dynamic2), true);
        Module h1 = this.installDummyModule("h1_v1.MF", "h1_v1", container);
        Module f1 = this.installDummyModule("f1_v1.MF", "f1_v1", container);
        database.getModuleEvents();
        ModuleWiring h1Wiring = h1.getCurrentRevision().getWiring();
        Assert.assertNull((String)"h1 got resolved somehow.", (Object)h1Wiring);
        ModuleWire dynamicWire = container.resolveDynamic("f1.a", dynamic2.getCurrentRevision());
        Assert.assertNotNull((String)"Dynamic wire not found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"f1.a", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)h1.getCurrentRevision(), (Object)dynamicWire.getProvider());
        h1Wiring = h1.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"h1 wiring is null.", (Object)h1Wiring);
        ModuleWiring f1Wiring = f1.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"f1 wiring is null.", (Object)f1Wiring);
    }

    @Test
    public void testDynamicImportMiss01() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", null, null, "osgi.ee; osgi.ee=JavaSE; version:Version=\"1.5.0\"", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module c1 = this.installDummyModule("c1_v1.MF", "c1_v1", container);
        Module dynamic1 = this.installDummyModule("dynamic1_v1.MF", "dynamic1_v1", container);
        container.resolve(Arrays.asList(c1, dynamic1), true);
        DummyResolverHookFactory factory = (DummyResolverHookFactory)adaptor.getResolverHookFactory();
        DummyResolverHook hook = (DummyResolverHook)factory.getHook();
        hook.getResolutionReports().clear();
        ModuleWire dynamicWire = container.resolveDynamic("org.osgi.framework", dynamic1.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong package found.", (Object)"org.osgi.framework", dynamicWire.getCapability().getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong provider for the wire found.", (Object)systemBundle.getCurrentRevision(), (Object)dynamicWire.getProvider());
        Assert.assertEquals((String)"Wrong number of reports.", (long)1L, (long)hook.getResolutionReports().size());
        hook.getResolutionReports().clear();
        dynamicWire = container.resolveDynamic("does.not.exist", dynamic1.getCurrentRevision());
        Assert.assertNull((String)"Unexpected Dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong number of reports.", (long)1L, (long)hook.getResolutionReports().size());
        hook.getResolutionReports().clear();
        dynamicWire = container.resolveDynamic("does.not.exist", dynamic1.getCurrentRevision());
        Assert.assertNull((String)"Unexpected Dynamic wire found.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong number of reports.", (long)0L, (long)hook.getResolutionReports().size());
    }

    @Test
    public void testRequireBundleUses() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module b1 = this.installDummyModule("require.b1.MF", "b1", container);
        this.installDummyModule("require.b2.MF", "b2", container);
        this.installDummyModule("require.b3.MF", "b3", container);
        this.installDummyModule("require.b4.MF", "b4", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"b1 should not resolve.", (Object)Module.State.INSTALLED, (Object)b1.getState());
    }

    @Test
    public void testUses1() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module uses_a = this.installDummyModule("uses.a.MF", "a", container);
        Module uses_b = this.installDummyModule("uses.b.MF", "b", container);
        Module uses_c = this.installDummyModule("uses.c.MF", "c", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"a should resolve.", (Object)Module.State.RESOLVED, (Object)uses_a.getState());
        Assert.assertEquals((String)"b should resolve.", (Object)Module.State.RESOLVED, (Object)uses_b.getState());
        Assert.assertEquals((String)"c should not resolve.", (Object)Module.State.INSTALLED, (Object)uses_c.getState());
    }

    @Test
    public void testUses1Dynamic() throws BundleException, IOException {
        PrintStream testOut;
        DummyContainerAdaptor adaptor = this.createDummyAdaptor(new DummyDebugOptions(Collections.singletonMap("org.eclipse.osgi/resolver/report", "true")));
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module uses_a = this.installDummyModule("uses.a.MF", "a", container);
        Module uses_b = this.installDummyModule("uses.b.MF", "b", container);
        Module uses_c_dynamic = this.installDummyModule("uses.c.dynamic.MF", "c", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"a should resolve.", (Object)Module.State.RESOLVED, (Object)uses_a.getState());
        Assert.assertEquals((String)"b should resolve.", (Object)Module.State.RESOLVED, (Object)uses_b.getState());
        Assert.assertEquals((String)"c should resolve.", (Object)Module.State.RESOLVED, (Object)uses_c_dynamic.getState());
        ModuleWire dynamicWire = container.resolveDynamic("uses1", uses_c_dynamic.getCurrentRevision());
        Assert.assertNotNull((String)"No dynamic wire.", (Object)dynamicWire);
        PrintStream originalOut = Debug.out;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        Debug.out = testOut = new PrintStream(bytesOut);
        try {
            dynamicWire = container.resolveDynamic("uses2", uses_c_dynamic.getCurrentRevision());
            Assert.assertNull((String)"Dynamic wire found.", (Object)dynamicWire);
        }
        finally {
            Debug.out = originalOut;
            testOut.close();
        }
        String traceOutput = bytesOut.toString();
        Assert.assertTrue((String)("Wrong traceOutput: " + traceOutput), (boolean)traceOutput.startsWith("org.osgi.service.resolver.ResolutionException"));
    }

    @Test
    public void testUses2() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module uses_a = this.installDummyModule("uses.a.MF", "a", container);
        Module uses_b = this.installDummyModule("uses.b.MF", "b", container);
        Module uses_d = this.installDummyModule("uses.d.MF", "d", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"a should resolve.", (Object)Module.State.RESOLVED, (Object)uses_a.getState());
        Assert.assertEquals((String)"b should resolve.", (Object)Module.State.RESOLVED, (Object)uses_b.getState());
        Assert.assertEquals((String)"d should resolve.", (Object)Module.State.RESOLVED, (Object)uses_d.getState());
    }

    @Test
    public void testUses3() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module uses_a = this.installDummyModule("uses.a.MF", "a", container);
        Module uses_b = this.installDummyModule("uses.b.MF", "b", container);
        Module uses_e = this.installDummyModule("uses.e.MF", "e", container);
        Module uses_f = this.installDummyModule("uses.f.MF", "f", container);
        Module uses_g = this.installDummyModule("uses.g.MF", "g", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"a should resolve.", (Object)Module.State.RESOLVED, (Object)uses_a.getState());
        Assert.assertEquals((String)"b should resolve.", (Object)Module.State.RESOLVED, (Object)uses_b.getState());
        Assert.assertEquals((String)"e should resolve.", (Object)Module.State.RESOLVED, (Object)uses_e.getState());
        Assert.assertEquals((String)"f should resolve.", (Object)Module.State.RESOLVED, (Object)uses_f.getState());
        Assert.assertEquals((String)"g should not resolve.", (Object)Module.State.INSTALLED, (Object)uses_g.getState());
    }

    @Test
    public void testUses4() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module uses_h = this.installDummyModule("uses.h.MF", "h", container);
        Module uses_h_frag = this.installDummyModule("uses.h.frag.MF", "h.frag", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"h should resolve.", (Object)Module.State.RESOLVED, (Object)uses_h.getState());
        Assert.assertEquals((String)"h.frag should resolve.", (Object)Module.State.RESOLVED, (Object)uses_h_frag.getState());
        Module uses_i = this.installDummyModule("uses.i.MF", "i", container);
        Module uses_j = this.installDummyModule("uses.j.MF", "j", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"i should resolve.", (Object)Module.State.RESOLVED, (Object)uses_i.getState());
        Assert.assertEquals((String)"j should resolve.", (Object)Module.State.RESOLVED, (Object)uses_j.getState());
        List requiredWires = uses_j.getCurrentRevision().getWiring().getRequiredWires(null);
        Assert.assertEquals((String)"Wrong number of wires for j", (long)2L, (long)requiredWires.size());
        for (BundleWire wire : requiredWires) {
            Assert.assertEquals((String)"Wrong provider", (Object)uses_i.getCurrentRevision(), (Object)wire.getProvider());
        }
        Module uses_j_dynamic = this.installDummyModule("uses.j.dynamic.MF", "j.dynamic", container);
        container.resolve(null, false);
        ModuleWire dynamicWire = container.resolveDynamic("uses2", uses_j_dynamic.getCurrentRevision());
        Assert.assertNotNull((String)"Null dynamic wire.", (Object)dynamicWire);
        Assert.assertEquals((String)"Wrong provider", (Object)uses_i.getCurrentRevision(), (Object)dynamicWire.getProvider());
    }

    @Test
    public void testUses5Importer() throws BundleException, IOException {
        this.doTestUses5("uses.k.importer.MF");
    }

    @Test
    public void testUses5ReqCap() throws BundleException, IOException {
        this.doTestUses5("uses.k.reqCap.MF");
    }

    @Test
    public void testUses5Requirer() throws BundleException, IOException {
        this.doTestUses5("uses.k.requirer.MF");
    }

    public void doTestUses5(String kManifest) throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module uses_k = this.installDummyModule(kManifest, "k", container);
        Module uses_l = this.installDummyModule("uses.l.MF", "l", container);
        Module uses_m_conflict1 = this.installDummyModule("uses.m.conflict1.MF", "m.conflict1", container);
        Module uses_m_conflict2 = this.installDummyModule("uses.m.conflict2.MF", "m.conflict2", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"k should resolve.", (Object)Module.State.RESOLVED, (Object)uses_k.getState());
        Assert.assertEquals((String)"l should resolve.", (Object)Module.State.RESOLVED, (Object)uses_l.getState());
        Assert.assertEquals((String)"m.conflict1 should resolve.", (Object)Module.State.RESOLVED, (Object)uses_m_conflict1.getState());
        Assert.assertEquals((String)"m.conflict2 should resolve.", (Object)Module.State.RESOLVED, (Object)uses_m_conflict2.getState());
    }

    @Test
    public void testUses6FragConflicts() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module uses_n1 = this.installDummyModule("uses.n1.MF", "n1", container);
        this.installDummyModule("uses.n2.MF", "n2", container);
        Module uses_n2_frag = this.installDummyModule("uses.n2.frag.MF", "n2.frag", container);
        Module uses_n3 = this.installDummyModule("uses.n3.MF", "n3", container);
        ResolutionReport report = container.resolve(null, false);
        Assert.assertNull((String)"resolution report has a resolution exception.", (Object)report.getResolutionException());
        Assert.assertEquals((String)"n1 should resolve.", (Object)Module.State.RESOLVED, (Object)uses_n1.getState());
        Assert.assertEquals((String)"n2.frag should not resolve.", (Object)Module.State.INSTALLED, (Object)uses_n2_frag.getState());
        Assert.assertEquals((String)"n3 should resolve.", (Object)Module.State.RESOLVED, (Object)uses_n3.getState());
    }

    public void testUsesTimeout() throws BundleException {
        int coreThreads = 0;
        int maxThreads = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        int idleTimeout = 5;
        SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Resolver thread - UNIT TEST");
                t.setDaemon(true);
                return t;
            }
        };
        RejectedExecutionHandler rejectHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor exe) {
                r.run();
            }
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThreads, maxThreads, idleTimeout, TimeUnit.SECONDS, queue, threadFactory, rejectHandler);
        ScheduledThreadPoolExecutor timeoutExecutor = new ScheduledThreadPoolExecutor(1);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("equinox.resolver.batch.timeout", "5000");
        Map<String, String> debugOpts = Collections.emptyMap();
        DummyContainerAdaptor adaptor = new DummyContainerAdaptor(new DummyCollisionHook(false), configuration, new DummyResolverHookFactory(), new DummyDebugOptions(debugOpts));
        adaptor.setResolverExecutor(executor);
        adaptor.setTimeoutExecutor(timeoutExecutor);
        ModuleContainer container = adaptor.getContainer();
        int i = 1;
        while (i <= 1000) {
            for (Map<String, String> manifest : this.getUsesTimeoutManifests("test" + i)) {
                this.installDummyModule(manifest, manifest.get("Bundle-SymbolicName"), container);
            }
            ++i;
        }
        ResolutionReport report = container.resolve((Collection)container.getModules(), true);
        Assert.assertNull((String)"Found resolution errors.", (Object)report.getResolutionException());
        for (Module module : container.getModules()) {
            Assert.assertEquals((String)("Wrong state of module: " + module), (Object)Module.State.RESOLVED, (Object)module.getState());
        }
        executor.shutdown();
        timeoutExecutor.shutdown();
        System.gc();
        System.gc();
        System.gc();
    }

    private List<Map<String, String>> getUsesTimeoutManifests(String prefix) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        HashMap<String, String> x1Manifest = new HashMap<String, String>();
        x1Manifest.put("Bundle-ManifestVersion", "2");
        x1Manifest.put("Bundle-SymbolicName", String.valueOf(prefix) + ".x1");
        x1Manifest.put("Export-Package", String.valueOf(prefix) + ".a; version=1.0; uses:=" + prefix + ".b");
        x1Manifest.put("Import-Package", String.valueOf(prefix) + ".b; version=\"[1.1,1.2)\"");
        result.add(x1Manifest);
        HashMap<String, String> x2Manifest = new HashMap<String, String>();
        x2Manifest.put("Bundle-ManifestVersion", "2");
        x2Manifest.put("Bundle-SymbolicName", String.valueOf(prefix) + ".x2");
        x2Manifest.put("Export-Package", String.valueOf(prefix) + ".a; version=1.1; uses:=" + prefix + ".b");
        x2Manifest.put("Import-Package", String.valueOf(prefix) + ".b; version=\"[1.0,1.1)\"");
        result.add(x2Manifest);
        HashMap<String, String> y1Manifest = new HashMap<String, String>();
        y1Manifest.put("Bundle-ManifestVersion", "2");
        y1Manifest.put("Bundle-SymbolicName", String.valueOf(prefix) + ".y1");
        y1Manifest.put("Export-Package", String.valueOf(prefix) + ".b; version=1.0");
        result.add(y1Manifest);
        HashMap<String, String> y2Manifest = new HashMap<String, String>();
        y2Manifest.put("Bundle-ManifestVersion", "2");
        y2Manifest.put("Bundle-SymbolicName", String.valueOf(prefix) + ".y2");
        y2Manifest.put("Export-Package", String.valueOf(prefix) + ".b; version=1.1");
        result.add(y2Manifest);
        HashMap<String, String> z1Manifest = new HashMap<String, String>();
        z1Manifest.put("Bundle-ManifestVersion", "2");
        z1Manifest.put("Bundle-SymbolicName", String.valueOf(prefix) + ".z1");
        z1Manifest.put("Import-Package", String.valueOf(prefix) + ".a, " + prefix + ".b");
        result.add(z1Manifest);
        return result;
    }

    @Test
    public void testOptionalSubstituted() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module sub_n = this.installDummyModule("sub.n.MF", "n", container);
        Module sub_l = this.installDummyModule("sub.l.MF", "l", container);
        Module sub_m = this.installDummyModule("sub.m.MF", "m", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"l should resolve.", (Object)Module.State.RESOLVED, (Object)sub_l.getState());
        Assert.assertEquals((String)"m should resolve.", (Object)Module.State.RESOLVED, (Object)sub_m.getState());
        Assert.assertEquals((String)"n should resolve.", (Object)Module.State.RESOLVED, (Object)sub_n.getState());
    }

    @Test
    public void testStaticSubstituted() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module sub_n = this.installDummyModule("sub.n.static.MF", "n", container);
        Module sub_l = this.installDummyModule("sub.l.MF", "l", container);
        Module sub_m = this.installDummyModule("sub.m.MF", "m", container);
        container.resolve(null, false);
        Assert.assertEquals((String)"l should resolve.", (Object)Module.State.RESOLVED, (Object)sub_l.getState());
        Assert.assertEquals((String)"m should resolve.", (Object)Module.State.RESOLVED, (Object)sub_m.getState());
        Assert.assertEquals((String)"n should resolve.", (Object)Module.State.RESOLVED, (Object)sub_n.getState());
    }

    @Test
    public void testMultiCardinalityUses() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module p5v100 = this.installDummyModule("p5_v100.MF", "p5_v100", container);
        Module p5v101 = this.installDummyModule("p5_v101.MF", "p5_v101", container);
        Module p5v110 = this.installDummyModule("p5_v110.MF", "p5_v110", container);
        Module p5v111 = this.installDummyModule("p5_v111.MF", "p5_v111", container);
        this.installDummyModule("p6_v100.MF", "p6_v100", container);
        this.installDummyModule("p6_v110.MF", "p6_v110", container);
        this.installDummyModule("p7_v100.MF", "p7_v100", container);
        this.installDummyModule("p7_v110.MF", "p7_v110", container);
        container.resolve(null, false);
        Module c6v100 = this.installDummyModule("c6_v100.MF", "c6_v100", container);
        Module c6v110 = this.installDummyModule("c6_v110.MF", "c6_v110", container);
        Module c6v130 = this.installDummyModule("c6_v130.MF", "c6_v130", container);
        Module c6v140 = this.installDummyModule("c6_v140.MF", "c6_v140", container);
        Module c6v150 = this.installDummyModule("c6_v150.MF", "c6_v150", container);
        Module c6v170 = this.installDummyModule("c6_v170.MF", "c6_v170", container);
        container.resolve(null, false);
        List p5v100Provided = p5v100.getCurrentRevision().getWiring().getProvidedModuleWires("namespace.5");
        List p5v101Provided = p5v101.getCurrentRevision().getWiring().getProvidedModuleWires("namespace.5");
        List p5v110Provided = p5v110.getCurrentRevision().getWiring().getProvidedModuleWires("namespace.5");
        List p5v111Provided = p5v111.getCurrentRevision().getWiring().getProvidedModuleWires("namespace.5");
        ModuleWiring c6v100Wiring = c6v100.getCurrentRevision().getWiring();
        List c6v100Required = c6v100Wiring.getRequiredModuleWires("namespace.5");
        Assert.assertEquals((String)"Wrong number of capabilities", (long)2L, (long)c6v100Required.size());
        TestModuleContainer.assertWires(c6v100Required, p5v100Provided, p5v101Provided);
        ModuleWiring c6v110Wiring = c6v110.getCurrentRevision().getWiring();
        List c6v110Required = c6v110Wiring.getRequiredModuleWires("namespace.5");
        Assert.assertEquals((String)"Wrong number of capabilities", (long)2L, (long)c6v110Required.size());
        TestModuleContainer.assertWires(c6v110Required, p5v100Provided, p5v101Provided);
        ModuleWiring c6v130Wiring = c6v130.getCurrentRevision().getWiring();
        List c6v130Required = c6v130Wiring.getRequiredModuleWires("namespace.5");
        Assert.assertEquals((String)"Wrong number of capabilities", (long)2L, (long)c6v130Required.size());
        TestModuleContainer.assertWires(c6v130Required, p5v100Provided, p5v101Provided);
        ModuleWiring c6v140Wiring = c6v140.getCurrentRevision().getWiring();
        List c6v140Required = c6v140Wiring.getRequiredModuleWires("namespace.5");
        Assert.assertEquals((String)"Wrong number of capabilities", (long)2L, (long)c6v140Required.size());
        TestModuleContainer.assertWires(c6v140Required, p5v100Provided, p5v101Provided);
        ModuleWiring c6v150Wiring = c6v150.getCurrentRevision().getWiring();
        List c6v150Required = c6v150Wiring.getRequiredModuleWires("namespace.5");
        Assert.assertEquals((String)"Wrong number of capabilities", (long)2L, (long)c6v150Required.size());
        TestModuleContainer.assertWires(c6v150Required, p5v110Provided, p5v111Provided);
        ModuleWiring c6v170Wiring = c6v170.getCurrentRevision().getWiring();
        List c6v170Required = c6v170Wiring.getRequiredModuleWires("namespace.5");
        Assert.assertEquals((String)"Wrong number of capabilities", (long)2L, (long)c6v170Required.size());
        TestModuleContainer.assertWires(c6v170Required, p5v110Provided, p5v111Provided);
        Module c6v160 = this.installDummyModule("c6_v160.MF", "c6_v160", container);
        container.resolve(null, false);
        Assert.assertNull((String)("Bundle should not be resolved: " + c6v160), (Object)c6v160.getCurrentRevision().getWiring());
        container.uninstall(c6v160);
        Module c6v180 = this.installDummyModule("c6_v180.MF", "c6_v180", container);
        container.resolve(null, false);
        Assert.assertNull((String)("Bundle should not be resolved: " + c6v180), (Object)c6v180.getCurrentRevision().getWiring());
        container.uninstall(c6v180);
    }

    @Test
    public void testCompatSingleton() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module s1 = this.installDummyModule("compatSingleton1.MF", "s1", container);
        Module s2 = this.installDummyModule("compatSingleton2.MF", "s2", container);
        Module s3 = this.installDummyModule("compatSingleton3.MF", "s3", container);
        String s1Singleton = (String)((Capability)s1.getCurrentRevision().getCapabilities("osgi.identity").iterator().next()).getDirectives().get("singleton");
        String s2Singleton = (String)((Capability)s2.getCurrentRevision().getCapabilities("osgi.identity").iterator().next()).getDirectives().get("singleton");
        String s3Singleton = (String)((Capability)s3.getCurrentRevision().getCapabilities("osgi.identity").iterator().next()).getDirectives().get("singleton");
        Assert.assertEquals((String)("Wrong singleton directive: " + s1), (Object)"true", (Object)s1Singleton);
        Assert.assertNull((String)("Wrong singleton directive: " + s2), (Object)s2Singleton);
        Assert.assertEquals((String)("Wrong singleton directive: " + s3), (Object)"true", (Object)s3Singleton);
    }

    @Test
    public void testCompatReprovide() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module b1 = this.installDummyModule("compatReprovide1.MF", "b1", container);
        Module b2 = this.installDummyModule("compatReprovide2.MF", "b2", container);
        Module b3 = this.installDummyModule("compatReprovide3.MF", "b3", container);
        String b1Visibility = (String)((Requirement)b1.getCurrentRevision().getRequirements("osgi.wiring.bundle").iterator().next()).getDirectives().get("visibility");
        String b2Visibility = (String)((Requirement)b2.getCurrentRevision().getRequirements("osgi.wiring.bundle").iterator().next()).getDirectives().get("visibility");
        String b3Visibility = (String)((Requirement)b3.getCurrentRevision().getRequirements("osgi.wiring.bundle").iterator().next()).getDirectives().get("visibility");
        Assert.assertEquals((String)("Wrong visibility directive: " + b1), (Object)"reexport", (Object)b1Visibility);
        Assert.assertNull((String)"Wrong visibility directive: ", (Object)b2Visibility);
        Assert.assertEquals((String)("Wrong visibility directive: " + b2), (Object)"reexport", (Object)b3Visibility);
    }

    @Test
    public void testCompatOptional() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module b1 = this.installDummyModule("compatOptional1.MF", "b1", container);
        Module b2 = this.installDummyModule("compatOptional2.MF", "b2", container);
        Module b3 = this.installDummyModule("compatOptional3.MF", "b3", container);
        String b1BundleResolution = (String)((Requirement)b1.getCurrentRevision().getRequirements("osgi.wiring.bundle").iterator().next()).getDirectives().get("resolution");
        String b2BundleResolution = (String)((Requirement)b2.getCurrentRevision().getRequirements("osgi.wiring.bundle").iterator().next()).getDirectives().get("resolution");
        String b3BundleResolution = (String)((Requirement)b3.getCurrentRevision().getRequirements("osgi.wiring.bundle").iterator().next()).getDirectives().get("resolution");
        String b1PackageResolution = (String)((Requirement)b1.getCurrentRevision().getRequirements("osgi.wiring.package").iterator().next()).getDirectives().get("resolution");
        String b2PackageResolution = (String)((Requirement)b2.getCurrentRevision().getRequirements("osgi.wiring.package").iterator().next()).getDirectives().get("resolution");
        String b3PackageResolution = (String)((Requirement)b3.getCurrentRevision().getRequirements("osgi.wiring.package").iterator().next()).getDirectives().get("resolution");
        Assert.assertEquals((String)("Wrong resolution directive: " + b1), (Object)"optional", (Object)b1BundleResolution);
        Assert.assertNull((String)"Wrong resolution directive: ", (Object)b2BundleResolution);
        Assert.assertEquals((String)("Wrong resolution directive: " + b2), (Object)"optional", (Object)b3BundleResolution);
        Assert.assertEquals((String)("Wrong resolution directive: " + b1), (Object)"optional", (Object)b1PackageResolution);
        Assert.assertNull((String)"Wrong resolution directive: ", (Object)b2PackageResolution);
        Assert.assertEquals((String)("Wrong resolution directive: " + b2), (Object)"optional", (Object)b3PackageResolution);
    }

    @Test
    public void testCompatProvidePackage() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module b1 = this.installDummyModule("compatProvidePackage1.MF", "b1", container);
        List packageCaps = b1.getCurrentRevision().getModuleCapabilities("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of exports", (long)5L, (long)packageCaps.size());
        Assert.assertEquals((String)"Wrong package name.", (Object)"foo", ((ModuleCapability)packageCaps.get(0)).getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong package name.", (Object)"faa", ((ModuleCapability)packageCaps.get(1)).getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong package name.", (Object)"bar", ((ModuleCapability)packageCaps.get(2)).getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong package name.", (Object)"baz", ((ModuleCapability)packageCaps.get(3)).getAttributes().get("osgi.wiring.package"));
        Assert.assertEquals((String)"Wrong package name.", (Object)"biz", ((ModuleCapability)packageCaps.get(4)).getAttributes().get("osgi.wiring.package"));
    }

    @Test
    public void testBug457118() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", container);
        container.resolve(Arrays.asList(systemBundle), true);
        Module e = this.installDummyModule("bug457118.e.MF", "e", container);
        Module a = this.installDummyModule("bug457118.a.MF", "a", container);
        Module b = this.installDummyModule("bug457118.b.MF", "b", container);
        Module c = this.installDummyModule("bug457118.c.MF", "c", container);
        Module d = this.installDummyModule("bug457118.d.MF", "d", container);
        this.installDummyModule("bug457118.a2.MF", "a2", container);
        this.installDummyModule("bug457118.b2.MF", "b2", container);
        this.installDummyModule("bug457118.c2.MF", "c2", container);
        this.installDummyModule("bug457118.d2.MF", "d2", container);
        container.resolve(null, true);
        Assert.assertEquals((String)"e should resolve.", (Object)Module.State.RESOLVED, (Object)e.getState());
        Assert.assertEquals((String)"a should resolve.", (Object)Module.State.RESOLVED, (Object)a.getState());
        Assert.assertEquals((String)"b should resolve.", (Object)Module.State.RESOLVED, (Object)b.getState());
        Assert.assertEquals((String)"c should resolve.", (Object)Module.State.RESOLVED, (Object)c.getState());
        Assert.assertEquals((String)"d should resolve.", (Object)Module.State.RESOLVED, (Object)d.getState());
        List bundleWires = e.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.bundle");
        Assert.assertEquals((String)("Wrong number of bundle wires: " + bundleWires), (long)1L, (long)bundleWires.size());
        Assert.assertEquals((String)"Wrong bundle provider", (Object)a.getCurrentRevision(), (Object)((ModuleWire)bundleWires.get(0)).getProvider());
    }

    @Test
    public void testBadNativeCode() throws IOException {
        try {
            OSGiManifestBuilderFactory.createBuilder(this.getManifest("bad.native.code.MF"));
        }
        catch (BundleException e) {
            Assert.assertEquals((String)"Wrong exception type.", (long)3L, (long)e.getType());
        }
    }

    @Test
    public void testNativeWithFilterChars() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        String extraCapabilities = "osgi.native; osgi.native.osname=\"Windows NT (unknown)\"";
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, extraCapabilities, container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        HashMap<String, String> nativeCodeManifest = new HashMap<String, String>();
        nativeCodeManifest.put("Bundle-ManifestVersion", "2");
        nativeCodeManifest.put("Bundle-SymbolicName", "importer");
        nativeCodeManifest.put("Bundle-NativeCode", "/lib/mylib.dll; osname=\"win32\"; osname=\"Windows NT (unknown)\",/lib/mylib.lib; osname=\"Linux\"");
        Module nativeCodeModule = this.installDummyModule(nativeCodeManifest, "nativeCodeBundle", container);
        report = container.resolve(Arrays.asList(nativeCodeModule), true);
        Assert.assertNull((String)"Failed to resolve nativeCodeBundle.", (Object)report.getResolutionException());
    }

    @Test
    public void testUTF8LineContinuation() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        String utfString = "a.with.\ufffd.multibyte";
        while (utfString.getBytes("UTF8").length < 500) {
            Map<String, String> manifest = TestModuleContainer.getUTFManifest(utfString);
            Module testModule = this.installDummyModule(manifest, manifest.get("Bundle-SymbolicName"), container);
            Assert.assertEquals((String)"Wrong bns for the bundle.", (Object)utfString, (Object)testModule.getCurrentRevision().getSymbolicName());
            ModuleCapability exportPackage = (ModuleCapability)testModule.getCurrentRevision().getModuleCapabilities("osgi.wiring.package").get(0);
            ModuleRequirement importPackage = (ModuleRequirement)testModule.getCurrentRevision().getModuleRequirements("osgi.wiring.package").get(0);
            String actualPackageName = (String)exportPackage.getAttributes().get("osgi.wiring.package");
            Assert.assertEquals((String)"Wrong exported package name.", (Object)utfString, (Object)actualPackageName);
            Assert.assertTrue((String)("import does not match export: " + importPackage), (boolean)importPackage.matches((BundleCapability)exportPackage));
            utfString = "a" + utfString;
        }
    }

    @Test
    public void testDynamicWithOptionalImport() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        HashMap<String, String> optionalImporterManifest = new HashMap<String, String>();
        optionalImporterManifest.put("Bundle-ManifestVersion", "2");
        optionalImporterManifest.put("Bundle-SymbolicName", "importer");
        optionalImporterManifest.put("Import-Package", "exporter; resolution:=optional");
        optionalImporterManifest.put("DynamicImport-Package", "exporter");
        Module optionalImporterModule = this.installDummyModule(optionalImporterManifest, "optionalImporter", container);
        report = container.resolve(Arrays.asList(optionalImporterModule), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        List importReqsList = optionalImporterModule.getCurrentRevision().getWiring().getRequirements("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imports.", (long)1L, (long)importReqsList.size());
        Assert.assertEquals((String)"Import was not dynamic", (Object)"dynamic", ((BundleRequirement)importReqsList.get(0)).getDirectives().get("resolution"));
        HashMap<String, String> exporterManifest = new HashMap<String, String>();
        exporterManifest.put("Bundle-ManifestVersion", "2");
        exporterManifest.put("Bundle-SymbolicName", "exporter");
        exporterManifest.put("Export-Package", "exporter");
        this.installDummyModule(exporterManifest, "exporter", container);
        ModuleWire dynamicWire = container.resolveDynamic("exporter", optionalImporterModule.getCurrentRevision());
        Assert.assertNotNull((String)"Expected to find a dynamic wire.", (Object)dynamicWire);
        container.refresh(Collections.singleton(optionalImporterModule));
        report = container.resolve(Arrays.asList(optionalImporterModule), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        importReqsList = optionalImporterModule.getCurrentRevision().getWiring().getRequirements("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imports.", (long)2L, (long)importReqsList.size());
    }

    @Test
    public void testDynamicWithExport() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        HashMap<String, String> optionalImporterManifest = new HashMap<String, String>();
        optionalImporterManifest.put("Bundle-ManifestVersion", "2");
        optionalImporterManifest.put("Bundle-SymbolicName", "importer");
        optionalImporterManifest.put("Export-Package", "exporter");
        optionalImporterManifest.put("DynamicImport-Package", "exporter");
        Module optionalImporterModule = this.installDummyModule(optionalImporterManifest, "optionalImporter", container);
        report = container.resolve(Arrays.asList(optionalImporterModule), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        List importReqsList = optionalImporterModule.getCurrentRevision().getWiring().getRequirements("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imports.", (long)1L, (long)importReqsList.size());
        Assert.assertEquals((String)"Import was not dynamic", (Object)"dynamic", ((BundleRequirement)importReqsList.get(0)).getDirectives().get("resolution"));
        ModuleWire dynamicWire = container.resolveDynamic("exporter", optionalImporterModule.getCurrentRevision());
        Assert.assertNull((String)"Expected no dynamic wire.", (Object)dynamicWire);
    }

    @Test
    public void testSubstitutableExport() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        HashMap<String, String> exporterManifest = new HashMap<String, String>();
        exporterManifest.put("Bundle-ManifestVersion", "2");
        exporterManifest.put("Bundle-SymbolicName", "exporter");
        exporterManifest.put("Export-Package", "exporter");
        exporterManifest.put("Import-Package", "exporter");
        Module moduleSubsExport = this.installDummyModule(exporterManifest, "exporter", container);
        report = container.resolve(Arrays.asList(moduleSubsExport), true);
        Assert.assertNull((String)"Failed to resolve", (Object)report.getResolutionException());
        List reqs = moduleSubsExport.getCurrentRevision().getWiring().getRequirements("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imports.", (long)0L, (long)reqs.size());
        container.uninstall(moduleSubsExport);
        exporterManifest = new HashMap();
        exporterManifest.put("Bundle-ManifestVersion", "2");
        exporterManifest.put("Bundle-SymbolicName", "substitutableExporter");
        exporterManifest.put("Export-Package", "exporter");
        exporterManifest.put("Import-Package", "exporter; pickme=true");
        moduleSubsExport = this.installDummyModule(exporterManifest, "substitutableExporter", container);
        exporterManifest = new HashMap();
        exporterManifest.put("Bundle-ManifestVersion", "2");
        exporterManifest.put("Bundle-SymbolicName", "exporter");
        exporterManifest.put("Export-Package", "exporter; pickme=true");
        Module moduleExport = this.installDummyModule(exporterManifest, "exporter", container);
        report = container.resolve(Arrays.asList(moduleSubsExport), true);
        Assert.assertNull((String)"Failed to resolve", (Object)report.getResolutionException());
        List caps = moduleSubsExport.getCurrentRevision().getWiring().getCapabilities("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of capabilities.", (long)0L, (long)caps.size());
        reqs = moduleSubsExport.getCurrentRevision().getWiring().getRequirements("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imports.", (long)1L, (long)reqs.size());
        ModuleWiring wiring = moduleSubsExport.getCurrentRevision().getWiring();
        List packageWires = wiring.getRequiredModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)"Unexpected number of wires", (long)1L, (long)packageWires.size());
        Assert.assertEquals((String)"Wrong exporter", (Object)((ModuleWire)packageWires.get(0)).getProviderWiring().getRevision(), (Object)moduleExport.getCurrentRevision());
    }

    @Test
    public void testR3() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        HashMap<String, String> exporterManifest = new HashMap<String, String>();
        exporterManifest = new HashMap();
        exporterManifest.put("Bundle-SymbolicName", "exporter");
        exporterManifest.put("Export-Package", "exporter; version=\"1.1\"");
        Module moduleExport = this.installDummyModule(exporterManifest, "exporter", container);
        report = container.resolve(Arrays.asList(moduleExport, moduleExport), true);
        Assert.assertNull((String)"Failed to resolve", (Object)report.getResolutionException());
        List reqs = moduleExport.getCurrentRevision().getWiring().getRequirements("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imports.", (long)0L, (long)reqs.size());
        exporterManifest.clear();
        exporterManifest.put("Bundle-SymbolicName", "dynamicExporter");
        exporterManifest.put("Export-Package", "exporter; version=\"1.0\"");
        exporterManifest.put("DynamicImport-Package", "exporter");
        Module moduleWithDynExport = this.installDummyModule(exporterManifest, "dynamicExporter", container);
        report = container.resolve(Arrays.asList(moduleWithDynExport), true);
        Assert.assertNull((String)"Failed to resolve", (Object)report.getResolutionException());
        reqs = moduleWithDynExport.getCurrentRevision().getWiring().getRequirements("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imports.", (long)2L, (long)reqs.size());
        report = container.resolve(Arrays.asList(moduleWithDynExport), true);
        Assert.assertNull((String)"Failed to resolve", (Object)report.getResolutionException());
        reqs = moduleWithDynExport.getCurrentRevision().getWiring().getRequirements("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of imports.", (long)2L, (long)reqs.size());
        ModuleWiring wiring = moduleWithDynExport.getCurrentRevision().getWiring();
        List packageWires = wiring.getRequiredModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)"Unexpected number of wires", (long)1L, (long)packageWires.size());
        Assert.assertEquals((String)"Wrong exporter", (Object)((ModuleWire)packageWires.get(0)).getProviderWiring().getRevision(), (Object)moduleExport.getCurrentRevision());
    }

    private static Map<String, String> getUTFManifest(String packageName) throws IOException, BundleException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Manifest m = new Manifest();
        Attributes a = m.getMainAttributes();
        a.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        a.putValue("Bundle-ManifestVersion", "2");
        a.putValue("Bundle-SymbolicName", packageName);
        a.putValue("Export-Package", packageName);
        a.putValue("Import-Package", packageName);
        m.write(out);
        return ManifestElement.parseBundleManifest((InputStream)new ByteArrayInputStream(out.toByteArray()), null);
    }

    @Test
    public void testPersistence() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("string", "sValue");
        attrs.put("string.list1", Arrays.asList("v1", "v2", "v3"));
        attrs.put("string.list2", Arrays.asList("v4", "v5", "v6"));
        attrs.put("version", Version.valueOf((String)"1.1"));
        attrs.put("version.list", Arrays.asList(Version.valueOf((String)"1.0"), Version.valueOf((String)"2.0"), Version.valueOf((String)"3.0")));
        attrs.put("long", 12345L);
        attrs.put("long.list", Arrays.asList(1L, 2L, 3L));
        attrs.put("double", 1.2345);
        attrs.put("double.list", Arrays.asList(1.1, 1.2, 1.3));
        attrs.put("uri", "some.uri");
        attrs.put("set", Arrays.asList("s1", "s2", "s3"));
        HashMap<String, String> providerManifest = new HashMap<String, String>();
        providerManifest.put("Bundle-ManifestVersion", "2");
        providerManifest.put("Bundle-SymbolicName", "provider");
        providerManifest.put("Export-Package", "provider; version=1.1; attr1=attr1; attr2=attr2; dir1:=dir1; dir2:=dir2");
        providerManifest.put("Provide-Capability", "provider.cap; string=sValue; string.list1:List=\"v1,v2,v3\"; string.list2:List<String>=\"v4,v5,v6\"; version:Version=1.1; version.list:List<Version>=\"1.0,2.0,3.0\"; long:Long=12345; long.list:List<Long>=\"1,2,3\"; double:Double=1.2345; double.list:List<Double>=\"1.1,1.2,1.3\"; uri:uri=some.uri; set:set=\"s1,s2,s3\"");
        Module providerModule = this.installDummyModule(providerManifest, "provider", container);
        Map providerAttrs = ((Capability)providerModule.getCurrentRevision().getCapabilities("provider.cap").get(0)).getAttributes();
        Assert.assertEquals((String)"Wrong provider attrs", attrs, (Object)providerAttrs);
        HashMap<String, String> requirerManifest = new HashMap<String, String>();
        requirerManifest.put("Bundle-ManifestVersion", "2");
        requirerManifest.put("Bundle-SymbolicName", "requirer");
        requirerManifest.put("Import-Package", "provider; version=1.1; attr1=attr1; attr2=attr2; dir1:=dir1; dir2:=dir2");
        requirerManifest.put("Require-Capability", "optional; resolution:=optional;  string=sValue; string.list1:List=\"v1,v2,v3\"; string.list2:List<String>=\"v4,v5,v6\"; version:Version=1.1; version.list:List<Version>=\"1.0,2.0,3.0\"; long:Long=12345; long.list:List<Long>=\"1,2,3\"; double:Double=1.2345; double.list:List<Double>=\"1.1,1.2,1.3\"; uri:uri=some.uri; set:set=\"s1,s2,s3\",provider.cap; filter:=\"(string=sValue)\",provider.cap; filter:=\"(string.list1=v2)\",provider.cap; filter:=\"(string.list2=v5)\",provider.cap; filter:=\"(string.list2=v5)\",provider.cap; filter:=\"(&(version>=1.1)(version<=1.1.1))\",provider.cap; filter:=\"(&(version.list=1)(version.list=2))\",provider.cap; filter:=\"(long>=12344)\",provider.cap; filter:=\"(long.list=2)\",provider.cap; filter:=\"(double>=1.2)\",provider.cap; filter:=\"(double.list=1.2)\",provider.cap; filter:=\"(uri=some.uri)\",provider.cap; filter:=\"(set=s2)\"");
        Module requirerModule = this.installDummyModule(requirerManifest, "requirer", container);
        Map requirerAttrs = ((Requirement)requirerModule.getCurrentRevision().getRequirements("optional").get(0)).getAttributes();
        Assert.assertEquals((String)"Wrong requirer attrs", attrs, (Object)requirerAttrs);
        ResolutionReport report = container.resolve(Collections.singleton(requirerModule), true);
        Assert.assertNull((String)"Error resolving.", (Object)report.getResolutionException());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        adaptor.getDatabase().store(data, true);
        adaptor = this.createDummyAdaptor();
        container = adaptor.getContainer();
        adaptor.getDatabase().load(new DataInputStream(new ByteArrayInputStream(bytes.toByteArray())));
        providerModule = container.getModule("provider");
        providerAttrs = ((Capability)providerModule.getCurrentRevision().getCapabilities("provider.cap").get(0)).getAttributes();
        Assert.assertEquals((String)"Wrong provider attrs", attrs, (Object)providerAttrs);
        Assert.assertNotNull((String)"No provider found.", (Object)providerModule);
        requirerModule = container.getModule("requirer");
        Assert.assertNotNull((String)"No requirer found.", (Object)requirerModule);
        requirerAttrs = ((Requirement)requirerModule.getCurrentRevision().getRequirements("optional").get(0)).getAttributes();
        Assert.assertEquals((String)"Wrong requirer attrs", attrs, (Object)requirerAttrs);
    }

    @Test
    public void testInvalidAttributes() throws IOException, BundleException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        HashMap<String, String> invalidAttrManifest = new HashMap<String, String>();
        invalidAttrManifest.put("Bundle-ManifestVersion", "2");
        invalidAttrManifest.put("Bundle-SymbolicName", "invalid");
        invalidAttrManifest.put("Provide-Capability", "provider.cap; invalid:Boolean=true");
        this.checkInvalidManifest(invalidAttrManifest, container);
        invalidAttrManifest.put("Provide-Capability", "provider.cap; invalid:Integer=1");
        this.checkInvalidManifest(invalidAttrManifest, container);
        invalidAttrManifest.put("Provide-Capability", "provider.cap; invalid:List<Boolean>=true");
        this.checkInvalidManifest(invalidAttrManifest, container);
        invalidAttrManifest.put("Provide-Capability", "provider.cap; invalid:List<Integer>=1");
        this.checkInvalidManifest(invalidAttrManifest, container);
    }

    private void checkInvalidManifest(Map<String, String> invalidAttrManifest, ModuleContainer container) {
        try {
            this.installDummyModule(invalidAttrManifest, "invalid", container);
            Assert.fail((String)"Expected to get a BundleException with MANIFEST_ERROR");
        }
        catch (BundleException e) {
            Assert.assertEquals((String)"Wrong type.", (long)3L, (long)e.getType());
        }
    }

    @Test
    public void testStoreInvalidAttributes() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        Integer testInt = 1;
        List<Integer> testIntList = Collections.singletonList(testInt);
        ModuleRevisionBuilder builder = new ModuleRevisionBuilder();
        builder.setSymbolicName("invalid.attr");
        builder.setVersion(Version.valueOf((String)"1.0.0"));
        builder.addCapability("test", Collections.emptyMap(), Collections.singletonMap("test", testInt));
        builder.addCapability("test.list", Collections.emptyMap(), Collections.singletonMap("test.list", testIntList));
        Module invalid = container.install(null, builder.getSymbolicName(), builder, null);
        Object testAttr = ((Capability)invalid.getCurrentRevision().getCapabilities("test").get(0)).getAttributes().get("test");
        Assert.assertEquals((String)"Wrong test attr", (Object)testInt, testAttr);
        Object testAttrList = ((Capability)invalid.getCurrentRevision().getCapabilities("test.list").get(0)).getAttributes().get("test.list");
        Assert.assertEquals((String)"Wrong test list attr", testIntList, testAttrList);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        adaptor.getDatabase().store(data, true);
        List<DummyModuleDatabase.DummyContainerEvent> events = adaptor.getDatabase().getContainerEvents();
        Assert.assertEquals((String)"Wrong number of events.", (long)2L, (long)events.size());
        for (DummyModuleDatabase.DummyContainerEvent event : events) {
            Assert.assertEquals((String)"Wrong type of event.", (Object)ModuleContainerAdaptor.ContainerEvent.ERROR, (Object)event.type);
            Assert.assertTrue((String)"Wrong type of exception.", (boolean)(event.error instanceof BundleException));
        }
        adaptor = this.createDummyAdaptor();
        container = adaptor.getContainer();
        adaptor.getDatabase().load(new DataInputStream(new ByteArrayInputStream(bytes.toByteArray())));
        invalid = container.getModule("invalid.attr");
        Assert.assertNotNull((String)"Could not find module.", (Object)invalid);
        String testIntString = String.valueOf(testInt);
        List<String> testIntStringList = Collections.singletonList(testIntString);
        testAttr = ((Capability)invalid.getCurrentRevision().getCapabilities("test").get(0)).getAttributes().get("test");
        Assert.assertEquals((String)"Wrong test attr", (Object)testIntString, testAttr);
        testAttrList = ((Capability)invalid.getCurrentRevision().getCapabilities("test.list").get(0)).getAttributes().get("test.list");
        Assert.assertEquals((String)"Wrong test list attr", testIntStringList, testAttrList);
    }

    @Test
    public void testBug483849() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module host = this.installDummyModule("bug483849.host.MF", "host", container);
        ResolutionReport report = container.resolve(Arrays.asList(host), true);
        Assert.assertNull((String)"Failed to resolve host.", (Object)report.getResolutionException());
        Module frag = this.installDummyModule("bug483849.frag.MF", "frag", container);
        Module importer = this.installDummyModule("bug483849.importer.MF", "importer", container);
        report = container.resolve(Arrays.asList(frag, importer), true);
        Assert.assertNull((String)"Failed to resolve test fragment and importer.", (Object)report.getResolutionException());
        ModuleWiring wiring = host.getCurrentRevision().getWiring();
        int originalPackageCnt = wiring.getCapabilities("osgi.wiring.package").size();
        Map<String, String> updateManifest = this.getManifest("bug483849.host.MF");
        ModuleRevisionBuilder updateBuilder = OSGiManifestBuilderFactory.createBuilder(updateManifest);
        container.update(host, updateBuilder, null);
        report = container.refresh(Collections.singleton(host));
        ModuleWiring importerWiring = importer.getCurrentRevision().getWiring();
        Assert.assertNotNull((String)"No wiring for importer.", (Object)importerWiring);
        List importerPackageWires = importerWiring.getRequiredModuleWires("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of importer package Wires.", (long)1L, (long)importerPackageWires.size());
        Assert.assertEquals((String)"Wrong provider wiring.", (Object)host.getCurrentRevision().getWiring(), (Object)((ModuleWire)importerPackageWires.iterator().next()).getProviderWiring());
        Assert.assertEquals((String)"Wrong provider revision.", (Object)host.getCurrentRevision(), (Object)((ModuleWire)importerPackageWires.iterator().next()).getProviderWiring().getRevision());
        wiring = host.getCurrentRevision().getWiring();
        List packages = wiring.getCapabilities("osgi.wiring.package");
        Assert.assertEquals((String)"Wrong number of host packages.", (long)originalPackageCnt, (long)packages.size());
    }

    @Test
    public void testStartLevelDeadlock() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        container.getFrameworkStartLevel().setInitialBundleStartLevel(2);
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        systemBundle.start(new Module.StartOptions[0]);
        HashMap<String, String> manifest = new HashMap<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "module.test");
        Module module = this.installDummyModule(manifest, (String)manifest.get("Bundle-SymbolicName"), container);
        adaptor.setSlowdownEvents(true);
        module.setStartLevel(1);
        module.start(new Module.StartOptions[0]);
        List<DummyModuleDatabase.DummyContainerEvent> events = adaptor.getDatabase().getContainerEvents();
        for (DummyModuleDatabase.DummyContainerEvent event : events) {
            Assert.assertNotEquals((String)("Found an error: " + event.error), (Object)ModuleContainerAdaptor.ContainerEvent.ERROR, (Object)event.type);
        }
    }

    @Test
    public void testSystemBundleOnDemandFragments() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        HashMap<String, String> equinoxFragManifest = new HashMap<String, String>();
        equinoxFragManifest.put("Bundle-ManifestVersion", "2");
        equinoxFragManifest.put("Bundle-SymbolicName", "equinoxFrag");
        equinoxFragManifest.put("Fragment-Host", "org.eclipse.osgi");
        Module equinoxFrag = this.installDummyModule(equinoxFragManifest, "equinoxFrag", container);
        HashMap<String, String> systemFragManifest = new HashMap<String, String>();
        systemFragManifest.put("Bundle-ManifestVersion", "2");
        systemFragManifest.put("Bundle-SymbolicName", "systemFrag");
        systemFragManifest.put("Fragment-Host", "system.bundle");
        Module systemFrag = this.installDummyModule(systemFragManifest, "systemFrag", container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        List hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)2L, (long)hostWires.size());
        HashSet<ModuleRevision> fragmentRevisions = new HashSet<ModuleRevision>(Arrays.asList(equinoxFrag.getCurrentRevision(), systemFrag.getCurrentRevision()));
        for (ModuleWire hostWire : hostWires) {
            if (fragmentRevisions.remove(hostWire.getRequirer())) continue;
            Assert.fail((String)("Unexpected fragment revision: " + hostWire.getRequirer()));
        }
    }

    @Test
    public void testUnresolvedHostWithFragmentCycle() throws BundleException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        HashMap<String, String> hostManifest = new HashMap<String, String>();
        hostManifest.put("Bundle-ManifestVersion", "2");
        hostManifest.put("Bundle-SymbolicName", "host");
        hostManifest.put("Bundle-Version", "1.0");
        hostManifest.put("Export-Package", "host");
        hostManifest.put("Import-Package", "host.impl");
        this.installDummyModule(hostManifest, "host10", container);
        hostManifest.put("Bundle-Version", "1.1");
        this.installDummyModule(hostManifest, "host11", container);
        hostManifest.put("Bundle-Version", "1.2");
        this.installDummyModule(hostManifest, "host12", container);
        HashMap<String, String> hostImplManifest = new HashMap<String, String>();
        hostImplManifest.put("Bundle-ManifestVersion", "2");
        hostImplManifest.put("Bundle-SymbolicName", "host.impl");
        hostImplManifest.put("Export-Package", "host.impl");
        hostImplManifest.put("Import-Package", "host");
        hostImplManifest.put("Fragment-Host", "host");
        this.installDummyModule(hostImplManifest, "hostImpl", container);
        HashMap<String, String> hostImporterManifest = new HashMap<String, String>();
        hostImporterManifest.put("Bundle-ManifestVersion", "2");
        hostImporterManifest.put("Bundle-SymbolicName", "host.importer");
        hostImporterManifest.put("Import-Package", "host");
        Module hostImporter = this.installDummyModule(hostImporterManifest, "hostImporter", container);
        ResolutionReport report = container.resolve(Arrays.asList(hostImporter), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
    }

    @Test
    public void testMultiHostFragmentWithOverlapImport() throws BundleException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        HashMap<String, String> exporterManifest = new HashMap<String, String>();
        exporterManifest.put("Bundle-ManifestVersion", "2");
        exporterManifest.put("Bundle-SymbolicName", "exporter");
        exporterManifest.put("Bundle-Version", "1.0");
        exporterManifest.put("Export-Package", "exporter");
        this.installDummyModule(exporterManifest, "exporter", container);
        HashMap<String, String> exporterFragManifest = new HashMap<String, String>();
        exporterFragManifest.put("Bundle-ManifestVersion", "2");
        exporterFragManifest.put("Bundle-SymbolicName", "exporter.frag");
        exporterFragManifest.put("Export-Package", "exporter.frag");
        exporterFragManifest.put("Fragment-Host", "exporter");
        this.installDummyModule(exporterFragManifest, "exporter.frag", container);
        HashMap<String, String> hostManifest = new HashMap<String, String>();
        hostManifest.put("Bundle-ManifestVersion", "2");
        hostManifest.put("Bundle-SymbolicName", "host");
        hostManifest.put("Bundle-Version", "1.0");
        hostManifest.put("Import-Package", "exporter");
        this.installDummyModule(hostManifest, "host10", container);
        hostManifest.put("Bundle-Version", "1.1");
        this.installDummyModule(hostManifest, "host11", container);
        hostManifest.put("Bundle-Version", "1.2");
        this.installDummyModule(hostManifest, "host12", container);
        HashMap<String, String> hostFragManifest = new HashMap<String, String>();
        hostFragManifest.put("Bundle-ManifestVersion", "2");
        hostFragManifest.put("Bundle-SymbolicName", "host.frag");
        hostFragManifest.put("Fragment-Host", "host");
        hostFragManifest.put("Import-Package", "exporter; version=0.0");
        Module hostFrag = this.installDummyModule(hostFragManifest, "host.frag", container);
        ResolutionReport report = container.resolve(Arrays.asList(hostFrag), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
    }

    @Test
    public void testModuleWiringToString() throws BundleException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        HashMap<String, String> testManifest = new HashMap<String, String>();
        testManifest.put("Bundle-ManifestVersion", "2");
        testManifest.put("Bundle-SymbolicName", "test.name");
        testManifest.put("Bundle-Version", "1.0");
        Module testModule = this.installDummyModule(testManifest, "host10", container);
        ResolutionReport report = container.resolve(Arrays.asList(testModule), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
        ModuleRevision revision = testModule.getCurrentRevision();
        ModuleWiring wiring = revision.getWiring();
        Assert.assertEquals((String)"Unexpected wiring.toString()", (Object)revision.toString(), (Object)wiring.toString());
    }

    @Test
    public void testStartOnResolve() throws BundleException, IOException {
        this.doTestStartOnResolve(true);
    }

    @Test
    public void testDisableStartOnResolve() throws BundleException, IOException {
        this.doTestStartOnResolve(false);
    }

    private void doTestStartOnResolve(boolean enabled) throws BundleException, IOException {
        HashMap<String, String> configuration = new HashMap<String, String>();
        if (!enabled) {
            configuration.put("osgi.module.auto.start.on.resolve", Boolean.toString(false));
        }
        DummyContainerAdaptor adaptor = new DummyContainerAdaptor(new DummyCollisionHook(false), configuration);
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        systemBundle.start(new Module.StartOptions[0]);
        HashMap<String, String> manifest = new HashMap<String, String>();
        ArrayList<Module> modules = new ArrayList<Module>();
        int i = 0;
        while (i < 5) {
            manifest.clear();
            manifest.put("Bundle-ManifestVersion", "2");
            manifest.put("Bundle-SymbolicName", "module." + i);
            manifest.put("Import-Package", "export");
            Module module = this.installDummyModule(manifest, (String)manifest.get("Bundle-SymbolicName"), container);
            try {
                module.start(new Module.StartOptions[0]);
                Assert.fail((String)"expected a bundle exception.");
            }
            catch (BundleException bundleException) {}
            modules.add(module);
            ++i;
        }
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "exporter");
        manifest.put("Export-Package", "export");
        this.installDummyModule(manifest, (String)manifest.get("Bundle-SymbolicName"), container);
        report = container.resolve(Collections.emptySet(), false);
        Assert.assertNull((String)"Found a error.", (Object)report.getResolutionException());
        Module.State expectedState = enabled ? Module.State.ACTIVE : Module.State.RESOLVED;
        for (Module module : modules) {
            Assert.assertEquals((String)"Wrong state.", (Object)expectedState, (Object)module.getState());
        }
    }

    @Test
    public void testResolveDeadlock() throws BundleException, IOException, InterruptedException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        systemBundle.start(new Module.StartOptions[0]);
        HashMap<String, String> manifest = new HashMap<String, String>();
        ArrayList<Module> modules = new ArrayList<Module>();
        int i = 0;
        while (i < 5) {
            manifest.clear();
            manifest.put("Bundle-ManifestVersion", "2");
            manifest.put("Bundle-SymbolicName", "module." + i);
            modules.add(this.installDummyModule(manifest, (String)manifest.get("Bundle-SymbolicName"), container));
            ++i;
        }
        adaptor.setSlowdownEvents(true);
        final ConcurrentLinkedQueue startErrors = new ConcurrentLinkedQueue();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            for (final Module module : modules) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            module.start(new Module.StartOptions[0]);
                        }
                        catch (BundleException e) {
                            startErrors.offer(e);
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.MINUTES);
            systemBundle.stop(new Module.StopOptions[0]);
        }
        Assert.assertNull((String)"Found a error.", startErrors.poll());
        List<DummyModuleDatabase.DummyContainerEvent> events = adaptor.getDatabase().getContainerEvents();
        for (DummyModuleDatabase.DummyContainerEvent event : events) {
            Assert.assertNotEquals((String)"Found an error.", (Object)ModuleContainerAdaptor.ContainerEvent.ERROR, (Object)event.type);
        }
    }

    @Test
    public void testSystemBundleFragmentsPackageImport() throws BundleException, IOException {
        Module systemBundle = this.createContainerWithSystemBundle(true);
        ModuleContainer container = systemBundle.getContainer();
        HashMap<String, String> systemFragManifest = new HashMap<String, String>();
        systemFragManifest.put("Bundle-ManifestVersion", "2");
        systemFragManifest.put("Bundle-SymbolicName", "systemFrag");
        systemFragManifest.put("Fragment-Host", "system.bundle");
        systemFragManifest.put("Import-Package", "org.osgi.framework");
        Module systemFrag = this.installDummyModule(systemFragManifest, "systemFrag", container);
        ResolutionReport report = container.resolve(Arrays.asList(systemFrag), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        List hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)1L, (long)hostWires.size());
        Assert.assertEquals((String)("Unexpected fragment revision: " + hostWires), (Object)systemFrag.getCurrentRevision(), (Object)((ModuleWire)hostWires.get(0)).getRequirer());
        List systemBundleRequiredWires = systemBundle.getCurrentRevision().getWiring().getRequiredModuleWires(null);
        Assert.assertEquals((String)"No required wires expected.", (long)0L, (long)systemBundleRequiredWires.size());
    }

    @Test
    public void testSystemBundleFragmentsNonPayloadRequirements() throws BundleException, IOException {
        Module systemBundle = this.createContainerWithSystemBundle(true);
        ModuleContainer container = systemBundle.getContainer();
        HashMap<String, String> systemFragManifest = new HashMap<String, String>();
        systemFragManifest.put("Bundle-ManifestVersion", "2");
        systemFragManifest.put("Bundle-SymbolicName", "systemFrag");
        systemFragManifest.put("Fragment-Host", "system.bundle");
        systemFragManifest.put("Require-Capability", "osgi.ee; filter:=\"(osgi.ee=JavaSE)\"");
        Module systemFrag = this.installDummyModule(systemFragManifest, "systemFrag", container);
        ResolutionReport report = container.resolve(Arrays.asList(systemFrag), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        List hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)1L, (long)hostWires.size());
        Assert.assertEquals((String)("Unexpected fragment revision: " + hostWires), (Object)systemFrag.getCurrentRevision(), (Object)((ModuleWire)hostWires.get(0)).getRequirer());
        List systemBundleRequiredWires = systemBundle.getCurrentRevision().getWiring().getRequiredModuleWires(null);
        Assert.assertEquals((String)"No required wires expected.", (long)0L, (long)systemBundleRequiredWires.size());
        List fragRequiredWires = systemFrag.getCurrentRevision().getWiring().getRequiredModuleWires(null);
        Assert.assertEquals((String)"Wrong number of required wires.", (long)2L, (long)fragRequiredWires.size());
        TestModuleContainer.assertWires(fragRequiredWires, systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires(null));
    }

    @Test
    public void testSystemBundleFragmentsWithPayloadRequirements() throws BundleException, IOException {
        Module systemBundle = this.createContainerWithSystemBundle(true);
        ModuleContainer container = systemBundle.getContainer();
        HashMap<String, String> systemFragManifest = new HashMap<String, String>();
        systemFragManifest.put("Bundle-ManifestVersion", "2");
        systemFragManifest.put("Bundle-SymbolicName", "systemFrag");
        systemFragManifest.put("Fragment-Host", "system.bundle");
        systemFragManifest.put("Require-Capability", "equinox.test; filter:=\"(equinox.test=system)\"");
        Module systemFrag = this.installDummyModule(systemFragManifest, "systemFrag", container);
        ResolutionReport report = container.resolve(Arrays.asList(systemFrag), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        List hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)1L, (long)hostWires.size());
        Assert.assertEquals((String)("Unexpected fragment revision: " + hostWires), (Object)systemFrag.getCurrentRevision(), (Object)((ModuleWire)hostWires.get(0)).getRequirer());
        List systemBundleRequiredWires = systemBundle.getCurrentRevision().getWiring().getRequiredModuleWires(null);
        Assert.assertEquals((String)"Wrong number of wires.", (long)1L, (long)systemBundleRequiredWires.size());
        Assert.assertEquals((String)"Wrong requirer.", (Object)systemBundle.getCurrentRevision(), (Object)((ModuleWire)systemBundleRequiredWires.get(0)).getRequirer());
        Assert.assertEquals((String)"Wrong requirement.", (Object)systemFrag.getCurrentRevision(), (Object)((ModuleWire)systemBundleRequiredWires.get(0)).getRequirement().getRevision());
        List fragRequiredWires = systemFrag.getCurrentRevision().getWiring().getRequiredModuleWires(null);
        Assert.assertEquals((String)"Wrong number of required wires.", (long)1L, (long)fragRequiredWires.size());
        TestModuleContainer.assertWires(fragRequiredWires, hostWires);
    }

    @Test
    public void testSystemBundleFragmentRequiresOtherFragment() throws BundleException, IOException {
        Module systemBundle = this.createContainerWithSystemBundle(true);
        ModuleContainer container = systemBundle.getContainer();
        HashMap<String, String> systemFragManifest1 = new HashMap<String, String>();
        systemFragManifest1.put("Bundle-ManifestVersion", "2");
        systemFragManifest1.put("Bundle-SymbolicName", "systemFrag1");
        systemFragManifest1.put("Fragment-Host", "system.bundle");
        systemFragManifest1.put("Provide-Capability", "fragment.capability; fragment.capability=test");
        Module systemFrag1 = this.installDummyModule(systemFragManifest1, "systemFrag1", container);
        HashMap<String, String> systemFragManifest2 = new HashMap<String, String>();
        systemFragManifest2.put("Bundle-ManifestVersion", "2");
        systemFragManifest2.put("Bundle-SymbolicName", "systemFrag2");
        systemFragManifest2.put("Fragment-Host", "system.bundle");
        systemFragManifest2.put("Require-Capability", "fragment.capability; filter:=\"(fragment.capability=test)\"");
        Module systemFrag2 = this.installDummyModule(systemFragManifest2, "systemFrag2", container);
        ResolutionReport report = container.resolve(Arrays.asList(systemFrag2), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        List hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)2L, (long)hostWires.size());
        List systemBundleRequiredWires = systemBundle.getCurrentRevision().getWiring().getRequiredModuleWires(null);
        Assert.assertEquals((String)"Wrong number of wires.", (long)1L, (long)systemBundleRequiredWires.size());
        Assert.assertEquals((String)"Wrong requirer.", (Object)systemBundle.getCurrentRevision(), (Object)((ModuleWire)systemBundleRequiredWires.get(0)).getRequirer());
        Assert.assertEquals((String)"Wrong requirement.", (Object)systemFrag2.getCurrentRevision(), (Object)((ModuleWire)systemBundleRequiredWires.get(0)).getRequirement().getRevision());
        Assert.assertEquals((String)"Wrong provider.", (Object)systemBundle.getCurrentRevision(), (Object)((ModuleWire)systemBundleRequiredWires.get(0)).getProvider());
        Assert.assertEquals((String)"Wrong capability.", (Object)systemFrag1.getCurrentRevision(), (Object)((ModuleWire)systemBundleRequiredWires.get(0)).getCapability().getRevision());
        List fragRequiredWires = systemFrag2.getCurrentRevision().getWiring().getRequiredModuleWires(null);
        Assert.assertEquals((String)"Wrong number of required wires.", (long)1L, (long)fragRequiredWires.size());
        TestModuleContainer.assertWires(fragRequiredWires, hostWires);
    }

    @Test
    public void testSystemBundleFragmentRequiresOtherFragmentFailResolution() throws BundleException, IOException {
        Module systemBundle = this.createContainerWithSystemBundle(true);
        ModuleContainer container = systemBundle.getContainer();
        HashMap<String, String> systemFragManifest1 = new HashMap<String, String>();
        systemFragManifest1.put("Bundle-ManifestVersion", "2");
        systemFragManifest1.put("Bundle-SymbolicName", "systemFrag1");
        systemFragManifest1.put("Fragment-Host", "system.bundle");
        systemFragManifest1.put("Provide-Capability", "fragment.capability; fragment.capability=test1");
        Module systemFrag1 = this.installDummyModule(systemFragManifest1, "systemFrag1", container);
        HashMap<String, String> systemFragManifest2 = new HashMap<String, String>();
        systemFragManifest2.put("Bundle-ManifestVersion", "2");
        systemFragManifest2.put("Bundle-SymbolicName", "systemFrag2");
        systemFragManifest2.put("Fragment-Host", "system.bundle");
        systemFragManifest2.put("Require-Capability", "fragment.capability; filter:=\"(fragment.capability=test4)\"");
        systemFragManifest2.put("Provide-Capability", "fragment.capability; fragment.capability=test2");
        Module systemFrag2 = this.installDummyModule(systemFragManifest2, "systemFrag2", container);
        HashMap<String, String> systemFragManifest3 = new HashMap<String, String>();
        systemFragManifest3.put("Bundle-ManifestVersion", "2");
        systemFragManifest3.put("Bundle-SymbolicName", "systemFrag3");
        systemFragManifest3.put("Fragment-Host", "system.bundle");
        systemFragManifest3.put("Require-Capability", "fragment.capability; filter:=\"(fragment.capability=test2)\"");
        systemFragManifest3.put("Provide-Capability", "fragment.capability; fragment.capability=test3");
        Module systemFrag3 = this.installDummyModule(systemFragManifest3, "systemFrag3", container);
        ResolutionReport report = container.resolve(Arrays.asList(systemFrag3), true);
        Assert.assertNotNull((String)"Expected failure message", (Object)report.getResolutionException());
        List hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)1L, (long)hostWires.size());
        List systemFrag1HostWires = systemFrag1.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.host");
        TestModuleContainer.assertWires(systemFrag1HostWires, hostWires);
        HashMap<String, String> provideCapabilityManifest1 = new HashMap<String, String>();
        provideCapabilityManifest1.put("Bundle-ManifestVersion", "2");
        provideCapabilityManifest1.put("Bundle-SymbolicName", "provideCapabilityBundle1");
        provideCapabilityManifest1.put("Provide-Capability", "fragment.capability; fragment.capability=test4");
        this.installDummyModule(provideCapabilityManifest1, "provideCapabilityBundle1", container);
        hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)1L, (long)hostWires.size());
        systemFrag1HostWires = systemFrag1.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.host");
        TestModuleContainer.assertWires(systemFrag1HostWires, hostWires);
        HashMap<String, String> systemFragManifest4 = new HashMap<String, String>();
        systemFragManifest4.put("Bundle-ManifestVersion", "2");
        systemFragManifest4.put("Bundle-SymbolicName", "systemFrag4");
        systemFragManifest4.put("Fragment-Host", "system.bundle");
        systemFragManifest4.put("Provide-Capability", "fragment.capability; fragment.capability=test4");
        Module systemFrag4 = this.installDummyModule(systemFragManifest4, "systemFrag4", container);
        report = container.resolve(Arrays.asList(systemFrag3), true);
        Assert.assertNull((String)"Failed to resolve.", (Object)report.getResolutionException());
        hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)4L, (long)hostWires.size());
        systemFrag1HostWires = systemFrag1.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.host");
        List systemFrag2HostWires = systemFrag2.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.host");
        List systemFrag3HostWires = systemFrag3.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.host");
        List systemFrag4HostWires = systemFrag4.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.host");
        TestModuleContainer.assertWires(systemFrag1HostWires, hostWires);
        TestModuleContainer.assertWires(systemFrag2HostWires, hostWires);
        TestModuleContainer.assertWires(systemFrag3HostWires, hostWires);
        TestModuleContainer.assertWires(systemFrag4HostWires, hostWires);
        List fragmentCapabilities = systemBundle.getCurrentRevision().getWiring().getModuleCapabilities("fragment.capability");
        Assert.assertEquals((String)"Wrong number of fragment capabilities.", (long)4L, (long)fragmentCapabilities.size());
        HashSet hostRequiredFragmentCapWires = new HashSet(systemBundle.getCurrentRevision().getWiring().getRequiredModuleWires("fragment.capability"));
        HashSet hostProvidedFragmentCapWires = new HashSet(systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("fragment.capability"));
        Assert.assertEquals((String)"Wrong number of wires.", (long)2L, (long)hostProvidedFragmentCapWires.size());
        Assert.assertEquals((String)"Wrong wires found from host.", hostRequiredFragmentCapWires, hostProvidedFragmentCapWires);
    }

    @Test
    public void testMultipleSystemBundleFragmentsWithSameName() throws BundleException, IOException {
        Module systemBundle = this.createContainerWithSystemBundle(true);
        ModuleContainer container = systemBundle.getContainer();
        HashMap<String, String> systemFragManifest1 = new HashMap<String, String>();
        systemFragManifest1.put("Bundle-ManifestVersion", "2");
        systemFragManifest1.put("Bundle-SymbolicName", "systemFrag");
        systemFragManifest1.put("Bundle-Version", "1.0");
        systemFragManifest1.put("Fragment-Host", "system.bundle");
        Module systemFrag1 = this.installDummyModule(systemFragManifest1, "systemFrag1", container);
        ResolutionReport report = container.resolve(Arrays.asList(systemFrag1), true);
        Assert.assertNull((String)"Unexpected failure message", (Object)report.getResolutionException());
        List hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)1L, (long)hostWires.size());
        List systemFrag1HostWires = systemFrag1.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.host");
        TestModuleContainer.assertWires(systemFrag1HostWires, hostWires);
        HashMap<String, String> systemFragManifest2 = new HashMap<String, String>();
        systemFragManifest2.put("Bundle-ManifestVersion", "2");
        systemFragManifest2.put("Bundle-SymbolicName", "systemFrag");
        systemFragManifest2.put("Bundle-Version", "2.0");
        systemFragManifest2.put("Fragment-Host", "system.bundle");
        Module systemFrag2 = this.installDummyModule(systemFragManifest2, "systemFrag2", container);
        HashMap<String, String> systemFragManifest3 = new HashMap<String, String>();
        systemFragManifest3.put("Bundle-ManifestVersion", "2");
        systemFragManifest3.put("Bundle-SymbolicName", "systemFrag");
        systemFragManifest3.put("Bundle-Version", "3.0");
        systemFragManifest3.put("Fragment-Host", "system.bundle");
        Module systemFrag3 = this.installDummyModule(systemFragManifest3, "systemFrag3", container);
        report = container.resolve(Arrays.asList(systemFrag2), true);
        Assert.assertNotNull((String)"Expected failure message", (Object)report.getResolutionException());
        report = container.resolve(Arrays.asList(systemFrag3), true);
        Assert.assertNotNull((String)"Expected failure message", (Object)report.getResolutionException());
        hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)1L, (long)hostWires.size());
        systemFrag1HostWires = systemFrag1.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.host");
        TestModuleContainer.assertWires(systemFrag1HostWires, hostWires);
        container.uninstall(systemFrag1);
        container.uninstall(systemFrag2);
        container.uninstall(systemFrag3);
        report = container.refresh(Collections.singleton(systemBundle));
        Assert.assertNull((String)"Unexpected failure message", (Object)report.getResolutionException());
        hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        Assert.assertEquals((String)"Wrong number of fragments.", (long)0L, (long)hostWires.size());
        systemFrag1 = this.installDummyModule(systemFragManifest1, "systemFrag1", container);
        systemFrag2 = this.installDummyModule(systemFragManifest2, "systemFrag2", container);
        systemFrag3 = this.installDummyModule(systemFragManifest3, "systemFrag3", container);
        report = container.resolve(Arrays.asList(systemFrag1), true);
        Assert.assertNotNull((String)"Expected failure message", (Object)report.getResolutionException());
        report = container.resolve(Arrays.asList(systemFrag2), true);
        Assert.assertNotNull((String)"Expected failure message", (Object)report.getResolutionException());
        report = container.resolve(Arrays.asList(systemFrag3), true);
        Assert.assertNull((String)"Unexpected failure message", (Object)report.getResolutionException());
        hostWires = systemBundle.getCurrentRevision().getWiring().getProvidedModuleWires("osgi.wiring.host");
        List systemFrag3HostWires = systemFrag3.getCurrentRevision().getWiring().getRequiredModuleWires("osgi.wiring.host");
        TestModuleContainer.assertWires(systemFrag3HostWires, hostWires);
    }

    private Module createContainerWithSystemBundle(boolean resolveSystemBundle) throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        String systemCapability = "osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6\", equinox.test; equinox.test=system, osgi.native; osgi.native.osname=test";
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, systemCapability, container);
        if (resolveSystemBundle) {
            ResolutionReport report = container.resolve(Collections.singleton(systemBundle), true);
            Assert.assertNull((String)"Found resolution exception.", (Object)report.getResolutionException());
            Assert.assertEquals((String)"System is not resolved.", (Object)Module.State.RESOLVED, (Object)systemBundle.getState());
        }
        return systemBundle;
    }

    @Test
    public void testSplitPackageUses01() throws BundleException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        HashMap<String, String> coreManifest = new HashMap<String, String>();
        coreManifest.put("Bundle-ManifestVersion", "2");
        coreManifest.put("Bundle-SymbolicName", "core");
        coreManifest.put("Export-Package", "pkg1; core=split; mandatory:=core");
        coreManifest.put("Import-Package", "pkg1; core=split");
        HashMap<String, String> miscManifest = new HashMap<String, String>();
        miscManifest.put("Bundle-ManifestVersion", "2");
        miscManifest.put("Bundle-SymbolicName", "misc");
        miscManifest.put("Export-Package", "pkg1; misc=split; mandatory:=misc");
        miscManifest.put("Require-Bundle", "core");
        HashMap<String, String> importsCoreManifest = new HashMap<String, String>();
        importsCoreManifest.put("Bundle-ManifestVersion", "2");
        importsCoreManifest.put("Bundle-SymbolicName", "importsCore");
        importsCoreManifest.put("Export-Package", "pkg2; uses:=pkg1");
        importsCoreManifest.put("Import-Package", "pkg1; core=split");
        HashMap<String, String> requiresMiscManifest = new HashMap<String, String>();
        requiresMiscManifest.put("Bundle-ManifestVersion", "2");
        requiresMiscManifest.put("Bundle-SymbolicName", "requiresMisc");
        requiresMiscManifest.put("Import-Package", "pkg2");
        requiresMiscManifest.put("Require-Bundle", "misc");
        this.installDummyModule(coreManifest, "core", container);
        this.installDummyModule(miscManifest, "misc", container);
        this.installDummyModule(importsCoreManifest, "importsCore", container);
        Module requireMisc = this.installDummyModule(requiresMiscManifest, "requireMisc", container);
        ResolutionReport report = container.resolve(Arrays.asList(requireMisc), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
        adaptor = this.createDummyAdaptor();
        container = adaptor.getContainer();
        this.installDummyModule(coreManifest, "core", container);
        Module misc = this.installDummyModule(miscManifest, "misc", container);
        report = container.resolve(Arrays.asList(misc), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
        this.installDummyModule(importsCoreManifest, "importsCore", container);
        requireMisc = this.installDummyModule(requiresMiscManifest, "requireMisc", container);
        report = container.resolve(Arrays.asList(requireMisc), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
        adaptor = this.createDummyAdaptor();
        container = adaptor.getContainer();
        HashMap<String, String> substitutesCoreManifest = new HashMap<String, String>();
        substitutesCoreManifest.put("Bundle-ManifestVersion", "2");
        substitutesCoreManifest.put("Bundle-SymbolicName", "substitutesCore");
        substitutesCoreManifest.put("Export-Package", "pkg1; substitutesCore=true; mandatory:=substitutesCore");
        coreManifest.put("Import-Package", "pkg1; substitutesCore=true");
        importsCoreManifest.put("Import-Package", "pkg1; substitutesCore=true");
        this.installDummyModule(substitutesCoreManifest, "substitutesCore", container);
        this.installDummyModule(coreManifest, "core", container);
        misc = this.installDummyModule(miscManifest, "misc", container);
        report = container.resolve(Arrays.asList(misc), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
        this.installDummyModule(importsCoreManifest, "importsCore", container);
        requireMisc = this.installDummyModule(requiresMiscManifest, "requireMisc", container);
        report = container.resolve(Arrays.asList(requireMisc), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
        adaptor = this.createDummyAdaptor();
        container = adaptor.getContainer();
        this.installDummyModule(substitutesCoreManifest, "substitutesCore", container);
        this.installDummyModule(coreManifest, "core", container);
        this.installDummyModule(miscManifest, "misc", container);
        this.installDummyModule(importsCoreManifest, "importsCore", container);
        requireMisc = this.installDummyModule(requiresMiscManifest, "requireMisc", container);
        report = container.resolve(Arrays.asList(requireMisc), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
    }

    @Test
    public void testSubstitutionWithMoreThan2Providers() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", "javax.crypto, javax.crypto.spec, javax.net, javax.net.ssl, javax.security.auth.x500, org.ietf.jgss", "osgi.ee; osgi.ee=JavaSE; version:List<Version>=\"1.3, 1.4, 1.5, 1.6, 1.7\"", container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String manifest : this.HTTPCOMPS_AND_EATHER) {
            modules.add(this.installDummyModule(manifest, manifest, container));
        }
        report = container.resolve(modules, true);
        Assert.assertNull((String)"Failed to resolve test.", (Object)report.getResolutionException());
    }

    @Test
    public void testModuleIDSetting() throws BundleException, IOException {
        DummyContainerAdaptor adaptor = this.createDummyAdaptor();
        ModuleContainer container = adaptor.getContainer();
        Module systemBundle = this.installDummyModule("system.bundle.MF", "System Bundle", "system.bundle", null, null, container);
        ResolutionReport report = container.resolve(Arrays.asList(systemBundle), true);
        Assert.assertNull((String)"Failed to resolve system.bundle.", (Object)report.getResolutionException());
        HashMap<String, String> manifest = new HashMap<String, String>();
        ArrayList<Module> modules = new ArrayList<Module>();
        int i = 5;
        while (i > 0) {
            manifest.clear();
            manifest.put("Bundle-ManifestVersion", "2");
            manifest.put("Bundle-SymbolicName", String.valueOf(i));
            modules.add(this.installDummyModule(manifest, i, (String)manifest.get("Bundle-SymbolicName"), container));
            --i;
        }
        long id = 5L;
        for (Module module : modules) {
            Assert.assertEquals((String)"Wrong ID found.", (long)id--, (long)module.getId());
        }
        manifest.clear();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", String.valueOf("test.dup.id"));
        try {
            this.installDummyModule(manifest, 5L, (String)manifest.get("Bundle-SymbolicName"), container);
            Assert.fail((String)"Expected to fail installation with duplicate ID.");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private static void assertWires(List<ModuleWire> required, List<ModuleWire> ... provided) {
        for (ModuleWire requiredWire : required) {
            List<ModuleWire>[] listArray = provided;
            int n = provided.length;
            int n2 = 0;
            while (n2 < n) {
                List<ModuleWire> providedList = listArray[n2];
                if (providedList.contains(requiredWire)) {
                    return;
                }
                ++n2;
            }
            Assert.fail((String)("Could not find required wire in expected provider wires: " + requiredWire));
        }
    }

    private void assertEvents(List<DummyModuleDatabase.DummyModuleEvent> expected, List<DummyModuleDatabase.DummyModuleEvent> actual, boolean orderMatters) {
        List<DummyModuleDatabase.DummyModuleEvent> expectedCommon = this.removeFirstListOfCommonEvents(expected);
        while (!expectedCommon.isEmpty()) {
            List<DummyModuleDatabase.DummyModuleEvent> actualCommon = this.removeFirstListOfCommonEvents(actual);
            if (expectedCommon.size() != actualCommon.size()) {
                Assert.assertEquals((String)("Wrong number of events found in: " + actualCommon), (long)expectedCommon.size(), (long)actualCommon.size());
            }
            if (orderMatters) {
                Assert.assertEquals((String)"Wrong events found.", expectedCommon, actualCommon);
            } else {
                for (DummyModuleDatabase.DummyModuleEvent expectedEvent : expectedCommon) {
                    Assert.assertTrue((String)("Missing expected event: " + expectedEvent + " : from " + actualCommon), (boolean)actualCommon.contains(expectedEvent));
                }
                for (DummyModuleDatabase.DummyModuleEvent actualEvent : actualCommon) {
                    Assert.assertTrue((String)("Found unexpected event: " + actualEvent + " : from " + actualCommon), (boolean)expectedCommon.contains(actualEvent));
                }
            }
            expectedCommon = this.removeFirstListOfCommonEvents(expected);
        }
    }

    private List<DummyModuleDatabase.DummyModuleEvent> removeFirstListOfCommonEvents(List<DummyModuleDatabase.DummyModuleEvent> events) {
        ArrayList<DummyModuleDatabase.DummyModuleEvent> result = new ArrayList<DummyModuleDatabase.DummyModuleEvent>();
        if (events.isEmpty()) {
            return result;
        }
        ModuleContainerAdaptor.ModuleEvent commonEvent = events.get((int)0).event;
        Iterator<DummyModuleDatabase.DummyModuleEvent> iEvents = events.iterator();
        while (iEvents.hasNext()) {
            DummyModuleDatabase.DummyModuleEvent current = iEvents.next();
            if (!commonEvent.equals((Object)current.event)) break;
            iEvents.remove();
            result.add(current);
        }
        return result;
    }
}

