/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.container.dummys;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCollisionHook;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.SystemModule;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.tests.container.dummys.DummyModule;
import org.eclipse.osgi.tests.container.dummys.DummyModuleDatabase;
import org.eclipse.osgi.tests.container.dummys.DummyResolverHookFactory;
import org.eclipse.osgi.tests.container.dummys.DummySystemModule;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;

public class DummyContainerAdaptor
extends ModuleContainerAdaptor {
    private AtomicBoolean slowdownEvents = new AtomicBoolean(false);
    private final ModuleCollisionHook collisionHook;
    private final Map<String, String> configuration;
    private final DummyModuleDatabase moduleDatabase;
    private final ModuleContainer container;
    private final ResolverHookFactory resolverHookFactory;
    private final DebugOptions debugOptions;
    private volatile Executor resolverExecutor;
    private volatile ScheduledExecutorService timeoutExecutor;

    public DummyContainerAdaptor(ModuleCollisionHook collisionHook, Map<String, String> configuration) {
        this(collisionHook, configuration, new DummyResolverHookFactory());
    }

    public DummyContainerAdaptor(ModuleCollisionHook collisionHook, Map<String, String> configuration, ResolverHookFactory resolverHookFactory) {
        this(collisionHook, configuration, resolverHookFactory, null);
    }

    public DummyContainerAdaptor(ModuleCollisionHook collisionHook, Map<String, String> configuration, ResolverHookFactory resolverHookFactory, DebugOptions debugOptions) {
        this.collisionHook = collisionHook;
        this.configuration = configuration;
        this.resolverHookFactory = resolverHookFactory;
        this.moduleDatabase = new DummyModuleDatabase(this);
        this.debugOptions = debugOptions;
        this.container = new ModuleContainer((ModuleContainerAdaptor)this, (ModuleDatabase)this.moduleDatabase);
    }

    public ModuleCollisionHook getModuleCollisionHook() {
        return this.collisionHook;
    }

    public ResolverHookFactory getResolverHookFactory() {
        return this.resolverHookFactory;
    }

    public void publishContainerEvent(ModuleContainerAdaptor.ContainerEvent type, Module module, Throwable error, FrameworkListener ... listeners) {
        this.moduleDatabase.addEvent(new DummyModuleDatabase.DummyContainerEvent(type, module, error, listeners));
    }

    public String getProperty(String key) {
        return this.configuration.get(key);
    }

    public Module createModule(String location, long id, EnumSet<Module.Settings> settings, int startlevel) {
        return new DummyModule(id, location, this.container, settings, startlevel);
    }

    public SystemModule createSystemModule() {
        return new DummySystemModule(this.container);
    }

    public ModuleContainer getContainer() {
        return this.container;
    }

    public DummyModuleDatabase getDatabase() {
        return this.moduleDatabase;
    }

    public void setSlowdownEvents(boolean slowdown) {
        this.slowdownEvents.set(slowdown);
    }

    public void publishModuleEvent(ModuleContainerAdaptor.ModuleEvent type, Module module, Module origin) {
        if (type == ModuleContainerAdaptor.ModuleEvent.STARTING && this.slowdownEvents.get()) {
            try {
                Thread.sleep(6000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.moduleDatabase.addEvent(new DummyModuleDatabase.DummyModuleEvent(module, type, module.getState()));
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void setResolverExecutor(Executor executor) {
        this.resolverExecutor = executor;
    }

    public Executor getResolverExecutor() {
        Executor current = this.resolverExecutor;
        if (current != null) {
            return current;
        }
        return super.getResolverExecutor();
    }

    public void setTimeoutExecutor(ScheduledExecutorService timeoutExecutor) {
        this.timeoutExecutor = timeoutExecutor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.timeoutExecutor;
    }
}

