/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.debugoptions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.osgi.internal.debug.FrameworkDebugOptions;
import org.eclipse.osgi.internal.debug.FrameworkDebugTraceEntry;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class DebugOptionsTestCase
extends CoreTest {
    DebugOptions debugOptions;
    ServiceReference ref;
    Dictionary props = null;
    TestDebugOptionsListener listener = null;
    ServiceRegistration reg = null;
    private static final String TRACE_ELEMENT_DELIMITER = "|";
    private static final String TRACE_ELEMENT_DELIMITER_ENCODED = "&#124;";
    private static final SimpleDateFormat TRACE_FILE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String LINE_SEPARATOR;
    private boolean verboseDebug = true;
    private static final String TAB_CHARACTER = "\t";

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
    }

    public static Test suite() {
        return new TestSuite(DebugOptionsTestCase.class);
    }

    protected void setUp() throws Exception {
        this.ref = OSGiTestsActivator.getContext().getServiceReference(DebugOptions.class.getName());
        DebugOptionsTestCase.assertNotNull((String)"DebugOptions service is not available", (Object)this.ref);
        this.debugOptions = (DebugOptions)OSGiTestsActivator.getContext().getService(this.ref);
        DebugOptionsTestCase.assertNotNull((String)"DebugOptions service is not available", (Object)this.debugOptions);
        this.props = new Hashtable();
        this.props.put("listener.symbolic.name", this.getName());
        this.listener = new TestDebugOptionsListener();
        this.reg = OSGiTestsActivator.getContext().registerService(DebugOptionsListener.class.getName(), (Object)this.listener, this.props);
    }

    protected void tearDown() throws Exception {
        if (this.debugOptions == null) {
            return;
        }
        this.debugOptions.setDebugEnabled(false);
        this.debugOptions = null;
        OSGiTestsActivator.getContext().ungetService(this.ref);
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    public void testRegistration01() {
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
    }

    public void testTracingEntry01() {
        String bundleName = OSGiTestsActivator.getContext().getBundle().getSymbolicName();
        String optionPath = "/debug";
        String message = "Test message";
        FrameworkDebugTraceEntry traceEntry = new FrameworkDebugTraceEntry(bundleName, optionPath, message, null);
        String correctClassName = "org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase";
        String correctMethodName = "testTracingEntry01";
        DebugOptionsTestCase.assertEquals((String)"The class calling the trace API does not match the expected value.", (String)correctClassName, (String)traceEntry.getClassName());
        DebugOptionsTestCase.assertEquals((String)"The method calling the trace API does not match the expected value.", (String)correctMethodName, (String)traceEntry.getMethodName());
    }

    public void testTracingEntry02() {
        String correctClassName = Runner1.class.getName();
        String correctMethodName = "run";
        FrameworkDebugTraceEntry traceEntry = new Runner1().run();
        DebugOptionsTestCase.assertEquals((String)"The class calling the trace API does not match the expected value.", (String)correctClassName, (String)traceEntry.getClassName());
        DebugOptionsTestCase.assertEquals((String)"The method calling the trace API does not match the expected value.", (String)correctMethodName, (String)traceEntry.getMethodName());
    }

    public void testDyanmicEnablement01() {
        if (this.debugOptions.isDebugEnabled()) {
            return;
        }
        this.debugOptions.setDebugEnabled(true);
        DebugOptionsTestCase.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        this.listener.clear();
        HashMap<String, String> checkValues = new HashMap<String, String>();
        checkValues.put(String.valueOf(this.getName()) + "/debug", "true");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setOption(String.valueOf(this.getName()) + "/debug", "true");
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        DebugOptionsTestCase.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
    }

    public void testDyanmicEnablement02() {
        if (this.debugOptions.isDebugEnabled()) {
            return;
        }
        this.debugOptions.setDebugEnabled(true);
        DebugOptionsTestCase.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        this.listener.clear();
        HashMap<String, String> checkValues = new HashMap<String, String>();
        checkValues.put(String.valueOf(this.getName()) + "/debug", "false");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setOption(String.valueOf(this.getName()) + "/debug", "true");
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        DebugOptionsTestCase.assertNotNull((String)("Should find bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
    }

    public void testDyanmicEnablement03() {
        this.listener.clear();
        if (this.debugOptions.isDebugEnabled()) {
            return;
        }
        TestDebugOptionsListener anotherListener = new TestDebugOptionsListener();
        Hashtable<String, String> anotherProps = new Hashtable<String, String>();
        ((Dictionary)anotherProps).put("listener.symbolic.name", "anotherListener");
        ServiceRegistration anotherReg = OSGiTestsActivator.getContext().registerService(DebugOptionsListener.class.getName(), (Object)anotherListener, anotherProps);
        DebugOptionsTestCase.assertTrue((String)"Not called", (boolean)anotherListener.gotCalled());
        this.debugOptions.setDebugEnabled(true);
        DebugOptionsTestCase.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        this.listener.clear();
        anotherListener.clear();
        HashMap<String, String> checkValues = new HashMap<String, String>();
        checkValues.put(String.valueOf(this.getName()) + "/debug", "true");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setOption(String.valueOf(this.getName()) + "/debug", "true");
        DebugOptionsTestCase.assertFalse((String)"Should not call wrong listener", (boolean)anotherListener.gotCalled());
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        DebugOptionsTestCase.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
        this.listener.clear();
        anotherListener.clear();
        this.debugOptions.setOption("anotherListener/test", "blah");
        DebugOptionsTestCase.assertFalse((String)"Listener should not have been called", (boolean)this.listener.gotCalled());
        DebugOptionsTestCase.assertTrue((String)"Another listener should have been called", (boolean)anotherListener.gotCalled());
        this.listener.clear();
        anotherListener.clear();
        ((Dictionary)anotherProps).put("listener.symbolic.name", this.getName());
        anotherReg.setProperties(anotherProps);
        this.debugOptions.setOption(String.valueOf(this.getName()) + "/debug", "false");
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        DebugOptionsTestCase.assertTrue((String)"Another listener did not get called", (boolean)anotherListener.gotCalled());
        anotherReg.unregister();
    }

    public void testDyanmicEnablement04() {
        if (this.debugOptions.isDebugEnabled()) {
            return;
        }
        this.debugOptions.setDebugEnabled(true);
        this.listener.clear();
        DebugOptionsTestCase.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        HashMap<String, String> checkValues = new HashMap<String, String>();
        checkValues.put(String.valueOf(this.getName()) + "/debug", "true");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setOption(String.valueOf(this.getName()) + "/debug", "true");
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        DebugOptionsTestCase.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
        this.listener.clear();
        checkValues.put(String.valueOf(this.getName()) + "/debug", null);
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setDebugEnabled(false);
        DebugOptionsTestCase.assertFalse((String)"Debug is enabled", (boolean)this.debugOptions.isDebugEnabled());
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        DebugOptionsTestCase.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
        this.listener.clear();
        checkValues.put(String.valueOf(this.getName()) + "/debug", "true");
        this.listener.setCheckValues(checkValues);
        this.debugOptions.setDebugEnabled(true);
        DebugOptionsTestCase.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called", (boolean)this.listener.gotCalled());
        DebugOptionsTestCase.assertNull((String)("Found bad value: " + this.listener.getIncorrectValue()), (Object)this.listener.getIncorrectValue());
    }

    public void testBatchSetOptionsWhenEnabled() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String key1 = String.valueOf(this.getName()) + "/debug/disableCheck1";
        String key2 = String.valueOf(this.getName()) + "/debug/disableCheck2";
        String key3 = String.valueOf(this.getName()) + "/debug/disableCheck3";
        HashMap<String, String> newOptions = new HashMap<String, String>();
        newOptions.put(key1, "ok1");
        newOptions.put(key2, "ok2");
        newOptions.put(key3, "ok3");
        this.listener.clear();
        this.debugOptions.setOptions(newOptions);
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called when setting batch options when tracing is enabled", (boolean)this.listener.gotCalled());
        Map currentOptions = this.debugOptions.getOptions();
        DebugOptionsTestCase.assertNotSame((String)"The Map object set is the exact same Map object returned", newOptions, (Object)currentOptions);
        DebugOptionsTestCase.assertEquals((String)"The amount of options retrieved is not correct", (int)newOptions.size(), (int)currentOptions.size());
        String actualValue = (String)currentOptions.get(key1);
        DebugOptionsTestCase.assertEquals((String)"The original option for key1 does not match the retrieved option when tracing is enabled", (String)"ok1", (String)actualValue);
        actualValue = (String)currentOptions.get(key2);
        DebugOptionsTestCase.assertEquals((String)"The original option for key1 does not match the retrieved option when tracing is enabled", (String)"ok2", (String)actualValue);
        actualValue = (String)currentOptions.get(key3);
        DebugOptionsTestCase.assertEquals((String)"The original option for key1 does not match the retrieved option when tracing is enabled", (String)"ok3", (String)actualValue);
        String key4 = String.valueOf(this.getName()) + "/debug/disableCheck4";
        String key5 = String.valueOf(this.getName()) + "/debug/disableCheck5";
        String key6 = String.valueOf(this.getName()) + "/debug/disableCheck6";
        HashMap<String, String> newOptions2 = new HashMap<String, String>();
        newOptions2.put(key4, "ok4");
        newOptions2.put(key5, "ok5");
        newOptions2.put(key6, "ok6");
        this.listener.clear();
        this.debugOptions.setOptions(newOptions2);
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called when setting batch options when tracing is enabled", (boolean)this.listener.gotCalled());
        Map currentOptions2 = this.debugOptions.getOptions();
        DebugOptionsTestCase.assertNotSame((String)"The Map object set is the exact same Map object returned", newOptions, (Object)currentOptions2);
        DebugOptionsTestCase.assertEquals((String)"The amount of options retrieved is not correct", (int)newOptions.size(), (int)currentOptions2.size());
        actualValue = (String)currentOptions2.get(key1);
        DebugOptionsTestCase.assertNull((String)"The original option for key1 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key2);
        DebugOptionsTestCase.assertNull((String)"The original option for key2 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key3);
        DebugOptionsTestCase.assertNull((String)"The original option for key3 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key4);
        DebugOptionsTestCase.assertEquals((String)"The new option for key4 does not match the retrieved option when tracing is enabled", (String)"ok4", (String)actualValue);
        actualValue = (String)currentOptions2.get(key5);
        DebugOptionsTestCase.assertEquals((String)"The new option for key5 does not match the retrieved option when tracing is enabled", (String)"ok5", (String)actualValue);
        actualValue = (String)currentOptions2.get(key6);
        DebugOptionsTestCase.assertEquals((String)"The new option for key6 does not match the retrieved option when tracing is enabled", (String)"ok6", (String)actualValue);
    }

    public void testSetNullOptions() {
        boolean exceptionThrown = false;
        try {
            this.debugOptions.setOptions(null);
        }
        catch (Exception exception) {
            exceptionThrown = true;
        }
        DebugOptionsTestCase.assertTrue((String)"An exception was not thrown when calling setOptions() with a null parameter", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.debugOptions.setOption("key", null);
        }
        catch (Exception exception) {
            exceptionThrown = true;
        }
        DebugOptionsTestCase.assertTrue((String)"An exception was not thrown when calling setOption() with a null value", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.debugOptions.setOption(null, "value");
        }
        catch (Exception exception) {
            exceptionThrown = true;
        }
        DebugOptionsTestCase.assertTrue((String)"An exception was not thrown when calling setOption() with a null key", (boolean)exceptionThrown);
    }

    public void testBatchSetOptionsWhenDisabled() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String key1 = String.valueOf(this.getName()) + "/debug/disableCheck1";
        String key2 = String.valueOf(this.getName()) + "/debug/disableCheck2";
        String key3 = String.valueOf(this.getName()) + "/debug/disableCheck3";
        HashMap<String, String> newOptions = new HashMap<String, String>();
        newOptions.put(key1, "ok1");
        newOptions.put(key2, "ok2");
        newOptions.put(key3, "ok3");
        this.listener.clear();
        this.debugOptions.setOptions(newOptions);
        DebugOptionsTestCase.assertTrue((String)"Listener did not get called when setting batch options when tracing is enabled", (boolean)this.listener.gotCalled());
        this.debugOptions.setDebugEnabled(false);
        Map currentOptions = this.debugOptions.getOptions();
        DebugOptionsTestCase.assertNotSame((String)"The Map object retrieved is the exact same Map object returned when tracing is disabled.", newOptions, (Object)currentOptions);
        DebugOptionsTestCase.assertEquals((String)"The amount of options retrieved is not the same after tracing is disabled", (int)newOptions.size(), (int)currentOptions.size());
        String actualValue = (String)currentOptions.get(key1);
        DebugOptionsTestCase.assertNotNull((String)"The value for key1 is null", (Object)actualValue);
        DebugOptionsTestCase.assertEquals((String)"The original option for key1 does not match the retrieved option when tracing is disabled", (String)"ok1", (String)actualValue);
        actualValue = (String)currentOptions.get(key2);
        DebugOptionsTestCase.assertNotNull((String)"The value for key2 is null", (Object)actualValue);
        DebugOptionsTestCase.assertEquals((String)"The original option for key2 does not match the retrieved option when tracing is disabled", (String)"ok2", (String)actualValue);
        actualValue = (String)currentOptions.get(key3);
        DebugOptionsTestCase.assertNotNull((String)"The value for key3 is null", (Object)actualValue);
        DebugOptionsTestCase.assertEquals((String)"The original option for key3 does not match the retrieved option when tracing is disabled", (String)"ok3", (String)actualValue);
        String key4 = String.valueOf(this.getName()) + "/debug/disableCheck4";
        String key5 = String.valueOf(this.getName()) + "/debug/disableCheck5";
        String key6 = String.valueOf(this.getName()) + "/debug/disableCheck6";
        HashMap<String, String> newOptions2 = new HashMap<String, String>();
        newOptions2.put(key4, "ok4");
        newOptions2.put(key5, "ok5");
        newOptions2.put(key6, "ok6");
        this.listener.clear();
        this.debugOptions.setOptions(newOptions2);
        DebugOptionsTestCase.assertFalse((String)"Listener got called when settings batch options with tracing disabled", (boolean)this.listener.gotCalled());
        Map currentOptions2 = this.debugOptions.getOptions();
        DebugOptionsTestCase.assertNotSame((String)"The Map object set is the exact same Map object returned", newOptions, (Object)currentOptions2);
        DebugOptionsTestCase.assertEquals((String)"The amount of options retrieved is not correct", (int)newOptions.size(), (int)currentOptions2.size());
        actualValue = (String)currentOptions2.get(key1);
        DebugOptionsTestCase.assertNull((String)"The original option for key1 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key2);
        DebugOptionsTestCase.assertNull((String)"The original option for key2 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key3);
        DebugOptionsTestCase.assertNull((String)"The original option for key3 is in the returned options (it should not be there)", (Object)actualValue);
        actualValue = (String)currentOptions2.get(key4);
        DebugOptionsTestCase.assertEquals((String)"The new option for key4 does not match the retrieved option when tracing is disabled", (String)"ok4", (String)actualValue);
        actualValue = (String)currentOptions2.get(key5);
        DebugOptionsTestCase.assertEquals((String)"The new option for key5 does not match the retrieved option when tracing is disabled", (String)"ok5", (String)actualValue);
        actualValue = (String)currentOptions2.get(key6);
        DebugOptionsTestCase.assertEquals((String)"The new option for key6 does not match the retrieved option when tracing is disabled", (String)"ok6", (String)actualValue);
    }

    public void testSetOptionsWhenDisabled() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String testKey = String.valueOf(this.getName()) + "/debug/disableCheck";
        this.debugOptions.setOption(testKey, "ok");
        String actualValue = this.debugOptions.getOption(testKey, "not ok");
        DebugOptionsTestCase.assertEquals((String)("The correct option value was not returned from the debug option: " + testKey), (String)"ok", (String)actualValue);
        this.debugOptions.setDebugEnabled(false);
        actualValue = this.debugOptions.getOption(testKey, "not ok");
        DebugOptionsTestCase.assertEquals((String)"The 'default' value supplied was not returned when tracing is disabled.", (String)"not ok", (String)actualValue);
        this.debugOptions.setOption(testKey, "ok");
        actualValue = this.debugOptions.getOption(testKey, "not ok");
        DebugOptionsTestCase.assertEquals((String)"The 'default' value supplied was not returned when tracing is disabled.", (String)"not ok", (String)actualValue);
        this.debugOptions.removeOption(testKey);
        this.debugOptions.setDebugEnabled(true);
        actualValue = this.debugOptions.getOption(testKey, "not ok");
        DebugOptionsTestCase.assertEquals((String)"The value after re-enabling tracing is invalid.", (String)"ok", (String)actualValue);
    }

    public void testStringValues() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String testKey = String.valueOf(this.getName()) + "/debug/stringValue";
        this.debugOptions.setOption(testKey, "test");
        String actualValue = this.debugOptions.getOption(testKey, "default");
        DebugOptionsTestCase.assertEquals((String)("The correct option value was not returned from the debug option: " + testKey), (String)"test", (String)actualValue);
        this.debugOptions.removeOption(testKey);
        actualValue = this.debugOptions.getOption(testKey, "default");
        DebugOptionsTestCase.assertEquals((String)"The 'default' value supplied was not returned when the key does not exist in the DebugOptions.", (String)"default", (String)actualValue);
    }

    public void testIntegerValues() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String testKey = String.valueOf(this.getName()) + "/debug/intValue";
        this.debugOptions.setOption(testKey, "42");
        int actualValue = this.debugOptions.getIntegerOption(testKey, 0);
        DebugOptionsTestCase.assertEquals((String)("The correct option value was not returned from the debug option: " + testKey), (int)42, (int)actualValue);
        this.debugOptions.setOption(testKey, "test");
        actualValue = this.debugOptions.getIntegerOption(testKey, 0);
        DebugOptionsTestCase.assertEquals((String)"The 'default' value supplied was not returned when a NumberFormatException occurs.", (int)0, (int)actualValue);
        this.debugOptions.removeOption(testKey);
        actualValue = this.debugOptions.getIntegerOption(testKey, 0);
        DebugOptionsTestCase.assertEquals((String)"The 'default' value supplied was not returned when the key does not exist in the DebugOptions.", (int)0, (int)actualValue);
    }

    public void testBooleanValues() {
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        String testKey = String.valueOf(this.getName()) + "/debug";
        boolean testValue = this.debugOptions.getBooleanOption(testKey, false);
        DebugOptionsTestCase.assertFalse((String)(String.valueOf(testKey) + " is true"), (boolean)testValue);
        this.debugOptions.setOption(testKey, "false");
        testValue = this.debugOptions.getBooleanOption(testKey, true);
        DebugOptionsTestCase.assertFalse((String)(String.valueOf(testKey) + " is true"), (boolean)testValue);
        this.debugOptions.setOption(testKey, "true");
        testValue = this.debugOptions.getBooleanOption(testKey, false);
        DebugOptionsTestCase.assertTrue((String)(String.valueOf(testKey) + " is false"), (boolean)testValue);
        testValue = this.debugOptions.getBooleanOption(testKey, true);
        DebugOptionsTestCase.assertTrue((String)(String.valueOf(testKey) + " is false"), (boolean)testValue);
    }

    private TestDebugTrace createDebugTrace(File traceFile) {
        TestDebugTrace debugTrace = null;
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
            DebugOptionsTestCase.assertTrue((String)"Debug is not enabled", (boolean)this.debugOptions.isDebugEnabled());
        }
        this.debugOptions.setOption(String.valueOf(this.getName()) + "/debug", "true");
        this.debugOptions.setFile(traceFile);
        DebugTrace wrapped = this.debugOptions.newDebugTrace(this.getName(), TestDebugTrace.class);
        debugTrace = new TestDebugTrace(wrapped);
        return debugTrace;
    }

    public void testVerboseDebugging() {
        FrameworkDebugOptions fwDebugOptions = (FrameworkDebugOptions)this.debugOptions;
        if (!this.debugOptions.isDebugEnabled()) {
            this.debugOptions.setDebugEnabled(true);
        }
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            fwDebugOptions.setVerbose(false);
            debugTrace.trace("/debug", "testing 1", new Exception("An error 1"));
            fwDebugOptions.setVerbose(true);
            debugTrace.trace("/debug", "testing 2");
            fwDebugOptions.setVerbose(false);
            debugTrace.trace("/debug", "testing 3");
            debugTrace.traceEntry("/debug");
            debugTrace.traceEntry("/debug", "arg");
            debugTrace.traceEntry("/debug", new String[]{"arg1", "arg2"});
            debugTrace.traceExit("/debug");
            debugTrace.traceExit("/debug", "returnValue");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.trace(option, message)' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries", (int)8, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[0].getThreadName());
        DebugOptionsTestCase.assertNull((String)"A bundle was found when it should be null", (Object)traceOutput[0].getBundleSymbolicName());
        DebugOptionsTestCase.assertNull((String)"A class name was found when it should be null", (Object)traceOutput[0].getClassName());
        DebugOptionsTestCase.assertNull((String)"A method name was found when it should be null", (Object)traceOutput[0].getMethodName());
        DebugOptionsTestCase.assertTrue((String)"A line number other than -1 was read in", (traceOutput[0].getLineNumber() == -1 ? 1 : 0) != 0);
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"testing 1", (String)traceOutput[0].getMessage());
        StringBuffer expectedThrowableText1 = new StringBuffer("java.lang.Exception: ");
        expectedThrowableText1.append("An error 1");
        expectedThrowableText1.append(LINE_SEPARATOR);
        expectedThrowableText1.append(TAB_CHARACTER);
        expectedThrowableText1.append("at org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase.testVerboseDebugging(DebugOptionsTestCase.java:");
        if (!traceOutput[0].getThrowableText().startsWith(expectedThrowableText1.toString())) {
            StringBuffer errorMessage = new StringBuffer("The expected throwable text does not start with the actual throwable text.");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Expected");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(expectedThrowableText1.toString());
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Actual");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(traceOutput[0].getThrowableText());
            DebugOptionsTestCase.fail((String)errorMessage.toString());
        }
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[1].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[1].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[1].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[1].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testVerboseDebugging", (String)traceOutput[1].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"testing 2", (String)traceOutput[1].getMessage());
        DebugOptionsTestCase.assertNull((String)"The throwable text was found when it should be null", (Object)traceOutput[1].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[2].getThreadName());
        DebugOptionsTestCase.assertNull((String)"A bundle was found when it should be null", (Object)traceOutput[2].getBundleSymbolicName());
        DebugOptionsTestCase.assertNull((String)"A class name was found when it should be null", (Object)traceOutput[2].getClassName());
        DebugOptionsTestCase.assertNull((String)"A method name was found when it should be null", (Object)traceOutput[2].getMethodName());
        DebugOptionsTestCase.assertTrue((String)"A line number other than -1 was read in", (traceOutput[2].getLineNumber() == -1 ? 1 : 0) != 0);
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"testing 3", (String)traceOutput[2].getMessage());
        DebugOptionsTestCase.assertNull((String)"The throwable text was found when it should be null", (Object)traceOutput[2].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"Entering method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with no parameters", (String)traceOutput[3].getMessage());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"Entering method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with parameters: (arg)", (String)traceOutput[4].getMessage());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"Entering method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with parameters: (arg1 arg2)", (String)traceOutput[5].getMessage());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"Exiting method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with a void return", (String)traceOutput[6].getMessage());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"Exiting method org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase#testVerboseDebugging with result: returnValue", (String)traceOutput[7].getMessage());
        traceFile.delete();
        fwDebugOptions.setVerbose(true);
    }

    public void testTraceFile01() {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.trace("/debug", "testing 1");
            debugTrace.trace("/notset", "testing 2");
            debugTrace.trace("/debug", "testing 3");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.trace(option, message)' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[0].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[0].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[0].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[0].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile01", (String)traceOutput[0].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"testing 1", (String)traceOutput[0].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries for trace without an exception", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[1].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[1].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[1].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[1].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile01", (String)traceOutput[1].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"testing 3", (String)traceOutput[1].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    public void testTraceFile02() {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.trace("/debug", "testing 1", new Exception("An error 1"));
            debugTrace.trace("/notset", "testing 2", new Exception("An error 2"));
            debugTrace.trace("/debug", "testing 3", new Exception("An error 3"));
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.trace(option, message, Throwable)' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        StringBuffer expectedThrowableText1 = new StringBuffer("java.lang.Exception: ");
        expectedThrowableText1.append("An error 1");
        expectedThrowableText1.append(LINE_SEPARATOR);
        expectedThrowableText1.append(TAB_CHARACTER);
        expectedThrowableText1.append("at org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase.testTraceFile02(DebugOptionsTestCase.java:");
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[0].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[0].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[0].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[0].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile02", (String)traceOutput[0].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"testing 1", (String)traceOutput[0].getMessage());
        DebugOptionsTestCase.assertNotNull((String)"throwable text should not be null", (Object)traceOutput[0].getThrowableText());
        if (!traceOutput[0].getThrowableText().startsWith(expectedThrowableText1.toString())) {
            StringBuffer errorMessage = new StringBuffer("The expected throwable text does not start with the actual throwable text.");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Expected");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(expectedThrowableText1.toString());
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Actual");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(traceOutput[0].getThrowableText());
            DebugOptionsTestCase.fail((String)errorMessage.toString());
        }
        DebugOptionsTestCase.assertNotNull((String)"throwable should not be null", (Object)traceOutput[0].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries for trace without an exception", (int)2, (int)traceOutput.length);
        StringBuffer expectedThrowableText2 = new StringBuffer("java.lang.Exception: ");
        expectedThrowableText2.append("An error 3");
        expectedThrowableText2.append(LINE_SEPARATOR);
        expectedThrowableText2.append(TAB_CHARACTER);
        expectedThrowableText2.append("at org.eclipse.osgi.tests.debugoptions.DebugOptionsTestCase.testTraceFile02(DebugOptionsTestCase.java:");
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[1].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[1].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[1].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[1].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile02", (String)traceOutput[1].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"trace message is incorrect", (String)"testing 3", (String)traceOutput[1].getMessage());
        DebugOptionsTestCase.assertNotNull((String)"throwable text should not be null", (Object)traceOutput[1].getThrowableText());
        if (!traceOutput[1].getThrowableText().startsWith(expectedThrowableText2.toString())) {
            StringBuffer errorMessage = new StringBuffer("The expected throwable text does not start with the actual throwable text.");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Expected");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(expectedThrowableText2.toString());
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("Actual");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append("--------");
            errorMessage.append(LINE_SEPARATOR);
            errorMessage.append(traceOutput[1].getThrowableText());
            DebugOptionsTestCase.fail((String)errorMessage.toString());
        }
        DebugOptionsTestCase.assertNotNull((String)"throwable should not be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    public void testTraceFile03() {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceDumpStack("/debug");
            debugTrace.traceDumpStack("/notset");
            debugTrace.traceDumpStack("/debug");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.traceDumpStack(option)' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[0].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[0].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[0].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[0].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile03", (String)traceOutput[0].getMethodName());
        DebugOptionsTestCase.assertTrue((String)"Trace message is not a stack dump", (boolean)traceOutput[0].getMessage().startsWith("Thread Stack dump: "));
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries for trace without an exception", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[1].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[1].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[1].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[1].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile03", (String)traceOutput[1].getMethodName());
        DebugOptionsTestCase.assertTrue((String)"Trace message is not a stack dump", (boolean)traceOutput[1].getMessage().startsWith("Thread Stack dump: "));
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    public void testTraceFile04() {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceEntry("/debug");
            debugTrace.traceEntry("/notset");
            debugTrace.traceEntry("/debug");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.traceEntry(option)' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[0].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[0].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[0].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[0].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile04", (String)traceOutput[0].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Entering method with no parameters", (String)traceOutput[0].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries for trace without an exception", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[1].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[1].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[1].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[1].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile04", (String)traceOutput[1].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Entering method with no parameters", (String)traceOutput[1].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    public void testTraceFile05() {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceEntry("/debug", new String("arg1"));
            debugTrace.traceEntry("/notset", new String("arg2"));
            debugTrace.traceEntry("/debug", new String("arg3"));
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.traceEntry(option, methodArgument)' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[0].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[0].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[0].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[0].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile05", (String)traceOutput[0].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Entering method with parameters: (arg1)", (String)traceOutput[0].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries for trace without an exception", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[1].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[1].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[1].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[1].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile05", (String)traceOutput[1].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Entering method with parameters: (arg3)", (String)traceOutput[1].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    public void testTraceFile06() {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceEntry("/debug", new String[]{"arg1", "arg2"});
            debugTrace.traceEntry("/notset", new String[]{"arg3", "arg4"});
            debugTrace.traceEntry("/debug", new String[]{"arg5", "arg6"});
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.traceEntry(option, methodArgument[])' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[0].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[0].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[0].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[0].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile06", (String)traceOutput[0].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Entering method with parameters: (arg1 arg2)", (String)traceOutput[0].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries for trace without an exception", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[1].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[1].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[1].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[1].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile06", (String)traceOutput[1].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Entering method with parameters: (arg5 arg6)", (String)traceOutput[1].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    public void testTraceFile07() {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceExit("/debug");
            debugTrace.traceExit("/notset");
            debugTrace.traceExit("/debug");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.traceExit(option)' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[0].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[0].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[0].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[0].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile07", (String)traceOutput[0].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Exiting method with a void return", (String)traceOutput[0].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries for trace without an exception", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[1].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[1].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[1].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[1].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile07", (String)traceOutput[1].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Exiting method with a void return", (String)traceOutput[1].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    public void testTraceFile08() {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.traceExit("/debug", new String("returnValue1"));
            debugTrace.traceExit("/notset", new String("returnValue2"));
            debugTrace.traceExit("/debug", new String("returnValue3"));
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.traceExit(option, result)' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[0].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[0].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[0].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[0].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile08", (String)traceOutput[0].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Exiting method with result: returnValue1", (String)traceOutput[0].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[0].getThrowableText());
        DebugOptionsTestCase.assertEquals((String)"Wrong number of trace entries for trace without an exception", (int)2, (int)traceOutput.length);
        DebugOptionsTestCase.assertEquals((String)"Thread name is incorrect", (String)Thread.currentThread().getName(), (String)traceOutput[1].getThreadName());
        DebugOptionsTestCase.assertEquals((String)"Bundle name is incorrect", (String)this.getName(), (String)traceOutput[1].getBundleSymbolicName());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)traceOutput[1].getOptionPath());
        DebugOptionsTestCase.assertEquals((String)"class name value is incorrect", (String)DebugOptionsTestCase.class.getName(), (String)traceOutput[1].getClassName());
        DebugOptionsTestCase.assertEquals((String)"method name value is incorrect", (String)"testTraceFile08", (String)traceOutput[1].getMethodName());
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Exiting method with result: returnValue3", (String)traceOutput[1].getMessage());
        DebugOptionsTestCase.assertNull((String)"throwable should be null", (Object)traceOutput[1].getThrowableText());
        traceFile.delete();
    }

    public void testTraceFile09() {
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        TestDebugTrace debugTrace = this.createDebugTrace(traceFile);
        this.debugOptions.setOption(String.valueOf(this.getName()) + "/debug|path", "true");
        TraceEntry[] traceOutput = null;
        try {
            debugTrace.trace("/debug|path", "A message with a | character.");
            debugTrace.trace("/debug|path", "|A message with | multiple || characters.|");
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry invalidEx) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.trace(option, message)' test as an invalid trace entry was found.  Actual Value: '" + invalidEx.getActualValue() + "'."), (Throwable)invalidEx);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of entries", (int)2, (int)traceOutput.length);
        String optionPath = DebugOptionsTestCase.decodeString(traceOutput[0].getOptionPath());
        String message = DebugOptionsTestCase.decodeString(traceOutput[0].getMessage());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug|path", (String)optionPath);
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"A message with a | character.", (String)message);
        optionPath = DebugOptionsTestCase.decodeString(traceOutput[1].getOptionPath());
        message = DebugOptionsTestCase.decodeString(traceOutput[1].getMessage());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug|path", (String)optionPath);
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"|A message with | multiple || characters.|", (String)message);
        traceFile.delete();
    }

    public void testTraceSystemOut() throws IOException {
        PrintStream old = System.out;
        File traceFile = OSGiTestsActivator.getContext().getDataFile(String.valueOf(this.getName()) + ".trace");
        OutputStream out = new FileOutputStream(traceFile);
        final AtomicReference<Boolean> closed = new AtomicReference<Boolean>(Boolean.FALSE);
        out = new FilterOutputStream(out){

            @Override
            public void close() throws IOException {
                super.close();
                closed.set(Boolean.TRUE);
            }
        };
        System.setOut(new PrintStream(out));
        try {
            TestDebugTrace debugTrace = this.createDebugTrace(new File("/does/not/exist/trace.out"));
            this.debugOptions.setOption(String.valueOf(this.getName()) + "/debug", "true");
            debugTrace.trace("/debug", "A message to System.out.");
            debugTrace.trace("/debug", "Another message.");
            DebugOptionsTestCase.assertFalse((String)"Closed System.out.", (boolean)closed.get());
        }
        finally {
            System.setOut(old);
            out.close();
        }
        TraceEntry[] traceOutput = null;
        try {
            traceOutput = this.readTraceFile(traceFile);
        }
        catch (InvalidTraceEntry e) {
            DebugOptionsTestCase.fail((String)("Failed 'DebugTrace.trace(option, message)' test as an invalid trace entry was found.  Actual Value: '" + e.getActualValue() + "'."), (Throwable)e);
        }
        DebugOptionsTestCase.assertEquals((String)"Wrong number of entries", (int)2, (int)traceOutput.length);
        String optionPath = DebugOptionsTestCase.decodeString(traceOutput[0].getOptionPath());
        String message = DebugOptionsTestCase.decodeString(traceOutput[0].getMessage());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)optionPath);
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"A message to System.out.", (String)message);
        optionPath = DebugOptionsTestCase.decodeString(traceOutput[1].getOptionPath());
        message = DebugOptionsTestCase.decodeString(traceOutput[1].getMessage());
        DebugOptionsTestCase.assertEquals((String)"option-path value is incorrect", (String)"/debug", (String)optionPath);
        DebugOptionsTestCase.assertEquals((String)"Trace message is not correct", (String)"Another message.", (String)message);
        traceFile.delete();
    }

    private static String decodeString(String inputString) {
        if (inputString == null || inputString.indexOf(TRACE_ELEMENT_DELIMITER_ENCODED) < 0) {
            return inputString;
        }
        StringBuffer tempBuffer = new StringBuffer(inputString);
        int currentIndex = tempBuffer.indexOf(TRACE_ELEMENT_DELIMITER_ENCODED);
        while (currentIndex >= 0) {
            tempBuffer.replace(currentIndex, currentIndex + TRACE_ELEMENT_DELIMITER_ENCODED.length(), TRACE_ELEMENT_DELIMITER);
            currentIndex = tempBuffer.indexOf(TRACE_ELEMENT_DELIMITER_ENCODED);
        }
        return tempBuffer.toString();
    }

    private TraceEntry[] readTraceFile(File traceFile) throws InvalidTraceEntry {
        ArrayList<TraceEntry> traceEntries;
        block15: {
            BufferedReader traceReader = null;
            traceEntries = new ArrayList<TraceEntry>();
            this.verboseDebug = true;
            try {
                try {
                    traceReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(traceFile), "UTF-8"));
                    TraceEntry entry = null;
                    while ((entry = this.readMessage(traceReader)) != null) {
                        traceEntries.add(entry);
                    }
                }
                catch (IOException ex) {
                    DebugOptionsTestCase.fail((String)"Failed to read trace file", (Throwable)ex);
                    if (traceReader != null) {
                        try {
                            traceReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (traceReader != null) {
                    try {
                        traceReader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (traceReader != null) {
                try {
                    traceReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return traceEntries.toArray(new TraceEntry[traceEntries.size()]);
    }

    private TraceEntry readMessage(BufferedReader traceReader) throws IOException, InvalidTraceEntry {
        TraceEntry result = null;
        int input = traceReader.read();
        while (input != -1) {
            char inputChar = (char)input;
            if (inputChar == '#') {
                String comment = traceReader.readLine();
                if (comment != null) {
                    comment = comment.trim();
                }
                if (comment.startsWith("verbose")) {
                    int splitIndex = comment.indexOf(58);
                    String verboseValue = comment.substring(splitIndex + 1, comment.length()).trim();
                    this.verboseDebug = Boolean.valueOf(verboseValue);
                }
            }
            if (inputChar == TRACE_ELEMENT_DELIMITER.charAt(0)) {
                String threadName = this.readEntry(traceReader);
                if (threadName == null || threadName.length() == 0) {
                    throw new InvalidTraceEntry("The thread name in a trace entry is null or empty", threadName);
                }
                String date = this.readEntry(traceReader);
                if (date == null || date.length() == 0) {
                    throw new InvalidTraceEntry("The timestamp in a trace entry is null or empty", date);
                }
                long timestamp = 0L;
                try {
                    timestamp = TRACE_FILE_DATE_FORMATTER.parse(date).getTime();
                }
                catch (ParseException parseException) {
                    throw new InvalidTraceEntry("The date in a trace entry '" + date + "' could not be parsed.", date);
                }
                String symbolicName = null;
                String optionPath = null;
                String className = null;
                String methodName = null;
                int lineNumber = -1;
                if (this.verboseDebug) {
                    symbolicName = this.readEntry(traceReader);
                    if (symbolicName == null || symbolicName.length() == 0) {
                        throw new InvalidTraceEntry("The bundle symbolic name in a trace entry is null or empty", symbolicName);
                    }
                    optionPath = this.readEntry(traceReader);
                    if (optionPath == null || optionPath.length() == 0) {
                        throw new InvalidTraceEntry("The option-path in a trace entry is null or empty", optionPath);
                    }
                    className = this.readEntry(traceReader);
                    if (className == null || className.length() == 0) {
                        throw new InvalidTraceEntry("The class name in a trace entry is null or empty", className);
                    }
                    methodName = this.readEntry(traceReader);
                    if (methodName == null || methodName.length() == 0) {
                        throw new InvalidTraceEntry("The method name in a trace entry is null or empty", methodName);
                    }
                    String lineNumberString = this.readEntry(traceReader);
                    if (lineNumberString == null || lineNumberString.length() == 0) {
                        throw new InvalidTraceEntry("The line number in a trace entry is null or empty", lineNumberString);
                    }
                    lineNumber = Integer.valueOf(lineNumberString);
                }
                String message = this.readEntry(traceReader);
                traceReader.mark(1);
                inputChar = (char)traceReader.read();
                String throwable = null;
                if (inputChar != '\n' && inputChar != '\r') {
                    traceReader.reset();
                    throwable = this.readEntry(traceReader);
                    if (throwable == null || throwable.length() == 0) {
                        throw new InvalidTraceEntry("The throwable in a trace entry is null or empty", throwable);
                    }
                }
                result = new TraceEntry(threadName, timestamp, symbolicName, optionPath, className, methodName, lineNumber, message, throwable);
                break;
            }
            input = traceReader.read();
        }
        return result;
    }

    private String readEntry(Reader traceReader) throws IOException {
        char inputChar = (char)traceReader.read();
        StringBuffer buffer = new StringBuffer();
        while (inputChar != TRACE_ELEMENT_DELIMITER.charAt(0)) {
            inputChar = (char)traceReader.read();
            if (inputChar == TRACE_ELEMENT_DELIMITER.charAt(0)) continue;
            buffer.append(inputChar);
        }
        return buffer.toString().trim();
    }

    static class InvalidTraceEntry
    extends Exception {
        private static final long serialVersionUID = -63837787081750344L;
        String actualValue;
        String expectedValue;

        public InvalidTraceEntry(String message, String actual) {
            super(message);
            this.actualValue = actual;
        }

        public final String getActualValue() {
            return this.actualValue;
        }
    }

    static class Runner1 {
        Runner1() {
        }

        public FrameworkDebugTraceEntry run() {
            return new Runner2().run();
        }
    }

    static class Runner2 {
        Runner2() {
        }

        public FrameworkDebugTraceEntry run() {
            String bundleName = OSGiTestsActivator.getContext().getBundle().getSymbolicName();
            String optionPath = "/debug";
            String message = "Test message";
            String tracingClass = this.getClass().getName();
            return new FrameworkDebugTraceEntry(bundleName, optionPath, message, tracingClass);
        }
    }

    class TestDebugOptionsListener
    implements DebugOptionsListener {
        boolean called = false;
        String incorrectValue;
        Map checkValues;

        TestDebugOptionsListener() {
        }

        public void optionsChanged(DebugOptions options) {
            this.called = true;
            if (this.checkValues == null) {
                return;
            }
            for (Map.Entry entry : this.checkValues.entrySet()) {
                String debugValue = options.getOption((String)entry.getKey());
                String error = "Value is incorrect for key: " + entry.getKey() + " " + debugValue;
                if (debugValue == null) {
                    if (entry.getValue() == null) continue;
                    this.incorrectValue = error;
                    return;
                }
                if (debugValue.equals(entry.getValue())) continue;
                this.incorrectValue = error;
                return;
            }
        }

        public boolean gotCalled() {
            return this.called;
        }

        public void clear() {
            this.called = false;
            this.checkValues = null;
            this.incorrectValue = null;
        }

        public void setCheckValues(Map checkValues) {
            this.checkValues = checkValues;
        }

        public String getIncorrectValue() {
            return this.incorrectValue;
        }
    }

    static class TestDebugTrace
    implements DebugTrace {
        private final DebugTrace wrapped;

        public TestDebugTrace(DebugTrace wrapped) {
            this.wrapped = wrapped;
        }

        public void trace(String option, String message) {
            this.wrapped.trace(option, message);
        }

        public void trace(String option, String message, Throwable error) {
            this.wrapped.trace(option, message, error);
        }

        public void traceDumpStack(String option) {
            this.wrapped.traceDumpStack(option);
        }

        public void traceEntry(String option) {
            this.wrapped.traceEntry(option);
        }

        public void traceEntry(String option, Object methodArgument) {
            this.wrapped.traceEntry(option, methodArgument);
        }

        public void traceEntry(String option, Object[] methodArguments) {
            this.wrapped.traceEntry(option, methodArguments);
        }

        public void traceExit(String option) {
            this.wrapped.traceExit(option);
        }

        public void traceExit(String option, Object result) {
            this.wrapped.traceExit(option, result);
        }
    }

    public static class TraceEntry {
        public static final String DEFAULT_OPTION_PATH = "/debug";
        private final String threadName;
        private final long timestamp;
        private final String optionPath;
        private final String bundleSymbolicName;
        private final String className;
        private String methodName = null;
        private final int lineNumber;
        private final String message;
        private final String throwableText;

        public TraceEntry(String traceThreadName, long traceTimestamp, String traceBundleName, String traceOptionPath, String traceClassName, String traceMethodName, int traceLineNumber, String traceMessage) {
            this.threadName = traceThreadName;
            this.bundleSymbolicName = traceBundleName;
            this.optionPath = traceOptionPath;
            this.className = traceClassName;
            this.methodName = traceMethodName;
            this.lineNumber = traceLineNumber;
            this.message = traceMessage;
            this.timestamp = traceTimestamp;
            this.throwableText = null;
        }

        public TraceEntry(String traceThreadName, long traceTimestamp, String traceBundleName, String traceOptionPath, String traceClassName, String traceMethodName, int traceLineNumber, String traceMessage, String traceThrowable) {
            this.threadName = traceThreadName;
            this.bundleSymbolicName = traceBundleName;
            this.optionPath = traceOptionPath;
            this.className = traceClassName;
            this.methodName = traceMethodName;
            this.lineNumber = traceLineNumber;
            this.message = traceMessage;
            this.timestamp = traceTimestamp;
            this.throwableText = traceThrowable;
        }

        public final String getThreadName() {
            return this.threadName;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final String getBundleSymbolicName() {
            return this.bundleSymbolicName;
        }

        public final String getMessage() {
            return this.message;
        }

        public final String getThrowableText() {
            return this.throwableText;
        }

        public final String getClassName() {
            return this.className;
        }

        public final String getMethodName() {
            return this.methodName;
        }

        public final String getOptionPath() {
            return this.optionPath;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }
    }
}

