/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.eclipseadaptor;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.framework.util.FilePath;
import org.eclipse.osgi.tests.OSGiTest;

public class FilePathTest
extends OSGiTest {
    public static Test suite() {
        return new TestSuite(FilePathTest.class);
    }

    public FilePathTest(String name) {
        super(name);
    }

    public void testColonOnPath() {
        FilePath path = new FilePath("/c:b/a");
        if (Platform.getOS().equals("win32")) {
            FilePathTest.assertTrue((String)"1.0", (!path.isAbsolute() ? 1 : 0) != 0);
            FilePathTest.assertEquals((String)"2.0", (String)"c:", (String)path.getDevice());
            String[] segments = path.getSegments();
            FilePathTest.assertEquals((String)"3.0", (int)2, (int)segments.length);
            FilePathTest.assertEquals((String)"3.1", (String)"b", (String)segments[0]);
            FilePathTest.assertEquals((String)"3.2", (String)"a", (String)segments[1]);
            return;
        }
        FilePathTest.assertTrue((String)"1.0", (boolean)path.isAbsolute());
        FilePathTest.assertNull((String)"2.0", (Object)path.getDevice());
        String[] segments = path.getSegments();
        FilePathTest.assertEquals((String)"3.0", (int)2, (int)segments.length);
        FilePathTest.assertEquals((String)"3.1", (String)"c:b", (String)segments[0]);
        FilePathTest.assertEquals((String)"3.2", (String)"a", (String)segments[1]);
    }
}

