/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.eclipseadaptor;

import java.util.Locale;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class LocaleTransformationTest {
    @Test
    public void testValidLanguageCountryVariant() {
        String localeString = "de_DE_EURO";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"de", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"DE", (Object)locale.getCountry());
        Assert.assertEquals((Object)"EURO", (Object)locale.getVariant());
    }

    @Test
    public void testValidLanguageCountry() {
        String localeString = "de_DE";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"de", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"DE", (Object)locale.getCountry());
        Assert.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testValidLanguage() {
        String localeString = "de";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"de", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"", (Object)locale.getCountry());
        Assert.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testValidCountry() {
        String localeString = "_DE";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"DE", (Object)locale.getCountry());
        Assert.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testValidLanguageVariant() {
        String localeString = "de__EURO";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"de", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"", (Object)locale.getCountry());
        Assert.assertEquals((Object)"EURO", (Object)locale.getVariant());
    }

    @Test
    public void testValidVariant() {
        String localeString = "__EURO";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"", (Object)locale.getCountry());
        Assert.assertEquals((Object)"EURO", (Object)locale.getVariant());
    }

    @Test
    public void testValidCountryVariant() {
        String localeString = "_DE_EURO";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"DE", (Object)locale.getCountry());
        Assert.assertEquals((Object)"EURO", (Object)locale.getVariant());
    }

    @Test
    public void testInvalidLanguage() {
        String localeString = "1234";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"en", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"", (Object)locale.getCountry());
        Assert.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testInvalidOneLetterLanguage() {
        String localeString = "a";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"en", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"", (Object)locale.getCountry());
        Assert.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testThreeLetterValidLanguage() {
        String localeString = "kok";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"kok", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"", (Object)locale.getCountry());
        Assert.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testInvalidOneLetterCountry() {
        String localeString = "_X";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"en", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"", (Object)locale.getCountry());
        Assert.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testInvalidThreeLetterCountry() {
        String localeString = "_XXX";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"en", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"", (Object)locale.getCountry());
        Assert.assertEquals((Object)"", (Object)locale.getVariant());
    }

    @Test
    public void testValidNumericAreaCode() {
        String localeString = "_029";
        Locale locale = EquinoxConfiguration.toLocale((String)localeString, (Locale)Locale.ENGLISH);
        Assert.assertEquals((Object)"", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"029", (Object)locale.getCountry());
        Assert.assertEquals((Object)"", (Object)locale.getVariant());
    }
}

