/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.osgi.launch.EquinoxFactory;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public abstract class AbstractFrameworkHookTests
extends CoreTest {
    protected static final String BUNDLES_ROOT = "bundle_tests";
    protected BasicURLClassLoader classLoader;
    protected BundleInstaller bundleInstaller;

    public BundleContext getContext() {
        return OSGiTestsActivator.getContext();
    }

    protected void assertBundleDiscarded(String location, Framework framework) {
        AbstractFrameworkHookTests.assertNull((String)("Bundle " + location + " was not discarded"), (Object)framework.getBundleContext().getBundle(location));
    }

    protected void assertBundleNotDiscarded(String location, Framework framework) {
        AbstractFrameworkHookTests.assertNotNull((String)("Bundle " + location + " was discarded"), (Object)framework.getBundleContext().getBundle(location));
    }

    protected Framework createFramework(Map<String, String> configuration) throws Exception {
        FrameworkFactory factory = (FrameworkFactory)this.classLoader.loadClass(EquinoxFactory.class.getName()).newInstance();
        Framework framework = factory.newFramework(configuration);
        return framework;
    }

    protected void initAndStart(Framework framework) throws Exception {
        framework.init();
        framework.start();
    }

    protected Framework restart(Framework framework, Map<String, String> configuration) throws Exception {
        this.stop(framework);
        framework = this.createFramework(configuration);
        this.initAndStart(framework);
        return framework;
    }

    protected void setUp() throws Exception {
        this.setUpBundleInstaller();
        this.setUpClassLoader();
    }

    protected void stop(Framework framework) throws Exception {
        this.stop(framework, false);
    }

    protected void stopQuietly(Framework framework) {
        if (framework == null) {
            return;
        }
        try {
            this.stop(framework, true);
        }
        catch (Exception exception) {}
    }

    private void stop(Framework framework, boolean quietly) throws Exception {
        block3: {
            try {
                framework.stop();
                FrameworkEvent event = framework.waitForStop(10000L);
                if (!quietly) {
                    AbstractFrameworkHookTests.assertEquals((String)"The framework was not stopped", (int)64, (int)event.getType());
                }
            }
            catch (Exception e) {
                if (quietly) break block3;
                throw e;
            }
        }
    }

    protected void tearDown() throws Exception {
        this.bundleInstaller.shutdown();
    }

    private void setUpBundleInstaller() throws Exception {
        this.bundleInstaller = new BundleInstaller(BUNDLES_ROOT, this.getContext());
    }

    private void setUpClassLoader() throws Exception {
        BundleContext context = this.getContext();
        String osgiFramework = context.getProperty("osgi.framework");
        URL[] urls = "folder".equals(context.getProperty("osgi.framework.shape")) ? new URL[]{new URL(osgiFramework), new URL(String.valueOf(osgiFramework) + "bin/")} : new URL[]{new URL(osgiFramework)};
        this.classLoader = new BasicURLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected static class BasicURLClassLoader
    extends URLClassLoader {
        public BasicURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public URL getResource(String name) {
            if (this.isLocalResource(name)) {
                return this.findResource(name);
            }
            return super.getResource(name);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (this.isLocalResource(name)) {
                return this.findResources(name);
            }
            return super.getResources(name);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("org.eclipse")) {
                Class<?> result = this.findLoadedClass(name);
                if (result == null) {
                    result = this.findClass(name);
                }
                return result;
            }
            return super.loadClass(name, resolve);
        }

        private boolean isLocalResource(String name) {
            return name.startsWith("org/eclipse") || name.equals("hookconfigurators.properties");
        }
    }
}

