/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;

public class ContextFinderTests
extends AbstractFrameworkHookTests {
    private Map<String, String> configuration;
    private Framework framework;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File file = OSGiTestsActivator.getContext().getDataFile(this.getName());
        this.configuration = new HashMap<String, String>();
        this.configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        this.framework = this.createFramework(this.configuration);
        this.initAndStart(this.framework);
    }

    @Override
    protected void tearDown() throws Exception {
        this.stopQuietly(this.framework);
        super.tearDown();
    }

    public void testContextClassLoaderNullLocal() throws InvalidSyntaxException, IOException {
        BundleContext bc = this.framework.getBundleContext();
        ClassLoader contextFinder = (ClassLoader)bc.getService((ServiceReference)bc.getServiceReferences(ClassLoader.class, "(equinox.classloader.type=contextClassLoader)").iterator().next());
        Enumeration<URL> result = contextFinder.getResources("does/not/exist.txt");
        ContextFinderTests.assertNotNull((String)"Null result.", result);
        ContextFinderTests.assertFalse((String)"Found unexpected result", (boolean)result.hasMoreElements());
    }
}

