/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;

public class StorageHookTests
extends AbstractFrameworkHookTests {
    private static final String TEST_BUNDLE = "test";
    private static final String HOOK_CONFIGURATOR_BUNDLE = "storage.hooks.a";
    private static final String HOOK_CONFIGURATOR_CLASS = "org.eclipse.osgi.tests.hooks.framework.storage.a.TestHookConfigurator";
    private static final String HOOK_CONFIGURATOR_FIELD_CREATE_STORAGE_HOOK_CALLED = "createStorageHookCalled";
    private static final String HOOK_CONFIGURATOR_FIELD_FAIL_LOAD = "failLoad";
    private static final String HOOK_CONFIGURATOR_FIELD_INVALID = "invalid";
    private static final String HOOK_CONFIGURATOR_FIELD_INVALID_FACTORY_CLASS = "invalidFactoryClass";
    private static final String HOOK_CONFIGURATOR_FIELD_VALIDATE_CALLED = "validateCalled";
    private static final String HOOK_CONFIGURATOR_FIELD_DELETING_CALLED = "deletingGenerationCalled";
    private static final String HOOK_CONFIGURATOR_FIELD_ADAPT_MANIFEST = "adaptManifest";
    private static final String HOOK_CONFIGURATOR_FIELD_REPLACE_BUILDER = "replaceModuleBuilder";
    private Map<String, String> configuration;
    private Framework framework;
    private String location;

    public void testBundleDiscardedWhenClasspathStorageHookInvalidates() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setStorageHookInvalid(true);
        this.restartFramework();
        this.assertStorageHookValidateCalled();
        this.assertBundleDiscarded();
    }

    public void testBundleNotDiscardedWhenClasspathStorageHookValidates() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setStorageHookInvalid(false);
        this.restartFramework();
        this.assertStorageHookValidateCalled();
        this.assertBundleNotDiscarded();
    }

    public void testWrongStorageHookFactoryClassOnBundleInstall() throws Exception {
        this.setFactoryClassInvalid(true);
        this.initAndStartFramework();
        try {
            this.installBundle();
            StorageHookTests.fail((String)"Bundle install should have failed");
        }
        catch (BundleException e) {
            this.assertBundleException(e);
        }
        this.assertCreateStorageHookCalled();
    }

    public void testWrongStorageHookFactoryClassOnBundleUpdate() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setFactoryClassInvalid(true);
        try {
            this.updateBundle();
            StorageHookTests.fail((String)"Bundle update should have failed");
        }
        catch (BundleException e) {
            this.assertBundleException(e);
        }
        this.assertCreateStorageHookCalled();
    }

    public void testWrongStorageHookFactoryClassOnFrameworkRestart() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setFactoryClassInvalid(true);
        try {
            this.restartFramework();
            StorageHookTests.fail((String)"Framework restart should have failed");
        }
        catch (IllegalStateException e) {
            this.assertThrowable(e);
        }
        this.assertCreateStorageHookCalled();
    }

    public void testCleanOnFailLoad() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setFactoryHookFailLoad(true);
        this.restartFramework();
        this.assertBundleDiscarded();
        File bundlesBase = new File(OSGiTestsActivator.getContext().getDataFile(this.getName()), "bundles");
        bundlesBase.mkdirs();
        this.framework.getBundleContext().installBundle(SystemBundleTests.createBundle(bundlesBase, this.getName(), false, false).toURI().toString());
    }

    public void testDeletingGenerationCalledOnDiscard() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        this.setStorageHookInvalid(true);
        this.restartFramework();
        this.assertStorageHookDeletingGenerationCalled();
        this.assertBundleDiscarded();
    }

    public void testDeletingGenerationCalledUninstall() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        Bundle b = this.framework.getBundleContext().getBundle(this.location);
        StorageHookTests.assertNotNull((String)"Missing test bundle.", (Object)b);
        b.uninstall();
        this.assertStorageHookDeletingGenerationCalled();
    }

    public void testDeletingGenerationCalledUpdate() throws Exception {
        this.initAndStartFramework();
        this.installBundle();
        Bundle b = this.framework.getBundleContext().getBundle(this.location);
        StorageHookTests.assertNotNull((String)"Missing test bundle.", (Object)b);
        b.update();
        this.assertStorageHookDeletingGenerationCalled();
    }

    public void testAdaptModuleRevisionBuilder() throws Exception {
        this.setFactoryClassAdaptManifest(true);
        this.initAndStartFramework();
        this.installBundle();
        Bundle b = this.framework.getBundleContext().getBundle(this.location);
        Assert.assertNotEquals((String)"Wrong ID.", (long)5678L, (long)b.getBundleId());
        StorageHookTests.assertNotNull((String)"Missing test bundle.", (Object)b);
        List testCaps = ((BundleRevision)b.adapt(BundleRevision.class)).getCapabilities("test.file.path");
        StorageHookTests.assertEquals((String)"Wrong number of test caps.", (int)1, (int)testCaps.size());
        String path1 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.file.path");
        StorageHookTests.assertNotNull((String)"No path", (Object)path1);
        String operation1 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.operation");
        StorageHookTests.assertEquals((String)"Wrong operation", (String)ModuleContainerAdaptor.ModuleEvent.INSTALLED.toString(), (String)operation1);
        String location1 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.origin");
        StorageHookTests.assertEquals((String)"Wrong origin", (String)this.framework.getBundleContext().getBundle().getLocation(), (String)location1);
        b.update();
        Assert.assertNotEquals((String)"Wrong ID.", (long)5678L, (long)b.getBundleId());
        testCaps = ((BundleRevision)b.adapt(BundleRevision.class)).getCapabilities("test.file.path");
        StorageHookTests.assertEquals((String)"Wrong number of test caps.", (int)1, (int)testCaps.size());
        String path2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.file.path");
        StorageHookTests.assertNotNull((String)"No path", (Object)path2);
        String operation2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.operation");
        StorageHookTests.assertEquals((String)"Wrong operation", (String)ModuleContainerAdaptor.ModuleEvent.UPDATED.toString(), (String)operation2);
        String location2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.origin");
        StorageHookTests.assertEquals((String)"Wrong origin", (String)this.location, (String)location2);
        Assert.assertNotEquals((String)"Path of updated bundle is the same.", (Object)path1, (Object)path2);
        this.framework.stop();
        this.framework.waitForStop(5000L);
        this.framework = this.createFramework(this.configuration);
        this.framework.start();
        b = this.framework.getBundleContext().getBundle(this.location);
        Assert.assertNotEquals((String)"Wrong ID.", (long)5678L, (long)b.getBundleId());
        testCaps = ((BundleRevision)b.adapt(BundleRevision.class)).getCapabilities("test.file.path");
        StorageHookTests.assertEquals((String)"Wrong number of test caps.", (int)1, (int)testCaps.size());
        path2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.file.path");
        StorageHookTests.assertNotNull((String)"No path", (Object)path2);
        operation2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.operation");
        StorageHookTests.assertEquals((String)"Wrong operation", (String)ModuleContainerAdaptor.ModuleEvent.UPDATED.toString(), (String)operation2);
        location2 = (String)((Capability)testCaps.get(0)).getAttributes().get("test.origin");
        StorageHookTests.assertEquals((String)"Wrong origin", (String)this.location, (String)location2);
        this.setFactoryClassAdaptManifest(false);
        this.setFactoryClassReplaceBuilder(true);
        b.uninstall();
        this.installBundle();
        b = this.framework.getBundleContext().getBundle(this.location);
        Assert.assertNotEquals((String)"Wrong ID.", (long)5678L, (long)b.getBundleId());
        StorageHookTests.assertNotNull((String)"Missing test bundle.", (Object)b);
        StorageHookTests.assertEquals((String)"Wrong BSN.", (String)"replace", (String)b.getSymbolicName());
        testCaps = ((BundleRevision)b.adapt(BundleRevision.class)).getCapabilities("replace");
        StorageHookTests.assertEquals((String)"Wrong number of capabilities.", (int)1, (int)testCaps.size());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String loc = this.bundleInstaller.getBundleLocation(HOOK_CONFIGURATOR_BUNDLE);
        loc = loc.substring(loc.indexOf("file:"));
        this.classLoader.addURL(new URL(loc));
        this.location = this.bundleInstaller.getBundleLocation(TEST_BUNDLE);
        File file = OSGiTestsActivator.getContext().getDataFile(this.getName());
        this.configuration = new HashMap<String, String>();
        this.configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        this.configuration.put("osgi.hook.configurators.include", HOOK_CONFIGURATOR_CLASS);
        this.framework = this.createFramework(this.configuration);
        this.resetStorageHook();
    }

    @Override
    protected void tearDown() throws Exception {
        this.stopQuietly(this.framework);
        super.tearDown();
    }

    private void assertBundleDiscarded() {
        this.assertBundleDiscarded(this.location, this.framework);
    }

    private void assertBundleException(BundleException e) {
        this.assertThrowable(e.getCause());
    }

    private void assertBundleNotDiscarded() {
        this.assertBundleNotDiscarded(this.location, this.framework);
    }

    private void assertCreateStorageHookCalled() throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        StorageHookTests.assertTrue((String)"Storage hook factory createStorageHook not called by framework", (boolean)clazz.getField(HOOK_CONFIGURATOR_FIELD_CREATE_STORAGE_HOOK_CALLED).getBoolean(null));
    }

    private void assertThrowable(Throwable t) {
        StorageHookTests.assertTrue((String)"Unexpected exception", (t != null && t instanceof IllegalStateException && t.getMessage().startsWith("The factory class ") ? 1 : 0) != 0);
    }

    private void assertStorageHookValidateCalled() throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        StorageHookTests.assertTrue((String)"Storage hook validate not called by framework", (boolean)clazz.getField(HOOK_CONFIGURATOR_FIELD_VALIDATE_CALLED).getBoolean(null));
    }

    private void assertStorageHookDeletingGenerationCalled() throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        StorageHookTests.assertTrue((String)"Storage hook deletingGeneration not called by framework", (boolean)clazz.getField(HOOK_CONFIGURATOR_FIELD_DELETING_CALLED).getBoolean(null));
    }

    private void initAndStartFramework() throws Exception {
        this.initAndStart(this.framework);
    }

    private void installBundle() throws Exception {
        this.framework.getBundleContext().installBundle(this.location);
    }

    private void resetStorageHook() throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_CREATE_STORAGE_HOOK_CALLED).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_INVALID).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_VALIDATE_CALLED).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_INVALID_FACTORY_CLASS).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_DELETING_CALLED).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_ADAPT_MANIFEST).set(null, false);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_FAIL_LOAD).set(null, false);
    }

    private void restartFramework() throws Exception {
        this.framework = this.restart(this.framework, this.configuration);
    }

    private void setFactoryClassInvalid(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_INVALID_FACTORY_CLASS).set(null, value);
    }

    private void setStorageHookInvalid(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_INVALID).set(null, value);
    }

    private void setFactoryClassAdaptManifest(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_ADAPT_MANIFEST).set(null, value);
    }

    private void setFactoryClassReplaceBuilder(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_REPLACE_BUILDER).set(null, value);
    }

    private void setFactoryHookFailLoad(boolean value) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(HOOK_CONFIGURATOR_CLASS);
        clazz.getField(HOOK_CONFIGURATOR_FIELD_FAIL_LOAD).set(null, value);
    }

    private void updateBundle() throws Exception {
        this.framework.getBundleContext().getBundle(this.location).update();
    }
}

