/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.internal.plugins;

import java.io.IOException;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class InstallTests
extends CoreTest {
    public InstallTests() {
    }

    public InstallTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testInstallNoVersionManifest01() throws BundleException, IOException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle03");
            }
            catch (BundleException bundleException) {
                InstallTests.fail((String)"1.0");
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void testInstallInvalidManifest02() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testInstallInvalidManifest02", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle11");
                InstallTests.fail((String)"Expected a failure with no Bundle-SymbolicName header");
            }
            catch (BundleException be) {
                InstallTests.assertEquals((String)"Expected manifest error", (int)3, (int)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void testInstallInvalidManifest03() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testInstallInvalidManifest03", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle12");
                InstallTests.fail((String)"Expected a failure with duplicate directives");
            }
            catch (BundleException be) {
                InstallTests.assertEquals((String)"Expected manifest error", (int)3, (int)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void testInstallInvalidManifest04() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testInstallInvalidManifest04", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle13");
                InstallTests.fail((String)"Expected a failure with duplicate attributes");
            }
            catch (BundleException be) {
                InstallTests.assertEquals((String)"Expected manifest error", (int)3, (int)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void testInstallInvalidManifest05() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testInstallInvalidManifest05", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle14");
                InstallTests.fail((String)"Expected a failure with duplicate imports");
            }
            catch (BundleException be) {
                InstallTests.assertEquals((String)"Expected manifest error", (int)3, (int)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void testStartError01() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testStartError01", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle15");
            }
            catch (BundleException be) {
                InstallTests.fail((String)"Unexpected installation error", (Throwable)be);
            }
            try {
                installed.start();
                InstallTests.fail((String)"Expected a failure to start unresolved bundle");
            }
            catch (BundleException be) {
                InstallTests.assertEquals((String)"Expected manifest error", (int)4, (int)be.getType());
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void testStartError02() throws IOException, BundleException {
        Bundle host = null;
        Bundle fragment = null;
        try {
            try {
                host = BundleTestingHelper.installBundle((String)"testStartError02_host", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle16");
                fragment = BundleTestingHelper.installBundle((String)"testStartError02_frag", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle17");
            }
            catch (BundleException be) {
                InstallTests.fail((String)"Unexpected installation error", (Throwable)be);
            }
            try {
                host.start();
            }
            catch (BundleException be) {
                InstallTests.fail((String)"Unexpected start host error", (Throwable)be);
            }
            try {
                fragment.start();
                InstallTests.fail((String)"Expected a failure to start fragment bundle");
            }
            catch (BundleException be) {
                InstallTests.assertEquals((String)"Expected manifest error", (int)2, (int)be.getType());
            }
        }
        finally {
            if (host != null) {
                host.uninstall();
            }
            if (fragment != null) {
                fragment.uninstall();
            }
        }
    }

    public void testUnsupportedOperation01() throws IOException, BundleException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((String)"testUnsupportedOperation01", (BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle18");
                InstallTests.fail((String)"Expected an unsupported operation exception");
            }
            catch (BundleException be) {
                InstallTests.assertEquals((String)"Expected unsupported error", (int)1, (int)be.getType());
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void testInstallLocationWithSpaces() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle 01");
        try {
            InstallTests.assertEquals((String)"1.0", (String)"bundle01", (String)installed.getSymbolicName());
            InstallTests.assertEquals((String)"1.1", (int)2, (int)installed.getState());
        }
        finally {
            installed.uninstall();
        }
    }

    public void testInstallLocationWithUnderscores() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle02_1.0.0");
        try {
            InstallTests.assertEquals((String)"1.0", (String)"bundle02", (String)installed.getSymbolicName());
            InstallTests.assertEquals((String)"1.1", (int)2, (int)installed.getState());
            InstallTests.assertEquals((String)"1.2", (Object)new Version("2.0"), (Object)new Version((String)installed.getHeaders().get("Bundle-Version")));
        }
        finally {
            installed.uninstall();
        }
    }

    public void testInstallBundleWithExtensionPointOnly() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle04");
        try {
            InstallTests.assertEquals((String)"1.0", (String)"bundle04", (String)installed.getSymbolicName());
            InstallTests.assertEquals((String)"1.1", (int)2, (int)installed.getState());
            InstallTests.assertEquals((String)"1.2", (String)"1.3.7", (String)((String)installed.getHeaders().get("Bundle-Version")));
            String symbolicNameString = (String)installed.getHeaders().get("Bundle-SymbolicName");
            InstallTests.assertNotNull((String)"1.3", (Object)symbolicNameString);
            ManifestElement[] symbolicNameHeader = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameString);
            InstallTests.assertEquals((String)"1.4", (int)1, (int)symbolicNameHeader.length);
            InstallTests.assertEquals((String)"1.5", (String)"true", (String)symbolicNameHeader[0].getDirective("singleton"));
        }
        finally {
            installed.uninstall();
        }
    }

    public void testInstallBundleWithExtensionOnly() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle05");
        try {
            InstallTests.assertEquals((String)"1.0", (String)"bundle05", (String)installed.getSymbolicName());
            InstallTests.assertEquals((String)"1.1", (int)2, (int)installed.getState());
            InstallTests.assertEquals((String)"1.2", (String)"1.3.8", (String)((String)installed.getHeaders().get("Bundle-Version")));
            String symbolicNameString = (String)installed.getHeaders().get("Bundle-SymbolicName");
            InstallTests.assertNotNull((String)"1.3", (Object)symbolicNameString);
            ManifestElement[] symbolicNameHeader = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameString);
            InstallTests.assertEquals((String)"1.4", (int)1, (int)symbolicNameHeader.length);
            InstallTests.assertEquals((String)"1.5", (String)"true", (String)symbolicNameHeader[0].getDirective("singleton"));
        }
        finally {
            installed.uninstall();
        }
    }

    public void testInstallBundleWithExtensionAndExtensionPoint() throws BundleException, IOException {
        Bundle installed = null;
        installed = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle06");
        try {
            InstallTests.assertEquals((String)"1.0", (String)"bundle06", (String)installed.getSymbolicName());
            InstallTests.assertEquals((String)"1.1", (int)2, (int)installed.getState());
            InstallTests.assertEquals((String)"1.2", (String)"1.3.9", (String)((String)installed.getHeaders().get("Bundle-Version")));
            String symbolicNameString = (String)installed.getHeaders().get("Bundle-SymbolicName");
            InstallTests.assertNotNull((String)"1.3", (Object)symbolicNameString);
            ManifestElement[] symbolicNameHeader = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameString);
            InstallTests.assertEquals((String)"1.4", (int)1, (int)symbolicNameHeader.length);
            InstallTests.assertEquals((String)"1.5", (String)"true", (String)symbolicNameHeader[0].getDirective("singleton"));
        }
        finally {
            installed.uninstall();
        }
    }

    public void testInstall2NonSingletonBundles() throws BundleException, IOException {
        Bundle installed1 = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle07");
        ServiceReference packageAdminSR = OSGiTestsActivator.getContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)OSGiTestsActivator.getContext().getService(packageAdminSR);
        packageAdmin.resolveBundles(null);
        Bundle installed2 = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle07b");
        packageAdmin.resolveBundles(null);
        OSGiTestsActivator.getContext().ungetService(packageAdminSR);
        try {
            InstallTests.assertEquals((String)"1.0", (String)"bundle07", (String)installed2.getSymbolicName());
            InstallTests.assertEquals((String)"1.1", (int)4, (int)installed2.getState());
            InstallTests.assertEquals((String)"1.2", (String)"1.0.0.b", (String)((String)installed2.getHeaders().get("Bundle-Version")));
            InstallTests.assertEquals((String)"1.3", (String)"bundle07", (String)installed1.getSymbolicName());
            InstallTests.assertEquals((String)"1.4", (int)4, (int)installed1.getState());
            InstallTests.assertEquals((String)"1.5", (String)"1.0.0", (String)((String)installed1.getHeaders().get("Bundle-Version")));
        }
        finally {
            installed1.uninstall();
            installed2.uninstall();
        }
    }

    public void testInstall2SingletonBundles() throws BundleException, IOException {
        Bundle installed1 = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle08");
        ServiceReference packageAdminSR = OSGiTestsActivator.getContext().getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)OSGiTestsActivator.getContext().getService(packageAdminSR);
        packageAdmin.resolveBundles(null);
        Bundle installed2 = BundleTestingHelper.installBundle((BundleContext)OSGiTestsActivator.getContext(), (String)"test_files/internal/plugins/installTests/bundle08b");
        packageAdmin.resolveBundles(null);
        OSGiTestsActivator.getContext().ungetService(packageAdminSR);
        try {
            InstallTests.assertEquals((String)"1.0", (String)"bundle08", (String)installed1.getSymbolicName());
            InstallTests.assertEquals((String)"1.1", (int)4, (int)installed1.getState());
            InstallTests.assertEquals((String)"1.2", (String)"1.0.0", (String)((String)installed1.getHeaders().get("Bundle-Version")));
            InstallTests.assertEquals((String)"1.3", (String)"bundle08", (String)installed2.getSymbolicName());
            InstallTests.assertEquals((String)"1.4", (int)2, (int)installed2.getState());
            InstallTests.assertEquals((String)"1.5", (String)"1.0.0.b", (String)((String)installed2.getHeaders().get("Bundle-Version")));
        }
        finally {
            installed1.uninstall();
            installed2.uninstall();
        }
    }
}

