/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.perf;

import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.Version;

public class BasePerformanceTest
extends AbstractStateTest {
    private Random random;

    public static Test suite() {
        return new TestSuite(BasePerformanceTest.class);
    }

    public BasePerformanceTest(String name) {
        super(name);
    }

    protected State buildRandomState(int size) {
        State state = this.buildEmptyState();
        StateObjectFactory stateFactory = state.getFactory();
        BundleDescription[] bundles = new BundleDescription[size];
        int exportedPackages = 0;
        int i = 0;
        while (i < bundles.length) {
            long bundleId = i;
            String symbolicName = "bundle" + i;
            Version version = new Version(1, 0, 0);
            int exportPackageCount = this.random.nextInt(5);
            ExportPackageDescription[] exportPackages = new ExportPackageDescription[exportPackageCount];
            int j = 0;
            while (j < exportPackages.length) {
                String packageName = "package." + exportedPackages++;
                Version packageVersion = Version.parseVersion((String)"1.0.0");
                exportPackages[j] = stateFactory.createExportPackageDescription(packageName, packageVersion, null, null, true, null);
                ++j;
            }
            int importPackageCount = Math.min(exportPackageCount, this.random.nextInt(5));
            int importedPackageIndex = this.random.nextInt(exportPackageCount + 1);
            ImportPackageSpecification[] importPackages = new ImportPackageSpecification[importPackageCount];
            int j2 = 0;
            while (j2 < importPackages.length) {
                int index = importedPackageIndex++;
                if (importedPackageIndex > exportPackageCount) {
                    importedPackageIndex = 1;
                }
                String packageName = "package." + index;
                importPackages[j2] = stateFactory.createImportPackageSpecification(packageName, new VersionRange("1.0.0"), null, null, null, null, null);
                ++j2;
            }
            BundleSpecification[] requiredBundles = new BundleSpecification[Math.min(i, this.random.nextInt(5))];
            int j3 = 0;
            while (j3 < requiredBundles.length) {
                int requiredIndex = this.random.nextInt(i);
                String requiredName = bundles[requiredIndex].getSymbolicName();
                Version requiredVersion = bundles[requiredIndex].getVersion();
                boolean export = this.random.nextInt(10) > 6;
                boolean optional = this.random.nextInt(10) > 8;
                requiredBundles[j3] = stateFactory.createBundleSpecification(requiredName, new VersionRange(requiredVersion.toString()), export, optional);
                ++j3;
            }
            bundles[i] = stateFactory.createBundleDescription(bundleId, symbolicName, version, symbolicName, requiredBundles, null, importPackages, exportPackages, null, this.random.nextDouble() > 0.05);
            state.addBundle(bundles[i]);
            ++i;
        }
        return state;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.random = new Random(0L);
    }
}

