/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.perf;

import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.tests.OSGiTest;

public class CaseMapPerformanceTest
extends OSGiTest {
    static final String[] KEYS;
    static final Object VALUE;

    static {
        VALUE = new Object();
        KEYS = new String[1000];
        int i = 0;
        while (i < 1000) {
            CaseMapPerformanceTest.KEYS[i] = "Header-" + i + "-Key";
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(CaseMapPerformanceTest.class);
    }

    public CaseMapPerformanceTest(String name) {
        super(name);
    }

    public void testHeaders004() {
        Headers headers = new Headers(4);
        this.doTestMap((Map<String, Object>)headers, 4);
    }

    public void testHeaders005() {
        Headers headers = new Headers(5);
        this.doTestMap((Map<String, Object>)headers, 5);
    }

    public void testHeaders006() {
        Headers headers = new Headers(6);
        this.doTestMap((Map<String, Object>)headers, 6);
    }

    public void testHeaders010() {
        Headers headers = new Headers(10);
        this.doTestMap((Map<String, Object>)headers, 10);
    }

    public void testHeaders020() {
        Headers headers = new Headers(20);
        this.doTestMap((Map<String, Object>)headers, 20);
    }

    public void testHeaders100() {
        Headers headers = new Headers(100);
        this.doTestMap((Map<String, Object>)headers, 100);
    }

    public void testXCaseMap004() {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(4);
        this.doTestMap((Map<String, Object>)headers, 4);
    }

    public void testXCaseMap005() {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(5);
        this.doTestMap((Map<String, Object>)headers, 5);
    }

    public void testXCaseMap006() {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(6);
        this.doTestMap((Map<String, Object>)headers, 6);
    }

    public void testXCaseMap010() {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(10);
        this.doTestMap((Map<String, Object>)headers, 10);
    }

    public void testXCaseMap020() {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(20);
        this.doTestMap((Map<String, Object>)headers, 10);
    }

    public void testXCaseMap100() {
        CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(100);
        this.doTestMap((Map<String, Object>)headers, 100);
    }

    private void doTestMap(final Map<String, Object> map, final int numKeys) {
        CaseMapPerformanceTest.fillMap(map, numKeys);
        new PerformanceTestRunner(){

            protected void test() {
                CaseMapPerformanceTest.doMapGet(map, numKeys);
            }
        }.run((TestCase)this, 10, 10000);
    }

    static void fillMap(Map<String, Object> map, int numKeys) {
        map.clear();
        int i = 0;
        while (i < numKeys) {
            map.put(KEYS[i], VALUE);
            ++i;
        }
    }

    static void doMapGet(Map<String, Object> map, int numKeys) {
        int i = 0;
        while (i < numKeys) {
            map.get(KEYS[i]);
            ++i;
        }
    }
}

