/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.permissions;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermission;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.permissions.PermissionTests;
import org.osgi.framework.PackagePermission;

public class PackagePermissionTests
extends PermissionTests {
    public static Test suite() {
        return new TestSuite(PackagePermissionTests.class);
    }

    public void testPackagePermission() {
        this.badPackagePermission("a.b.c", "x");
        this.badPackagePermission("a.b.c", "   get  ,  x   ");
        this.badPackagePermission("a.b.c", "");
        this.badPackagePermission("a.b.c", "      ");
        this.badPackagePermission("a.b.c", null);
        this.badPackagePermission("a.b.c", ",");
        this.badPackagePermission("a.b.c", ",xxx");
        this.badPackagePermission("a.b.c", "xxx,");
        this.badPackagePermission("a.b.c", "import,");
        this.badPackagePermission("a.b.c", "export,   ");
        this.badPackagePermission("a.b.c", "importme,");
        this.badPackagePermission("a.b.c", "exportme,");
        this.badPackagePermission("a.b.c", ",import");
        this.badPackagePermission("a.b.c", ",export");
        this.badPackagePermission("a.b.c", "   importme   ");
        this.badPackagePermission("a.b.c", "   exportme     ");
        this.badPackagePermission("a.b.c", "   impor");
        this.badPackagePermission("a.b.c", "   expor");
        PropertyPermission op = new PropertyPermission("java.home", "read");
        PackagePermission p11 = new PackagePermission("com.foo.service1", "    IMPORT,export   ");
        PackagePermission p12 = new PackagePermission("com.foo.service1", "EXPORT  ,   import");
        PackagePermission p13 = new PackagePermission("com.foo.service1", "expORT   ");
        PackagePermission p14 = new PackagePermission("com.foo.service1", "    Import    ");
        this.shouldImply((Permission)p11, (Permission)p11);
        this.shouldImply((Permission)p11, (Permission)p12);
        this.shouldImply((Permission)p11, (Permission)p13);
        this.shouldImply((Permission)p11, (Permission)p14);
        this.shouldImply((Permission)p12, (Permission)p11);
        this.shouldImply((Permission)p12, (Permission)p12);
        this.shouldImply((Permission)p12, (Permission)p13);
        this.shouldImply((Permission)p12, (Permission)p14);
        this.shouldImply((Permission)p13, (Permission)p11);
        this.shouldImply((Permission)p13, (Permission)p12);
        this.shouldImply((Permission)p13, (Permission)p13);
        this.shouldImply((Permission)p13, (Permission)p14);
        this.shouldImply((Permission)p14, (Permission)p14);
        this.shouldNotImply((Permission)p14, (Permission)p11);
        this.shouldNotImply((Permission)p14, (Permission)p12);
        this.shouldNotImply((Permission)p14, (Permission)p13);
        this.shouldNotImply((Permission)p11, (Permission)op);
        this.shouldEqual((Permission)p11, (Permission)p11);
        this.shouldEqual((Permission)p11, (Permission)p12);
        this.shouldEqual((Permission)p11, (Permission)p13);
        this.shouldEqual((Permission)p12, (Permission)p11);
        this.shouldEqual((Permission)p12, (Permission)p12);
        this.shouldEqual((Permission)p12, (Permission)p13);
        this.shouldEqual((Permission)p13, (Permission)p11);
        this.shouldEqual((Permission)p13, (Permission)p12);
        this.shouldEqual((Permission)p13, (Permission)p13);
        this.shouldNotEqual((Permission)p11, (Permission)p14);
        this.shouldNotEqual((Permission)p12, (Permission)p14);
        this.shouldNotEqual((Permission)p13, (Permission)p14);
        this.shouldNotEqual((Permission)p14, (Permission)p11);
        this.shouldNotEqual((Permission)p14, (Permission)p12);
        this.shouldNotEqual((Permission)p14, (Permission)p13);
        PermissionCollection pc = p13.newPermissionCollection();
        this.checkEnumeration(pc.elements(), true);
        this.shouldNotImply(pc, (Permission)p11);
        this.shouldAdd(pc, (Permission)p14);
        this.shouldImply(pc, (Permission)p14);
        this.shouldNotImply(pc, (Permission)p11);
        this.shouldNotImply(pc, (Permission)p12);
        this.shouldNotImply(pc, (Permission)p13);
        this.shouldAdd(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p11);
        this.shouldImply(pc, (Permission)p12);
        this.shouldImply(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p14);
        this.shouldNotAdd(pc, op);
        pc = p13.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p11);
        this.shouldImply(pc, (Permission)p12);
        this.shouldImply(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p14);
        pc = p11.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p11);
        this.shouldImply(pc, (Permission)p11);
        this.shouldImply(pc, (Permission)p12);
        this.shouldImply(pc, (Permission)p13);
        this.shouldImply(pc, (Permission)p14);
        pc.setReadOnly();
        this.shouldNotAdd(pc, (Permission)p12);
        this.checkEnumeration(pc.elements(), false);
        PackagePermission p21 = new PackagePermission("com.foo.service2", "import");
        PackagePermission p22 = new PackagePermission("com.foo.*", "import");
        PackagePermission p23 = new PackagePermission("com.*", "import");
        PackagePermission p24 = new PackagePermission("*", "import");
        this.shouldImply((Permission)p21, (Permission)p21);
        this.shouldImply((Permission)p22, (Permission)p21);
        this.shouldImply((Permission)p23, (Permission)p21);
        this.shouldImply((Permission)p24, (Permission)p21);
        this.shouldImply((Permission)p22, (Permission)p22);
        this.shouldImply((Permission)p23, (Permission)p22);
        this.shouldImply((Permission)p24, (Permission)p22);
        this.shouldImply((Permission)p23, (Permission)p23);
        this.shouldImply((Permission)p24, (Permission)p23);
        this.shouldImply((Permission)p24, (Permission)p24);
        this.shouldNotImply((Permission)p21, (Permission)p22);
        this.shouldNotImply((Permission)p21, (Permission)p23);
        this.shouldNotImply((Permission)p21, (Permission)p24);
        this.shouldNotImply((Permission)p22, (Permission)p23);
        this.shouldNotImply((Permission)p22, (Permission)p24);
        this.shouldNotImply((Permission)p23, (Permission)p24);
        pc = p21.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p21);
        this.shouldNotImply(pc, (Permission)p22);
        this.shouldNotImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        this.shouldAdd(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldNotImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        this.shouldAdd(pc, (Permission)p23);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        this.shouldAdd(pc, (Permission)p24);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p23);
        this.shouldImply(pc, (Permission)p24);
        pc = p22.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldNotImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        pc = p23.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p23);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p23);
        this.shouldNotImply(pc, (Permission)p24);
        pc = p24.newPermissionCollection();
        this.shouldAdd(pc, (Permission)p24);
        this.shouldImply(pc, (Permission)p21);
        this.shouldImply(pc, (Permission)p22);
        this.shouldImply(pc, (Permission)p23);
        this.shouldImply(pc, (Permission)p24);
        this.testSerialization((Permission)p11);
        this.testSerialization((Permission)p12);
        this.testSerialization((Permission)p13);
        this.testSerialization((Permission)p14);
        this.testSerialization((Permission)p21);
        this.testSerialization((Permission)p22);
        this.testSerialization((Permission)p23);
        this.testSerialization((Permission)p24);
    }
}

