/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.permissions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.permissions.AdminPermissionTests;
import org.eclipse.osgi.tests.permissions.PackagePermissionTests;
import org.eclipse.osgi.tests.permissions.ServicePermissionTests;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServicePermission;

public class PermissionTests
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(PermissionTests.class.getName());
        suite.addTest(AdminPermissionTests.suite());
        suite.addTest(ServicePermissionTests.suite());
        suite.addTest(PackagePermissionTests.suite());
        return suite;
    }

    protected void badServicePermission(String name, String actions) {
        try {
            ServicePermission p = new ServicePermission(name, actions);
            PermissionTests.fail((String)(p + " created with invalid actions"));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void badPackagePermission(String name, String actions) {
        try {
            PackagePermission p = new PackagePermission(name, actions);
            PermissionTests.fail((String)(p + " created with invalid actions"));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void checkEnumeration(Enumeration en, boolean isEmpty) {
        PermissionTests.assertEquals((String)(en + " empty state is invalid"), (!isEmpty ? 1 : 0) != 0, (boolean)en.hasMoreElements());
        try {
            while (en.hasMoreElements()) {
                en.nextElement();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            PermissionTests.fail((String)(en + " threw NoSuchElementException"));
        }
        try {
            en.nextElement();
            PermissionTests.fail((String)(en + " is empty but didn't throw NoSuchElementException"));
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    protected void shouldImply(Permission p1, Permission p2) {
        PermissionTests.assertTrue((String)(p1 + " does not imply " + p2), (boolean)p1.implies(p2));
    }

    protected void shouldNotImply(Permission p1, Permission p2) {
        PermissionTests.assertFalse((String)(p1 + " does imply " + p2), (boolean)p1.implies(p2));
    }

    protected void shouldImply(PermissionCollection p1, Permission p2) {
        PermissionTests.assertTrue((String)(p1 + " does not imply " + p2), (boolean)p1.implies(p2));
    }

    protected void shouldNotImply(PermissionCollection p1, Permission p2) {
        PermissionTests.assertFalse((String)(p1 + " does imply " + p2), (boolean)p1.implies(p2));
    }

    protected void shouldEqual(Permission p1, Permission p2) {
        PermissionTests.assertTrue((String)(p1 + " does not equal " + p2), (boolean)p1.equals(p2));
        PermissionTests.assertTrue((String)(p2 + " does not equal " + p1), (boolean)p2.equals(p1));
    }

    protected void shouldNotEqual(Permission p1, Permission p2) {
        PermissionTests.assertFalse((String)(p1 + " does equal " + p2), (boolean)p1.equals(p2));
    }

    protected void shouldAdd(PermissionCollection p1, Permission p2) {
        try {
            p1.add(p2);
        }
        catch (Exception exception) {
            PermissionTests.fail((String)(p1 + " will not add " + p2));
        }
    }

    protected void shouldNotAdd(PermissionCollection p1, Permission p2) {
        try {
            p1.add(p2);
            PermissionTests.fail((String)(p1 + " will add " + p2));
        }
        catch (Exception exception) {}
    }

    protected void testSerialization(Permission p1) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(p1);
            out.flush();
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            Permission p2 = (Permission)in.readObject();
            this.shouldEqual(p1, p2);
            this.shouldImply(p1, p2);
            this.shouldImply(p2, p1);
        }
        catch (Exception e) {
            PermissionTests.fail((String)e.toString());
        }
    }
}

