/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resolver;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class TestCycle_004
extends AbstractStateTest {
    BundleDescription bundle_1 = null;
    BundleDescription bundle_2 = null;

    public TestCycle_004(String testName) {
        super(testName);
    }

    public void testTest_001() {
        State state = this.buildEmptyState();
        StateObjectFactory sof = StateObjectFactory.defaultFactory;
        this.bundle_1 = this.create_bundle_1(sof);
        this.bundle_2 = this.create_bundle_2(sof);
        this.addBundlesToState_a(state);
        try {
            state.resolve();
        }
        catch (Throwable t) {
            TestCycle_004.fail((String)("unexpected exception class=" + t.getClass().getName() + " message=" + t.getMessage()));
            return;
        }
        this.checkBundlesResolved_a();
        this.checkWiring_a();
    }

    public void checkWiringState_1() {
        ExportPackageDescription[] exports = this.bundle_1.getResolvedImports();
        TestCycle_004.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestCycle_004.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            ExportPackageDescription exp = exports[i];
            String exportPackageName = exp.getName();
            TestCycle_004.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("p")) {
                TestCycle_004.assertNotNull((String)"Package [p] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [p] is wired incorrectly ", exp.getExporter(), this.bundle_2);
            }
            ++i;
        }
    }

    public void checkWiringState_2() {
        ExportPackageDescription[] exports = this.bundle_2.getResolvedImports();
        TestCycle_004.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestCycle_004.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            ExportPackageDescription exp = exports[i];
            String exportPackageName = exp.getName();
            TestCycle_004.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("q")) {
                TestCycle_004.assertNotNull((String)"Package [q] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [q] is wired incorrectly ", exp.getExporter(), this.bundle_1);
            }
            ++i;
        }
    }

    public void checkWiring_a() {
        this.checkWiringState_1();
        this.checkWiringState_2();
    }

    public void addBundlesToState_a(State state) {
        boolean added = false;
        added = state.addBundle(this.bundle_1);
        TestCycle_004.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_2);
        TestCycle_004.assertTrue((String)"failed to add bundle ", (boolean)added);
    }

    public void checkBundlesResolved_a() {
        TestCycle_004.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_1.isResolved());
        TestCycle_004.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_2.isResolved());
    }

    public BundleDescription create_bundle_1(StateObjectFactory sof) {
        Properties dictionary_1 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_1).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_1).put("Bundle-SymbolicName", "A");
        ((Dictionary)dictionary_1).put("Export-Package", "q; version=1.0");
        ((Dictionary)dictionary_1).put("Import-Package", "p; version=1.0");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_1, "bundle_1", 1L);
        }
        catch (BundleException be) {
            TestCycle_004.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_2(StateObjectFactory sof) {
        Properties dictionary_2 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_2).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_2).put("Bundle-SymbolicName", "B");
        ((Dictionary)dictionary_2).put("Export-Package", "p; version=1.0");
        ((Dictionary)dictionary_2).put("Import-Package", "q; version=1.0");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_2, "bundle_2", 2L);
        }
        catch (BundleException be) {
            TestCycle_004.fail((String)be.getMessage());
        }
        return bundle;
    }
}

