/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resolver;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class TestRFC79_003
extends AbstractStateTest {
    BundleDescription bundle_1 = null;
    BundleDescription bundle_2 = null;
    BundleDescription bundle_3 = null;
    BundleDescription bundle_4 = null;

    public TestRFC79_003(String testName) {
        super(testName);
    }

    public void testTest_003() {
        State state = this.buildEmptyState();
        StateObjectFactory sof = StateObjectFactory.defaultFactory;
        this.bundle_1 = this.create_bundle_1(sof);
        this.bundle_2 = this.create_bundle_2(sof);
        this.bundle_3 = this.create_bundle_3(sof);
        this.bundle_4 = this.create_bundle_4(sof);
        this.addBundlesToState_a(state);
        try {
            state.resolve();
        }
        catch (Throwable t) {
            TestRFC79_003.fail((String)("unexpected exception class=" + t.getClass().getName() + " message=" + t.getMessage()));
            return;
        }
        this.checkBundlesResolved_a();
        this.checkWiring_a();
    }

    public void checkWiringState_1() {
        ExportPackageDescription[] exports = this.bundle_1.getResolvedImports();
        TestRFC79_003.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestRFC79_003.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            String exportPackageName = exports[i].getName();
            TestRFC79_003.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("javax.servlet")) {
                TestRFC79_003.assertNotNull((String)"Package [javax.servlet] is not wired when it should be ", (Object)exports[i].getExporter());
                this.assertEquals("Package [javax.servlet] is wired incorrectly ", exports[i].getExporter(), this.bundle_2);
            }
            ++i;
        }
    }

    public void checkWiringState_2() {
        ExportPackageDescription[] exports = this.bundle_2.getResolvedImports();
        TestRFC79_003.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestRFC79_003.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            String exportPackageName = exports[i].getName();
            TestRFC79_003.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("javax.servlet")) {
                TestRFC79_003.assertNotNull((String)"Package [javax.servlet] is not wired when it should be ", (Object)exports[i].getExporter());
                this.assertEquals("Package [javax.servlet] is wired incorrectly ", exports[i].getExporter(), this.bundle_2);
            }
            ++i;
        }
    }

    public void checkWiringState_3() {
        ExportPackageDescription[] exports = this.bundle_3.getResolvedImports();
        TestRFC79_003.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestRFC79_003.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            String exportPackageName = exports[i].getName();
            TestRFC79_003.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("org.foo.impl")) {
                TestRFC79_003.assertNotNull((String)"Package [org.foo.impl] is not wired when it should be ", (Object)exports[i].getExporter());
                this.assertEquals("Package [org.foo.impl] is wired incorrectly ", exports[i].getExporter(), this.bundle_1);
            } else if (exportPackageName.equals("javax.servlet")) {
                TestRFC79_003.assertNotNull((String)"Package [javax.servlet] is not wired when it should be ", (Object)exports[i].getExporter());
                this.assertEquals("Package [javax.servlet] is wired incorrectly ", exports[i].getExporter(), this.bundle_2);
            }
            ++i;
        }
    }

    public void checkWiringState_4() {
        ExportPackageDescription[] exports = this.bundle_4.getResolvedImports();
        TestRFC79_003.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestRFC79_003.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < exports.length) {
            String exportPackageName = exports[i].getName();
            TestRFC79_003.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("org.foo.impl")) {
                TestRFC79_003.assertNotNull((String)"Package [org.foo.impl] is not wired when it should be ", (Object)exports[i].getExporter());
                this.assertEquals("Package [org.foo.impl] is wired incorrectly ", exports[i].getExporter(), this.bundle_1);
            } else if (exportPackageName.equals("javax.servlet")) {
                TestRFC79_003.assertNotNull((String)"Package [javax.servlet] is not wired when it should be ", (Object)exports[i].getExporter());
                this.assertEquals("Package [javax.servlet] is wired incorrectly ", exports[i].getExporter(), this.bundle_2);
            }
            ++i;
        }
    }

    public void checkWiring_a() {
        this.checkWiringState_1();
        this.checkWiringState_2();
        this.checkWiringState_3();
        this.checkWiringState_4();
    }

    public void addBundlesToState_a(State state) {
        boolean added = false;
        added = state.addBundle(this.bundle_1);
        TestRFC79_003.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_2);
        TestRFC79_003.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_3);
        TestRFC79_003.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_4);
        TestRFC79_003.assertTrue((String)"failed to add bundle ", (boolean)added);
    }

    public void checkBundlesResolved_a() {
        TestRFC79_003.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_1.isResolved());
        TestRFC79_003.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_2.isResolved());
        TestRFC79_003.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_3.isResolved());
        TestRFC79_003.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_4.isResolved());
    }

    public BundleDescription create_bundle_1(StateObjectFactory sof) {
        Properties dictionary_1 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_1).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_1).put("Bundle-SymbolicName", "A");
        ((Dictionary)dictionary_1).put("Export-Package", "org.foo.impl; version=1.0.0, javax.servlet; version=2.1.0");
        ((Dictionary)dictionary_1).put("Import-Package", "javax.servlet; version=2.1.0");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_1, "bundle_1", 1L);
        }
        catch (BundleException be) {
            TestRFC79_003.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_2(StateObjectFactory sof) {
        Properties dictionary_2 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_2).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_2).put("Bundle-SymbolicName", "B");
        ((Dictionary)dictionary_2).put("Export-Package", "org.foo.impl; version=1.0.0, javax.servlet; version=2.2.0");
        ((Dictionary)dictionary_2).put("Import-Package", "javax.servlet; version=2.2.0");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_2, "bundle_2", 2L);
        }
        catch (BundleException be) {
            TestRFC79_003.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_3(StateObjectFactory sof) {
        Properties dictionary_3 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_3).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_3).put("Bundle-SymbolicName", "C");
        ((Dictionary)dictionary_3).put("Import-Package", "javax.servlet; version=2.1.0, org.foo.impl; version=\"[1.0.0, 1.0.0]\"; bundle-symbolic-name=A");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_3, "bundle_3", 3L);
        }
        catch (BundleException be) {
            TestRFC79_003.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_4(StateObjectFactory sof) {
        Properties dictionary_4 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_4).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_4).put("Bundle-SymbolicName", "D");
        ((Dictionary)dictionary_4).put("Import-Package", "javax.servlet; version=2.1.0, org.foo.impl; version=\"[1.0.0, 1.0.0]\"");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_4, "bundle_4", 4L);
        }
        catch (BundleException be) {
            TestRFC79_003.fail((String)be.getMessage());
        }
        return bundle;
    }
}

