/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resource;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.resource.AbstractResourceTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.FrameworkWiring;

public class ResolverHookTests
extends AbstractResourceTest {
    public static Test suite() {
        return new TestSuite(ResolverHookTests.class);
    }

    public ResolverHookTests(String name) {
        super(name);
    }

    public void testSingletonIdentity() throws Exception {
        final RuntimeException[] error = new RuntimeException[1];
        final boolean[] called = new boolean[1];
        ResolverHookFactory resolverHookFactory = new ResolverHookFactory(){

            public ResolverHook begin(Collection triggers) {
                return new ResolverHook(){

                    public void filterSingletonCollisions(BundleCapability singleton, Collection collisionCandidates) {
                        if (error[0] != null) {
                            return;
                        }
                        called[0] = true;
                        try {
                            ResolverHookTests.assertEquals((String)"Wrong namespace", (String)"osgi.identity", (String)singleton.getNamespace());
                            ResolverHookTests.assertEquals((String)"Wrong singleton directive", (String)"true", (String)((String)singleton.getDirectives().get("singleton")));
                            String symbolicName = (String)singleton.getAttributes().get("osgi.identity");
                            for (BundleCapability candidate : collisionCandidates) {
                                ResolverHookTests.assertEquals((String)"Wrong namespace", (String)"osgi.identity", (String)candidate.getNamespace());
                                ResolverHookTests.assertEquals((String)"Wrong singleton directive", (String)"true", (String)((String)candidate.getDirectives().get("singleton")));
                                ResolverHookTests.assertEquals((String)"Wrong symbolic name", (String)symbolicName, (String)((String)candidate.getAttributes().get("osgi.identity")));
                            }
                        }
                        catch (RuntimeException e) {
                            error[0] = e;
                        }
                    }

                    public void filterResolvable(Collection candidates) {
                    }

                    public void filterMatches(BundleRequirement requirement, Collection candidates) {
                    }

                    public void end() {
                    }
                };
            }
        };
        ServiceRegistration hookReg = this.getContext().registerService(ResolverHookFactory.class, (Object)resolverHookFactory, null);
        try {
            Bundle tb1v1 = this.installer.installBundle("singleton.tb1v1");
            Bundle tb1v2 = this.installer.installBundle("singleton.tb1v2");
            ResolverHookTests.assertFalse((boolean)((FrameworkWiring)this.getContext().getBundle(0L).adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(tb1v1, tb1v2)));
            ResolverHookTests.assertTrue((String)"ResolverHook was not called", (boolean)called[0]);
            if (error[0] != null) {
                throw error[0];
            }
        }
        finally {
            hookReg.unregister();
        }
    }
}

