/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEngine;
import org.eclipse.osgi.internal.service.security.KeyStoreTrustEngine;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class BaseSecurityTest
extends CoreTest {
    private static char[] PASSWORD_DEFAULT = new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'i', 't'};
    private static String TYPE_DEFAULT = "JKS";
    protected static final String BUNDLE_SECURITY_TESTS = "org.eclipse.osgi.tests";
    private static KeyStore supportStore;
    private ServiceRegistration trustReg = null;

    static {
        try {
            URL supportUrl = OSGiTestsActivator.getContext().getBundle().getEntry("test_files/security/keystore.jks");
            supportStore = KeyStore.getInstance(TYPE_DEFAULT);
            supportStore.load(supportUrl.openStream(), PASSWORD_DEFAULT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BaseSecurityTest() {
    }

    public BaseSecurityTest(String name) {
        super(name);
    }

    protected static void addDefaultSecurityBundles(ConfigurationSessionTestSuite suite) {
        String[] ids = ConfigurationSessionTestSuite.MINIMAL_BUNDLE_SET;
        int i = 0;
        while (i < ids.length) {
            suite.addBundle(ids[i]);
            ++i;
        }
        suite.addBundle(BUNDLE_SECURITY_TESTS);
    }

    protected static Certificate getTestCertificate(String alias) throws KeyStoreException {
        return supportStore.getCertificate(alias);
    }

    protected static Certificate[] getTestCertificateChain(String[] aliases) throws KeyStoreException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>(aliases.length);
        int i = 0;
        while (i < aliases.length) {
            certs.add(BaseSecurityTest.getTestCertificate(aliases[i]));
            ++i;
        }
        return certs.toArray(new Certificate[0]);
    }

    protected void registerEclipseTrustEngine() throws Exception {
        URL eclipseURL = OSGiTestsActivator.getContext().getBundle().getEntry("test_files/security/eclipse.jks");
        File tempEngine = OSGiTestsActivator.getContext().getDataFile("temp.jks");
        BaseSecurityTest.copy(eclipseURL.openStream(), tempEngine);
        KeyStoreTrustEngine dummyTE = new KeyStoreTrustEngine(tempEngine.getAbsolutePath(), "JKS", "changeit".toCharArray(), "temp.jks", null);
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>(7);
        properties.put("service.ranking", new Integer(Integer.MAX_VALUE));
        this.trustReg = OSGiTestsActivator.getContext().registerService(TrustEngine.class.getName(), (Object)dummyTE, properties);
    }

    protected void tearDown() throws Exception {
        if (this.trustReg != null) {
            this.trustReg.unregister();
        }
    }

    public static void copy(InputStream in, File dst) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    protected SignedContentFactory getSignedContentFactory() {
        ServiceReference ref = OSGiTestsActivator.getContext().getServiceReference(SignedContentFactory.class.getName());
        BaseSecurityTest.assertNotNull((String)"No SignedContentFactory service", (Object)ref);
        SignedContentFactory factory = (SignedContentFactory)OSGiTestsActivator.getContext().getService(ref);
        OSGiTestsActivator.getContext().ungetService(ref);
        return factory;
    }

    protected TrustEngine getTrustEngine() {
        ServiceReference ref = OSGiTestsActivator.getContext().getServiceReference(TrustEngine.class.getName());
        BaseSecurityTest.assertNotNull((String)"No TrustEngine available", (Object)ref);
        TrustEngine engine = (TrustEngine)OSGiTestsActivator.getContext().getService(ref);
        OSGiTestsActivator.getContext().ungetService(ref);
        return engine;
    }

    protected AuthorizationEngine getAuthorizationEngine() {
        ServiceReference ref = OSGiTestsActivator.getContext().getServiceReference(AuthorizationEngine.class.getName());
        BaseSecurityTest.assertNotNull((String)"No AuthorizationEngine available", (Object)ref);
        AuthorizationEngine engine = (AuthorizationEngine)OSGiTestsActivator.getContext().getService(ref);
        OSGiTestsActivator.getContext().ungetService(ref);
        return engine;
    }

    protected Bundle installBundle(String bundlePath) {
        URL bundleURL = OSGiTestsActivator.getContext().getBundle().getEntry(bundlePath);
        BaseSecurityTest.assertNotNull((String)("Bundle URL is null " + bundlePath), (Object)bundleURL);
        try {
            return OSGiTestsActivator.getContext().installBundle(bundlePath, bundleURL.openStream());
        }
        catch (Exception e) {
            BaseSecurityTest.fail((String)"unexpected install exception", (Throwable)e);
            return null;
        }
    }

    protected File getEntryFile(String entryPath) throws IOException {
        URL entryURL = OSGiTestsActivator.getContext().getBundle().getEntry(entryPath);
        if (entryURL == null) {
            return null;
        }
        return new File(FileLocator.toFileURL((URL)entryURL).toExternalForm().substring(5));
    }

    protected File copyEntryFile(String entryPath) throws IOException {
        URL entryURL = OSGiTestsActivator.getContext().getBundle().getEntry(entryPath);
        if (entryURL == null) {
            return null;
        }
        File tempFolder = OSGiTestsActivator.getContext().getDataFile("temp");
        tempFolder.mkdirs();
        File result = File.createTempFile("entry", ".jar", tempFolder);
        BaseSecurityTest.readFile(entryURL.openStream(), result);
        return result;
    }

    protected static String getTestJarPath(String jarName) {
        return "test_files/security/bundles/" + jarName + ".jar";
    }

    protected static void setEclipseTrustEngine(ConfigurationSessionTestSuite suite) {
        try {
            URL eclipseURL = OSGiTestsActivator.getContext().getBundle().getEntry("test_files/security/eclipse.jks");
            File tempFile = File.createTempFile("keystore", ".jks");
            BaseSecurityTest.copy(eclipseURL.openStream(), tempFile);
            suite.getSetup().setSystemProperty("osgi.framework.keystore", tempFile.toURL().toExternalForm());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            fos = null;
            in.close();
            in = null;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
    }
}

