/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.security;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.security.BaseSecurityTest;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.condpermadmin.BundleSignerCondition;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class OSGiAPICertificateTest
extends BaseSecurityTest {
    private static String dn1 = "CN=CA1 LeafA, O=CA1, L=Boston, ST=Massachusetts, C=US";
    private static String dn2 = "CN=CA1 Root, O=CA1, L=Boston, ST=Massachusetts, C=US";
    private static String dn3 = "CN=CA1 LeafA, O=CA1, L=Austin, ST=Texas, C=US";
    private static String dn4 = "CN=CA1 Root, O=CA1, L=Austin, ST=Texas, C=US";
    private static String dn5 = "CN=CA1 LeafA, O=CA1, L=*, ST=*, C=US";
    private static String dn6 = "CN=CA1 Root, O=CA1, L=*, ST=*, C=US";
    private static String dn7 = "*, L=*, ST=*, C=US";
    private static String dnChain01True = String.valueOf(dn1) + ';' + dn2;
    private static String dnChain02True = "*;" + dn2;
    private static String dnChain03True = String.valueOf(dn1) + ";*";
    private static String dnChain04False = String.valueOf(dn1) + ';' + dn4;
    private static String dnChain05False = String.valueOf(dn3) + ';' + dn2;
    private static String dnChain06True = String.valueOf(dn5) + ';' + dn6;
    private static String dnChain07True = String.valueOf(dn7) + ';' + dn6;
    private static String dnChain08True = String.valueOf(dn5) + ';' + dn7;
    private static String dnChain01TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain01True);
    private static String dnChain02TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain02True);
    private static String dnChain03TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain03True);
    private static String dnChain04FalseEscaped = OSGiAPICertificateTest.escapeStar(dnChain04False);
    private static String dnChain05FalseEscaped = OSGiAPICertificateTest.escapeStar(dnChain05False);
    private static String dnChain06TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain06True);
    private static String dnChain07TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain07True);
    private static String dnChain08TrueEscaped = OSGiAPICertificateTest.escapeStar(dnChain08True);
    private static ConditionInfo info01True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{"-"});
    private static ConditionInfo info02False = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{"-", "!"});
    private static ConditionInfo info03True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain01True});
    private static ConditionInfo info04True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain02True});
    private static ConditionInfo info05True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain03True});
    private static ConditionInfo info06False = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain04False});
    private static ConditionInfo info07False = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain05False});
    private static ConditionInfo info08True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain06True});
    private static ConditionInfo info09True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain07True});
    private static ConditionInfo info10True = new ConditionInfo(BundleSignerCondition.class.getName(), new String[]{dnChain08True});
    private Collection<Bundle> installedBundles = new ArrayList<Bundle>();

    public static TestSuite suite() {
        return new TestSuite(OSGiAPICertificateTest.class);
    }

    private static String escapeStar(String dnChain) {
        if (dnChain == null || dnChain.length() == 0) {
            return dnChain;
        }
        int star = dnChain.indexOf(42);
        while (star >= 0) {
            dnChain = String.valueOf(dnChain.substring(0, star)) + '\\' + dnChain.substring(star);
            star = dnChain.indexOf(42, star + 2);
        }
        return dnChain;
    }

    public OSGiAPICertificateTest() {
    }

    public OSGiAPICertificateTest(String name, String jarname, String[] aliases) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.registerEclipseTrustEngine();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        for (Bundle b : this.installedBundles) {
            try {
                b.uninstall();
            }
            catch (BundleException bundleException) {}
        }
    }

    @Override
    protected Bundle installBundle(String bundlePath) {
        Bundle b = super.installBundle(bundlePath);
        this.installedBundles.add(b);
        return b;
    }

    public void testBundleSignerCondition01() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info01True);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition02() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info02False);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.FALSE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition03() {
        try {
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info01True);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.FALSE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition04() {
        try {
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info02False);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition05() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info03True);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition06() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info04True);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition07() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info05True);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition08() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info06False);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.FALSE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition09() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info07False);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.FALSE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition10() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info08True);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition11() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info09True);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testBundleSignerCondition12() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            Condition condition = BundleSignerCondition.getCondition((Bundle)testBundle, (ConditionInfo)info10True);
            OSGiAPICertificateTest.assertEquals((String)"Unexpected condition value", (Object)Condition.TRUE, (Object)condition);
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission01() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(signer=-)", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission02() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain01TrueEscaped + ")", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission03() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(!(signer=-))", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertFalse((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission04() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(!(signer=" + dnChain01TrueEscaped + "))", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertFalse((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission05() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain02TrueEscaped + ")", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission06() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain03TrueEscaped + ")", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission07() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain04FalseEscaped + ")", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertFalse((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission08() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain05FalseEscaped + ")", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertFalse((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission09() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain06TrueEscaped + ")", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission10() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain07TrueEscaped + ")", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    public void testAdminPermission11() {
        try {
            this.getTrustEngine().addTrustAnchor(OSGiAPICertificateTest.getTestCertificate("ca1_leafa"), "ca1_leafa");
            Bundle testBundle = this.installBundle(OSGiAPICertificateTest.getTestJarPath("signed"));
            AdminPermission declaredPerm = new AdminPermission("(signer=" + dnChain08TrueEscaped + ")", "context");
            AdminPermission checkedPerm = new AdminPermission(testBundle, "context");
            OSGiAPICertificateTest.assertTrue((String)"Security check failed", (boolean)declaredPerm.implies((Permission)checkedPerm));
        }
        catch (Exception e) {
            OSGiAPICertificateTest.fail((String)"Unexpected exception", (Throwable)e);
        }
    }
}

